/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.LongUnaryOperator;
import kala.Conditions;
import kala.collection.base.primitive.LongArrays;
import kala.collection.base.primitive.LongIterator;
import kala.collection.base.primitive.LongTraversable;
import kala.collection.factory.primitive.LongCollectionFactory;
import kala.collection.mutable.primitive.MutableLongArray;
import kala.collection.mutable.primitive.MutableLongCollection;
import kala.collection.mutable.primitive.MutableLongSeqIterator;
import kala.collection.mutable.primitive.MutablePrimitiveSeq;
import kala.collection.primitive.LongSeq;
import kala.collection.primitive.internal.LongSeqIterators;
import kala.function.IndexedLongUnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MutableLongSeq
extends MutablePrimitiveSeq<Long>,
LongSeq,
MutableLongCollection {
    @NotNull
    public static LongCollectionFactory<?, MutableLongSeq> factory() {
        return LongCollectionFactory.narrow(MutableLongArray.factory());
    }

    @NotNull
    public static MutableLongSeq of() {
        return MutableLongArray.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableLongSeq of(long value1) {
        return MutableLongArray.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableLongSeq of(long value1, long value2) {
        return MutableLongArray.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableLongSeq of(long value1, long value2, long value3) {
        return MutableLongArray.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableLongSeq of(long value1, long value2, long value3, long value4) {
        return MutableLongArray.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableLongSeq of(long value1, long value2, long value3, long value4, long value5) {
        return MutableLongArray.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static MutableLongSeq of(long ... values) {
        return MutableLongArray.of(values);
    }

    @NotNull
    public static MutableLongSeq from(long @NotNull [] values) {
        return MutableLongArray.from(values);
    }

    @NotNull
    public static MutableLongSeq from(@NotNull LongTraversable values) {
        return MutableLongArray.from(values);
    }

    @NotNull
    public static MutableLongSeq from(@NotNull LongIterator it) {
        return MutableLongArray.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableLongSeq";
    }

    @NotNull
    default public LongCollectionFactory<?, ? extends MutableLongSeq> iterableFactory() {
        return MutableLongSeq.factory();
    }

    @Override
    @NotNull
    default public MutableLongSeqIterator seqIterator() {
        return this.seqIterator(0);
    }

    @Override
    @NotNull
    default public MutableLongSeqIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new LongSeqIterators.DefaultMutableLongSeqIterator<MutableLongSeq>(this, index);
    }

    @Contract(mutates="this")
    public void set(int var1, long var2);

    default public void swap(int index1, int index2) {
        long old1 = this.get(index1);
        long old2 = this.get(index2);
        this.set(index1, old2);
        this.set(index2, old1);
    }

    @Contract(mutates="this")
    default public void replaceAll(@NotNull LongUnaryOperator operator) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.set(i, operator.applyAsLong(this.get(i)));
        }
    }

    @Contract(mutates="this")
    default public void replaceAllIndexed(@NotNull IndexedLongUnaryOperator operator) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.set(i, operator.applyAsLong(i, this.get(i)));
        }
    }

    @Contract(mutates="this")
    default public void sort() {
        long[] values = this.toArray();
        Arrays.sort(values);
        for (int i = 0; i < values.length; ++i) {
            this.set(i, values[i]);
        }
    }

    @Contract(mutates="this")
    default public void reverse() {
        int size = this.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size / 2; ++i) {
            this.swap(i, size - i - 1);
        }
    }

    default public void shuffle() {
        this.shuffle(ThreadLocalRandom.current());
    }

    default public void shuffle(@NotNull Random random) {
        int ks = this.knownSize();
        if (ks == 0 || ks == 1) {
            return;
        }
        if (this.supportsFastRandomAccess() || ks > 0 && ks <= 5) {
            if (!1.$assertionsDisabled && ks <= 0) {
                throw new AssertionError();
            }
            for (int i2 = ks; i2 > 1; --i2) {
                this.swap(i2 - 1, random.nextInt(i2));
            }
        } else {
            long[] arr = this.toArray();
            LongArrays.shuffle((long[])arr, (Random)random);
            this.replaceAllIndexed((i, v) -> arr[i]);
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

