/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.LongConsumer;
import kala.collection.AnySet;
import kala.collection.base.primitive.AbstractLongIterator;
import kala.collection.base.primitive.LongIterator;
import kala.collection.base.primitive.LongTraversable;
import kala.collection.factory.primitive.LongCollectionFactory;
import kala.collection.mutable.primitive.AbstractMutableLongSetFactory;
import kala.collection.mutable.primitive.MutableLongSet;
import kala.collection.primitive.LongSet;
import kala.collection.primitive.internal.tree.LongRedBlackTree;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableLongTreeSet
extends LongRedBlackTree<Node>
implements MutableLongSet,
Cloneable,
Serializable {
    private static final long serialVersionUID = 6211626172352429615L;
    private static final Factory FACTORY = new Factory();

    @NotNull
    public static LongCollectionFactory<?, MutableLongTreeSet> factory() {
        return FACTORY;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static MutableLongTreeSet create() {
        return new MutableLongTreeSet();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static MutableLongTreeSet of() {
        return new MutableLongTreeSet();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableLongTreeSet of(long value1) {
        MutableLongTreeSet s = new MutableLongTreeSet();
        s.add(value1);
        return s;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static MutableLongTreeSet of(long value1, long value2) {
        MutableLongTreeSet s = new MutableLongTreeSet();
        s.add(value1);
        s.add(value2);
        return s;
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static MutableLongTreeSet of(long value1, long value2, long value3) {
        MutableLongTreeSet s = new MutableLongTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        return s;
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static MutableLongTreeSet of(long value1, long value2, long value3, long value4) {
        MutableLongTreeSet s = new MutableLongTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        return s;
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static MutableLongTreeSet of(long value1, long value2, long value3, long value4, long value5) {
        MutableLongTreeSet s = new MutableLongTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        s.add(value5);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableLongTreeSet of(long ... values) {
        return MutableLongTreeSet.from(values);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableLongTreeSet from(long @NotNull [] values) {
        Objects.requireNonNull(values);
        MutableLongTreeSet s = new MutableLongTreeSet();
        s.addAll(values);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableLongTreeSet from(@NotNull LongTraversable values) {
        Objects.requireNonNull(values);
        MutableLongTreeSet s = new MutableLongTreeSet();
        s.addAll(values);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableLongTreeSet from(@NotNull LongIterator it) {
        MutableLongTreeSet s = new MutableLongTreeSet();
        while (it.hasNext()) {
            s.add(it.nextLong());
        }
        return s;
    }

    @Override
    @NotNull
    public String className() {
        return "MutableLongTreeSet";
    }

    @NotNull
    public LongCollectionFactory<?, MutableLongTreeSet> iterableFactory() {
        return FACTORY;
    }

    @NotNull
    public LongIterator iterator() {
        Node firstNode = (Node)this.firstNode();
        return firstNode == null ? LongIterator.empty() : new Itr(firstNode);
    }

    @NotNull
    public MutableLongTreeSet clone() {
        return MutableLongTreeSet.from(this);
    }

    @Override
    public boolean add(long value) {
        int c;
        Node parent;
        Node node = (Node)this.root;
        if (node == null) {
            this.root = new Node(value, null);
            this.size = 1;
            return true;
        }
        do {
            parent = node;
            c = Long.compare(value, node.getValue());
            if (c < 0) {
                node = (Node)node.left;
                continue;
            }
            if (c > 0) {
                node = (Node)node.right;
                continue;
            }
            return false;
        } while (node != null);
        Node n = new Node(value, parent);
        if (c < 0) {
            parent.left = n;
        } else {
            parent.right = n;
        }
        ++this.size;
        this.fixAfterInsert(n);
        return true;
    }

    @Override
    public boolean remove(long value) {
        Node node = (Node)this.getNode(value);
        if (node == null) {
            return false;
        }
        this.remove0(node);
        return true;
    }

    @Override
    public boolean contains(long value) {
        return this.getNode(value) != null;
    }

    public long getFirst() {
        Node node = (Node)this.firstNode();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.getValue();
    }

    public long getLast() {
        Node node = (Node)this.lastNode();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.getValue();
    }

    public long @NotNull [] toArray() {
        int size = this.size;
        long[] res = new long[size];
        if (size == 0) {
            return res;
        }
        LongIterator it = this.iterator();
        for (int i = 0; i < size; ++i) {
            res[i] = it.nextLong();
        }
        return res;
    }

    public int hashCode() {
        return LongSet.hashCode(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof AnySet && LongSet.equals(this, (AnySet)obj);
    }

    public void forEach(@NotNull LongConsumer action) {
        this.forEachKey0(action);
    }

    public String toString() {
        return this.joinToString(", ", "MutableTreeSet[", "]");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            this.add(in.readLong());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.size);
        this.forEachUnchecked(out::writeLong);
    }

    private static final class Factory
    extends AbstractMutableLongSetFactory<MutableLongTreeSet> {
        private Factory() {
        }

        public MutableLongTreeSet newBuilder() {
            return new MutableLongTreeSet();
        }
    }

    static final class Node
    extends LongRedBlackTree.Node<Node> {
        Node(long value, Node parent) {
            super(value, parent);
        }

        void setValue(long newValue) {
            this.key = newValue;
        }

        long getValue() {
            return this.key;
        }

        public String toString() {
            return String.format("MutableLongTreeSet.Node[value=%s, color=%s, parent=%s, left=%s, right=%s]", this.key, this.color ? "RED" : "BLACK", this.parent, this.left, this.right);
        }
    }

    private static final class Itr
    extends AbstractLongIterator {
        private Node node;

        Itr(Node node) {
            this.node = node;
        }

        public boolean hasNext() {
            return this.node != null;
        }

        public long nextLong() {
            Node n;
            Node node = this.node;
            if (node == null) {
                throw new NoSuchElementException();
            }
            if (node.right != null) {
                n = (Node)node.right;
                while (n.left != null) {
                    n = (Node)n.left;
                }
            } else {
                n = (Node)node.parent;
                Node c = node;
                while (n != null && c == n.right) {
                    c = n;
                    n = (Node)n.parent;
                }
            }
            this.node = n;
            return node.getValue();
        }
    }
}

