/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.io.Serializable;
import kala.Conditions;
import kala.collection.base.primitive.BitArrays;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.primitive.AbstractBooleanSeq;
import kala.collection.primitive.IndexedBooleanSeq;
import kala.function.BooleanConsumer;
import org.jetbrains.annotations.NotNull;

public class BitArray
extends AbstractBooleanSeq
implements IndexedBooleanSeq,
Serializable {
    private static final long serialVersionUID = 4673372256434484L;
    private static final BitArray EMPTY = new BitArray(0L, 0);
    protected final long[] bitsArray;
    protected long bits;
    protected final int size;

    @NotNull
    public static BitArray wrap(long bits, int size) {
        if (size < 0 || size > 64) {
            throw new IllegalArgumentException();
        }
        return new BitArray(bits, size);
    }

    @NotNull
    public static BitArray wrap(long[] bitArray, int size) {
        if (bitArray.length * 64 < size) {
            throw new IllegalArgumentException();
        }
        if (size <= 64) {
            return new BitArray(bitArray[0], size);
        }
        return new BitArray(bitArray, size);
    }

    @NotNull
    public static BitArray emtpy() {
        return EMPTY;
    }

    protected BitArray(long[] bitsArray, int size) {
        this.bitsArray = bitsArray;
        this.bits = 0L;
        this.size = size;
    }

    protected BitArray(long bits, int size) {
        assert (size <= 64);
        this.bitsArray = null;
        this.bits = bits;
        this.size = size;
    }

    @Override
    @NotNull
    public String className() {
        return "BitArray";
    }

    @Override
    @NotNull
    public final BooleanIterator iterator() {
        if (this.bitsArray == null) {
            return BitArrays.iterator((long)this.bits, (int)0, (int)this.size);
        }
        return BitArrays.iterator((long[])this.bitsArray, (int)0, (int)this.size);
    }

    public final int size() {
        return this.size;
    }

    @Override
    public final boolean get(int index) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        if (this.bitsArray == null) {
            return BitArrays.get((long)this.bits, (int)index);
        }
        return BitArrays.get((long[])this.bitsArray, (int)index);
    }

    public final boolean @NotNull [] toArray() {
        boolean[] res;
        block5: {
            int baseIndex;
            long currentBits;
            block4: {
                res = new boolean[this.size];
                if (this.bitsArray != null) break block4;
                for (int i = 0; i < this.size; ++i) {
                    res[i] = BitArrays.get((long)this.bits, (int)i);
                }
                break block5;
            }
            int fullChunkCount = this.size / 64;
            for (int i = 0; i < fullChunkCount; ++i) {
                currentBits = this.bitsArray[i];
                baseIndex = i * 64;
                for (int j = 0; j < 64; ++j) {
                    res[baseIndex + j] = BitArrays.get((long)currentBits, (int)j);
                }
            }
            int notFullChunkLength = this.size % 64;
            if (notFullChunkLength == 0) break block5;
            currentBits = this.bitsArray[fullChunkCount];
            baseIndex = fullChunkCount * 64;
            for (int i = 0; i < notFullChunkLength; ++i) {
                res[baseIndex + i] = BitArrays.get((long)currentBits, (int)i);
            }
        }
        return res;
    }

    @Override
    public final void forEach(@NotNull BooleanConsumer action) {
        block5: {
            int baseIndex;
            long currentBits;
            block4: {
                if (this.bitsArray != null) break block4;
                for (int i = 0; i < this.size; ++i) {
                    action.accept(BitArrays.get((long)this.bits, (int)i));
                }
                break block5;
            }
            int fullChunkCount = this.size / 64;
            for (int i = 0; i < fullChunkCount; ++i) {
                currentBits = this.bitsArray[i];
                baseIndex = i * 64;
                for (int j = 0; j < 64; ++j) {
                    action.accept(BitArrays.get((long)currentBits, (int)j));
                }
            }
            int notFullChunkLength = this.size % 64;
            if (notFullChunkLength == 0) break block5;
            currentBits = this.bitsArray[fullChunkCount];
            baseIndex = (this.bitsArray.length - 1) * 64;
            for (int i = 0; i < notFullChunkLength; ++i) {
                action.accept(BitArrays.get((long)currentBits, (int)i));
            }
        }
    }
}

