/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import kala.collection.base.primitive.BooleanArrays;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.BooleanTraversable;
import kala.collection.factory.primitive.BooleanCollectionFactory;
import kala.collection.immutable.primitive.ImmutableBooleanArray;
import kala.collection.mutable.primitive.MutableBooleanArrayList;
import kala.collection.primitive.AbstractBooleanSeq;
import kala.collection.primitive.IndexedBooleanSeq;
import kala.function.BooleanBinaryOperator;
import kala.function.BooleanConsumer;
import kala.function.BooleanObjBiFunction;
import kala.function.BooleanPredicate;
import kala.function.ObjBooleanBiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;

@Debug.Renderer(hasChildren="isNotEmpty()", childrenArray="elements")
public class BooleanArraySeq
extends AbstractBooleanSeq
implements IndexedBooleanSeq,
Serializable {
    private static final long serialVersionUID = 4981379062449237945L;
    public static final BooleanArraySeq EMPTY = new BooleanArraySeq(BooleanArrays.EMPTY);
    private static final Factory FACTORY = new Factory();
    protected final boolean @NotNull [] elements;

    protected BooleanArraySeq(boolean @NotNull [] elements) {
        this.elements = elements;
    }

    @NotNull
    public static BooleanCollectionFactory<?, ? extends BooleanArraySeq> factory() {
        return FACTORY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static BooleanArraySeq wrap(boolean @NotNull [] array) {
        Objects.requireNonNull(array);
        return new BooleanArraySeq(array);
    }

    @NotNull
    public static BooleanArraySeq empty() {
        return EMPTY;
    }

    @NotNull
    public static BooleanArraySeq of() {
        return BooleanArraySeq.empty();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static BooleanArraySeq of(boolean value1) {
        return new BooleanArraySeq(new boolean[]{value1});
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static BooleanArraySeq of(boolean value1, boolean value2) {
        return new BooleanArraySeq(new boolean[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static BooleanArraySeq of(boolean value1, boolean value2, boolean value3) {
        return new BooleanArraySeq(new boolean[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static BooleanArraySeq of(boolean value1, boolean value2, boolean value3, boolean value4) {
        return new BooleanArraySeq(new boolean[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static BooleanArraySeq of(boolean value1, boolean value2, boolean value3, boolean value4, boolean value5) {
        return new BooleanArraySeq(new boolean[]{value1, value2, value3, value4, value5});
    }

    @Contract(pure=true)
    @NotNull
    public static BooleanArraySeq of(boolean ... values) {
        return BooleanArraySeq.from(values);
    }

    @Contract(pure=true)
    @NotNull
    public static BooleanArraySeq from(boolean @NotNull [] values) {
        return values.length == 0 ? BooleanArraySeq.empty() : new BooleanArraySeq((boolean[])values.clone());
    }

    @NotNull
    public static BooleanArraySeq from(@NotNull BooleanTraversable values) {
        if (values instanceof ImmutableBooleanArray) {
            return (BooleanArraySeq)values;
        }
        if (values.isEmpty()) {
            return BooleanArraySeq.empty();
        }
        boolean[] arr = values.toArray();
        return arr.length == 0 ? BooleanArraySeq.empty() : new BooleanArraySeq(arr);
    }

    @NotNull
    public static BooleanArraySeq from(@NotNull BooleanIterator it) {
        if (!it.hasNext()) {
            return BooleanArraySeq.empty();
        }
        return new BooleanArraySeq(it.toArray());
    }

    @NotNull
    public static BooleanArraySeq fill(int n, boolean value) {
        if (n <= 0) {
            return BooleanArraySeq.empty();
        }
        boolean[] ans = new boolean[n];
        if (value) {
            Arrays.fill(ans, value);
        }
        return new BooleanArraySeq(ans);
    }

    @NotNull
    public static BooleanArraySeq fill(int n, @NotNull BooleanSupplier supplier) {
        if (n <= 0) {
            return BooleanArraySeq.empty();
        }
        boolean[] ans = new boolean[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsBoolean();
        }
        return new BooleanArraySeq(ans);
    }

    @Override
    @NotNull
    public String className() {
        return "BooleanArraySeq";
    }

    @Override
    @NotNull
    public final BooleanIterator iterator() {
        return BooleanArrays.iterator((boolean[])this.elements);
    }

    @Override
    @NotNull
    public BooleanIterator iterator(int beginIndex) {
        return BooleanArrays.iterator((boolean[])this.elements, (int)beginIndex);
    }

    @Override
    public final boolean isEmpty() {
        return this.elements.length == 0;
    }

    public final int size() {
        return this.elements.length;
    }

    @Override
    public final int knownSize() {
        return this.elements.length;
    }

    @Override
    @NotNull
    public final BooleanIterator reverseIterator() {
        return BooleanArrays.reverseIterator((boolean[])this.elements);
    }

    @Override
    public final boolean get(int index) {
        return this.elements[index];
    }

    @Override
    public final boolean getFirst() {
        try {
            return this.elements[0];
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public final boolean getLast() {
        int size = this.elements.length;
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[size - 1];
    }

    public final boolean contains(boolean value) {
        if (this.elements.length == 0) {
            return false;
        }
        for (boolean e : this.elements) {
            if (value != e) continue;
            return true;
        }
        return false;
    }

    public final boolean containsAll(@NotNull BooleanTraversable values) {
        BooleanIterator it = values.iterator();
        while (it.hasNext()) {
            boolean v = it.nextBoolean();
            if (this.contains(v)) continue;
            return false;
        }
        return true;
    }

    public final boolean anyMatch(@NotNull BooleanPredicate predicate) {
        for (boolean e : this.elements) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public final boolean allMatch(@NotNull BooleanPredicate predicate) {
        for (boolean e : this.elements) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public final boolean noneMatch(@NotNull BooleanPredicate predicate) {
        for (boolean e : this.elements) {
            if (!predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int indexOf(boolean value) {
        return BooleanArrays.indexOf((boolean[])this.elements, (boolean)value);
    }

    @Override
    public final int indexOf(boolean value, int from) {
        return BooleanArrays.indexOf((boolean[])this.elements, (boolean)value, (int)from);
    }

    @Override
    public final int indexWhere(@NotNull BooleanPredicate predicate) {
        return BooleanArrays.indexWhere((boolean[])this.elements, (BooleanPredicate)predicate);
    }

    @Override
    public final int indexWhere(@NotNull BooleanPredicate predicate, int from) {
        return BooleanArrays.indexWhere((boolean[])this.elements, (BooleanPredicate)predicate, (int)from);
    }

    @Override
    public final int lastIndexOf(boolean value) {
        return BooleanArrays.lastIndexOf((boolean[])this.elements, (boolean)value);
    }

    @Override
    public final int lastIndexOf(boolean value, int end) {
        return BooleanArrays.lastIndexOf((boolean[])this.elements, (boolean)value, (int)end);
    }

    @Override
    public final int lastIndexWhere(@NotNull BooleanPredicate predicate) {
        return BooleanArrays.lastIndexWhere((boolean[])this.elements, (BooleanPredicate)predicate);
    }

    @Override
    public final int lastIndexWhere(@NotNull BooleanPredicate predicate, int end) {
        return BooleanArrays.lastIndexWhere((boolean[])this.elements, (BooleanPredicate)predicate, (int)end);
    }

    public final int count(@NotNull BooleanPredicate predicate) {
        int c = 0;
        for (boolean e : this.elements) {
            if (!predicate.test(e)) continue;
            ++c;
        }
        return c;
    }

    public final boolean max() {
        return BooleanArrays.max((boolean[])this.elements);
    }

    public final boolean min() {
        return BooleanArrays.min((boolean[])this.elements);
    }

    public boolean foldLeft(boolean zero, @NotNull BooleanBinaryOperator op) {
        return BooleanArrays.foldLeft((boolean[])this.elements, (boolean)zero, (BooleanBinaryOperator)op);
    }

    public <U> U foldLeftToObj(U zero, @NotNull ObjBooleanBiFunction<U, U> op) {
        return (U)BooleanArrays.foldLeftToObj((boolean[])this.elements, zero, op);
    }

    public boolean foldRight(boolean zero, @NotNull BooleanBinaryOperator op) {
        return BooleanArrays.foldRight((boolean[])this.elements, (boolean)zero, (BooleanBinaryOperator)op);
    }

    public <U> U foldRightToObj(U zero, @NotNull BooleanObjBiFunction<U, U> op) {
        return (U)BooleanArrays.foldRightToObj((boolean[])this.elements, zero, op);
    }

    public boolean reduceLeft(@NotNull BooleanBinaryOperator op) {
        return BooleanArrays.reduceLeft((boolean[])this.elements, (BooleanBinaryOperator)op);
    }

    public boolean reduceRight(@NotNull BooleanBinaryOperator op) {
        return BooleanArrays.reduceRight((boolean[])this.elements, (BooleanBinaryOperator)op);
    }

    public final int copyToArray(int srcPos, boolean @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + destPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        int dl = dest.length;
        int size = this.elements.length;
        if (destPos >= dl || srcPos >= size) {
            return 0;
        }
        int n = Math.min(Math.min(size - srcPos, dl - destPos), limit);
        System.arraycopy(this.elements, srcPos, dest, destPos, n);
        return n;
    }

    public final boolean @NotNull [] toArray() {
        return (boolean[])this.elements.clone();
    }

    @Override
    public final void forEach(@NotNull BooleanConsumer action) {
        for (boolean e : this.elements) {
            action.accept(e);
        }
    }

    @Override
    public final int hashCode() {
        int ans = 0;
        boolean[] blArray = this.elements;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            Boolean o = blArray[i];
            ans = ans * 31 + Objects.hashCode(o);
        }
        return ans + -1140647423;
    }

    @NotNull
    public final <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        int size = this.elements.length;
        try {
            buffer.append(prefix);
            if (size > 0) {
                buffer.append(Objects.toString(this.elements[0]));
                for (int i = 1; i < size; ++i) {
                    buffer.append(separator);
                    buffer.append(Objects.toString(this.elements[i]));
                }
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    private static final class Factory
    implements BooleanCollectionFactory<MutableBooleanArrayList, BooleanArraySeq> {
        private Factory() {
        }

        public BooleanArraySeq empty() {
            return BooleanArraySeq.empty();
        }

        public BooleanArraySeq from(boolean @NotNull [] values) {
            return BooleanArraySeq.from(values);
        }

        public BooleanArraySeq from(@NotNull BooleanTraversable values) {
            return BooleanArraySeq.from(values);
        }

        public BooleanArraySeq from(@NotNull BooleanIterator it) {
            return BooleanArraySeq.from(it);
        }

        public BooleanArraySeq fill(int n, boolean value) {
            return BooleanArraySeq.fill(n, value);
        }

        public BooleanArraySeq fill(int n, @NotNull BooleanSupplier supplier) {
            return BooleanArraySeq.fill(n, supplier);
        }

        public MutableBooleanArrayList newBuilder() {
            return new MutableBooleanArrayList();
        }

        public void addToBuilder(@NotNull MutableBooleanArrayList buffer, boolean value) {
            buffer.append(value);
        }

        public MutableBooleanArrayList mergeBuilder(@NotNull MutableBooleanArrayList builder1, @NotNull MutableBooleanArrayList builder2) {
            throw new UnsupportedOperationException();
        }

        public void sizeHint(@NotNull MutableBooleanArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public BooleanArraySeq build(@NotNull MutableBooleanArrayList builder) {
            return new BooleanArraySeq(builder.toArray());
        }
    }
}

