/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import kala.Conditions;
import kala.collection.SeqLike;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.BooleanTraversable;
import kala.collection.mutable.primitive.MutableBooleanArrayList;
import kala.collection.primitive.BooleanCollectionLike;
import kala.collection.primitive.BooleanSeqIterator;
import kala.collection.primitive.BooleanSeqView;
import kala.collection.primitive.PrimitiveSeqLike;
import kala.collection.primitive.internal.BooleanSeqIterators;
import kala.control.primitive.BooleanOption;
import kala.function.BooleanFunction;
import kala.function.BooleanPredicate;
import kala.function.BooleanUnaryOperator;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public interface BooleanSeqLike
extends PrimitiveSeqLike<Boolean>,
BooleanCollectionLike {
    @Override
    @NotNull
    default public String className() {
        return "BooleanSeqLike";
    }

    @Override
    @NotNull
    public BooleanSeqView view();

    @NotNull
    default public BooleanIterator iterator(int beginIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") < 0");
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0) {
            if (beginIndex > knownSize) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") > size(" + knownSize + ")");
            }
            if (beginIndex == knownSize) {
                return BooleanIterator.empty();
            }
        }
        BooleanIterator it = this.iterator();
        for (int i = 0; i < beginIndex; ++i) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException("beginIndex: " + beginIndex);
            }
            it.nextBoolean();
        }
        return it;
    }

    @NotNull
    default public BooleanSeqIterator seqIterator() {
        return this.seqIterator(0);
    }

    @NotNull
    default public BooleanSeqIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new BooleanSeqIterators.DefaultBooleanSeqIterator<BooleanSeqLike>(this, index);
    }

    @Contract(pure=true)
    default public boolean isDefinedAt(int index) {
        return index >= 0 && this.sizeGreaterThan(index);
    }

    default public boolean elementAt(int index) {
        return this.get(index);
    }

    @Contract(pure=true)
    @Flow(sourceIsContainer=true)
    default public boolean get(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return this.iterator(index).nextBoolean();
    }

    @Contract(pure=true)
    @Nullable
    default public Boolean getOrNull(int index) {
        return this.isDefinedAt(index) ? Boolean.valueOf(this.get(index)) : null;
    }

    @Contract(pure=true)
    @Flow(sourceIsContainer=true, targetIsContainer=true)
    @NotNull
    default public BooleanOption getOption(int index) {
        return this.isDefinedAt(index) ? BooleanOption.some((boolean)this.get(index)) : BooleanOption.none();
    }

    @NotNull
    default public BooleanIterator reverseIterator() {
        BooleanIterator it = this.iterator();
        if (!it.hasNext()) {
            return it;
        }
        MutableBooleanArrayList builder = new MutableBooleanArrayList();
        while (it.hasNext()) {
            builder.append(it.nextBoolean());
        }
        return builder.reverseIterator();
    }

    @NotNull
    default public BooleanOption find(@NotNull BooleanPredicate predicate) {
        return this.findFirst(predicate);
    }

    @NotNull
    default public BooleanOption findFirst(@NotNull BooleanPredicate predicate) {
        return this.iterator().find(predicate);
    }

    @NotNull
    default public BooleanOption findLast(@NotNull BooleanPredicate predicate) {
        return this.reverseIterator().find(predicate);
    }

    default public boolean getFirst() {
        return this.iterator().nextBoolean();
    }

    @Nullable
    default public Boolean getFirstOrNull() {
        return this.isNotEmpty() ? Boolean.valueOf(this.getFirst()) : null;
    }

    @NotNull
    default public BooleanOption getFirstOption() {
        return this.isNotEmpty() ? BooleanOption.some((boolean)this.getFirst()) : BooleanOption.none();
    }

    default public boolean getLast() {
        return this.reverseIterator().nextBoolean();
    }

    @Nullable
    default public Boolean getLastOrNull() {
        return this.isNotEmpty() ? Boolean.valueOf(this.getLast()) : null;
    }

    @NotNull
    default public BooleanOption getLastOption() {
        return this.isNotEmpty() ? BooleanOption.some((boolean)this.getLast()) : BooleanOption.none();
    }

    default public boolean first(@NotNull BooleanPredicate predicate) {
        return this.findFirst(predicate).get();
    }

    @Nullable
    default public Boolean firstOrNull(@NotNull BooleanPredicate predicate) {
        return this.findFirst(predicate).getOrNull();
    }

    @NotNull
    default public BooleanOption firstOption(@NotNull BooleanPredicate predicate) {
        return this.findFirst(predicate);
    }

    default public boolean last(@NotNull BooleanPredicate predicate) {
        return this.findLast(predicate).get();
    }

    @Nullable
    default public Boolean lastOrNull(@NotNull BooleanPredicate predicate) {
        return this.findLast(predicate).getOrNull();
    }

    @NotNull
    default public BooleanOption lastOption(@NotNull BooleanPredicate predicate) {
        return this.findLast(predicate);
    }

    @Contract(pure=true)
    default public int indexOf(boolean value) {
        int idx = 0;
        BooleanIterator it = this.iterator();
        while (it.hasNext()) {
            if (value == it.nextBoolean()) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexOf(boolean value, int from) {
        int idx = 0;
        BooleanIterator it = this.iterator();
        while (it.hasNext()) {
            if (idx >= from && value == it.nextBoolean()) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull BooleanPredicate predicate) {
        int idx = 0;
        BooleanIterator it = this.iterator();
        while (it.hasNext()) {
            if (predicate.test(it.nextBoolean())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull BooleanPredicate predicate, int from) {
        int idx = 0;
        BooleanIterator it = this.iterator();
        while (it.hasNext()) {
            if (idx >= from && predicate.test(it.nextBoolean())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(boolean value) {
        int idx = this.size() - 1;
        BooleanIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (value == it.nextBoolean()) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(boolean value, int end) {
        int idx = this.size() - 1;
        BooleanIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (idx <= end && value == it.nextBoolean()) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull BooleanPredicate predicate) {
        int idx = this.size() - 1;
        BooleanIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (predicate.test(it.nextBoolean())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull BooleanPredicate predicate, int end) {
        int idx = this.size() - 1;
        BooleanIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (idx <= end && predicate.test(it.nextBoolean())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    @NotNull
    public BooleanSeqLike slice(int var1, int var2);

    @Contract(pure=true)
    @NotNull
    public BooleanSeqLike drop(int var1);

    @Contract(pure=true)
    @NotNull
    public BooleanSeqLike dropLast(int var1);

    @Contract(pure=true)
    @NotNull
    public BooleanSeqLike dropWhile(@NotNull BooleanPredicate var1);

    @Contract(pure=true)
    @NotNull
    public BooleanSeqLike take(int var1);

    @NotNull
    public BooleanSeqLike takeLast(int var1);

    @Contract(pure=true)
    @NotNull
    public BooleanSeqLike takeWhile(@NotNull BooleanPredicate var1);

    @Contract(pure=true)
    @NotNull
    public BooleanSeqLike updated(int var1, boolean var2);

    @Contract(pure=true)
    @NotNull
    public BooleanSeqLike concat(@NotNull BooleanSeqLike var1);

    @Contract(pure=true)
    @NotNull
    public BooleanSeqLike prepended(boolean var1);

    @Contract(pure=true)
    @NotNull
    public BooleanSeqLike prependedAll(boolean @NotNull [] var1);

    @Contract(pure=true)
    @NotNull
    public BooleanSeqLike prependedAll(@NotNull BooleanTraversable var1);

    @Contract(pure=true)
    @NotNull
    public BooleanSeqLike appended(boolean var1);

    @Contract(pure=true)
    @NotNull
    public BooleanSeqLike appendedAll(@NotNull BooleanTraversable var1);

    @Contract(pure=true)
    @NotNull
    public BooleanSeqLike appendedAll(boolean @NotNull [] var1);

    @Contract(pure=true)
    @NotNull
    public BooleanSeqLike sorted();

    @Contract(pure=true)
    @NotNull
    public BooleanSeqLike reversed();

    @Override
    @Contract(pure=true)
    @NotNull
    public BooleanSeqLike filter(@NotNull BooleanPredicate var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public BooleanSeqLike filterNot(@NotNull BooleanPredicate var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public BooleanSeqLike map(@NotNull BooleanUnaryOperator var1);

    @Contract(pure=true)
    @NotNull
    public <U> SeqLike<U> mapToObj(@NotNull BooleanFunction<? extends U> var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public BooleanSeqLike flatMap(@NotNull BooleanFunction<? extends BooleanTraversable> var1);

    @NotNull
    public <T> SeqLike<T> flatMapToObj(@NotNull BooleanFunction<? extends Iterable<? extends T>> var1);
}

