/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import kala.collection.AnySet;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.BooleanTraversable;
import kala.collection.factory.primitive.BooleanCollectionFactory;
import kala.collection.immutable.primitive.ImmutableBooleanSet;
import kala.collection.primitive.BooleanCollection;
import kala.collection.primitive.BooleanSetLike;
import kala.collection.primitive.BooleanSetView;
import kala.collection.primitive.PrimitiveSet;
import kala.collection.primitive.internal.view.BooleanSetViews;
import kala.function.BooleanPredicate;
import org.jetbrains.annotations.NotNull;

public interface BooleanSet
extends PrimitiveSet<Boolean>,
BooleanCollection,
BooleanSetLike {
    public static BooleanCollectionFactory<?, BooleanSet> factory() {
        return BooleanCollectionFactory.narrow(ImmutableBooleanSet.factory());
    }

    @NotNull
    public static BooleanSet empty() {
        return ImmutableBooleanSet.empty();
    }

    @NotNull
    public static BooleanSet of() {
        return ImmutableBooleanSet.of();
    }

    @NotNull
    public static BooleanSet of(boolean value1) {
        return ImmutableBooleanSet.of(value1);
    }

    @NotNull
    public static BooleanSet of(boolean value1, boolean value2) {
        return ImmutableBooleanSet.of(value1, value2);
    }

    @NotNull
    public static BooleanSet of(boolean value1, boolean value2, boolean value3) {
        return ImmutableBooleanSet.of(value1, value2, value3);
    }

    @NotNull
    public static BooleanSet of(boolean value1, boolean value2, boolean value3, boolean value4) {
        return ImmutableBooleanSet.of(value1, value2, value3, value4);
    }

    @NotNull
    public static BooleanSet of(boolean value1, boolean value2, boolean value3, boolean value4, boolean value5) {
        return ImmutableBooleanSet.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static BooleanSet of(boolean ... values) {
        return ImmutableBooleanSet.of(values);
    }

    @NotNull
    public static BooleanSet from(boolean @NotNull [] values) {
        return ImmutableBooleanSet.from(values);
    }

    @NotNull
    public static BooleanSet from(@NotNull BooleanTraversable values) {
        return ImmutableBooleanSet.from(values);
    }

    @NotNull
    public static BooleanSet from(@NotNull BooleanIterator it) {
        return ImmutableBooleanSet.from(it);
    }

    public static int hashCode(@NotNull BooleanSet set) {
        int h = 1045751549;
        BooleanIterator it = set.iterator();
        while (it.hasNext()) {
            h += Boolean.hashCode(it.nextBoolean());
        }
        return h;
    }

    public static boolean equals(@NotNull BooleanSet set1, @NotNull AnySet<?> set2) {
        if (set1 == set2) {
            return true;
        }
        if (!set1.canEqual(set2) || !set2.canEqual((Object)set1)) {
            return false;
        }
        if (set1.size() != set2.size()) {
            return false;
        }
        if (set2 instanceof BooleanSet) {
            return set1.containsAll((BooleanSet)set2);
        }
        for (Object v : set2.asGeneric()) {
            if (v instanceof Boolean && set1.contains((Boolean)v)) continue;
            return false;
        }
        return true;
    }

    public boolean containsTrue();

    public boolean containsFalse();

    default public boolean isFull() {
        return this.containsTrue() && this.containsFalse();
    }

    default public boolean contains(boolean value) {
        return value ? this.containsTrue() : this.containsFalse();
    }

    @Override
    @NotNull
    default public String className() {
        return "BooleanSet";
    }

    @NotNull
    default public BooleanCollectionFactory<?, ? extends BooleanSet> iterableFactory() {
        return BooleanSet.factory();
    }

    @Override
    @NotNull
    default public BooleanSetView view() {
        return new BooleanSetViews.Of<BooleanSet>(this);
    }

    @NotNull
    default public BooleanIterator iterator() {
        if (this.containsFalse()) {
            return this.containsTrue() ? BooleanIterator.of((boolean[])new boolean[]{false, true}) : BooleanIterator.of((boolean)false);
        }
        if (this.containsTrue()) {
            return BooleanIterator.of((boolean)true);
        }
        return BooleanIterator.empty();
    }

    default public boolean isEmpty() {
        return !this.containsFalse() && !this.containsTrue();
    }

    default public int size() {
        if (this.containsFalse()) {
            return this.containsTrue() ? 2 : 1;
        }
        return this.containsTrue() ? 1 : 0;
    }

    default public int knownSize() {
        return this.size();
    }

    @Override
    @NotNull
    default public ImmutableBooleanSet filter(@NotNull BooleanPredicate predicate) {
        return ImmutableBooleanSet.from(this.view().filter(predicate));
    }

    @Override
    @NotNull
    default public ImmutableBooleanSet filterNot(@NotNull BooleanPredicate predicate) {
        return ImmutableBooleanSet.from(this.view().filterNot(predicate));
    }
}

