/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.Conditions;
import kala.collection.base.primitive.ByteArrays;
import kala.collection.base.primitive.ByteIterator;
import kala.collection.base.primitive.ByteTraversable;
import kala.collection.factory.primitive.ByteCollectionFactory;
import kala.collection.immutable.primitive.ImmutableByteArray;
import kala.collection.mutable.primitive.MutableByteArrayList;
import kala.collection.primitive.AbstractByteSeq;
import kala.collection.primitive.IndexedByteSeq;
import kala.function.ByteBinaryOperator;
import kala.function.ByteConsumer;
import kala.function.ByteObjBiFunction;
import kala.function.BytePredicate;
import kala.function.ByteSupplier;
import kala.function.ObjByteBiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;

@Debug.Renderer(hasChildren="isNotEmpty()", childrenArray="elements")
public class ByteArraySeq
extends AbstractByteSeq
implements IndexedByteSeq,
Serializable {
    private static final long serialVersionUID = 4981379062449237945L;
    public static final ByteArraySeq EMPTY = new ByteArraySeq(ByteArrays.EMPTY);
    private static final Factory FACTORY = new Factory();
    protected final byte @NotNull [] elements;

    protected ByteArraySeq(byte @NotNull [] elements) {
        this.elements = elements;
    }

    @NotNull
    public static ByteCollectionFactory<?, ? extends ByteArraySeq> factory() {
        return FACTORY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ByteArraySeq wrap(byte @NotNull [] array) {
        Objects.requireNonNull(array);
        return new ByteArraySeq(array);
    }

    @NotNull
    public static ByteArraySeq empty() {
        return EMPTY;
    }

    @NotNull
    public static ByteArraySeq of() {
        return ByteArraySeq.empty();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ByteArraySeq of(byte value1) {
        return new ByteArraySeq(new byte[]{value1});
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static ByteArraySeq of(byte value1, byte value2) {
        return new ByteArraySeq(new byte[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static ByteArraySeq of(byte value1, byte value2, byte value3) {
        return new ByteArraySeq(new byte[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static ByteArraySeq of(byte value1, byte value2, byte value3, byte value4) {
        return new ByteArraySeq(new byte[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static ByteArraySeq of(byte value1, byte value2, byte value3, byte value4, byte value5) {
        return new ByteArraySeq(new byte[]{value1, value2, value3, value4, value5});
    }

    @Contract(pure=true)
    @NotNull
    public static ByteArraySeq of(byte ... values) {
        return ByteArraySeq.from(values);
    }

    @Contract(pure=true)
    @NotNull
    public static ByteArraySeq from(byte @NotNull [] values) {
        return values.length == 0 ? ByteArraySeq.empty() : new ByteArraySeq((byte[])values.clone());
    }

    @NotNull
    public static ByteArraySeq from(@NotNull ByteTraversable values) {
        if (values instanceof ImmutableByteArray) {
            return (ByteArraySeq)values;
        }
        if (values.isEmpty()) {
            return ByteArraySeq.empty();
        }
        byte[] arr = values.toArray();
        return arr.length == 0 ? ByteArraySeq.empty() : new ByteArraySeq(arr);
    }

    @NotNull
    public static ByteArraySeq from(@NotNull ByteIterator it) {
        if (!it.hasNext()) {
            return ByteArraySeq.empty();
        }
        return new ByteArraySeq(it.toArray());
    }

    @NotNull
    public static ByteArraySeq fill(int n, byte value) {
        if (n <= 0) {
            return ByteArraySeq.empty();
        }
        byte[] ans = new byte[n];
        if (value != 0) {
            Arrays.fill(ans, value);
        }
        return new ByteArraySeq(ans);
    }

    @NotNull
    public static ByteArraySeq fill(int n, @NotNull ByteSupplier supplier) {
        if (n <= 0) {
            return ByteArraySeq.empty();
        }
        byte[] ans = new byte[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsByte();
        }
        return new ByteArraySeq(ans);
    }

    @Override
    @NotNull
    public String className() {
        return "ByteArraySeq";
    }

    @Override
    @NotNull
    public final ByteIterator iterator() {
        return ByteArrays.iterator((byte[])this.elements);
    }

    @Override
    @NotNull
    public ByteIterator iterator(int beginIndex) {
        return ByteArrays.iterator((byte[])this.elements, (int)beginIndex);
    }

    @Override
    public final boolean isEmpty() {
        return this.elements.length == 0;
    }

    public final int size() {
        return this.elements.length;
    }

    @Override
    public final int knownSize() {
        return this.elements.length;
    }

    @Override
    @NotNull
    public final ByteIterator reverseIterator() {
        return ByteArrays.reverseIterator((byte[])this.elements);
    }

    @Override
    public final byte get(int index) {
        return this.elements[index];
    }

    @Override
    public final int binarySearch(int beginIndex, int endIndex, byte value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.elements.length);
        return Arrays.binarySearch(this.elements, beginIndex, endIndex, value);
    }

    @Override
    public final byte getFirst() {
        try {
            return this.elements[0];
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public final byte getLast() {
        int size = this.elements.length;
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[size - 1];
    }

    public final boolean contains(byte value) {
        if (this.elements.length == 0) {
            return false;
        }
        for (byte e : this.elements) {
            if (value != e) continue;
            return true;
        }
        return false;
    }

    public final boolean containsAll(@NotNull ByteTraversable values) {
        ByteIterator it = values.iterator();
        while (it.hasNext()) {
            byte v = it.nextByte();
            if (this.contains(v)) continue;
            return false;
        }
        return true;
    }

    public final boolean anyMatch(@NotNull BytePredicate predicate) {
        for (byte e : this.elements) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public final boolean allMatch(@NotNull BytePredicate predicate) {
        for (byte e : this.elements) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public final boolean noneMatch(@NotNull BytePredicate predicate) {
        for (byte e : this.elements) {
            if (!predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int indexOf(byte value) {
        return ByteArrays.indexOf((byte[])this.elements, (byte)value);
    }

    @Override
    public final int indexOf(byte value, int from) {
        return ByteArrays.indexOf((byte[])this.elements, (byte)value, (int)from);
    }

    @Override
    public final int indexWhere(@NotNull BytePredicate predicate) {
        return ByteArrays.indexWhere((byte[])this.elements, (BytePredicate)predicate);
    }

    @Override
    public final int indexWhere(@NotNull BytePredicate predicate, int from) {
        return ByteArrays.indexWhere((byte[])this.elements, (BytePredicate)predicate, (int)from);
    }

    @Override
    public final int lastIndexOf(byte value) {
        return ByteArrays.lastIndexOf((byte[])this.elements, (byte)value);
    }

    @Override
    public final int lastIndexOf(byte value, int end) {
        return ByteArrays.lastIndexOf((byte[])this.elements, (byte)value, (int)end);
    }

    @Override
    public final int lastIndexWhere(@NotNull BytePredicate predicate) {
        return ByteArrays.lastIndexWhere((byte[])this.elements, (BytePredicate)predicate);
    }

    @Override
    public final int lastIndexWhere(@NotNull BytePredicate predicate, int end) {
        return ByteArrays.lastIndexWhere((byte[])this.elements, (BytePredicate)predicate, (int)end);
    }

    public final int count(@NotNull BytePredicate predicate) {
        int c = 0;
        for (byte e : this.elements) {
            if (!predicate.test(e)) continue;
            ++c;
        }
        return c;
    }

    public final byte max() {
        return ByteArrays.max((byte[])this.elements);
    }

    public final byte min() {
        return ByteArrays.min((byte[])this.elements);
    }

    public byte foldLeft(byte zero, @NotNull ByteBinaryOperator op) {
        return ByteArrays.foldLeft((byte[])this.elements, (byte)zero, (ByteBinaryOperator)op);
    }

    public <U> U foldLeftToObj(U zero, @NotNull ObjByteBiFunction<U, U> op) {
        return (U)ByteArrays.foldLeftToObj((byte[])this.elements, zero, op);
    }

    public byte foldRight(byte zero, @NotNull ByteBinaryOperator op) {
        return ByteArrays.foldRight((byte[])this.elements, (byte)zero, (ByteBinaryOperator)op);
    }

    public <U> U foldRightToObj(U zero, @NotNull ByteObjBiFunction<U, U> op) {
        return (U)ByteArrays.foldRightToObj((byte[])this.elements, zero, op);
    }

    public byte reduceLeft(@NotNull ByteBinaryOperator op) {
        return ByteArrays.reduceLeft((byte[])this.elements, (ByteBinaryOperator)op);
    }

    public byte reduceRight(@NotNull ByteBinaryOperator op) {
        return ByteArrays.reduceRight((byte[])this.elements, (ByteBinaryOperator)op);
    }

    public final int copyToArray(int srcPos, byte @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + destPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        int dl = dest.length;
        int size = this.elements.length;
        if (destPos >= dl || srcPos >= size) {
            return 0;
        }
        int n = Math.min(Math.min(size - srcPos, dl - destPos), limit);
        System.arraycopy(this.elements, srcPos, dest, destPos, n);
        return n;
    }

    public final byte @NotNull [] toArray() {
        return (byte[])this.elements.clone();
    }

    @Override
    public final void forEach(@NotNull ByteConsumer action) {
        for (byte e : this.elements) {
            action.accept(e);
        }
    }

    @Override
    public final int hashCode() {
        int ans = 0;
        byte[] byArray = this.elements;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte o = byArray[i];
            ans = ans * 31 + Objects.hashCode(o);
        }
        return ans + -1140647423;
    }

    @NotNull
    public final <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        int size = this.elements.length;
        try {
            buffer.append(prefix);
            if (size > 0) {
                buffer.append(Objects.toString(this.elements[0]));
                for (int i = 1; i < size; ++i) {
                    buffer.append(separator);
                    buffer.append(Objects.toString(this.elements[i]));
                }
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    private static final class Factory
    implements ByteCollectionFactory<MutableByteArrayList, ByteArraySeq> {
        private Factory() {
        }

        public ByteArraySeq empty() {
            return ByteArraySeq.empty();
        }

        public ByteArraySeq from(byte @NotNull [] values) {
            return ByteArraySeq.from(values);
        }

        public ByteArraySeq from(@NotNull ByteTraversable values) {
            return ByteArraySeq.from(values);
        }

        public ByteArraySeq from(@NotNull ByteIterator it) {
            return ByteArraySeq.from(it);
        }

        public ByteArraySeq fill(int n, byte value) {
            return ByteArraySeq.fill(n, value);
        }

        public ByteArraySeq fill(int n, @NotNull ByteSupplier supplier) {
            return ByteArraySeq.fill(n, supplier);
        }

        public MutableByteArrayList newBuilder() {
            return new MutableByteArrayList();
        }

        public void addToBuilder(@NotNull MutableByteArrayList buffer, byte value) {
            buffer.append(value);
        }

        public MutableByteArrayList mergeBuilder(@NotNull MutableByteArrayList builder1, @NotNull MutableByteArrayList builder2) {
            throw new UnsupportedOperationException();
        }

        public void sizeHint(@NotNull MutableByteArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public ByteArraySeq build(@NotNull MutableByteArrayList builder) {
            return new ByteArraySeq(builder.toArray());
        }
    }
}

