/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import kala.Conditions;
import kala.collection.SeqLike;
import kala.collection.base.primitive.ByteIterator;
import kala.collection.base.primitive.ByteTraversable;
import kala.collection.mutable.primitive.MutableByteArrayList;
import kala.collection.primitive.ByteCollectionLike;
import kala.collection.primitive.ByteSeqIterator;
import kala.collection.primitive.ByteSeqView;
import kala.collection.primitive.PrimitiveSeqLike;
import kala.collection.primitive.internal.ByteSeqIterators;
import kala.control.primitive.ByteOption;
import kala.function.ByteFunction;
import kala.function.BytePredicate;
import kala.function.ByteUnaryOperator;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public interface ByteSeqLike
extends PrimitiveSeqLike<Byte>,
ByteCollectionLike {
    @Override
    @NotNull
    default public String className() {
        return "ByteSeqLike";
    }

    @Override
    @NotNull
    public ByteSeqView view();

    @NotNull
    default public ByteIterator iterator(int beginIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") < 0");
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0) {
            if (beginIndex > knownSize) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") > size(" + knownSize + ")");
            }
            if (beginIndex == knownSize) {
                return ByteIterator.empty();
            }
        }
        ByteIterator it = this.iterator();
        for (int i = 0; i < beginIndex; ++i) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException("beginIndex: " + beginIndex);
            }
            it.nextByte();
        }
        return it;
    }

    @NotNull
    default public ByteSeqIterator seqIterator() {
        return this.seqIterator(0);
    }

    @NotNull
    default public ByteSeqIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new ByteSeqIterators.DefaultByteSeqIterator<ByteSeqLike>(this, index);
    }

    @Contract(pure=true)
    default public boolean isDefinedAt(int index) {
        return index >= 0 && this.sizeGreaterThan(index);
    }

    default public byte elementAt(int index) {
        return this.get(index);
    }

    @Contract(pure=true)
    @Flow(sourceIsContainer=true)
    default public byte get(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return this.iterator(index).nextByte();
    }

    @Contract(pure=true)
    @Nullable
    default public Byte getOrNull(int index) {
        return this.isDefinedAt(index) ? Byte.valueOf(this.get(index)) : null;
    }

    @Contract(pure=true)
    @Flow(sourceIsContainer=true, targetIsContainer=true)
    @NotNull
    default public ByteOption getOption(int index) {
        return this.isDefinedAt(index) ? ByteOption.some((byte)this.get(index)) : ByteOption.none();
    }

    @NotNull
    default public ByteIterator reverseIterator() {
        ByteIterator it = this.iterator();
        if (!it.hasNext()) {
            return it;
        }
        MutableByteArrayList builder = new MutableByteArrayList();
        while (it.hasNext()) {
            builder.append(it.nextByte());
        }
        return builder.reverseIterator();
    }

    @NotNull
    default public ByteOption find(@NotNull BytePredicate predicate) {
        return this.findFirst(predicate);
    }

    @NotNull
    default public ByteOption findFirst(@NotNull BytePredicate predicate) {
        return this.iterator().find(predicate);
    }

    @NotNull
    default public ByteOption findLast(@NotNull BytePredicate predicate) {
        return this.reverseIterator().find(predicate);
    }

    default public byte getFirst() {
        return this.iterator().nextByte();
    }

    @Nullable
    default public Byte getFirstOrNull() {
        return this.isNotEmpty() ? Byte.valueOf(this.getFirst()) : null;
    }

    @NotNull
    default public ByteOption getFirstOption() {
        return this.isNotEmpty() ? ByteOption.some((byte)this.getFirst()) : ByteOption.none();
    }

    default public byte getLast() {
        return this.reverseIterator().nextByte();
    }

    @Nullable
    default public Byte getLastOrNull() {
        return this.isNotEmpty() ? Byte.valueOf(this.getLast()) : null;
    }

    @NotNull
    default public ByteOption getLastOption() {
        return this.isNotEmpty() ? ByteOption.some((byte)this.getLast()) : ByteOption.none();
    }

    default public byte first(@NotNull BytePredicate predicate) {
        return this.findFirst(predicate).get();
    }

    @Nullable
    default public Byte firstOrNull(@NotNull BytePredicate predicate) {
        return this.findFirst(predicate).getOrNull();
    }

    @NotNull
    default public ByteOption firstOption(@NotNull BytePredicate predicate) {
        return this.findFirst(predicate);
    }

    default public byte last(@NotNull BytePredicate predicate) {
        return this.findLast(predicate).get();
    }

    @Nullable
    default public Byte lastOrNull(@NotNull BytePredicate predicate) {
        return this.findLast(predicate).getOrNull();
    }

    @NotNull
    default public ByteOption lastOption(@NotNull BytePredicate predicate) {
        return this.findLast(predicate);
    }

    @Contract(pure=true)
    default public int indexOf(byte value) {
        int idx = 0;
        ByteIterator it = this.iterator();
        while (it.hasNext()) {
            if (value == it.nextByte()) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexOf(byte value, int from) {
        int idx = 0;
        ByteIterator it = this.iterator();
        while (it.hasNext()) {
            if (idx >= from && value == it.nextByte()) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull BytePredicate predicate) {
        int idx = 0;
        ByteIterator it = this.iterator();
        while (it.hasNext()) {
            if (predicate.test(it.nextByte())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull BytePredicate predicate, int from) {
        int idx = 0;
        ByteIterator it = this.iterator();
        while (it.hasNext()) {
            if (idx >= from && predicate.test(it.nextByte())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(byte value) {
        int idx = this.size() - 1;
        ByteIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (value == it.nextByte()) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(byte value, int end) {
        int idx = this.size() - 1;
        ByteIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (idx <= end && value == it.nextByte()) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull BytePredicate predicate) {
        int idx = this.size() - 1;
        ByteIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (predicate.test(it.nextByte())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull BytePredicate predicate, int end) {
        int idx = this.size() - 1;
        ByteIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (idx <= end && predicate.test(it.nextByte())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    @NotNull
    public ByteSeqLike slice(int var1, int var2);

    @Contract(pure=true)
    @NotNull
    public ByteSeqLike drop(int var1);

    @Contract(pure=true)
    @NotNull
    public ByteSeqLike dropLast(int var1);

    @Contract(pure=true)
    @NotNull
    public ByteSeqLike dropWhile(@NotNull BytePredicate var1);

    @Contract(pure=true)
    @NotNull
    public ByteSeqLike take(int var1);

    @NotNull
    public ByteSeqLike takeLast(int var1);

    @Contract(pure=true)
    @NotNull
    public ByteSeqLike takeWhile(@NotNull BytePredicate var1);

    @Contract(pure=true)
    @NotNull
    public ByteSeqLike updated(int var1, byte var2);

    @Contract(pure=true)
    @NotNull
    public ByteSeqLike concat(@NotNull ByteSeqLike var1);

    @Contract(pure=true)
    @NotNull
    public ByteSeqLike prepended(byte var1);

    @Contract(pure=true)
    @NotNull
    public ByteSeqLike prependedAll(byte @NotNull [] var1);

    @Contract(pure=true)
    @NotNull
    public ByteSeqLike prependedAll(@NotNull ByteTraversable var1);

    @Contract(pure=true)
    @NotNull
    public ByteSeqLike appended(byte var1);

    @Contract(pure=true)
    @NotNull
    public ByteSeqLike appendedAll(@NotNull ByteTraversable var1);

    @Contract(pure=true)
    @NotNull
    public ByteSeqLike appendedAll(byte @NotNull [] var1);

    @Contract(pure=true)
    @NotNull
    public ByteSeqLike sorted();

    @Contract(pure=true)
    @NotNull
    public ByteSeqLike reversed();

    @Override
    @Contract(pure=true)
    @NotNull
    public ByteSeqLike filter(@NotNull BytePredicate var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public ByteSeqLike filterNot(@NotNull BytePredicate var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public ByteSeqLike map(@NotNull ByteUnaryOperator var1);

    @Contract(pure=true)
    @NotNull
    public <U> SeqLike<U> mapToObj(@NotNull ByteFunction<? extends U> var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public ByteSeqLike flatMap(@NotNull ByteFunction<? extends ByteTraversable> var1);

    @NotNull
    public <T> SeqLike<T> flatMapToObj(@NotNull ByteFunction<? extends Iterable<? extends T>> var1);
}

