/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import kala.Conditions;
import kala.collection.base.primitive.DoubleArrays;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.DoubleTraversable;
import kala.collection.factory.primitive.DoubleCollectionFactory;
import kala.collection.immutable.primitive.ImmutableDoubleArray;
import kala.collection.mutable.primitive.MutableDoubleArrayList;
import kala.collection.primitive.AbstractDoubleSeq;
import kala.collection.primitive.IndexedDoubleSeq;
import kala.function.DoubleObjBiFunction;
import kala.function.ObjDoubleBiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;

@Debug.Renderer(hasChildren="isNotEmpty()", childrenArray="elements")
public class DoubleArraySeq
extends AbstractDoubleSeq
implements IndexedDoubleSeq,
Serializable {
    private static final long serialVersionUID = 4981379062449237945L;
    public static final DoubleArraySeq EMPTY = new DoubleArraySeq(DoubleArrays.EMPTY);
    private static final Factory FACTORY = new Factory();
    protected final double @NotNull [] elements;

    protected DoubleArraySeq(double @NotNull [] elements) {
        this.elements = elements;
    }

    @NotNull
    public static DoubleCollectionFactory<?, ? extends DoubleArraySeq> factory() {
        return FACTORY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static DoubleArraySeq wrap(double @NotNull [] array) {
        Objects.requireNonNull(array);
        return new DoubleArraySeq(array);
    }

    @NotNull
    public static DoubleArraySeq empty() {
        return EMPTY;
    }

    @NotNull
    public static DoubleArraySeq of() {
        return DoubleArraySeq.empty();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static DoubleArraySeq of(double value1) {
        return new DoubleArraySeq(new double[]{value1});
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static DoubleArraySeq of(double value1, double value2) {
        return new DoubleArraySeq(new double[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static DoubleArraySeq of(double value1, double value2, double value3) {
        return new DoubleArraySeq(new double[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static DoubleArraySeq of(double value1, double value2, double value3, double value4) {
        return new DoubleArraySeq(new double[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static DoubleArraySeq of(double value1, double value2, double value3, double value4, double value5) {
        return new DoubleArraySeq(new double[]{value1, value2, value3, value4, value5});
    }

    @Contract(pure=true)
    @NotNull
    public static DoubleArraySeq of(double ... values) {
        return DoubleArraySeq.from(values);
    }

    @Contract(pure=true)
    @NotNull
    public static DoubleArraySeq from(double @NotNull [] values) {
        return values.length == 0 ? DoubleArraySeq.empty() : new DoubleArraySeq((double[])values.clone());
    }

    @NotNull
    public static DoubleArraySeq from(@NotNull DoubleTraversable values) {
        if (values instanceof ImmutableDoubleArray) {
            return (DoubleArraySeq)values;
        }
        if (values.isEmpty()) {
            return DoubleArraySeq.empty();
        }
        double[] arr = values.toArray();
        return arr.length == 0 ? DoubleArraySeq.empty() : new DoubleArraySeq(arr);
    }

    @NotNull
    public static DoubleArraySeq from(@NotNull DoubleIterator it) {
        if (!it.hasNext()) {
            return DoubleArraySeq.empty();
        }
        return new DoubleArraySeq(it.toArray());
    }

    @NotNull
    public static DoubleArraySeq fill(int n, double value) {
        if (n <= 0) {
            return DoubleArraySeq.empty();
        }
        double[] ans = new double[n];
        if (value != 0.0) {
            Arrays.fill(ans, value);
        }
        return new DoubleArraySeq(ans);
    }

    @NotNull
    public static DoubleArraySeq fill(int n, @NotNull DoubleSupplier supplier) {
        if (n <= 0) {
            return DoubleArraySeq.empty();
        }
        double[] ans = new double[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsDouble();
        }
        return new DoubleArraySeq(ans);
    }

    @Override
    @NotNull
    public String className() {
        return "DoubleArraySeq";
    }

    @Override
    @NotNull
    public final DoubleIterator iterator() {
        return DoubleArrays.iterator((double[])this.elements);
    }

    @Override
    @NotNull
    public DoubleIterator iterator(int beginIndex) {
        return DoubleArrays.iterator((double[])this.elements, (int)beginIndex);
    }

    @Override
    public final boolean isEmpty() {
        return this.elements.length == 0;
    }

    public final int size() {
        return this.elements.length;
    }

    @Override
    public final int knownSize() {
        return this.elements.length;
    }

    @Override
    @NotNull
    public final DoubleIterator reverseIterator() {
        return DoubleArrays.reverseIterator((double[])this.elements);
    }

    @Override
    public final double get(int index) {
        return this.elements[index];
    }

    @Override
    public final int binarySearch(int beginIndex, int endIndex, double value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.elements.length);
        return Arrays.binarySearch(this.elements, beginIndex, endIndex, value);
    }

    @Override
    public final double getFirst() {
        try {
            return this.elements[0];
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public final double getLast() {
        int size = this.elements.length;
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[size - 1];
    }

    public final boolean contains(double value) {
        if (this.elements.length == 0) {
            return false;
        }
        for (double e : this.elements) {
            if (Double.doubleToLongBits(value) != Double.doubleToLongBits(e)) continue;
            return true;
        }
        return false;
    }

    public final boolean containsAll(@NotNull DoubleTraversable values) {
        DoubleIterator it = values.iterator();
        while (it.hasNext()) {
            double v = it.nextDouble();
            if (this.contains(v)) continue;
            return false;
        }
        return true;
    }

    public final boolean anyMatch(@NotNull DoublePredicate predicate) {
        for (double e : this.elements) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public final boolean allMatch(@NotNull DoublePredicate predicate) {
        for (double e : this.elements) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public final boolean noneMatch(@NotNull DoublePredicate predicate) {
        for (double e : this.elements) {
            if (!predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int indexOf(double value) {
        return DoubleArrays.indexOf((double[])this.elements, (double)value);
    }

    @Override
    public final int indexOf(double value, int from) {
        return DoubleArrays.indexOf((double[])this.elements, (double)value, (int)from);
    }

    @Override
    public final int indexWhere(@NotNull DoublePredicate predicate) {
        return DoubleArrays.indexWhere((double[])this.elements, (DoublePredicate)predicate);
    }

    @Override
    public final int indexWhere(@NotNull DoublePredicate predicate, int from) {
        return DoubleArrays.indexWhere((double[])this.elements, (DoublePredicate)predicate, (int)from);
    }

    @Override
    public final int lastIndexOf(double value) {
        return DoubleArrays.lastIndexOf((double[])this.elements, (double)value);
    }

    @Override
    public final int lastIndexOf(double value, int end) {
        return DoubleArrays.lastIndexOf((double[])this.elements, (double)value, (int)end);
    }

    @Override
    public final int lastIndexWhere(@NotNull DoublePredicate predicate) {
        return DoubleArrays.lastIndexWhere((double[])this.elements, (DoublePredicate)predicate);
    }

    @Override
    public final int lastIndexWhere(@NotNull DoublePredicate predicate, int end) {
        return DoubleArrays.lastIndexWhere((double[])this.elements, (DoublePredicate)predicate, (int)end);
    }

    public final int count(@NotNull DoublePredicate predicate) {
        int c = 0;
        for (double e : this.elements) {
            if (!predicate.test(e)) continue;
            ++c;
        }
        return c;
    }

    public final double max() {
        return DoubleArrays.max((double[])this.elements);
    }

    public final double min() {
        return DoubleArrays.min((double[])this.elements);
    }

    public double foldLeft(double zero, @NotNull DoubleBinaryOperator op) {
        return DoubleArrays.foldLeft((double[])this.elements, (double)zero, (DoubleBinaryOperator)op);
    }

    public <U> U foldLeftToObj(U zero, @NotNull ObjDoubleBiFunction<U, U> op) {
        return (U)DoubleArrays.foldLeftToObj((double[])this.elements, zero, op);
    }

    public double foldRight(double zero, @NotNull DoubleBinaryOperator op) {
        return DoubleArrays.foldRight((double[])this.elements, (double)zero, (DoubleBinaryOperator)op);
    }

    public <U> U foldRightToObj(U zero, @NotNull DoubleObjBiFunction<U, U> op) {
        return (U)DoubleArrays.foldRightToObj((double[])this.elements, zero, op);
    }

    public double reduceLeft(@NotNull DoubleBinaryOperator op) {
        return DoubleArrays.reduceLeft((double[])this.elements, (DoubleBinaryOperator)op);
    }

    public double reduceRight(@NotNull DoubleBinaryOperator op) {
        return DoubleArrays.reduceRight((double[])this.elements, (DoubleBinaryOperator)op);
    }

    public final int copyToArray(int srcPos, double @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + destPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        int dl = dest.length;
        int size = this.elements.length;
        if (destPos >= dl || srcPos >= size) {
            return 0;
        }
        int n = Math.min(Math.min(size - srcPos, dl - destPos), limit);
        System.arraycopy(this.elements, srcPos, dest, destPos, n);
        return n;
    }

    public final double @NotNull [] toArray() {
        return (double[])this.elements.clone();
    }

    @Override
    public final void forEach(@NotNull DoubleConsumer action) {
        for (double e : this.elements) {
            action.accept(e);
        }
    }

    @Override
    public final int hashCode() {
        int ans = 0;
        double[] dArray = this.elements;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double o = dArray[i];
            ans = ans * 31 + Objects.hashCode(o);
        }
        return ans + -1140647423;
    }

    @NotNull
    public final <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        int size = this.elements.length;
        try {
            buffer.append(prefix);
            if (size > 0) {
                buffer.append(Objects.toString(this.elements[0]));
                for (int i = 1; i < size; ++i) {
                    buffer.append(separator);
                    buffer.append(Objects.toString(this.elements[i]));
                }
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    private static final class Factory
    implements DoubleCollectionFactory<MutableDoubleArrayList, DoubleArraySeq> {
        private Factory() {
        }

        public DoubleArraySeq empty() {
            return DoubleArraySeq.empty();
        }

        public DoubleArraySeq from(double @NotNull [] values) {
            return DoubleArraySeq.from(values);
        }

        public DoubleArraySeq from(@NotNull DoubleTraversable values) {
            return DoubleArraySeq.from(values);
        }

        public DoubleArraySeq from(@NotNull DoubleIterator it) {
            return DoubleArraySeq.from(it);
        }

        public DoubleArraySeq fill(int n, double value) {
            return DoubleArraySeq.fill(n, value);
        }

        public DoubleArraySeq fill(int n, @NotNull DoubleSupplier supplier) {
            return DoubleArraySeq.fill(n, supplier);
        }

        public MutableDoubleArrayList newBuilder() {
            return new MutableDoubleArrayList();
        }

        public void addToBuilder(@NotNull MutableDoubleArrayList buffer, double value) {
            buffer.append(value);
        }

        public MutableDoubleArrayList mergeBuilder(@NotNull MutableDoubleArrayList builder1, @NotNull MutableDoubleArrayList builder2) {
            throw new UnsupportedOperationException();
        }

        public void sizeHint(@NotNull MutableDoubleArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public DoubleArraySeq build(@NotNull MutableDoubleArrayList builder) {
            return new DoubleArraySeq(builder.toArray());
        }
    }
}

