/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import kala.Conditions;
import kala.collection.SeqLike;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.DoubleTraversable;
import kala.collection.mutable.primitive.MutableDoubleArrayList;
import kala.collection.primitive.DoubleCollectionLike;
import kala.collection.primitive.DoubleSeqIterator;
import kala.collection.primitive.DoubleSeqView;
import kala.collection.primitive.PrimitiveSeqLike;
import kala.collection.primitive.internal.DoubleSeqIterators;
import kala.control.primitive.DoubleOption;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public interface DoubleSeqLike
extends PrimitiveSeqLike<Double>,
DoubleCollectionLike {
    @Override
    @NotNull
    default public String className() {
        return "DoubleSeqLike";
    }

    @Override
    @NotNull
    public DoubleSeqView view();

    @NotNull
    default public DoubleIterator iterator(int beginIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") < 0");
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0) {
            if (beginIndex > knownSize) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") > size(" + knownSize + ")");
            }
            if (beginIndex == knownSize) {
                return DoubleIterator.empty();
            }
        }
        DoubleIterator it = this.iterator();
        for (int i = 0; i < beginIndex; ++i) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException("beginIndex: " + beginIndex);
            }
            it.nextDouble();
        }
        return it;
    }

    @NotNull
    default public DoubleSeqIterator seqIterator() {
        return this.seqIterator(0);
    }

    @NotNull
    default public DoubleSeqIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new DoubleSeqIterators.DefaultDoubleSeqIterator<DoubleSeqLike>(this, index);
    }

    @Contract(pure=true)
    default public boolean isDefinedAt(int index) {
        return index >= 0 && this.sizeGreaterThan(index);
    }

    default public double elementAt(int index) {
        return this.get(index);
    }

    @Contract(pure=true)
    @Flow(sourceIsContainer=true)
    default public double get(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return this.iterator(index).nextDouble();
    }

    @Contract(pure=true)
    @Nullable
    default public Double getOrNull(int index) {
        return this.isDefinedAt(index) ? Double.valueOf(this.get(index)) : null;
    }

    @Contract(pure=true)
    @Flow(sourceIsContainer=true, targetIsContainer=true)
    @NotNull
    default public DoubleOption getOption(int index) {
        return this.isDefinedAt(index) ? DoubleOption.some((double)this.get(index)) : DoubleOption.none();
    }

    @NotNull
    default public DoubleIterator reverseIterator() {
        DoubleIterator it = this.iterator();
        if (!it.hasNext()) {
            return it;
        }
        MutableDoubleArrayList builder = new MutableDoubleArrayList();
        while (it.hasNext()) {
            builder.append(it.nextDouble());
        }
        return builder.reverseIterator();
    }

    @NotNull
    default public DoubleOption find(@NotNull DoublePredicate predicate) {
        return this.findFirst(predicate);
    }

    @NotNull
    default public DoubleOption findFirst(@NotNull DoublePredicate predicate) {
        return this.iterator().find(predicate);
    }

    @NotNull
    default public DoubleOption findLast(@NotNull DoublePredicate predicate) {
        return this.reverseIterator().find(predicate);
    }

    default public double getFirst() {
        return this.iterator().nextDouble();
    }

    @Nullable
    default public Double getFirstOrNull() {
        return this.isNotEmpty() ? Double.valueOf(this.getFirst()) : null;
    }

    @NotNull
    default public DoubleOption getFirstOption() {
        return this.isNotEmpty() ? DoubleOption.some((double)this.getFirst()) : DoubleOption.none();
    }

    default public double getLast() {
        return this.reverseIterator().nextDouble();
    }

    @Nullable
    default public Double getLastOrNull() {
        return this.isNotEmpty() ? Double.valueOf(this.getLast()) : null;
    }

    @NotNull
    default public DoubleOption getLastOption() {
        return this.isNotEmpty() ? DoubleOption.some((double)this.getLast()) : DoubleOption.none();
    }

    default public double first(@NotNull DoublePredicate predicate) {
        return this.findFirst(predicate).get();
    }

    @Nullable
    default public Double firstOrNull(@NotNull DoublePredicate predicate) {
        return this.findFirst(predicate).getOrNull();
    }

    @NotNull
    default public DoubleOption firstOption(@NotNull DoublePredicate predicate) {
        return this.findFirst(predicate);
    }

    default public double last(@NotNull DoublePredicate predicate) {
        return this.findLast(predicate).get();
    }

    @Nullable
    default public Double lastOrNull(@NotNull DoublePredicate predicate) {
        return this.findLast(predicate).getOrNull();
    }

    @NotNull
    default public DoubleOption lastOption(@NotNull DoublePredicate predicate) {
        return this.findLast(predicate);
    }

    @Contract(pure=true)
    default public int indexOf(double value) {
        int idx = 0;
        DoubleIterator it = this.iterator();
        while (it.hasNext()) {
            if (Double.doubleToLongBits(value) == Double.doubleToLongBits(it.nextDouble())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexOf(double value, int from) {
        int idx = 0;
        DoubleIterator it = this.iterator();
        while (it.hasNext()) {
            if (idx >= from && Double.doubleToLongBits(value) == Double.doubleToLongBits(it.nextDouble())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull DoublePredicate predicate) {
        int idx = 0;
        DoubleIterator it = this.iterator();
        while (it.hasNext()) {
            if (predicate.test(it.nextDouble())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull DoublePredicate predicate, int from) {
        int idx = 0;
        DoubleIterator it = this.iterator();
        while (it.hasNext()) {
            if (idx >= from && predicate.test(it.nextDouble())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(double value) {
        int idx = this.size() - 1;
        DoubleIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (Double.doubleToLongBits(value) == Double.doubleToLongBits(it.nextDouble())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(double value, int end) {
        int idx = this.size() - 1;
        DoubleIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (idx <= end && Double.doubleToLongBits(value) == Double.doubleToLongBits(it.nextDouble())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull DoublePredicate predicate) {
        int idx = this.size() - 1;
        DoubleIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (predicate.test(it.nextDouble())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull DoublePredicate predicate, int end) {
        int idx = this.size() - 1;
        DoubleIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (idx <= end && predicate.test(it.nextDouble())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    @NotNull
    public DoubleSeqLike slice(int var1, int var2);

    @Contract(pure=true)
    @NotNull
    public DoubleSeqLike drop(int var1);

    @Contract(pure=true)
    @NotNull
    public DoubleSeqLike dropLast(int var1);

    @Contract(pure=true)
    @NotNull
    public DoubleSeqLike dropWhile(@NotNull DoublePredicate var1);

    @Contract(pure=true)
    @NotNull
    public DoubleSeqLike take(int var1);

    @NotNull
    public DoubleSeqLike takeLast(int var1);

    @Contract(pure=true)
    @NotNull
    public DoubleSeqLike takeWhile(@NotNull DoublePredicate var1);

    @Contract(pure=true)
    @NotNull
    public DoubleSeqLike updated(int var1, double var2);

    @Contract(pure=true)
    @NotNull
    public DoubleSeqLike concat(@NotNull DoubleSeqLike var1);

    @Contract(pure=true)
    @NotNull
    public DoubleSeqLike prepended(double var1);

    @Contract(pure=true)
    @NotNull
    public DoubleSeqLike prependedAll(double @NotNull [] var1);

    @Contract(pure=true)
    @NotNull
    public DoubleSeqLike prependedAll(@NotNull DoubleTraversable var1);

    @Contract(pure=true)
    @NotNull
    public DoubleSeqLike appended(double var1);

    @Contract(pure=true)
    @NotNull
    public DoubleSeqLike appendedAll(@NotNull DoubleTraversable var1);

    @Contract(pure=true)
    @NotNull
    public DoubleSeqLike appendedAll(double @NotNull [] var1);

    @Contract(pure=true)
    @NotNull
    public DoubleSeqLike sorted();

    @Contract(pure=true)
    @NotNull
    public DoubleSeqLike reversed();

    @Override
    @Contract(pure=true)
    @NotNull
    public DoubleSeqLike filter(@NotNull DoublePredicate var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public DoubleSeqLike filterNot(@NotNull DoublePredicate var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public DoubleSeqLike map(@NotNull DoubleUnaryOperator var1);

    @Contract(pure=true)
    @NotNull
    public <U> SeqLike<U> mapToObj(@NotNull DoubleFunction<? extends U> var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public DoubleSeqLike flatMap(@NotNull DoubleFunction<? extends DoubleTraversable> var1);

    @NotNull
    public <T> SeqLike<T> flatMapToObj(@NotNull DoubleFunction<? extends Iterable<? extends T>> var1);
}

