/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.Conditions;
import kala.collection.base.primitive.FloatArrays;
import kala.collection.base.primitive.FloatIterator;
import kala.collection.base.primitive.FloatTraversable;
import kala.collection.factory.primitive.FloatCollectionFactory;
import kala.collection.immutable.primitive.ImmutableFloatArray;
import kala.collection.mutable.primitive.MutableFloatArrayList;
import kala.collection.primitive.AbstractFloatSeq;
import kala.collection.primitive.IndexedFloatSeq;
import kala.function.FloatBinaryOperator;
import kala.function.FloatConsumer;
import kala.function.FloatObjBiFunction;
import kala.function.FloatPredicate;
import kala.function.FloatSupplier;
import kala.function.ObjFloatBiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;

@Debug.Renderer(hasChildren="isNotEmpty()", childrenArray="elements")
public class FloatArraySeq
extends AbstractFloatSeq
implements IndexedFloatSeq,
Serializable {
    private static final long serialVersionUID = 4981379062449237945L;
    public static final FloatArraySeq EMPTY = new FloatArraySeq(FloatArrays.EMPTY);
    private static final Factory FACTORY = new Factory();
    protected final float @NotNull [] elements;

    protected FloatArraySeq(float @NotNull [] elements) {
        this.elements = elements;
    }

    @NotNull
    public static FloatCollectionFactory<?, ? extends FloatArraySeq> factory() {
        return FACTORY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static FloatArraySeq wrap(float @NotNull [] array) {
        Objects.requireNonNull(array);
        return new FloatArraySeq(array);
    }

    @NotNull
    public static FloatArraySeq empty() {
        return EMPTY;
    }

    @NotNull
    public static FloatArraySeq of() {
        return FloatArraySeq.empty();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static FloatArraySeq of(float value1) {
        return new FloatArraySeq(new float[]{value1});
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static FloatArraySeq of(float value1, float value2) {
        return new FloatArraySeq(new float[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static FloatArraySeq of(float value1, float value2, float value3) {
        return new FloatArraySeq(new float[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static FloatArraySeq of(float value1, float value2, float value3, float value4) {
        return new FloatArraySeq(new float[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static FloatArraySeq of(float value1, float value2, float value3, float value4, float value5) {
        return new FloatArraySeq(new float[]{value1, value2, value3, value4, value5});
    }

    @Contract(pure=true)
    @NotNull
    public static FloatArraySeq of(float ... values) {
        return FloatArraySeq.from(values);
    }

    @Contract(pure=true)
    @NotNull
    public static FloatArraySeq from(float @NotNull [] values) {
        return values.length == 0 ? FloatArraySeq.empty() : new FloatArraySeq((float[])values.clone());
    }

    @NotNull
    public static FloatArraySeq from(@NotNull FloatTraversable values) {
        if (values instanceof ImmutableFloatArray) {
            return (FloatArraySeq)values;
        }
        if (values.isEmpty()) {
            return FloatArraySeq.empty();
        }
        float[] arr = values.toArray();
        return arr.length == 0 ? FloatArraySeq.empty() : new FloatArraySeq(arr);
    }

    @NotNull
    public static FloatArraySeq from(@NotNull FloatIterator it) {
        if (!it.hasNext()) {
            return FloatArraySeq.empty();
        }
        return new FloatArraySeq(it.toArray());
    }

    @NotNull
    public static FloatArraySeq fill(int n, float value) {
        if (n <= 0) {
            return FloatArraySeq.empty();
        }
        float[] ans = new float[n];
        if (value != 0.0f) {
            Arrays.fill(ans, value);
        }
        return new FloatArraySeq(ans);
    }

    @NotNull
    public static FloatArraySeq fill(int n, @NotNull FloatSupplier supplier) {
        if (n <= 0) {
            return FloatArraySeq.empty();
        }
        float[] ans = new float[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsFloat();
        }
        return new FloatArraySeq(ans);
    }

    @Override
    @NotNull
    public String className() {
        return "FloatArraySeq";
    }

    @Override
    @NotNull
    public final FloatIterator iterator() {
        return FloatArrays.iterator((float[])this.elements);
    }

    @Override
    @NotNull
    public FloatIterator iterator(int beginIndex) {
        return FloatArrays.iterator((float[])this.elements, (int)beginIndex);
    }

    @Override
    public final boolean isEmpty() {
        return this.elements.length == 0;
    }

    public final int size() {
        return this.elements.length;
    }

    @Override
    public final int knownSize() {
        return this.elements.length;
    }

    @Override
    @NotNull
    public final FloatIterator reverseIterator() {
        return FloatArrays.reverseIterator((float[])this.elements);
    }

    @Override
    public final float get(int index) {
        return this.elements[index];
    }

    @Override
    public final int binarySearch(int beginIndex, int endIndex, float value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.elements.length);
        return Arrays.binarySearch(this.elements, beginIndex, endIndex, value);
    }

    @Override
    public final float getFirst() {
        try {
            return this.elements[0];
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public final float getLast() {
        int size = this.elements.length;
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[size - 1];
    }

    public final boolean contains(float value) {
        if (this.elements.length == 0) {
            return false;
        }
        for (float e : this.elements) {
            if (Float.floatToIntBits(value) != Float.floatToIntBits(e)) continue;
            return true;
        }
        return false;
    }

    public final boolean containsAll(@NotNull FloatTraversable values) {
        FloatIterator it = values.iterator();
        while (it.hasNext()) {
            float v = it.nextFloat();
            if (this.contains(v)) continue;
            return false;
        }
        return true;
    }

    public final boolean anyMatch(@NotNull FloatPredicate predicate) {
        for (float e : this.elements) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public final boolean allMatch(@NotNull FloatPredicate predicate) {
        for (float e : this.elements) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public final boolean noneMatch(@NotNull FloatPredicate predicate) {
        for (float e : this.elements) {
            if (!predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int indexOf(float value) {
        return FloatArrays.indexOf((float[])this.elements, (float)value);
    }

    @Override
    public final int indexOf(float value, int from) {
        return FloatArrays.indexOf((float[])this.elements, (float)value, (int)from);
    }

    @Override
    public final int indexWhere(@NotNull FloatPredicate predicate) {
        return FloatArrays.indexWhere((float[])this.elements, (FloatPredicate)predicate);
    }

    @Override
    public final int indexWhere(@NotNull FloatPredicate predicate, int from) {
        return FloatArrays.indexWhere((float[])this.elements, (FloatPredicate)predicate, (int)from);
    }

    @Override
    public final int lastIndexOf(float value) {
        return FloatArrays.lastIndexOf((float[])this.elements, (float)value);
    }

    @Override
    public final int lastIndexOf(float value, int end) {
        return FloatArrays.lastIndexOf((float[])this.elements, (float)value, (int)end);
    }

    @Override
    public final int lastIndexWhere(@NotNull FloatPredicate predicate) {
        return FloatArrays.lastIndexWhere((float[])this.elements, (FloatPredicate)predicate);
    }

    @Override
    public final int lastIndexWhere(@NotNull FloatPredicate predicate, int end) {
        return FloatArrays.lastIndexWhere((float[])this.elements, (FloatPredicate)predicate, (int)end);
    }

    public final int count(@NotNull FloatPredicate predicate) {
        int c = 0;
        for (float e : this.elements) {
            if (!predicate.test(e)) continue;
            ++c;
        }
        return c;
    }

    public final float max() {
        return FloatArrays.max((float[])this.elements);
    }

    public final float min() {
        return FloatArrays.min((float[])this.elements);
    }

    public float foldLeft(float zero, @NotNull FloatBinaryOperator op) {
        return FloatArrays.foldLeft((float[])this.elements, (float)zero, (FloatBinaryOperator)op);
    }

    public <U> U foldLeftToObj(U zero, @NotNull ObjFloatBiFunction<U, U> op) {
        return (U)FloatArrays.foldLeftToObj((float[])this.elements, zero, op);
    }

    public float foldRight(float zero, @NotNull FloatBinaryOperator op) {
        return FloatArrays.foldRight((float[])this.elements, (float)zero, (FloatBinaryOperator)op);
    }

    public <U> U foldRightToObj(U zero, @NotNull FloatObjBiFunction<U, U> op) {
        return (U)FloatArrays.foldRightToObj((float[])this.elements, zero, op);
    }

    public float reduceLeft(@NotNull FloatBinaryOperator op) {
        return FloatArrays.reduceLeft((float[])this.elements, (FloatBinaryOperator)op);
    }

    public float reduceRight(@NotNull FloatBinaryOperator op) {
        return FloatArrays.reduceRight((float[])this.elements, (FloatBinaryOperator)op);
    }

    public final int copyToArray(int srcPos, float @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + destPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        int dl = dest.length;
        int size = this.elements.length;
        if (destPos >= dl || srcPos >= size) {
            return 0;
        }
        int n = Math.min(Math.min(size - srcPos, dl - destPos), limit);
        System.arraycopy(this.elements, srcPos, dest, destPos, n);
        return n;
    }

    public final float @NotNull [] toArray() {
        return (float[])this.elements.clone();
    }

    @Override
    public final void forEach(@NotNull FloatConsumer action) {
        for (float e : this.elements) {
            action.accept(e);
        }
    }

    @Override
    public final int hashCode() {
        int ans = 0;
        float[] fArray = this.elements;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            Float o = Float.valueOf(fArray[i]);
            ans = ans * 31 + Objects.hashCode(o);
        }
        return ans + -1140647423;
    }

    @NotNull
    public final <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        int size = this.elements.length;
        try {
            buffer.append(prefix);
            if (size > 0) {
                buffer.append(Objects.toString(Float.valueOf(this.elements[0])));
                for (int i = 1; i < size; ++i) {
                    buffer.append(separator);
                    buffer.append(Objects.toString(Float.valueOf(this.elements[i])));
                }
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    private static final class Factory
    implements FloatCollectionFactory<MutableFloatArrayList, FloatArraySeq> {
        private Factory() {
        }

        public FloatArraySeq empty() {
            return FloatArraySeq.empty();
        }

        public FloatArraySeq from(float @NotNull [] values) {
            return FloatArraySeq.from(values);
        }

        public FloatArraySeq from(@NotNull FloatTraversable values) {
            return FloatArraySeq.from(values);
        }

        public FloatArraySeq from(@NotNull FloatIterator it) {
            return FloatArraySeq.from(it);
        }

        public FloatArraySeq fill(int n, float value) {
            return FloatArraySeq.fill(n, value);
        }

        public FloatArraySeq fill(int n, @NotNull FloatSupplier supplier) {
            return FloatArraySeq.fill(n, supplier);
        }

        public MutableFloatArrayList newBuilder() {
            return new MutableFloatArrayList();
        }

        public void addToBuilder(@NotNull MutableFloatArrayList buffer, float value) {
            buffer.append(value);
        }

        public MutableFloatArrayList mergeBuilder(@NotNull MutableFloatArrayList builder1, @NotNull MutableFloatArrayList builder2) {
            throw new UnsupportedOperationException();
        }

        public void sizeHint(@NotNull MutableFloatArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public FloatArraySeq build(@NotNull MutableFloatArrayList builder) {
            return new FloatArraySeq(builder.toArray());
        }
    }
}

