/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.NoSuchElementException;
import java.util.RandomAccess;
import kala.Conditions;
import kala.collection.base.primitive.AbstractBooleanIterator;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.primitive.BooleanSeqLike;
import kala.control.primitive.BooleanOption;
import kala.function.BooleanConsumer;
import kala.function.BooleanPredicate;
import org.jetbrains.annotations.NotNull;

public interface IndexedBooleanSeqLike
extends BooleanSeqLike,
RandomAccess {
    @NotNull
    default public BooleanIterator iterator() {
        return this.iterator(0);
    }

    @Override
    @NotNull
    default public BooleanIterator iterator(int beginIndex) {
        final int size = this.size();
        if (size == 0) {
            return BooleanIterator.empty();
        }
        final class Itr
        extends AbstractBooleanIterator {
            private int idx;

            Itr(int beginIndex) {
                this.idx = beginIndex;
            }

            public boolean hasNext() {
                return this.idx < size;
            }

            public boolean nextBoolean() {
                if (this.idx >= size) {
                    throw new NoSuchElementException();
                }
                return IndexedBooleanSeqLike.this.get(this.idx++);
            }
        }
        return new Itr(beginIndex);
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public int knownSize() {
        return this.size();
    }

    default public boolean supportsFastRandomAccess() {
        return true;
    }

    @Override
    default public boolean isDefinedAt(int index) {
        return index >= 0 && index < this.size();
    }

    @Override
    public boolean get(int var1);

    @Override
    @NotNull
    default public BooleanIterator reverseIterator() {
        if (this.isEmpty()) {
            return BooleanIterator.empty();
        }
        return new AbstractBooleanIterator(){
            private int idx;
            {
                this.idx = IndexedBooleanSeqLike.this.size() - 1;
            }

            public boolean hasNext() {
                return this.idx >= 0;
            }

            public boolean nextBoolean() {
                if (this.idx < 0) {
                    throw new NoSuchElementException();
                }
                return IndexedBooleanSeqLike.this.get(this.idx--);
            }
        };
    }

    default public int binarySearch(boolean value) {
        return this.binarySearch(0, this.size(), value);
    }

    default public int binarySearch(int beginIndex, int endIndex, boolean value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size());
        int low = beginIndex;
        int high = endIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            boolean midVal = this.get(mid);
            int cmp = Boolean.compare(midVal, value);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    @NotNull
    default public BooleanOption findFirst(@NotNull BooleanPredicate predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            boolean e = this.get(i);
            if (!predicate.test(e)) continue;
            return BooleanOption.some((boolean)e);
        }
        return BooleanOption.none();
    }

    @Override
    @NotNull
    default public BooleanOption findLast(@NotNull BooleanPredicate predicate) {
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            boolean e = this.get(i);
            if (!predicate.test(e)) continue;
            return BooleanOption.some((boolean)e);
        }
        return BooleanOption.none();
    }

    @Override
    default public boolean getFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(0);
    }

    @Override
    default public boolean getLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.get(size - 1);
    }

    default public void forEach(@NotNull BooleanConsumer action) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            action.accept(this.get(i));
        }
    }
}

