/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.NoSuchElementException;
import java.util.RandomAccess;
import kala.Conditions;
import kala.collection.base.primitive.AbstractByteIterator;
import kala.collection.base.primitive.ByteIterator;
import kala.collection.primitive.ByteSeqLike;
import kala.control.primitive.ByteOption;
import kala.function.ByteConsumer;
import kala.function.BytePredicate;
import org.jetbrains.annotations.NotNull;

public interface IndexedByteSeqLike
extends ByteSeqLike,
RandomAccess {
    @NotNull
    default public ByteIterator iterator() {
        return this.iterator(0);
    }

    @Override
    @NotNull
    default public ByteIterator iterator(int beginIndex) {
        final int size = this.size();
        if (size == 0) {
            return ByteIterator.empty();
        }
        final class Itr
        extends AbstractByteIterator {
            private int idx;

            Itr(int beginIndex) {
                this.idx = beginIndex;
            }

            public boolean hasNext() {
                return this.idx < size;
            }

            public byte nextByte() {
                if (this.idx >= size) {
                    throw new NoSuchElementException();
                }
                return IndexedByteSeqLike.this.get(this.idx++);
            }
        }
        return new Itr(beginIndex);
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public int knownSize() {
        return this.size();
    }

    default public boolean supportsFastRandomAccess() {
        return true;
    }

    @Override
    default public boolean isDefinedAt(int index) {
        return index >= 0 && index < this.size();
    }

    @Override
    public byte get(int var1);

    @Override
    @NotNull
    default public ByteIterator reverseIterator() {
        if (this.isEmpty()) {
            return ByteIterator.empty();
        }
        return new AbstractByteIterator(){
            private int idx;
            {
                this.idx = IndexedByteSeqLike.this.size() - 1;
            }

            public boolean hasNext() {
                return this.idx >= 0;
            }

            public byte nextByte() {
                if (this.idx < 0) {
                    throw new NoSuchElementException();
                }
                return IndexedByteSeqLike.this.get(this.idx--);
            }
        };
    }

    default public int binarySearch(byte value) {
        return this.binarySearch(0, this.size(), value);
    }

    default public int binarySearch(int beginIndex, int endIndex, byte value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size());
        int low = beginIndex;
        int high = endIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            byte midVal = this.get(mid);
            int cmp = Byte.compare(midVal, value);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    @NotNull
    default public ByteOption findFirst(@NotNull BytePredicate predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            byte e = this.get(i);
            if (!predicate.test(e)) continue;
            return ByteOption.some((byte)e);
        }
        return ByteOption.none();
    }

    @Override
    @NotNull
    default public ByteOption findLast(@NotNull BytePredicate predicate) {
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            byte e = this.get(i);
            if (!predicate.test(e)) continue;
            return ByteOption.some((byte)e);
        }
        return ByteOption.none();
    }

    @Override
    default public byte getFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(0);
    }

    @Override
    default public byte getLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.get(size - 1);
    }

    default public void forEach(@NotNull ByteConsumer action) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            action.accept(this.get(i));
        }
    }
}

