/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.NoSuchElementException;
import java.util.RandomAccess;
import kala.Conditions;
import kala.collection.base.primitive.AbstractShortIterator;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.primitive.ShortSeqLike;
import kala.control.primitive.ShortOption;
import kala.function.ShortConsumer;
import kala.function.ShortPredicate;
import org.jetbrains.annotations.NotNull;

public interface IndexedShortSeqLike
extends ShortSeqLike,
RandomAccess {
    @NotNull
    default public ShortIterator iterator() {
        return this.iterator(0);
    }

    @Override
    @NotNull
    default public ShortIterator iterator(int beginIndex) {
        final int size = this.size();
        if (size == 0) {
            return ShortIterator.empty();
        }
        final class Itr
        extends AbstractShortIterator {
            private int idx;

            Itr(int beginIndex) {
                this.idx = beginIndex;
            }

            public boolean hasNext() {
                return this.idx < size;
            }

            public short nextShort() {
                if (this.idx >= size) {
                    throw new NoSuchElementException();
                }
                return IndexedShortSeqLike.this.get(this.idx++);
            }
        }
        return new Itr(beginIndex);
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public int knownSize() {
        return this.size();
    }

    default public boolean supportsFastRandomAccess() {
        return true;
    }

    @Override
    default public boolean isDefinedAt(int index) {
        return index >= 0 && index < this.size();
    }

    @Override
    public short get(int var1);

    @Override
    @NotNull
    default public ShortIterator reverseIterator() {
        if (this.isEmpty()) {
            return ShortIterator.empty();
        }
        return new AbstractShortIterator(){
            private int idx;
            {
                this.idx = IndexedShortSeqLike.this.size() - 1;
            }

            public boolean hasNext() {
                return this.idx >= 0;
            }

            public short nextShort() {
                if (this.idx < 0) {
                    throw new NoSuchElementException();
                }
                return IndexedShortSeqLike.this.get(this.idx--);
            }
        };
    }

    default public int binarySearch(short value) {
        return this.binarySearch(0, this.size(), value);
    }

    default public int binarySearch(int beginIndex, int endIndex, short value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size());
        int low = beginIndex;
        int high = endIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            short midVal = this.get(mid);
            int cmp = Short.compare(midVal, value);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    @NotNull
    default public ShortOption findFirst(@NotNull ShortPredicate predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            short e = this.get(i);
            if (!predicate.test(e)) continue;
            return ShortOption.some((short)e);
        }
        return ShortOption.none();
    }

    @Override
    @NotNull
    default public ShortOption findLast(@NotNull ShortPredicate predicate) {
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            short e = this.get(i);
            if (!predicate.test(e)) continue;
            return ShortOption.some((short)e);
        }
        return ShortOption.none();
    }

    @Override
    default public short getFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(0);
    }

    @Override
    default public short getLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.get(size - 1);
    }

    default public void forEach(@NotNull ShortConsumer action) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            action.accept(this.get(i));
        }
    }
}

