/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import kala.Conditions;
import kala.collection.base.primitive.IntArrays;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.factory.primitive.IntCollectionFactory;
import kala.collection.immutable.primitive.ImmutableIntArray;
import kala.collection.mutable.primitive.MutableIntArrayList;
import kala.collection.primitive.AbstractIntSeq;
import kala.collection.primitive.IndexedIntSeq;
import kala.function.IntObjBiFunction;
import kala.function.ObjIntBiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;

@Debug.Renderer(hasChildren="isNotEmpty()", childrenArray="elements")
public class IntArraySeq
extends AbstractIntSeq
implements IndexedIntSeq,
Serializable {
    private static final long serialVersionUID = 4981379062449237945L;
    public static final IntArraySeq EMPTY = new IntArraySeq(IntArrays.EMPTY);
    private static final Factory FACTORY = new Factory();
    protected final int @NotNull [] elements;

    protected IntArraySeq(int @NotNull [] elements) {
        this.elements = elements;
    }

    @NotNull
    public static IntCollectionFactory<?, ? extends IntArraySeq> factory() {
        return FACTORY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static IntArraySeq wrap(int @NotNull [] array) {
        Objects.requireNonNull(array);
        return new IntArraySeq(array);
    }

    @NotNull
    public static IntArraySeq empty() {
        return EMPTY;
    }

    @NotNull
    public static IntArraySeq of() {
        return IntArraySeq.empty();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static IntArraySeq of(int value1) {
        return new IntArraySeq(new int[]{value1});
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static IntArraySeq of(int value1, int value2) {
        return new IntArraySeq(new int[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static IntArraySeq of(int value1, int value2, int value3) {
        return new IntArraySeq(new int[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static IntArraySeq of(int value1, int value2, int value3, int value4) {
        return new IntArraySeq(new int[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static IntArraySeq of(int value1, int value2, int value3, int value4, int value5) {
        return new IntArraySeq(new int[]{value1, value2, value3, value4, value5});
    }

    @Contract(pure=true)
    @NotNull
    public static IntArraySeq of(int ... values) {
        return IntArraySeq.from(values);
    }

    @Contract(pure=true)
    @NotNull
    public static IntArraySeq from(int @NotNull [] values) {
        return values.length == 0 ? IntArraySeq.empty() : new IntArraySeq((int[])values.clone());
    }

    @NotNull
    public static IntArraySeq from(@NotNull IntTraversable values) {
        if (values instanceof ImmutableIntArray) {
            return (IntArraySeq)values;
        }
        if (values.isEmpty()) {
            return IntArraySeq.empty();
        }
        int[] arr = values.toArray();
        return arr.length == 0 ? IntArraySeq.empty() : new IntArraySeq(arr);
    }

    @NotNull
    public static IntArraySeq from(@NotNull IntIterator it) {
        if (!it.hasNext()) {
            return IntArraySeq.empty();
        }
        return new IntArraySeq(it.toArray());
    }

    @NotNull
    public static IntArraySeq fill(int n, int value) {
        if (n <= 0) {
            return IntArraySeq.empty();
        }
        int[] ans = new int[n];
        if (value != 0) {
            Arrays.fill(ans, value);
        }
        return new IntArraySeq(ans);
    }

    @NotNull
    public static IntArraySeq fill(int n, @NotNull IntSupplier supplier) {
        if (n <= 0) {
            return IntArraySeq.empty();
        }
        int[] ans = new int[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsInt();
        }
        return new IntArraySeq(ans);
    }

    @Override
    @NotNull
    public String className() {
        return "IntArraySeq";
    }

    @Override
    @NotNull
    public final IntIterator iterator() {
        return IntArrays.iterator((int[])this.elements);
    }

    @Override
    @NotNull
    public IntIterator iterator(int beginIndex) {
        return IntArrays.iterator((int[])this.elements, (int)beginIndex);
    }

    @Override
    public final boolean isEmpty() {
        return this.elements.length == 0;
    }

    public final int size() {
        return this.elements.length;
    }

    @Override
    public final int knownSize() {
        return this.elements.length;
    }

    @Override
    @NotNull
    public final IntIterator reverseIterator() {
        return IntArrays.reverseIterator((int[])this.elements);
    }

    @Override
    public final int get(int index) {
        return this.elements[index];
    }

    @Override
    public final int binarySearch(int beginIndex, int endIndex, int value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.elements.length);
        return Arrays.binarySearch(this.elements, beginIndex, endIndex, value);
    }

    @Override
    public final int getFirst() {
        try {
            return this.elements[0];
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public final int getLast() {
        int size = this.elements.length;
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[size - 1];
    }

    public final boolean contains(int value) {
        if (this.elements.length == 0) {
            return false;
        }
        for (int e : this.elements) {
            if (value != e) continue;
            return true;
        }
        return false;
    }

    public final boolean containsAll(@NotNull IntTraversable values) {
        IntIterator it = values.iterator();
        while (it.hasNext()) {
            int v = it.nextInt();
            if (this.contains(v)) continue;
            return false;
        }
        return true;
    }

    public final boolean anyMatch(@NotNull IntPredicate predicate) {
        for (int e : this.elements) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public final boolean allMatch(@NotNull IntPredicate predicate) {
        for (int e : this.elements) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public final boolean noneMatch(@NotNull IntPredicate predicate) {
        for (int e : this.elements) {
            if (!predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int indexOf(int value) {
        return IntArrays.indexOf((int[])this.elements, (int)value);
    }

    @Override
    public final int indexOf(int value, int from) {
        return IntArrays.indexOf((int[])this.elements, (int)value, (int)from);
    }

    @Override
    public final int indexWhere(@NotNull IntPredicate predicate) {
        return IntArrays.indexWhere((int[])this.elements, (IntPredicate)predicate);
    }

    @Override
    public final int indexWhere(@NotNull IntPredicate predicate, int from) {
        return IntArrays.indexWhere((int[])this.elements, (IntPredicate)predicate, (int)from);
    }

    @Override
    public final int lastIndexOf(int value) {
        return IntArrays.lastIndexOf((int[])this.elements, (int)value);
    }

    @Override
    public final int lastIndexOf(int value, int end) {
        return IntArrays.lastIndexOf((int[])this.elements, (int)value, (int)end);
    }

    @Override
    public final int lastIndexWhere(@NotNull IntPredicate predicate) {
        return IntArrays.lastIndexWhere((int[])this.elements, (IntPredicate)predicate);
    }

    @Override
    public final int lastIndexWhere(@NotNull IntPredicate predicate, int end) {
        return IntArrays.lastIndexWhere((int[])this.elements, (IntPredicate)predicate, (int)end);
    }

    public final int count(@NotNull IntPredicate predicate) {
        int c = 0;
        for (int e : this.elements) {
            if (!predicate.test(e)) continue;
            ++c;
        }
        return c;
    }

    public final int max() {
        return IntArrays.max((int[])this.elements);
    }

    public final int min() {
        return IntArrays.min((int[])this.elements);
    }

    public int foldLeft(int zero, @NotNull IntBinaryOperator op) {
        return IntArrays.foldLeft((int[])this.elements, (int)zero, (IntBinaryOperator)op);
    }

    public <U> U foldLeftToObj(U zero, @NotNull ObjIntBiFunction<U, U> op) {
        return (U)IntArrays.foldLeftToObj((int[])this.elements, zero, op);
    }

    public int foldRight(int zero, @NotNull IntBinaryOperator op) {
        return IntArrays.foldRight((int[])this.elements, (int)zero, (IntBinaryOperator)op);
    }

    public <U> U foldRightToObj(U zero, @NotNull IntObjBiFunction<U, U> op) {
        return (U)IntArrays.foldRightToObj((int[])this.elements, zero, op);
    }

    public int reduceLeft(@NotNull IntBinaryOperator op) {
        return IntArrays.reduceLeft((int[])this.elements, (IntBinaryOperator)op);
    }

    public int reduceRight(@NotNull IntBinaryOperator op) {
        return IntArrays.reduceRight((int[])this.elements, (IntBinaryOperator)op);
    }

    public final int copyToArray(int srcPos, int @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + destPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        int dl = dest.length;
        int size = this.elements.length;
        if (destPos >= dl || srcPos >= size) {
            return 0;
        }
        int n = Math.min(Math.min(size - srcPos, dl - destPos), limit);
        System.arraycopy(this.elements, srcPos, dest, destPos, n);
        return n;
    }

    public final int @NotNull [] toArray() {
        return (int[])this.elements.clone();
    }

    @Override
    public final void forEach(@NotNull IntConsumer action) {
        for (int e : this.elements) {
            action.accept(e);
        }
    }

    @Override
    public final int hashCode() {
        int ans = 0;
        int[] nArray = this.elements;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer o = nArray[i];
            ans = ans * 31 + Objects.hashCode(o);
        }
        return ans + -1140647423;
    }

    @NotNull
    public final <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        int size = this.elements.length;
        try {
            buffer.append(prefix);
            if (size > 0) {
                buffer.append(Objects.toString(this.elements[0]));
                for (int i = 1; i < size; ++i) {
                    buffer.append(separator);
                    buffer.append(Objects.toString(this.elements[i]));
                }
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    private static final class Factory
    implements IntCollectionFactory<MutableIntArrayList, IntArraySeq> {
        private Factory() {
        }

        public IntArraySeq empty() {
            return IntArraySeq.empty();
        }

        public IntArraySeq from(int @NotNull [] values) {
            return IntArraySeq.from(values);
        }

        public IntArraySeq from(@NotNull IntTraversable values) {
            return IntArraySeq.from(values);
        }

        public IntArraySeq from(@NotNull IntIterator it) {
            return IntArraySeq.from(it);
        }

        public IntArraySeq fill(int n, int value) {
            return IntArraySeq.fill(n, value);
        }

        public IntArraySeq fill(int n, @NotNull IntSupplier supplier) {
            return IntArraySeq.fill(n, supplier);
        }

        public MutableIntArrayList newBuilder() {
            return new MutableIntArrayList();
        }

        public void addToBuilder(@NotNull MutableIntArrayList buffer, int value) {
            buffer.append(value);
        }

        public MutableIntArrayList mergeBuilder(@NotNull MutableIntArrayList builder1, @NotNull MutableIntArrayList builder2) {
            throw new UnsupportedOperationException();
        }

        public void sizeHint(@NotNull MutableIntArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public IntArraySeq build(@NotNull MutableIntArrayList builder) {
            return new IntArraySeq(builder.toArray());
        }
    }
}

