/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;
import kala.Conditions;
import kala.collection.base.primitive.LongArrays;
import kala.collection.base.primitive.LongIterator;
import kala.collection.base.primitive.LongTraversable;
import kala.collection.factory.primitive.LongCollectionFactory;
import kala.collection.immutable.primitive.ImmutableLongArray;
import kala.collection.mutable.primitive.MutableLongArrayList;
import kala.collection.primitive.AbstractLongSeq;
import kala.collection.primitive.IndexedLongSeq;
import kala.function.LongObjBiFunction;
import kala.function.ObjLongBiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;

@Debug.Renderer(hasChildren="isNotEmpty()", childrenArray="elements")
public class LongArraySeq
extends AbstractLongSeq
implements IndexedLongSeq,
Serializable {
    private static final long serialVersionUID = 4981379062449237945L;
    public static final LongArraySeq EMPTY = new LongArraySeq(LongArrays.EMPTY);
    private static final Factory FACTORY = new Factory();
    protected final long @NotNull [] elements;

    protected LongArraySeq(long @NotNull [] elements) {
        this.elements = elements;
    }

    @NotNull
    public static LongCollectionFactory<?, ? extends LongArraySeq> factory() {
        return FACTORY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static LongArraySeq wrap(long @NotNull [] array) {
        Objects.requireNonNull(array);
        return new LongArraySeq(array);
    }

    @NotNull
    public static LongArraySeq empty() {
        return EMPTY;
    }

    @NotNull
    public static LongArraySeq of() {
        return LongArraySeq.empty();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static LongArraySeq of(long value1) {
        return new LongArraySeq(new long[]{value1});
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static LongArraySeq of(long value1, long value2) {
        return new LongArraySeq(new long[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static LongArraySeq of(long value1, long value2, long value3) {
        return new LongArraySeq(new long[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static LongArraySeq of(long value1, long value2, long value3, long value4) {
        return new LongArraySeq(new long[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static LongArraySeq of(long value1, long value2, long value3, long value4, long value5) {
        return new LongArraySeq(new long[]{value1, value2, value3, value4, value5});
    }

    @Contract(pure=true)
    @NotNull
    public static LongArraySeq of(long ... values) {
        return LongArraySeq.from(values);
    }

    @Contract(pure=true)
    @NotNull
    public static LongArraySeq from(long @NotNull [] values) {
        return values.length == 0 ? LongArraySeq.empty() : new LongArraySeq((long[])values.clone());
    }

    @NotNull
    public static LongArraySeq from(@NotNull LongTraversable values) {
        if (values instanceof ImmutableLongArray) {
            return (LongArraySeq)values;
        }
        if (values.isEmpty()) {
            return LongArraySeq.empty();
        }
        long[] arr = values.toArray();
        return arr.length == 0 ? LongArraySeq.empty() : new LongArraySeq(arr);
    }

    @NotNull
    public static LongArraySeq from(@NotNull LongIterator it) {
        if (!it.hasNext()) {
            return LongArraySeq.empty();
        }
        return new LongArraySeq(it.toArray());
    }

    @NotNull
    public static LongArraySeq fill(int n, long value) {
        if (n <= 0) {
            return LongArraySeq.empty();
        }
        long[] ans = new long[n];
        if (value != 0L) {
            Arrays.fill(ans, value);
        }
        return new LongArraySeq(ans);
    }

    @NotNull
    public static LongArraySeq fill(int n, @NotNull LongSupplier supplier) {
        if (n <= 0) {
            return LongArraySeq.empty();
        }
        long[] ans = new long[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsLong();
        }
        return new LongArraySeq(ans);
    }

    @Override
    @NotNull
    public String className() {
        return "LongArraySeq";
    }

    @Override
    @NotNull
    public final LongIterator iterator() {
        return LongArrays.iterator((long[])this.elements);
    }

    @Override
    @NotNull
    public LongIterator iterator(int beginIndex) {
        return LongArrays.iterator((long[])this.elements, (int)beginIndex);
    }

    @Override
    public final boolean isEmpty() {
        return this.elements.length == 0;
    }

    public final int size() {
        return this.elements.length;
    }

    @Override
    public final int knownSize() {
        return this.elements.length;
    }

    @Override
    @NotNull
    public final LongIterator reverseIterator() {
        return LongArrays.reverseIterator((long[])this.elements);
    }

    @Override
    public final long get(int index) {
        return this.elements[index];
    }

    @Override
    public final int binarySearch(int beginIndex, int endIndex, long value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.elements.length);
        return Arrays.binarySearch(this.elements, beginIndex, endIndex, value);
    }

    @Override
    public final long getFirst() {
        try {
            return this.elements[0];
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public final long getLast() {
        int size = this.elements.length;
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[size - 1];
    }

    public final boolean contains(long value) {
        if (this.elements.length == 0) {
            return false;
        }
        for (long e : this.elements) {
            if (value != e) continue;
            return true;
        }
        return false;
    }

    public final boolean containsAll(@NotNull LongTraversable values) {
        LongIterator it = values.iterator();
        while (it.hasNext()) {
            long v = it.nextLong();
            if (this.contains(v)) continue;
            return false;
        }
        return true;
    }

    public final boolean anyMatch(@NotNull LongPredicate predicate) {
        for (long e : this.elements) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public final boolean allMatch(@NotNull LongPredicate predicate) {
        for (long e : this.elements) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public final boolean noneMatch(@NotNull LongPredicate predicate) {
        for (long e : this.elements) {
            if (!predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int indexOf(long value) {
        return LongArrays.indexOf((long[])this.elements, (long)value);
    }

    @Override
    public final int indexOf(long value, int from) {
        return LongArrays.indexOf((long[])this.elements, (long)value, (int)from);
    }

    @Override
    public final int indexWhere(@NotNull LongPredicate predicate) {
        return LongArrays.indexWhere((long[])this.elements, (LongPredicate)predicate);
    }

    @Override
    public final int indexWhere(@NotNull LongPredicate predicate, int from) {
        return LongArrays.indexWhere((long[])this.elements, (LongPredicate)predicate, (int)from);
    }

    @Override
    public final int lastIndexOf(long value) {
        return LongArrays.lastIndexOf((long[])this.elements, (long)value);
    }

    @Override
    public final int lastIndexOf(long value, int end) {
        return LongArrays.lastIndexOf((long[])this.elements, (long)value, (int)end);
    }

    @Override
    public final int lastIndexWhere(@NotNull LongPredicate predicate) {
        return LongArrays.lastIndexWhere((long[])this.elements, (LongPredicate)predicate);
    }

    @Override
    public final int lastIndexWhere(@NotNull LongPredicate predicate, int end) {
        return LongArrays.lastIndexWhere((long[])this.elements, (LongPredicate)predicate, (int)end);
    }

    public final int count(@NotNull LongPredicate predicate) {
        int c = 0;
        for (long e : this.elements) {
            if (!predicate.test(e)) continue;
            ++c;
        }
        return c;
    }

    public final long max() {
        return LongArrays.max((long[])this.elements);
    }

    public final long min() {
        return LongArrays.min((long[])this.elements);
    }

    public long foldLeft(long zero, @NotNull LongBinaryOperator op) {
        return LongArrays.foldLeft((long[])this.elements, (long)zero, (LongBinaryOperator)op);
    }

    public <U> U foldLeftToObj(U zero, @NotNull ObjLongBiFunction<U, U> op) {
        return (U)LongArrays.foldLeftToObj((long[])this.elements, zero, op);
    }

    public long foldRight(long zero, @NotNull LongBinaryOperator op) {
        return LongArrays.foldRight((long[])this.elements, (long)zero, (LongBinaryOperator)op);
    }

    public <U> U foldRightToObj(U zero, @NotNull LongObjBiFunction<U, U> op) {
        return (U)LongArrays.foldRightToObj((long[])this.elements, zero, op);
    }

    public long reduceLeft(@NotNull LongBinaryOperator op) {
        return LongArrays.reduceLeft((long[])this.elements, (LongBinaryOperator)op);
    }

    public long reduceRight(@NotNull LongBinaryOperator op) {
        return LongArrays.reduceRight((long[])this.elements, (LongBinaryOperator)op);
    }

    public final int copyToArray(int srcPos, long @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + destPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        int dl = dest.length;
        int size = this.elements.length;
        if (destPos >= dl || srcPos >= size) {
            return 0;
        }
        int n = Math.min(Math.min(size - srcPos, dl - destPos), limit);
        System.arraycopy(this.elements, srcPos, dest, destPos, n);
        return n;
    }

    public final long @NotNull [] toArray() {
        return (long[])this.elements.clone();
    }

    @Override
    public final void forEach(@NotNull LongConsumer action) {
        for (long e : this.elements) {
            action.accept(e);
        }
    }

    @Override
    public final int hashCode() {
        int ans = 0;
        long[] lArray = this.elements;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long o = lArray[i];
            ans = ans * 31 + Objects.hashCode(o);
        }
        return ans + -1140647423;
    }

    @NotNull
    public final <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        int size = this.elements.length;
        try {
            buffer.append(prefix);
            if (size > 0) {
                buffer.append(Objects.toString(this.elements[0]));
                for (int i = 1; i < size; ++i) {
                    buffer.append(separator);
                    buffer.append(Objects.toString(this.elements[i]));
                }
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    private static final class Factory
    implements LongCollectionFactory<MutableLongArrayList, LongArraySeq> {
        private Factory() {
        }

        public LongArraySeq empty() {
            return LongArraySeq.empty();
        }

        public LongArraySeq from(long @NotNull [] values) {
            return LongArraySeq.from(values);
        }

        public LongArraySeq from(@NotNull LongTraversable values) {
            return LongArraySeq.from(values);
        }

        public LongArraySeq from(@NotNull LongIterator it) {
            return LongArraySeq.from(it);
        }

        public LongArraySeq fill(int n, long value) {
            return LongArraySeq.fill(n, value);
        }

        public LongArraySeq fill(int n, @NotNull LongSupplier supplier) {
            return LongArraySeq.fill(n, supplier);
        }

        public MutableLongArrayList newBuilder() {
            return new MutableLongArrayList();
        }

        public void addToBuilder(@NotNull MutableLongArrayList buffer, long value) {
            buffer.append(value);
        }

        public MutableLongArrayList mergeBuilder(@NotNull MutableLongArrayList builder1, @NotNull MutableLongArrayList builder2) {
            throw new UnsupportedOperationException();
        }

        public void sizeHint(@NotNull MutableLongArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public LongArraySeq build(@NotNull MutableLongArrayList builder) {
            return new LongArraySeq(builder.toArray());
        }
    }
}

