/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.Objects;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import kala.Conditions;
import kala.collection.SeqView;
import kala.collection.base.primitive.LongTraversable;
import kala.collection.immutable.primitive.ImmutableLongSeq;
import kala.collection.primitive.LongArraySeq;
import kala.collection.primitive.LongCollectionView;
import kala.collection.primitive.LongSeqLike;
import kala.collection.primitive.PrimitiveSeqView;
import kala.collection.primitive.internal.view.LongSeqViews;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface LongSeqView
extends LongSeqLike,
LongCollectionView,
PrimitiveSeqView<Long> {
    @NotNull
    public static LongSeqView empty() {
        return LongSeqViews.EMPTY;
    }

    @Override
    @NotNull
    default public String className() {
        return "LongSeqView";
    }

    @Override
    @NotNull
    default public LongSeqView view() {
        return this;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public LongSeqView slice(int beginIndex, int endIndex) {
        int ks = this.knownSize();
        if (ks == 0) {
            if (beginIndex != 0) {
                throw new IndexOutOfBoundsException("beginIndex: " + beginIndex);
            }
            if (endIndex != 0) {
                throw new IndexOutOfBoundsException("endIndex: " + endIndex);
            }
            return LongSeqView.empty();
        }
        if (ks > 0) {
            Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)ks);
        } else {
            if (beginIndex < 0) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") < 0");
            }
            if (beginIndex > endIndex) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") > endIndex(" + endIndex + ")");
            }
        }
        return new LongSeqViews.Slice(this, beginIndex, endIndex);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public LongSeqView drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return LongSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return LongSeqView.empty();
        }
        return new LongSeqViews.Drop(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public LongSeqView dropLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return LongSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return LongSeqView.empty();
        }
        return new LongSeqViews.DropLast(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public LongSeqView dropWhile(@NotNull LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new LongSeqViews.DropWhile(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public LongSeqView take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return LongSeqView.empty();
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return LongSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return this;
        }
        return new LongSeqViews.Take(this, n);
    }

    @Override
    @NotNull
    default public LongSeqView takeLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return LongSeqView.empty();
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return LongSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return this;
        }
        return new LongSeqViews.TakeLast(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public LongSeqView takeWhile(@NotNull LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new LongSeqViews.TakeWhile(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public LongSeqView updated(int index, long newValue) {
        int ks = this.knownSize();
        if (ks < 0) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
        } else {
            Conditions.checkElementIndex((int)index, (int)ks);
        }
        return new LongSeqViews.Updated(this, index, newValue);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public LongSeqView concat(@NotNull LongSeqLike other) {
        Objects.requireNonNull(other);
        return new LongSeqViews.Concat(this, other.view());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public LongSeqView prepended(long value) {
        return new LongSeqViews.Prepended(this, value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public LongSeqView prependedAll(long @NotNull [] values) {
        Objects.requireNonNull(values);
        return new LongSeqViews.Concat(LongArraySeq.wrap(values), this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public LongSeqView prependedAll(@NotNull LongTraversable values) {
        Objects.requireNonNull(values);
        return new LongSeqViews.Concat(values instanceof LongSeqLike ? (LongSeqLike)values : ImmutableLongSeq.from(values), this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public LongSeqView appended(long value) {
        return new LongSeqViews.Appended(this, value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public LongSeqView appendedAll(long @NotNull [] values) {
        Objects.requireNonNull(values);
        return new LongSeqViews.Concat(this, LongArraySeq.wrap(values));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public LongSeqView appendedAll(@NotNull LongTraversable values) {
        Objects.requireNonNull(values);
        return new LongSeqViews.Concat(this, values instanceof LongSeqLike ? (LongSeqLike)values : ImmutableLongSeq.from(values));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public LongSeqView sorted() {
        return new LongSeqViews.Sorted(this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public LongSeqView reversed() {
        return new LongSeqViews.Reversed(this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public LongSeqView filter(@NotNull LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new LongSeqViews.Filter(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public LongSeqView filterNot(@NotNull LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new LongSeqViews.FilterNot(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public LongSeqView map(@NotNull LongUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return new LongSeqViews.Mapped(this, mapper);
    }

    @Contract(pure=true)
    @NotNull
    default public <U> SeqView<U> mapToObj(@NotNull LongFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return new LongSeqViews.MapToObj<U>(this, mapper);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public LongSeqView flatMap(@NotNull LongFunction<? extends LongTraversable> mapper) {
        Objects.requireNonNull(mapper);
        return new LongSeqViews.FlatMapped(this, mapper);
    }

    @NotNull
    default public <T> SeqView<T> flatMapToObj(@NotNull LongFunction<? extends Iterable<? extends T>> mapper) {
        Objects.requireNonNull(mapper);
        return new LongSeqViews.FlatMapToObj(this, mapper);
    }
}

