/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.Conditions;
import kala.collection.base.primitive.ShortArrays;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.base.primitive.ShortTraversable;
import kala.collection.factory.primitive.ShortCollectionFactory;
import kala.collection.immutable.primitive.ImmutableShortArray;
import kala.collection.mutable.primitive.MutableShortArrayList;
import kala.collection.primitive.AbstractShortSeq;
import kala.collection.primitive.IndexedShortSeq;
import kala.function.ObjShortBiFunction;
import kala.function.ShortBinaryOperator;
import kala.function.ShortConsumer;
import kala.function.ShortObjBiFunction;
import kala.function.ShortPredicate;
import kala.function.ShortSupplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;

@Debug.Renderer(hasChildren="isNotEmpty()", childrenArray="elements")
public class ShortArraySeq
extends AbstractShortSeq
implements IndexedShortSeq,
Serializable {
    private static final long serialVersionUID = 4981379062449237945L;
    public static final ShortArraySeq EMPTY = new ShortArraySeq(ShortArrays.EMPTY);
    private static final Factory FACTORY = new Factory();
    protected final short @NotNull [] elements;

    protected ShortArraySeq(short @NotNull [] elements) {
        this.elements = elements;
    }

    @NotNull
    public static ShortCollectionFactory<?, ? extends ShortArraySeq> factory() {
        return FACTORY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ShortArraySeq wrap(short @NotNull [] array) {
        Objects.requireNonNull(array);
        return new ShortArraySeq(array);
    }

    @NotNull
    public static ShortArraySeq empty() {
        return EMPTY;
    }

    @NotNull
    public static ShortArraySeq of() {
        return ShortArraySeq.empty();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ShortArraySeq of(short value1) {
        return new ShortArraySeq(new short[]{value1});
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static ShortArraySeq of(short value1, short value2) {
        return new ShortArraySeq(new short[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static ShortArraySeq of(short value1, short value2, short value3) {
        return new ShortArraySeq(new short[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static ShortArraySeq of(short value1, short value2, short value3, short value4) {
        return new ShortArraySeq(new short[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static ShortArraySeq of(short value1, short value2, short value3, short value4, short value5) {
        return new ShortArraySeq(new short[]{value1, value2, value3, value4, value5});
    }

    @Contract(pure=true)
    @NotNull
    public static ShortArraySeq of(short ... values) {
        return ShortArraySeq.from(values);
    }

    @Contract(pure=true)
    @NotNull
    public static ShortArraySeq from(short @NotNull [] values) {
        return values.length == 0 ? ShortArraySeq.empty() : new ShortArraySeq((short[])values.clone());
    }

    @NotNull
    public static ShortArraySeq from(@NotNull ShortTraversable values) {
        if (values instanceof ImmutableShortArray) {
            return (ShortArraySeq)values;
        }
        if (values.isEmpty()) {
            return ShortArraySeq.empty();
        }
        short[] arr = values.toArray();
        return arr.length == 0 ? ShortArraySeq.empty() : new ShortArraySeq(arr);
    }

    @NotNull
    public static ShortArraySeq from(@NotNull ShortIterator it) {
        if (!it.hasNext()) {
            return ShortArraySeq.empty();
        }
        return new ShortArraySeq(it.toArray());
    }

    @NotNull
    public static ShortArraySeq fill(int n, short value) {
        if (n <= 0) {
            return ShortArraySeq.empty();
        }
        short[] ans = new short[n];
        if (value != 0) {
            Arrays.fill(ans, value);
        }
        return new ShortArraySeq(ans);
    }

    @NotNull
    public static ShortArraySeq fill(int n, @NotNull ShortSupplier supplier) {
        if (n <= 0) {
            return ShortArraySeq.empty();
        }
        short[] ans = new short[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsShort();
        }
        return new ShortArraySeq(ans);
    }

    @Override
    @NotNull
    public String className() {
        return "ShortArraySeq";
    }

    @Override
    @NotNull
    public final ShortIterator iterator() {
        return ShortArrays.iterator((short[])this.elements);
    }

    @Override
    @NotNull
    public ShortIterator iterator(int beginIndex) {
        return ShortArrays.iterator((short[])this.elements, (int)beginIndex);
    }

    @Override
    public final boolean isEmpty() {
        return this.elements.length == 0;
    }

    public final int size() {
        return this.elements.length;
    }

    @Override
    public final int knownSize() {
        return this.elements.length;
    }

    @Override
    @NotNull
    public final ShortIterator reverseIterator() {
        return ShortArrays.reverseIterator((short[])this.elements);
    }

    @Override
    public final short get(int index) {
        return this.elements[index];
    }

    @Override
    public final int binarySearch(int beginIndex, int endIndex, short value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.elements.length);
        return Arrays.binarySearch(this.elements, beginIndex, endIndex, value);
    }

    @Override
    public final short getFirst() {
        try {
            return this.elements[0];
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public final short getLast() {
        int size = this.elements.length;
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[size - 1];
    }

    public final boolean contains(short value) {
        if (this.elements.length == 0) {
            return false;
        }
        for (short e : this.elements) {
            if (value != e) continue;
            return true;
        }
        return false;
    }

    public final boolean containsAll(@NotNull ShortTraversable values) {
        ShortIterator it = values.iterator();
        while (it.hasNext()) {
            short v = it.nextShort();
            if (this.contains(v)) continue;
            return false;
        }
        return true;
    }

    public final boolean anyMatch(@NotNull ShortPredicate predicate) {
        for (short e : this.elements) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public final boolean allMatch(@NotNull ShortPredicate predicate) {
        for (short e : this.elements) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public final boolean noneMatch(@NotNull ShortPredicate predicate) {
        for (short e : this.elements) {
            if (!predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int indexOf(short value) {
        return ShortArrays.indexOf((short[])this.elements, (short)value);
    }

    @Override
    public final int indexOf(short value, int from) {
        return ShortArrays.indexOf((short[])this.elements, (short)value, (int)from);
    }

    @Override
    public final int indexWhere(@NotNull ShortPredicate predicate) {
        return ShortArrays.indexWhere((short[])this.elements, (ShortPredicate)predicate);
    }

    @Override
    public final int indexWhere(@NotNull ShortPredicate predicate, int from) {
        return ShortArrays.indexWhere((short[])this.elements, (ShortPredicate)predicate, (int)from);
    }

    @Override
    public final int lastIndexOf(short value) {
        return ShortArrays.lastIndexOf((short[])this.elements, (short)value);
    }

    @Override
    public final int lastIndexOf(short value, int end) {
        return ShortArrays.lastIndexOf((short[])this.elements, (short)value, (int)end);
    }

    @Override
    public final int lastIndexWhere(@NotNull ShortPredicate predicate) {
        return ShortArrays.lastIndexWhere((short[])this.elements, (ShortPredicate)predicate);
    }

    @Override
    public final int lastIndexWhere(@NotNull ShortPredicate predicate, int end) {
        return ShortArrays.lastIndexWhere((short[])this.elements, (ShortPredicate)predicate, (int)end);
    }

    public final int count(@NotNull ShortPredicate predicate) {
        int c = 0;
        for (short e : this.elements) {
            if (!predicate.test(e)) continue;
            ++c;
        }
        return c;
    }

    public final short max() {
        return ShortArrays.max((short[])this.elements);
    }

    public final short min() {
        return ShortArrays.min((short[])this.elements);
    }

    public short foldLeft(short zero, @NotNull ShortBinaryOperator op) {
        return ShortArrays.foldLeft((short[])this.elements, (short)zero, (ShortBinaryOperator)op);
    }

    public <U> U foldLeftToObj(U zero, @NotNull ObjShortBiFunction<U, U> op) {
        return (U)ShortArrays.foldLeftToObj((short[])this.elements, zero, op);
    }

    public short foldRight(short zero, @NotNull ShortBinaryOperator op) {
        return ShortArrays.foldRight((short[])this.elements, (short)zero, (ShortBinaryOperator)op);
    }

    public <U> U foldRightToObj(U zero, @NotNull ShortObjBiFunction<U, U> op) {
        return (U)ShortArrays.foldRightToObj((short[])this.elements, zero, op);
    }

    public short reduceLeft(@NotNull ShortBinaryOperator op) {
        return ShortArrays.reduceLeft((short[])this.elements, (ShortBinaryOperator)op);
    }

    public short reduceRight(@NotNull ShortBinaryOperator op) {
        return ShortArrays.reduceRight((short[])this.elements, (ShortBinaryOperator)op);
    }

    public final int copyToArray(int srcPos, short @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + destPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        int dl = dest.length;
        int size = this.elements.length;
        if (destPos >= dl || srcPos >= size) {
            return 0;
        }
        int n = Math.min(Math.min(size - srcPos, dl - destPos), limit);
        System.arraycopy(this.elements, srcPos, dest, destPos, n);
        return n;
    }

    public final short @NotNull [] toArray() {
        return (short[])this.elements.clone();
    }

    @Override
    public final void forEach(@NotNull ShortConsumer action) {
        for (short e : this.elements) {
            action.accept(e);
        }
    }

    @Override
    public final int hashCode() {
        int ans = 0;
        short[] sArray = this.elements;
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            Short o = sArray[i];
            ans = ans * 31 + Objects.hashCode(o);
        }
        return ans + -1140647423;
    }

    @NotNull
    public final <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        int size = this.elements.length;
        try {
            buffer.append(prefix);
            if (size > 0) {
                buffer.append(Objects.toString(this.elements[0]));
                for (int i = 1; i < size; ++i) {
                    buffer.append(separator);
                    buffer.append(Objects.toString(this.elements[i]));
                }
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    private static final class Factory
    implements ShortCollectionFactory<MutableShortArrayList, ShortArraySeq> {
        private Factory() {
        }

        public ShortArraySeq empty() {
            return ShortArraySeq.empty();
        }

        public ShortArraySeq from(short @NotNull [] values) {
            return ShortArraySeq.from(values);
        }

        public ShortArraySeq from(@NotNull ShortTraversable values) {
            return ShortArraySeq.from(values);
        }

        public ShortArraySeq from(@NotNull ShortIterator it) {
            return ShortArraySeq.from(it);
        }

        public ShortArraySeq fill(int n, short value) {
            return ShortArraySeq.fill(n, value);
        }

        public ShortArraySeq fill(int n, @NotNull ShortSupplier supplier) {
            return ShortArraySeq.fill(n, supplier);
        }

        public MutableShortArrayList newBuilder() {
            return new MutableShortArrayList();
        }

        public void addToBuilder(@NotNull MutableShortArrayList buffer, short value) {
            buffer.append(value);
        }

        public MutableShortArrayList mergeBuilder(@NotNull MutableShortArrayList builder1, @NotNull MutableShortArrayList builder2) {
            throw new UnsupportedOperationException();
        }

        public void sizeHint(@NotNull MutableShortArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public ShortArraySeq build(@NotNull MutableShortArrayList builder) {
            return new ShortArraySeq(builder.toArray());
        }
    }
}

