/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import kala.Conditions;
import kala.collection.SeqLike;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.base.primitive.ShortTraversable;
import kala.collection.mutable.primitive.MutableShortArrayList;
import kala.collection.primitive.PrimitiveSeqLike;
import kala.collection.primitive.ShortCollectionLike;
import kala.collection.primitive.ShortSeqIterator;
import kala.collection.primitive.ShortSeqView;
import kala.collection.primitive.internal.ShortSeqIterators;
import kala.control.primitive.ShortOption;
import kala.function.ShortFunction;
import kala.function.ShortPredicate;
import kala.function.ShortUnaryOperator;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public interface ShortSeqLike
extends PrimitiveSeqLike<Short>,
ShortCollectionLike {
    @Override
    @NotNull
    default public String className() {
        return "ShortSeqLike";
    }

    @Override
    @NotNull
    public ShortSeqView view();

    @NotNull
    default public ShortIterator iterator(int beginIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") < 0");
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0) {
            if (beginIndex > knownSize) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") > size(" + knownSize + ")");
            }
            if (beginIndex == knownSize) {
                return ShortIterator.empty();
            }
        }
        ShortIterator it = this.iterator();
        for (int i = 0; i < beginIndex; ++i) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException("beginIndex: " + beginIndex);
            }
            it.nextShort();
        }
        return it;
    }

    @NotNull
    default public ShortSeqIterator seqIterator() {
        return this.seqIterator(0);
    }

    @NotNull
    default public ShortSeqIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new ShortSeqIterators.DefaultShortSeqIterator<ShortSeqLike>(this, index);
    }

    @Contract(pure=true)
    default public boolean isDefinedAt(int index) {
        return index >= 0 && this.sizeGreaterThan(index);
    }

    default public short elementAt(int index) {
        return this.get(index);
    }

    @Contract(pure=true)
    @Flow(sourceIsContainer=true)
    default public short get(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return this.iterator(index).nextShort();
    }

    @Contract(pure=true)
    @Nullable
    default public Short getOrNull(int index) {
        return this.isDefinedAt(index) ? Short.valueOf(this.get(index)) : null;
    }

    @Contract(pure=true)
    @Flow(sourceIsContainer=true, targetIsContainer=true)
    @NotNull
    default public ShortOption getOption(int index) {
        return this.isDefinedAt(index) ? ShortOption.some((short)this.get(index)) : ShortOption.none();
    }

    @NotNull
    default public ShortIterator reverseIterator() {
        ShortIterator it = this.iterator();
        if (!it.hasNext()) {
            return it;
        }
        MutableShortArrayList builder = new MutableShortArrayList();
        while (it.hasNext()) {
            builder.append(it.nextShort());
        }
        return builder.reverseIterator();
    }

    @NotNull
    default public ShortOption find(@NotNull ShortPredicate predicate) {
        return this.findFirst(predicate);
    }

    @NotNull
    default public ShortOption findFirst(@NotNull ShortPredicate predicate) {
        return this.iterator().find(predicate);
    }

    @NotNull
    default public ShortOption findLast(@NotNull ShortPredicate predicate) {
        return this.reverseIterator().find(predicate);
    }

    default public short getFirst() {
        return this.iterator().nextShort();
    }

    @Nullable
    default public Short getFirstOrNull() {
        return this.isNotEmpty() ? Short.valueOf(this.getFirst()) : null;
    }

    @NotNull
    default public ShortOption getFirstOption() {
        return this.isNotEmpty() ? ShortOption.some((short)this.getFirst()) : ShortOption.none();
    }

    default public short getLast() {
        return this.reverseIterator().nextShort();
    }

    @Nullable
    default public Short getLastOrNull() {
        return this.isNotEmpty() ? Short.valueOf(this.getLast()) : null;
    }

    @NotNull
    default public ShortOption getLastOption() {
        return this.isNotEmpty() ? ShortOption.some((short)this.getLast()) : ShortOption.none();
    }

    default public short first(@NotNull ShortPredicate predicate) {
        return this.findFirst(predicate).get();
    }

    @Nullable
    default public Short firstOrNull(@NotNull ShortPredicate predicate) {
        return this.findFirst(predicate).getOrNull();
    }

    @NotNull
    default public ShortOption firstOption(@NotNull ShortPredicate predicate) {
        return this.findFirst(predicate);
    }

    default public short last(@NotNull ShortPredicate predicate) {
        return this.findLast(predicate).get();
    }

    @Nullable
    default public Short lastOrNull(@NotNull ShortPredicate predicate) {
        return this.findLast(predicate).getOrNull();
    }

    @NotNull
    default public ShortOption lastOption(@NotNull ShortPredicate predicate) {
        return this.findLast(predicate);
    }

    @Contract(pure=true)
    default public int indexOf(short value) {
        int idx = 0;
        ShortIterator it = this.iterator();
        while (it.hasNext()) {
            if (value == it.nextShort()) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexOf(short value, int from) {
        int idx = 0;
        ShortIterator it = this.iterator();
        while (it.hasNext()) {
            if (idx >= from && value == it.nextShort()) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull ShortPredicate predicate) {
        int idx = 0;
        ShortIterator it = this.iterator();
        while (it.hasNext()) {
            if (predicate.test(it.nextShort())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull ShortPredicate predicate, int from) {
        int idx = 0;
        ShortIterator it = this.iterator();
        while (it.hasNext()) {
            if (idx >= from && predicate.test(it.nextShort())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(short value) {
        int idx = this.size() - 1;
        ShortIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (value == it.nextShort()) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(short value, int end) {
        int idx = this.size() - 1;
        ShortIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (idx <= end && value == it.nextShort()) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull ShortPredicate predicate) {
        int idx = this.size() - 1;
        ShortIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (predicate.test(it.nextShort())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull ShortPredicate predicate, int end) {
        int idx = this.size() - 1;
        ShortIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (idx <= end && predicate.test(it.nextShort())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    @NotNull
    public ShortSeqLike slice(int var1, int var2);

    @Contract(pure=true)
    @NotNull
    public ShortSeqLike drop(int var1);

    @Contract(pure=true)
    @NotNull
    public ShortSeqLike dropLast(int var1);

    @Contract(pure=true)
    @NotNull
    public ShortSeqLike dropWhile(@NotNull ShortPredicate var1);

    @Contract(pure=true)
    @NotNull
    public ShortSeqLike take(int var1);

    @NotNull
    public ShortSeqLike takeLast(int var1);

    @Contract(pure=true)
    @NotNull
    public ShortSeqLike takeWhile(@NotNull ShortPredicate var1);

    @Contract(pure=true)
    @NotNull
    public ShortSeqLike updated(int var1, short var2);

    @Contract(pure=true)
    @NotNull
    public ShortSeqLike concat(@NotNull ShortSeqLike var1);

    @Contract(pure=true)
    @NotNull
    public ShortSeqLike prepended(short var1);

    @Contract(pure=true)
    @NotNull
    public ShortSeqLike prependedAll(short @NotNull [] var1);

    @Contract(pure=true)
    @NotNull
    public ShortSeqLike prependedAll(@NotNull ShortTraversable var1);

    @Contract(pure=true)
    @NotNull
    public ShortSeqLike appended(short var1);

    @Contract(pure=true)
    @NotNull
    public ShortSeqLike appendedAll(@NotNull ShortTraversable var1);

    @Contract(pure=true)
    @NotNull
    public ShortSeqLike appendedAll(short @NotNull [] var1);

    @Contract(pure=true)
    @NotNull
    public ShortSeqLike sorted();

    @Contract(pure=true)
    @NotNull
    public ShortSeqLike reversed();

    @Override
    @Contract(pure=true)
    @NotNull
    public ShortSeqLike filter(@NotNull ShortPredicate var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public ShortSeqLike filterNot(@NotNull ShortPredicate var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public ShortSeqLike map(@NotNull ShortUnaryOperator var1);

    @Contract(pure=true)
    @NotNull
    public <U> SeqLike<U> mapToObj(@NotNull ShortFunction<? extends U> var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public ShortSeqLike flatMap(@NotNull ShortFunction<? extends ShortTraversable> var1);

    @NotNull
    public <T> SeqLike<T> flatMapToObj(@NotNull ShortFunction<? extends Iterable<? extends T>> var1);
}

