/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import kala.collection.base.primitive.AbstractBooleanIterator;
import kala.collection.mutable.primitive.MutableBooleanList;
import kala.collection.mutable.primitive.MutableBooleanListIterator;
import kala.collection.mutable.primitive.MutableBooleanSeq;
import kala.collection.mutable.primitive.MutableBooleanSeqIterator;
import kala.collection.primitive.AbstractBooleanSeqIterator;
import kala.collection.primitive.BooleanSeqIterator;
import kala.collection.primitive.BooleanSeqLike;
import org.jetbrains.annotations.NotNull;

public final class BooleanSeqIterators {
    public static final BooleanSeqIterator EMPTY = new EmptyBooleanSeqIterator();
    public static final MutableBooleanSeqIterator EMPTY_MUTABLE = new EmptyMutableBooleanSeqIterator();

    private BooleanSeqIterators() {
    }

    private static class EmptyBooleanSeqIterator
    extends AbstractBooleanIterator
    implements BooleanSeqIterator {
        private EmptyBooleanSeqIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean nextBoolean() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public boolean previousBoolean() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }
    }

    private static class EmptyMutableBooleanSeqIterator
    extends EmptyBooleanSeqIterator
    implements MutableBooleanSeqIterator {
        private EmptyMutableBooleanSeqIterator() {
        }

        @Override
        public void set(boolean e) {
            throw new IllegalStateException();
        }
    }

    public static final class FrozenBooleanSeqIterator
    implements BooleanSeqIterator {
        @NotNull
        private final BooleanSeqIterator source;

        public FrozenBooleanSeqIterator(@NotNull BooleanSeqIterator source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public boolean nextBoolean() {
            return this.source.nextBoolean();
        }

        @Override
        public boolean hasPrevious() {
            return this.source.hasPrevious();
        }

        @Override
        public boolean previousBoolean() {
            return this.source.previousBoolean();
        }

        @Override
        public int nextIndex() {
            return this.source.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.source.previousIndex();
        }

        public String toString() {
            return "FrozenBooleanSeqIterator[" + String.valueOf(this.source) + "]";
        }
    }

    public static class DefaultMutableBooleanListIterator<S extends MutableBooleanList>
    extends DefaultMutableBooleanSeqIterator<S>
    implements MutableBooleanListIterator {
        public DefaultMutableBooleanListIterator(@NotNull S seq, int index) {
            super(seq, index);
        }

        @Override
        public void add(boolean e) {
            try {
                int i = this.cursor;
                ((MutableBooleanList)this.seq).insert(i, e);
                this.lastRet = -1;
                this.cursor = i + 1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                ((MutableBooleanList)this.seq).removeAt(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public static class DefaultMutableBooleanSeqIterator<S extends MutableBooleanSeq>
    extends DefaultBooleanSeqIterator<S>
    implements MutableBooleanSeqIterator {
        public DefaultMutableBooleanSeqIterator(@NotNull S seq, int index) {
            super(seq, index);
        }

        @Override
        public void set(boolean e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                ((MutableBooleanSeq)this.seq).set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public static class DefaultBooleanSeqIterator<S extends BooleanSeqLike>
    extends AbstractBooleanSeqIterator {
        @NotNull
        protected final S seq;
        protected int lastRet = -1;

        public DefaultBooleanSeqIterator(@NotNull S seq, int index) {
            super(index);
            this.seq = seq;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.seq.size();
        }

        @Override
        public boolean nextBoolean() {
            try {
                int i = this.cursor;
                boolean next = this.seq.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public boolean previousBoolean() {
            try {
                int i = this.cursor - 1;
                boolean previous = this.seq.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }
    }
}

