/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import kala.collection.base.primitive.AbstractCharIterator;
import kala.collection.mutable.primitive.MutableCharList;
import kala.collection.mutable.primitive.MutableCharListIterator;
import kala.collection.mutable.primitive.MutableCharSeq;
import kala.collection.mutable.primitive.MutableCharSeqIterator;
import kala.collection.primitive.AbstractCharSeqIterator;
import kala.collection.primitive.CharSeqIterator;
import kala.collection.primitive.CharSeqLike;
import org.jetbrains.annotations.NotNull;

public final class CharSeqIterators {
    public static final CharSeqIterator EMPTY = new EmptyCharSeqIterator();
    public static final MutableCharSeqIterator EMPTY_MUTABLE = new EmptyMutableCharSeqIterator();

    private CharSeqIterators() {
    }

    private static class EmptyCharSeqIterator
    extends AbstractCharIterator
    implements CharSeqIterator {
        private EmptyCharSeqIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public char nextChar() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public char previousChar() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }
    }

    private static class EmptyMutableCharSeqIterator
    extends EmptyCharSeqIterator
    implements MutableCharSeqIterator {
        private EmptyMutableCharSeqIterator() {
        }

        @Override
        public void set(char e) {
            throw new IllegalStateException();
        }
    }

    public static final class FrozenCharSeqIterator
    implements CharSeqIterator {
        @NotNull
        private final CharSeqIterator source;

        public FrozenCharSeqIterator(@NotNull CharSeqIterator source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public char nextChar() {
            return this.source.nextChar();
        }

        @Override
        public boolean hasPrevious() {
            return this.source.hasPrevious();
        }

        @Override
        public char previousChar() {
            return this.source.previousChar();
        }

        @Override
        public int nextIndex() {
            return this.source.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.source.previousIndex();
        }

        public String toString() {
            return "FrozenCharSeqIterator[" + String.valueOf(this.source) + "]";
        }
    }

    public static class DefaultMutableCharListIterator<S extends MutableCharList>
    extends DefaultMutableCharSeqIterator<S>
    implements MutableCharListIterator {
        public DefaultMutableCharListIterator(@NotNull S seq, int index) {
            super(seq, index);
        }

        @Override
        public void add(char e) {
            try {
                int i = this.cursor;
                ((MutableCharList)this.seq).insert(i, e);
                this.lastRet = -1;
                this.cursor = i + 1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                ((MutableCharList)this.seq).removeAt(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public static class DefaultMutableCharSeqIterator<S extends MutableCharSeq>
    extends DefaultCharSeqIterator<S>
    implements MutableCharSeqIterator {
        public DefaultMutableCharSeqIterator(@NotNull S seq, int index) {
            super(seq, index);
        }

        @Override
        public void set(char e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                ((MutableCharSeq)this.seq).set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public static class DefaultCharSeqIterator<S extends CharSeqLike>
    extends AbstractCharSeqIterator {
        @NotNull
        protected final S seq;
        protected int lastRet = -1;

        public DefaultCharSeqIterator(@NotNull S seq, int index) {
            super(index);
            this.seq = seq;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.seq.size();
        }

        @Override
        public char nextChar() {
            try {
                int i = this.cursor;
                char next = this.seq.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public char previousChar() {
            try {
                int i = this.cursor - 1;
                char previous = this.seq.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }
    }
}

