/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import kala.collection.base.primitive.AbstractFloatIterator;
import kala.collection.mutable.primitive.MutableFloatList;
import kala.collection.mutable.primitive.MutableFloatListIterator;
import kala.collection.mutable.primitive.MutableFloatSeq;
import kala.collection.mutable.primitive.MutableFloatSeqIterator;
import kala.collection.primitive.AbstractFloatSeqIterator;
import kala.collection.primitive.FloatSeqIterator;
import kala.collection.primitive.FloatSeqLike;
import org.jetbrains.annotations.NotNull;

public final class FloatSeqIterators {
    public static final FloatSeqIterator EMPTY = new EmptyFloatSeqIterator();
    public static final MutableFloatSeqIterator EMPTY_MUTABLE = new EmptyMutableFloatSeqIterator();

    private FloatSeqIterators() {
    }

    private static class EmptyFloatSeqIterator
    extends AbstractFloatIterator
    implements FloatSeqIterator {
        private EmptyFloatSeqIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public float nextFloat() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public float previousFloat() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }
    }

    private static class EmptyMutableFloatSeqIterator
    extends EmptyFloatSeqIterator
    implements MutableFloatSeqIterator {
        private EmptyMutableFloatSeqIterator() {
        }

        @Override
        public void set(float e) {
            throw new IllegalStateException();
        }
    }

    public static final class FrozenFloatSeqIterator
    implements FloatSeqIterator {
        @NotNull
        private final FloatSeqIterator source;

        public FrozenFloatSeqIterator(@NotNull FloatSeqIterator source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public float nextFloat() {
            return this.source.nextFloat();
        }

        @Override
        public boolean hasPrevious() {
            return this.source.hasPrevious();
        }

        @Override
        public float previousFloat() {
            return this.source.previousFloat();
        }

        @Override
        public int nextIndex() {
            return this.source.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.source.previousIndex();
        }

        public String toString() {
            return "FrozenFloatSeqIterator[" + String.valueOf(this.source) + "]";
        }
    }

    public static class DefaultMutableFloatListIterator<S extends MutableFloatList>
    extends DefaultMutableFloatSeqIterator<S>
    implements MutableFloatListIterator {
        public DefaultMutableFloatListIterator(@NotNull S seq, int index) {
            super(seq, index);
        }

        @Override
        public void add(float e) {
            try {
                int i = this.cursor;
                ((MutableFloatList)this.seq).insert(i, e);
                this.lastRet = -1;
                this.cursor = i + 1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                ((MutableFloatList)this.seq).removeAt(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public static class DefaultMutableFloatSeqIterator<S extends MutableFloatSeq>
    extends DefaultFloatSeqIterator<S>
    implements MutableFloatSeqIterator {
        public DefaultMutableFloatSeqIterator(@NotNull S seq, int index) {
            super(seq, index);
        }

        @Override
        public void set(float e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                ((MutableFloatSeq)this.seq).set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public static class DefaultFloatSeqIterator<S extends FloatSeqLike>
    extends AbstractFloatSeqIterator {
        @NotNull
        protected final S seq;
        protected int lastRet = -1;

        public DefaultFloatSeqIterator(@NotNull S seq, int index) {
            super(index);
            this.seq = seq;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.seq.size();
        }

        @Override
        public float nextFloat() {
            try {
                int i = this.cursor;
                float next = this.seq.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public float previousFloat() {
            try {
                int i = this.cursor - 1;
                float previous = this.seq.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }
    }
}

