/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import kala.collection.base.primitive.AbstractLongIterator;
import kala.collection.mutable.primitive.MutableLongList;
import kala.collection.mutable.primitive.MutableLongListIterator;
import kala.collection.mutable.primitive.MutableLongSeq;
import kala.collection.mutable.primitive.MutableLongSeqIterator;
import kala.collection.primitive.AbstractLongSeqIterator;
import kala.collection.primitive.LongSeqIterator;
import kala.collection.primitive.LongSeqLike;
import org.jetbrains.annotations.NotNull;

public final class LongSeqIterators {
    public static final LongSeqIterator EMPTY = new EmptyLongSeqIterator();
    public static final MutableLongSeqIterator EMPTY_MUTABLE = new EmptyMutableLongSeqIterator();

    private LongSeqIterators() {
    }

    private static class EmptyLongSeqIterator
    extends AbstractLongIterator
    implements LongSeqIterator {
        private EmptyLongSeqIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public long nextLong() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public long previousLong() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }
    }

    private static class EmptyMutableLongSeqIterator
    extends EmptyLongSeqIterator
    implements MutableLongSeqIterator {
        private EmptyMutableLongSeqIterator() {
        }

        @Override
        public void set(long e) {
            throw new IllegalStateException();
        }
    }

    public static final class FrozenLongSeqIterator
    implements LongSeqIterator {
        @NotNull
        private final LongSeqIterator source;

        public FrozenLongSeqIterator(@NotNull LongSeqIterator source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public long nextLong() {
            return this.source.nextLong();
        }

        @Override
        public boolean hasPrevious() {
            return this.source.hasPrevious();
        }

        @Override
        public long previousLong() {
            return this.source.previousLong();
        }

        @Override
        public int nextIndex() {
            return this.source.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.source.previousIndex();
        }

        public String toString() {
            return "FrozenLongSeqIterator[" + String.valueOf(this.source) + "]";
        }
    }

    public static class DefaultMutableLongListIterator<S extends MutableLongList>
    extends DefaultMutableLongSeqIterator<S>
    implements MutableLongListIterator {
        public DefaultMutableLongListIterator(@NotNull S seq, int index) {
            super(seq, index);
        }

        @Override
        public void add(long e) {
            try {
                int i = this.cursor;
                ((MutableLongList)this.seq).insert(i, e);
                this.lastRet = -1;
                this.cursor = i + 1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                ((MutableLongList)this.seq).removeAt(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public static class DefaultMutableLongSeqIterator<S extends MutableLongSeq>
    extends DefaultLongSeqIterator<S>
    implements MutableLongSeqIterator {
        public DefaultMutableLongSeqIterator(@NotNull S seq, int index) {
            super(seq, index);
        }

        @Override
        public void set(long e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                ((MutableLongSeq)this.seq).set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public static class DefaultLongSeqIterator<S extends LongSeqLike>
    extends AbstractLongSeqIterator {
        @NotNull
        protected final S seq;
        protected int lastRet = -1;

        public DefaultLongSeqIterator(@NotNull S seq, int index) {
            super(index);
            this.seq = seq;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.seq.size();
        }

        @Override
        public long nextLong() {
            try {
                int i = this.cursor;
                long next = this.seq.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public long previousLong() {
            try {
                int i = this.cursor - 1;
                long previous = this.seq.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }
    }
}

