/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import kala.collection.base.primitive.AbstractShortIterator;
import kala.collection.mutable.primitive.MutableShortList;
import kala.collection.mutable.primitive.MutableShortListIterator;
import kala.collection.mutable.primitive.MutableShortSeq;
import kala.collection.mutable.primitive.MutableShortSeqIterator;
import kala.collection.primitive.AbstractShortSeqIterator;
import kala.collection.primitive.ShortSeqIterator;
import kala.collection.primitive.ShortSeqLike;
import org.jetbrains.annotations.NotNull;

public final class ShortSeqIterators {
    public static final ShortSeqIterator EMPTY = new EmptyShortSeqIterator();
    public static final MutableShortSeqIterator EMPTY_MUTABLE = new EmptyMutableShortSeqIterator();

    private ShortSeqIterators() {
    }

    private static class EmptyShortSeqIterator
    extends AbstractShortIterator
    implements ShortSeqIterator {
        private EmptyShortSeqIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public short nextShort() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public short previousShort() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }
    }

    private static class EmptyMutableShortSeqIterator
    extends EmptyShortSeqIterator
    implements MutableShortSeqIterator {
        private EmptyMutableShortSeqIterator() {
        }

        @Override
        public void set(short e) {
            throw new IllegalStateException();
        }
    }

    public static final class FrozenShortSeqIterator
    implements ShortSeqIterator {
        @NotNull
        private final ShortSeqIterator source;

        public FrozenShortSeqIterator(@NotNull ShortSeqIterator source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public short nextShort() {
            return this.source.nextShort();
        }

        @Override
        public boolean hasPrevious() {
            return this.source.hasPrevious();
        }

        @Override
        public short previousShort() {
            return this.source.previousShort();
        }

        @Override
        public int nextIndex() {
            return this.source.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.source.previousIndex();
        }

        public String toString() {
            return "FrozenShortSeqIterator[" + String.valueOf(this.source) + "]";
        }
    }

    public static class DefaultMutableShortListIterator<S extends MutableShortList>
    extends DefaultMutableShortSeqIterator<S>
    implements MutableShortListIterator {
        public DefaultMutableShortListIterator(@NotNull S seq, int index) {
            super(seq, index);
        }

        @Override
        public void add(short e) {
            try {
                int i = this.cursor;
                ((MutableShortList)this.seq).insert(i, e);
                this.lastRet = -1;
                this.cursor = i + 1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                ((MutableShortList)this.seq).removeAt(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public static class DefaultMutableShortSeqIterator<S extends MutableShortSeq>
    extends DefaultShortSeqIterator<S>
    implements MutableShortSeqIterator {
        public DefaultMutableShortSeqIterator(@NotNull S seq, int index) {
            super(seq, index);
        }

        @Override
        public void set(short e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                ((MutableShortSeq)this.seq).set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public static class DefaultShortSeqIterator<S extends ShortSeqLike>
    extends AbstractShortSeqIterator {
        @NotNull
        protected final S seq;
        protected int lastRet = -1;

        public DefaultShortSeqIterator(@NotNull S seq, int index) {
            super(index);
            this.seq = seq;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.seq.size();
        }

        @Override
        public short nextShort() {
            try {
                int i = this.cursor;
                short next = this.seq.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public short previousShort() {
            try {
                int i = this.cursor - 1;
                short previous = this.seq.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }
    }
}

