/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal.tree;

import java.io.Serializable;
import kala.function.CharConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CharRedBlackTree<N extends Node<N>>
implements Serializable {
    private static final long serialVersionUID = 3036340578028981301L;
    protected static final boolean RED = true;
    protected static final boolean BLACK = false;
    protected transient N root;
    protected transient int size;

    protected CharRedBlackTree() {
    }

    @Nullable
    protected final N getNode(char key) {
        N n = this.root;
        while (n != null) {
            int c = Character.compare(key, ((Node)n).key);
            if (c < 0) {
                n = ((Node)n).left;
                continue;
            }
            if (c > 0) {
                n = ((Node)n).right;
                continue;
            }
            return n;
        }
        return null;
    }

    @Nullable
    protected final N firstNode() {
        N node = this.root;
        if (node == null) {
            return null;
        }
        while (((Node)node).left != null) {
            node = ((Node)node).left;
        }
        return node;
    }

    @Nullable
    protected final N lastNode() {
        N node = this.root;
        if (node == null) {
            return null;
        }
        while (((Node)node).right != null) {
            node = ((Node)node).right;
        }
        return node;
    }

    protected static boolean colorOf(Node<?> p) {
        return p == null ? false : p.color;
    }

    protected static <N extends Node<N>> N parentOrNull(N p) {
        return p == null ? null : (N)p.parent;
    }

    protected static void setColor(Node<?> p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    protected static <N extends Node<N>> N leftOrNull(@Nullable N p) {
        return p == null ? null : (N)p.left;
    }

    protected static <N extends Node<N>> N rightOrNull(@Nullable N p) {
        return p == null ? null : (N)p.right;
    }

    protected static <N extends Node<N>> N minNode(@NotNull N node) {
        Object left;
        while ((left = node.left) != null) {
            node = left;
        }
        return node;
    }

    protected static <N extends Node<N>> N maxNode(@NotNull N node) {
        Object right;
        while ((right = node.right) != null) {
            node = right;
        }
        return node;
    }

    protected static <N extends Node<N>> N successor(@NotNull N node) {
        if (node.right != null) {
            return CharRedBlackTree.minNode(node.right);
        }
        Object n = node.parent;
        N ch = node;
        while (n != null && ch == ((Node)n).right) {
            ch = n;
            n = ((Node)n).parent;
        }
        return n;
    }

    protected static <N extends Node<N>> N predecessor(@NotNull N node) {
        if (node.left != null) {
            return CharRedBlackTree.maxNode(node.left);
        }
        Object p = node.parent;
        N ch = node;
        while (p != null && ch == ((Node)p).left) {
            ch = p;
            p = ((Node)p).parent;
        }
        return p;
    }

    protected final void rotateLeft(N node) {
        if (node == null) {
            return;
        }
        Object r = ((Node)node).right;
        ((Node)node).right = ((Node)r).left;
        if (((Node)r).left != null) {
            ((Node)((Node)r).left).parent = node;
        }
        ((Node)r).parent = ((Node)node).parent;
        if (((Node)node).parent == null) {
            this.root = r;
        } else if (((Node)((Node)node).parent).left == node) {
            ((Node)((Node)node).parent).left = r;
        } else {
            ((Node)((Node)node).parent).right = r;
        }
        ((Node)r).left = node;
        ((Node)node).parent = r;
    }

    protected final void rotateRight(N node) {
        if (node == null) {
            return;
        }
        Object l = ((Node)node).left;
        ((Node)node).left = ((Node)l).right;
        if (((Node)l).right != null) {
            ((Node)((Node)l).right).parent = node;
        }
        ((Node)l).parent = ((Node)node).parent;
        if (((Node)node).parent == null) {
            this.root = l;
        } else if (((Node)((Node)node).parent).right == node) {
            ((Node)((Node)node).parent).right = l;
        } else {
            ((Node)((Node)node).parent).left = l;
        }
        ((Node)l).right = node;
        ((Node)node).parent = l;
    }

    protected final void fixAfterInsert(N x) {
        ((Node)x).color = true;
        while (x != null && x != this.root && ((Node)((Node)x).parent).color) {
            N y;
            if (CharRedBlackTree.parentOrNull(x) == CharRedBlackTree.leftOrNull(CharRedBlackTree.parentOrNull(CharRedBlackTree.parentOrNull(x)))) {
                y = CharRedBlackTree.rightOrNull(CharRedBlackTree.parentOrNull(CharRedBlackTree.parentOrNull(x)));
                if (CharRedBlackTree.colorOf(y)) {
                    CharRedBlackTree.setColor(CharRedBlackTree.parentOrNull(x), false);
                    CharRedBlackTree.setColor(y, false);
                    CharRedBlackTree.setColor(CharRedBlackTree.parentOrNull(CharRedBlackTree.parentOrNull(x)), true);
                    x = CharRedBlackTree.parentOrNull(CharRedBlackTree.parentOrNull(x));
                    continue;
                }
                if (x == CharRedBlackTree.rightOrNull(CharRedBlackTree.parentOrNull(x))) {
                    x = CharRedBlackTree.parentOrNull(x);
                    this.rotateLeft(x);
                }
                CharRedBlackTree.setColor(CharRedBlackTree.parentOrNull(x), false);
                CharRedBlackTree.setColor(CharRedBlackTree.parentOrNull(CharRedBlackTree.parentOrNull(x)), true);
                this.rotateRight(CharRedBlackTree.parentOrNull(CharRedBlackTree.parentOrNull(x)));
                continue;
            }
            y = CharRedBlackTree.leftOrNull(CharRedBlackTree.parentOrNull(CharRedBlackTree.parentOrNull(x)));
            if (CharRedBlackTree.colorOf(y)) {
                CharRedBlackTree.setColor(CharRedBlackTree.parentOrNull(x), false);
                CharRedBlackTree.setColor(y, false);
                CharRedBlackTree.setColor(CharRedBlackTree.parentOrNull(CharRedBlackTree.parentOrNull(x)), true);
                x = CharRedBlackTree.parentOrNull(CharRedBlackTree.parentOrNull(x));
                continue;
            }
            if (x == CharRedBlackTree.leftOrNull(CharRedBlackTree.parentOrNull(x))) {
                x = CharRedBlackTree.parentOrNull(x);
                this.rotateRight(x);
            }
            CharRedBlackTree.setColor(CharRedBlackTree.parentOrNull(x), false);
            CharRedBlackTree.setColor(CharRedBlackTree.parentOrNull(CharRedBlackTree.parentOrNull(x)), true);
            this.rotateLeft(CharRedBlackTree.parentOrNull(CharRedBlackTree.parentOrNull(x)));
        }
        ((Node)this.root).color = false;
    }

    protected final void fixAfterDelete(N x) {
        while (x != this.root && !CharRedBlackTree.colorOf(x)) {
            N sib;
            if (x == CharRedBlackTree.leftOrNull(CharRedBlackTree.parentOrNull(x))) {
                sib = CharRedBlackTree.rightOrNull(CharRedBlackTree.parentOrNull(x));
                if (CharRedBlackTree.colorOf(sib)) {
                    CharRedBlackTree.setColor(sib, false);
                    CharRedBlackTree.setColor(CharRedBlackTree.parentOrNull(x), true);
                    this.rotateLeft(CharRedBlackTree.parentOrNull(x));
                    sib = CharRedBlackTree.rightOrNull(CharRedBlackTree.parentOrNull(x));
                }
                if (!CharRedBlackTree.colorOf(CharRedBlackTree.leftOrNull(sib)) && !CharRedBlackTree.colorOf(CharRedBlackTree.rightOrNull(sib))) {
                    CharRedBlackTree.setColor(sib, true);
                    x = CharRedBlackTree.parentOrNull(x);
                    continue;
                }
                if (!CharRedBlackTree.colorOf(CharRedBlackTree.rightOrNull(sib))) {
                    CharRedBlackTree.setColor(CharRedBlackTree.leftOrNull(sib), false);
                    CharRedBlackTree.setColor(sib, true);
                    this.rotateRight(sib);
                    sib = CharRedBlackTree.rightOrNull(CharRedBlackTree.parentOrNull(x));
                }
                CharRedBlackTree.setColor(sib, CharRedBlackTree.colorOf(CharRedBlackTree.parentOrNull(x)));
                CharRedBlackTree.setColor(CharRedBlackTree.parentOrNull(x), false);
                CharRedBlackTree.setColor(CharRedBlackTree.rightOrNull(sib), false);
                this.rotateLeft(CharRedBlackTree.parentOrNull(x));
                x = this.root;
                continue;
            }
            sib = CharRedBlackTree.leftOrNull(CharRedBlackTree.parentOrNull(x));
            if (CharRedBlackTree.colorOf(sib)) {
                CharRedBlackTree.setColor(sib, false);
                CharRedBlackTree.setColor(CharRedBlackTree.parentOrNull(x), true);
                this.rotateRight(CharRedBlackTree.parentOrNull(x));
                sib = CharRedBlackTree.leftOrNull(CharRedBlackTree.parentOrNull(x));
            }
            if (!CharRedBlackTree.colorOf(CharRedBlackTree.rightOrNull(sib)) && !CharRedBlackTree.colorOf(CharRedBlackTree.leftOrNull(sib))) {
                CharRedBlackTree.setColor(sib, true);
                x = CharRedBlackTree.parentOrNull(x);
                continue;
            }
            if (!CharRedBlackTree.colorOf(CharRedBlackTree.leftOrNull(sib))) {
                CharRedBlackTree.setColor(CharRedBlackTree.rightOrNull(sib), false);
                CharRedBlackTree.setColor(sib, true);
                this.rotateLeft(sib);
                sib = CharRedBlackTree.leftOrNull(CharRedBlackTree.parentOrNull(x));
            }
            CharRedBlackTree.setColor(sib, CharRedBlackTree.colorOf(CharRedBlackTree.parentOrNull(x)));
            CharRedBlackTree.setColor(CharRedBlackTree.parentOrNull(x), false);
            CharRedBlackTree.setColor(CharRedBlackTree.leftOrNull(sib), false);
            this.rotateRight(CharRedBlackTree.parentOrNull(x));
            x = this.root;
        }
        CharRedBlackTree.setColor(x, false);
    }

    protected final void remove0(N node) {
        Object replacement;
        if (((Node)node).left != null && ((Node)node).right != null) {
            N s = CharRedBlackTree.successor(node);
            ((Node)node).copyValuesFrom(s);
            node = s;
        }
        Object n = replacement = ((Node)node).left != null ? ((Node)node).left : ((Node)node).right;
        if (replacement != null) {
            ((Node)replacement).parent = ((Node)node).parent;
            if (((Node)node).parent == null) {
                this.root = replacement;
            } else if (node == ((Node)((Node)node).parent).left) {
                ((Node)((Node)node).parent).left = replacement;
            } else {
                ((Node)((Node)node).parent).right = replacement;
            }
            ((Node)node).parent = null;
            ((Node)node).right = null;
            ((Node)node).left = null;
            if (!((Node)node).color) {
                this.fixAfterDelete(replacement);
            }
        } else if (((Node)node).parent == null) {
            this.root = null;
        } else {
            if (!((Node)node).color) {
                this.fixAfterDelete(node);
            }
            if (((Node)node).parent != null) {
                if (node == ((Node)((Node)node).parent).left) {
                    ((Node)((Node)node).parent).left = null;
                } else if (node == ((Node)((Node)node).parent).right) {
                    ((Node)((Node)node).parent).right = null;
                }
                ((Node)node).parent = null;
            }
        }
        --this.size;
    }

    protected final void forEachKey0(@NotNull CharConsumer consumer) {
        N node = this.firstNode();
        while (node != null) {
            Object n;
            consumer.accept(((Node)node).key);
            if (((Node)node).right != null) {
                n = ((Node)node).right;
                while (((Node)n).left != null) {
                    n = ((Node)n).left;
                }
            } else {
                n = ((Node)node).parent;
                N c = node;
                while (n != null && c == ((Node)n).right) {
                    c = n;
                    n = ((Node)n).parent;
                }
            }
            node = n;
        }
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final int size() {
        return this.size;
    }

    public int knownSize() {
        return this.size;
    }

    public final void clear() {
        this.root = null;
        this.size = 0;
    }

    protected static class Node<N extends Node<N>> {
        public boolean color = false;
        public char key;
        public N left;
        public N right;
        public N parent;

        public Node(char key, N parent) {
            this.key = key;
            this.parent = parent;
        }

        public void copyValuesFrom(N other) {
            this.key = ((Node)other).key;
        }
    }
}

