/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal.view;

import java.util.Iterator;
import kala.collection.AbstractCollectionView;
import kala.collection.CollectionView;
import kala.collection.base.Iterators;
import kala.collection.base.primitive.CharArrays;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.collection.primitive.AbstractCharCollectionView;
import kala.collection.primitive.CharCollectionLike;
import kala.collection.primitive.CharCollectionView;
import kala.control.primitive.CharOption;
import kala.function.CharConsumer;
import kala.function.CharFunction;
import kala.function.CharPredicate;
import kala.function.CharUnaryOperator;
import org.jetbrains.annotations.NotNull;

public final class CharCollectionViews {
    public static final CharCollectionView EMPTY = new Empty();

    private CharCollectionViews() {
    }

    public static class Empty
    extends AbstractCharCollectionView {
        @NotNull
        public final CharIterator iterator() {
            return CharIterator.empty();
        }

        public final boolean isEmpty() {
            return true;
        }

        public final int size() {
            return 0;
        }

        public final int knownSize() {
            return 0;
        }

        @Override
        @NotNull
        public CharCollectionView filter(@NotNull CharPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public CharCollectionView filterNot(@NotNull CharPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public CharCollectionView map(@NotNull CharUnaryOperator mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> CollectionView<U> mapToObj(@NotNull CharFunction<? extends U> mapper) {
            return CollectionView.empty();
        }

        @Override
        @NotNull
        public CharCollectionView flatMap(@NotNull CharFunction<? extends CharTraversable> mapper) {
            return this;
        }

        public final char @NotNull [] toArray() {
            return CharArrays.EMPTY;
        }

        @Override
        public final String toString() {
            return this.className() + "[]";
        }
    }

    public static final class FlatMapToObj<T>
    extends AbstractCollectionView<T> {
        @NotNull
        private final CharCollectionView source;
        @NotNull
        private final CharFunction<? extends Iterable<? extends T>> mapper;

        public FlatMapToObj(@NotNull CharCollectionView source, @NotNull CharFunction<? extends Iterable<? extends T>> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public Iterator<T> iterator() {
            return Iterators.concat(this.source.mapToObj(it -> ((Iterable)this.mapper.apply(it)).iterator()));
        }
    }

    public static final class FlatMapped
    extends AbstractCharCollectionView {
        @NotNull
        private final CharCollectionView source;
        @NotNull
        private final CharFunction<? extends CharTraversable> mapper;

        public FlatMapped(@NotNull CharCollectionView source, @NotNull CharFunction<? extends CharTraversable> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public CharIterator iterator() {
            return CharIterator.concat(this.source.mapToObj(it -> ((CharTraversable)this.mapper.apply(it)).iterator()));
        }
    }

    public static final class FilterNot
    extends AbstractCharCollectionView {
        @NotNull
        private final CharCollectionView source;
        @NotNull
        private final CharPredicate predicate;

        public FilterNot(@NotNull CharCollectionView source, @NotNull CharPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public CharIterator iterator() {
            return this.source.iterator().filterNot(this.predicate);
        }
    }

    public static final class Filter
    extends AbstractCharCollectionView {
        @NotNull
        private final CharCollectionView source;
        @NotNull
        private final CharPredicate predicate;

        public Filter(@NotNull CharCollectionView source, @NotNull CharPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public CharIterator iterator() {
            return this.source.iterator().filter(this.predicate);
        }
    }

    public static final class MapToObj<T>
    extends AbstractCollectionView<T> {
        @NotNull
        private final CharCollectionView source;
        @NotNull
        private final CharFunction<? extends T> mapper;

        public MapToObj(@NotNull CharCollectionView source, @NotNull CharFunction<? extends T> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public Iterator<T> iterator() {
            return this.source.iterator().mapToObj(this.mapper);
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }
    }

    public static final class Mapped
    extends AbstractCharCollectionView {
        @NotNull
        private final CharCollectionView source;
        @NotNull
        private final CharUnaryOperator mapper;

        public Mapped(@NotNull CharCollectionView source, @NotNull CharUnaryOperator mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public CharIterator iterator() {
            return this.iterator().map(this.mapper);
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }
    }

    public static class Of<C extends CharCollectionLike>
    extends AbstractCharCollectionView {
        @NotNull
        protected final C source;

        public Of(@NotNull C source) {
            this.source = source;
        }

        @NotNull
        public final CharIterator iterator() {
            return this.source.iterator();
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }

        @NotNull
        public CharOption find(@NotNull CharPredicate predicate) {
            return this.source.find(predicate);
        }

        public final boolean contains(char value) {
            return this.source.contains(value);
        }

        public final boolean containsAll(char @NotNull [] values) {
            return this.source.containsAll(values);
        }

        public final boolean containsAll(@NotNull CharTraversable values) {
            return this.source.containsAll(values);
        }

        public final boolean sameElements(@NotNull Iterable<?> other) {
            return this.source.sameElements(other);
        }

        public final boolean anyMatch(@NotNull CharPredicate predicate) {
            return this.source.anyMatch(predicate);
        }

        public final boolean allMatch(@NotNull CharPredicate predicate) {
            return this.source.allMatch(predicate);
        }

        public final boolean noneMatch(@NotNull CharPredicate predicate) {
            return this.source.noneMatch(predicate);
        }

        public final int count(@NotNull CharPredicate predicate) {
            return this.source.count(predicate);
        }

        public final char max() {
            return this.source.max();
        }

        public final char min() {
            return this.source.min();
        }

        public final char @NotNull [] toArray() {
            return this.source.toArray();
        }

        public final void forEach(@NotNull CharConsumer action) {
            this.source.forEach(action);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer) {
            return (A)this.source.joinTo(buffer);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull CharSequence separator) {
            return (A)this.source.joinTo(buffer, separator);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix) {
            return (A)this.source.joinTo(buffer, separator, prefix, postfix);
        }

        @NotNull
        public final String joinToString() {
            return this.source.joinToString();
        }

        @NotNull
        public final String joinToString(@NotNull CharSequence separator) {
            return this.source.joinToString(separator);
        }

        @NotNull
        public final String joinToString(@NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix) {
            return this.source.joinToString(separator, prefix, postfix);
        }

        @Override
        public final String toString() {
            return this.joinToString(", ", this.className() + "[", "]");
        }
    }

    public static class Single
    extends AbstractCharCollectionView {
        protected final char value;

        public Single(char value) {
            this.value = value;
        }

        @NotNull
        public final CharIterator iterator() {
            return CharIterator.of((char)this.value);
        }

        public final boolean isEmpty() {
            return false;
        }

        public final int size() {
            return 1;
        }

        public final int knownSize() {
            return 1;
        }

        public void forEach(@NotNull CharConsumer action) {
            action.accept(this.value);
        }
    }
}

