/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal.view;

import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import kala.collection.AbstractCollectionView;
import kala.collection.CollectionView;
import kala.collection.base.Iterators;
import kala.collection.base.primitive.IntArrays;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.primitive.AbstractIntCollectionView;
import kala.collection.primitive.IntCollectionLike;
import kala.collection.primitive.IntCollectionView;
import kala.control.primitive.IntOption;
import org.jetbrains.annotations.NotNull;

public final class IntCollectionViews {
    public static final IntCollectionView EMPTY = new Empty();

    private IntCollectionViews() {
    }

    public static class Empty
    extends AbstractIntCollectionView {
        @NotNull
        public final IntIterator iterator() {
            return IntIterator.empty();
        }

        @NotNull
        public IntStream stream() {
            return IntStream.empty();
        }

        @NotNull
        public IntStream parallelStream() {
            return IntStream.empty().parallel();
        }

        public final boolean isEmpty() {
            return true;
        }

        public final int size() {
            return 0;
        }

        public final int knownSize() {
            return 0;
        }

        @Override
        @NotNull
        public IntCollectionView filter(@NotNull IntPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public IntCollectionView filterNot(@NotNull IntPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public IntCollectionView map(@NotNull IntUnaryOperator mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> CollectionView<U> mapToObj(@NotNull IntFunction<? extends U> mapper) {
            return CollectionView.empty();
        }

        @Override
        @NotNull
        public IntCollectionView flatMap(@NotNull IntFunction<? extends IntTraversable> mapper) {
            return this;
        }

        public final int @NotNull [] toArray() {
            return IntArrays.EMPTY;
        }

        @Override
        public final String toString() {
            return this.className() + "[]";
        }
    }

    static final class MappedSpliterator
    implements Spliterator.OfInt {
        @NotNull
        private final Spliterator.OfInt source;
        @NotNull
        private final IntUnaryOperator mapper;

        MappedSpliterator(@NotNull Spliterator.OfInt source, @NotNull IntUnaryOperator mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            Objects.requireNonNull(action);
            return this.source.tryAdvance((int t) -> action.accept(this.mapper.applyAsInt(t)));
        }

        @Override
        public Spliterator.OfInt trySplit() {
            Spliterator.OfInt ss = this.source.trySplit();
            return ss != null ? new MappedSpliterator(ss, this.mapper) : null;
        }

        @Override
        public long estimateSize() {
            return this.source.estimateSize();
        }

        @Override
        public int characteristics() {
            return this.source.characteristics();
        }
    }

    public static final class FlatMapToObj<T>
    extends AbstractCollectionView<T> {
        @NotNull
        private final IntCollectionView source;
        @NotNull
        private final IntFunction<? extends Iterable<? extends T>> mapper;

        public FlatMapToObj(@NotNull IntCollectionView source, @NotNull IntFunction<? extends Iterable<? extends T>> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public Iterator<T> iterator() {
            return Iterators.concat(this.source.mapToObj(it -> this.mapper.apply(it).iterator()));
        }
    }

    public static final class FlatMapped
    extends AbstractIntCollectionView {
        @NotNull
        private final IntCollectionView source;
        @NotNull
        private final IntFunction<? extends IntTraversable> mapper;

        public FlatMapped(@NotNull IntCollectionView source, @NotNull IntFunction<? extends IntTraversable> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public IntIterator iterator() {
            return IntIterator.concat(this.source.mapToObj((int it) -> this.mapper.apply(it).iterator()));
        }
    }

    public static final class FilterNot
    extends AbstractIntCollectionView {
        @NotNull
        private final IntCollectionView source;
        @NotNull
        private final IntPredicate predicate;

        public FilterNot(@NotNull IntCollectionView source, @NotNull IntPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public IntIterator iterator() {
            return this.source.iterator().filterNot(this.predicate);
        }

        @NotNull
        public IntStream stream() {
            return this.source.stream().filter(this.predicate.negate());
        }

        @NotNull
        public IntStream parallelStream() {
            return this.source.stream().filter(this.predicate.negate()).parallel();
        }
    }

    public static final class Filter
    extends AbstractIntCollectionView {
        @NotNull
        private final IntCollectionView source;
        @NotNull
        private final IntPredicate predicate;

        public Filter(@NotNull IntCollectionView source, @NotNull IntPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public IntIterator iterator() {
            return this.source.iterator().filter(this.predicate);
        }

        @NotNull
        public IntStream stream() {
            return this.source.stream().filter(this.predicate);
        }

        @NotNull
        public IntStream parallelStream() {
            return this.source.stream().filter(this.predicate).parallel();
        }
    }

    public static final class MapToObj<T>
    extends AbstractCollectionView<T> {
        @NotNull
        private final IntCollectionView source;
        @NotNull
        private final IntFunction<? extends T> mapper;

        public MapToObj(@NotNull IntCollectionView source, @NotNull IntFunction<? extends T> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public Iterator<T> iterator() {
            return this.source.iterator().mapToObj(this.mapper);
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }
    }

    public static final class Mapped
    extends AbstractIntCollectionView {
        @NotNull
        private final IntCollectionView source;
        @NotNull
        private final IntUnaryOperator mapper;

        public Mapped(@NotNull IntCollectionView source, @NotNull IntUnaryOperator mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public IntIterator iterator() {
            return this.iterator().map(this.mapper);
        }

        @NotNull
        public Spliterator.OfInt spliterator() {
            return new MappedSpliterator(this.source.spliterator(), this.mapper);
        }

        @NotNull
        public IntStream stream() {
            return this.source.stream().map(this.mapper);
        }

        @NotNull
        public IntStream parallelStream() {
            return this.source.parallelStream().map(this.mapper);
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }
    }

    public static class Of<C extends IntCollectionLike>
    extends AbstractIntCollectionView {
        @NotNull
        protected final C source;

        public Of(@NotNull C source) {
            this.source = source;
        }

        @NotNull
        public final IntIterator iterator() {
            return this.source.iterator();
        }

        @NotNull
        public final Spliterator.OfInt spliterator() {
            return this.source.spliterator();
        }

        @NotNull
        public final IntStream stream() {
            return this.source.stream();
        }

        @NotNull
        public final IntStream parallelStream() {
            return this.source.parallelStream();
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }

        @NotNull
        public IntOption find(@NotNull IntPredicate predicate) {
            return this.source.find(predicate);
        }

        public final boolean contains(int value) {
            return this.source.contains(value);
        }

        public final boolean containsAll(int @NotNull [] values) {
            return this.source.containsAll(values);
        }

        public final boolean containsAll(@NotNull IntTraversable values) {
            return this.source.containsAll(values);
        }

        public final boolean sameElements(@NotNull Iterable<?> other) {
            return this.source.sameElements(other);
        }

        public final boolean anyMatch(@NotNull IntPredicate predicate) {
            return this.source.anyMatch(predicate);
        }

        public final boolean allMatch(@NotNull IntPredicate predicate) {
            return this.source.allMatch(predicate);
        }

        public final boolean noneMatch(@NotNull IntPredicate predicate) {
            return this.source.noneMatch(predicate);
        }

        public final int count(@NotNull IntPredicate predicate) {
            return this.source.count(predicate);
        }

        public final int max() {
            return this.source.max();
        }

        public final int min() {
            return this.source.min();
        }

        public final int @NotNull [] toArray() {
            return this.source.toArray();
        }

        public final void forEach(@NotNull IntConsumer action) {
            this.source.forEach(action);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer) {
            return (A)this.source.joinTo(buffer);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull CharSequence separator) {
            return (A)this.source.joinTo(buffer, separator);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix) {
            return (A)this.source.joinTo(buffer, separator, prefix, postfix);
        }

        @NotNull
        public final String joinToString() {
            return this.source.joinToString();
        }

        @NotNull
        public final String joinToString(@NotNull CharSequence separator) {
            return this.source.joinToString(separator);
        }

        @NotNull
        public final String joinToString(@NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix) {
            return this.source.joinToString(separator, prefix, postfix);
        }

        @Override
        public final String toString() {
            return this.joinToString(", ", this.className() + "[", "]");
        }
    }

    public static class Single
    extends AbstractIntCollectionView {
        protected final int value;

        public Single(int value) {
            this.value = value;
        }

        @NotNull
        public final IntIterator iterator() {
            return IntIterator.of((int)this.value);
        }

        public final boolean isEmpty() {
            return false;
        }

        public final int size() {
            return 1;
        }

        public final int knownSize() {
            return 1;
        }

        public void forEach(@NotNull IntConsumer action) {
            action.accept(this.value);
        }
    }
}

