/*
 * Decompiled with CFR 0.152.
 */
package kala.collection;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.invoke.StringConcatFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import kala.Conditions;
import kala.collection.AbstractIndexedSeq;
import kala.collection.Seq;
import kala.collection.SeqView;
import kala.collection.base.GenericArrays;
import kala.collection.base.ObjectArrays;
import kala.collection.base.Traversable;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.ImmutableArray;
import kala.collection.internal.view.IndexedSeqViews;
import kala.collection.mutable.MutableArrayList;
import kala.control.Option;
import kala.function.IndexedConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(hasChildren="isNotEmpty()", childrenArray="elements")
public class ArraySeq<E>
extends AbstractIndexedSeq<E>
implements Seq<E>,
Serializable {
    private static final long serialVersionUID = 4981379062449237945L;
    public static final ArraySeq<?> EMPTY = new ArraySeq(GenericArrays.EMPTY_OBJECT_ARRAY);
    private static final Factory<?> FACTORY = new Factory();
    protected final Object @NotNull [] elements;

    protected ArraySeq(Object @NotNull [] elements) {
        this.elements = elements;
    }

    @Contract(value="_ -> param1", pure=true)
    public static <E> ArraySeq<E> narrow(ArraySeq<? extends E> seq) {
        return seq;
    }

    @NotNull
    public static <E> CollectionFactory<E, ?, ? extends ArraySeq<E>> factory() {
        return FACTORY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> ArraySeq<E> wrap(@NotNull E[] array) {
        Objects.requireNonNull(array);
        return new ArraySeq<E>(array);
    }

    @NotNull
    public static <E> ArraySeq<E> empty() {
        return EMPTY;
    }

    @NotNull
    public static <E> ArraySeq<E> of() {
        return ArraySeq.empty();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <E> ArraySeq<E> of(E value1) {
        return new ArraySeq<E>(new Object[]{value1});
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <E> ArraySeq<E> of(E value1, E value2) {
        return new ArraySeq<E>(new Object[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <E> ArraySeq<E> of(E value1, E value2, E value3) {
        return new ArraySeq<E>(new Object[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static <E> ArraySeq<E> of(E value1, E value2, E value3, E value4) {
        return new ArraySeq<E>(new Object[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static <E> ArraySeq<E> of(E value1, E value2, E value3, E value4, E value5) {
        return new ArraySeq<E>(new Object[]{value1, value2, value3, value4, value5});
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <E> ArraySeq<E> of(E ... values) {
        return ArraySeq.from(values);
    }

    @Contract(pure=true)
    @NotNull
    public static <E> ArraySeq<E> from(E @NotNull [] values) {
        return values.length == 0 ? ArraySeq.empty() : new ArraySeq<E>((Object[])values.clone());
    }

    @NotNull
    public static <E> ArraySeq<E> from(@NotNull Traversable<? extends E> values) {
        if (values instanceof ImmutableArray) {
            return (ArraySeq)values;
        }
        if (values.knownSize() == 0) {
            return ArraySeq.empty();
        }
        Object[] arr = values.toArray();
        if (arr.length == 0) {
            return ArraySeq.empty();
        }
        return new ArraySeq<E>(arr);
    }

    @NotNull
    public static <E> ArraySeq<E> from(@NotNull Collection<? extends E> values) {
        return values.size() == 0 ? ArraySeq.empty() : new ArraySeq<E>(values.toArray());
    }

    @NotNull
    public static <E> ArraySeq<E> from(@NotNull Iterable<? extends E> values) {
        Objects.requireNonNull(values);
        if (values instanceof Traversable) {
            return ArraySeq.from((Traversable)values);
        }
        if (values instanceof Collection) {
            return ArraySeq.from((Collection)values);
        }
        return new ArraySeq<E>(MutableArrayList.from(values).toArray());
    }

    @NotNull
    public static <E> ArraySeq<E> from(@NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            return ArraySeq.empty();
        }
        return new ArraySeq<E>(MutableArrayList.from(it).toArray());
    }

    @NotNull
    public static <E> ArraySeq<E> from(@NotNull Stream<? extends E> stream) {
        return stream.collect(ArraySeq.factory());
    }

    @NotNull
    public static <E> ArraySeq<E> fill(int n, E value) {
        if (n <= 0) {
            return ArraySeq.empty();
        }
        Object[] ans = new Object[n];
        if (value != null) {
            Arrays.fill(ans, value);
        }
        return new ArraySeq<E>(ans);
    }

    @NotNull
    public static <E> ArraySeq<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
        if (n <= 0) {
            return ArraySeq.empty();
        }
        Object[] ans = new Object[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.get();
        }
        return new ArraySeq<E>(ans);
    }

    @NotNull
    public static <E> ArraySeq<E> fill(int n, @NotNull IntFunction<? extends E> init) {
        if (n <= 0) {
            return ArraySeq.empty();
        }
        Object[] ans = new Object[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = init.apply(i);
        }
        return new ArraySeq<E>(ans);
    }

    @Override
    @NotNull
    public String className() {
        return "ArraySeq";
    }

    @Override
    @NotNull
    public final Iterator<E> iterator() {
        return GenericArrays.iterator((Object[])this.elements);
    }

    @Override
    @NotNull
    public Iterator<E> iterator(int beginIndex) {
        return GenericArrays.iterator((Object[])this.elements, (int)beginIndex);
    }

    @NotNull
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.elements, 0);
    }

    @NotNull
    public final Stream<E> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @NotNull
    public final Stream<E> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    @Override
    public final boolean isEmpty() {
        return this.elements.length == 0;
    }

    public final int size() {
        return this.elements.length;
    }

    @Override
    public final int knownSize() {
        return this.elements.length;
    }

    @Override
    @NotNull
    public final Iterator<E> reverseIterator() {
        return GenericArrays.reverseIterator((Object[])this.elements);
    }

    @Override
    public final E get(int index) {
        return (E)this.elements[index];
    }

    @Override
    public final int binarySearch(E value, int beginIndex, int endIndex) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.elements.length);
        return Arrays.binarySearch(this.elements, beginIndex, endIndex, value);
    }

    @Override
    public int binarySearch(E value, Comparator<? super E> comparator, int beginIndex, int endIndex) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.elements.length);
        return Arrays.binarySearch(this.elements, beginIndex, endIndex, value, comparator);
    }

    @Override
    public final E first() {
        try {
            return (E)this.elements[0];
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    @Nullable
    public E firstOrNull() {
        return (E)(this.elements.length != 0 ? this.elements[0] : null);
    }

    @Override
    @NotNull
    public Option<E> firstOption() {
        return this.elements.length != 0 ? Option.some((Object)this.elements[0]) : Option.none();
    }

    @Override
    public final E last() {
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return (E)elements[size - 1];
    }

    @Override
    @Nullable
    public E lastOrNull() {
        if (this.elements.length == 0) {
            throw new NoSuchElementException();
        }
        return (E)this.elements[this.elements.length - 1];
    }

    @Override
    @NotNull
    public Option<E> lastOption() {
        return this.elements.length != 0 ? Option.some((Object)this.elements[this.elements.length - 1]) : Option.none();
    }

    @Override
    public final boolean contains(Object value) {
        Object[] elements = this.elements;
        if (elements.length == 0) {
            return false;
        }
        if (value == null) {
            for (Object e : elements) {
                if (null != e) continue;
                return true;
            }
        } else {
            for (Object e : elements) {
                if (!value.equals(e)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean containsAll(@NotNull Iterable<?> values) {
        for (Object v : values) {
            if (this.contains(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean anyMatch(@NotNull Predicate<? super E> predicate) {
        for (Object e : this.elements) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean allMatch(@NotNull Predicate<? super E> predicate) {
        for (Object e : this.elements) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean noneMatch(@NotNull Predicate<? super E> predicate) {
        for (Object e : this.elements) {
            if (!predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int indexOf(Object value) {
        return GenericArrays.indexOf((Object[])this.elements, (Object)value);
    }

    @Override
    public final int indexOf(Object value, int from) {
        return GenericArrays.indexOf((Object[])this.elements, (Object)value, (int)from);
    }

    @Override
    public final int indexWhere(@NotNull Predicate<? super E> predicate) {
        return GenericArrays.indexWhere((Object[])this.elements, predicate);
    }

    @Override
    public final int indexWhere(@NotNull Predicate<? super E> predicate, int from) {
        return GenericArrays.indexWhere((Object[])this.elements, predicate, (int)from);
    }

    @Override
    public final int lastIndexOf(Object value) {
        return GenericArrays.lastIndexOf((Object[])this.elements, (Object)value);
    }

    @Override
    public final int lastIndexOf(Object value, int end) {
        return GenericArrays.lastIndexOf((Object[])this.elements, (Object)value, (int)end);
    }

    @Override
    public final int lastIndexWhere(@NotNull Predicate<? super E> predicate) {
        return GenericArrays.lastIndexWhere((Object[])this.elements, predicate);
    }

    @Override
    public final int lastIndexWhere(@NotNull Predicate<? super E> predicate, int end) {
        return GenericArrays.lastIndexWhere((Object[])this.elements, predicate, (int)end);
    }

    @Override
    @NotNull
    public SeqView<E> sliceView(int beginIndex, int endIndex) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.elements.length);
        int ns = endIndex - beginIndex;
        switch (ns) {
            case 0: {
                return SeqView.empty();
            }
            case 1: {
                return SeqView.of(this.elements[beginIndex]);
            }
        }
        return new IndexedSeqViews.OfArraySlice(this.elements, beginIndex, endIndex);
    }

    @Override
    public final int count(@NotNull Predicate<? super E> predicate) {
        int c = 0;
        for (Object e : this.elements) {
            if (!predicate.test(e)) continue;
            ++c;
        }
        return c;
    }

    public final E max() {
        return (E)ObjectArrays.max((Object[])this.elements);
    }

    @Override
    public final E max(@NotNull Comparator<? super E> comparator) {
        return (E)GenericArrays.max((Object[])this.elements, comparator);
    }

    @NotNull
    public final Option<E> maxOption() {
        Object[] elements = this.elements;
        if (elements.length == 0) {
            return Option.none();
        }
        return Option.some((Object)ObjectArrays.max((Object[])elements));
    }

    @Override
    @NotNull
    public final Option<E> maxOption(@NotNull Comparator<? super E> comparator) {
        if (this.elements.length == 0) {
            return Option.none();
        }
        return Option.some(this.max(comparator));
    }

    public final E min() {
        return (E)ObjectArrays.min((Object[])this.elements);
    }

    @Override
    public final E min(@NotNull Comparator<? super E> comparator) {
        return (E)GenericArrays.min((Object[])this.elements, comparator);
    }

    @NotNull
    public final Option<E> minOption() {
        Object[] elements = this.elements;
        if (elements.length == 0) {
            return Option.none();
        }
        return Option.some((Object)ObjectArrays.min((Object[])elements));
    }

    @Override
    @NotNull
    public final Option<E> minOption(@NotNull Comparator<? super E> comparator) {
        if (this.elements.length == 0) {
            return Option.none();
        }
        return Option.some(this.min(comparator));
    }

    public final E fold(E zero, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        return (E)GenericArrays.fold((Object[])this.elements, zero, op);
    }

    @Override
    public final <U> U foldLeft(U zero, @NotNull BiFunction<? super U, ? super E, ? extends U> op) {
        return (U)GenericArrays.foldLeft((Object[])this.elements, zero, op);
    }

    @Override
    public final <U> U foldRight(U zero, @NotNull BiFunction<? super E, ? super U, ? extends U> op) {
        return (U)GenericArrays.foldRight((Object[])this.elements, zero, op);
    }

    @Override
    public final E reduceLeft(@NotNull BiFunction<? super E, ? super E, ? extends E> op) throws NoSuchElementException {
        return (E)GenericArrays.reduceLeft((Object[])this.elements, op);
    }

    @Override
    public final E reduceRight(@NotNull BiFunction<? super E, ? super E, ? extends E> op) throws NoSuchElementException {
        return (E)GenericArrays.reduceRight((Object[])this.elements, op);
    }

    @Override
    @NotNull
    public final Option<E> reduceLeftOption(@NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        return GenericArrays.reduceLeftOption((Object[])this.elements, op);
    }

    @Override
    @NotNull
    public final Option<E> reduceRightOption(@NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        return GenericArrays.reduceRightOption((Object[])this.elements, op);
    }

    @Override
    public final int copyToArray(int srcPos, Object @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"srcPos(\u0001) < 0"}, (int)destPos)));
        }
        if (destPos < 0) {
            throw new IllegalArgumentException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"destPos(\u0001) < 0"}, (int)destPos)));
        }
        Object[] elements = this.elements;
        int dl = dest.length;
        int size = elements.length;
        if (destPos >= dl || srcPos >= size) {
            return 0;
        }
        int n = Math.min(Math.min(size - srcPos, dl - destPos), limit);
        System.arraycopy(elements, srcPos, dest, destPos, n);
        return n;
    }

    public final <R, Builder> R collect(@NotNull Collector<? super E, Builder, ? extends R> collector) {
        if (collector instanceof CollectionFactory) {
            return this.collect((CollectionFactory)collector);
        }
        Object[] elements = this.elements;
        Builder builder = collector.supplier().get();
        if (elements.length == 0) {
            return collector.finisher().apply(builder);
        }
        BiConsumer<Builder, E> accumulator = collector.accumulator();
        for (Object o : elements) {
            accumulator.accept(builder, o);
        }
        return collector.finisher().apply(builder);
    }

    public final <R, Builder> R collect(@NotNull CollectionFactory<? super E, Builder, ? extends R> factory) {
        Object[] elements = this.elements;
        int length = elements.length;
        if (length == 0) {
            return (R)factory.empty();
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, length);
        for (Object e : elements) {
            factory.addToBuilder(builder, e);
        }
        return (R)factory.build(builder);
    }

    @Override
    public final Object @NotNull [] toArray() {
        return Arrays.copyOf(this.elements, this.elements.length, Object[].class);
    }

    @Override
    public final <U> U @NotNull [] toArray(@NotNull Class<U> type) {
        return Arrays.copyOf(this.elements, this.elements.length, GenericArrays.arrayType(type));
    }

    @Override
    public final <U> U @NotNull [] toArray(@NotNull IntFunction<U[]> generator) {
        Object[] elements = this.elements;
        int size = elements.length;
        U[] res = generator.apply(size);
        if (size != 0) {
            System.arraycopy(elements, 0, res, 0, size);
        }
        return res;
    }

    @Override
    public final void forEach(@NotNull Consumer<? super E> action) {
        for (Object e : this.elements) {
            action.accept(e);
        }
    }

    @Override
    public final void forEachIndexed(@NotNull IndexedConsumer<? super E> action) {
        Object[] elements = this.elements;
        int length = elements.length;
        for (int i = 0; i < length; ++i) {
            action.accept(i, elements[i]);
        }
    }

    @Override
    public final int hashCode() {
        int ans = 0;
        for (Object o : this.elements) {
            ans = ans * 31 + Objects.hashCode(o);
        }
        return ans + -1140647423;
    }

    @Override
    @NotNull
    public final <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        Object[] elements = this.elements;
        int size = elements.length;
        try {
            buffer.append(prefix);
            if (size > 0) {
                buffer.append(Objects.toString(elements[0]));
                for (int i = 1; i < size; ++i) {
                    buffer.append(separator);
                    buffer.append(Objects.toString(elements[i]));
                }
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    @Override
    @NotNull
    public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull Function<? super E, ? extends CharSequence> transform) {
        Object[] elements = this.elements;
        int size = elements.length;
        try {
            buffer.append(prefix);
            if (size > 0) {
                buffer.append(transform.apply(elements[0]));
                for (int i = 1; i < size; ++i) {
                    buffer.append(separator);
                    buffer.append(transform.apply(elements[i]));
                }
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    private static final class Factory<E>
    implements CollectionFactory<E, MutableArrayList<E>, ArraySeq<E>> {
        private Factory() {
        }

        public ArraySeq<E> empty() {
            return ArraySeq.empty();
        }

        public ArraySeq<E> from(E @NotNull [] values) {
            return ArraySeq.from(values);
        }

        public ArraySeq<E> from(@NotNull Iterable<? extends E> values) {
            return ArraySeq.from(values);
        }

        public ArraySeq<E> from(@NotNull Iterator<? extends E> it) {
            return ArraySeq.from(it);
        }

        public ArraySeq<E> fill(int n, E value) {
            return ArraySeq.fill(n, value);
        }

        public ArraySeq<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
            return ArraySeq.fill(n, supplier);
        }

        public ArraySeq<E> fill(int n, @NotNull IntFunction<? extends E> init) {
            return ArraySeq.fill(n, init);
        }

        public MutableArrayList<E> newBuilder() {
            return new MutableArrayList();
        }

        public void addToBuilder(@NotNull MutableArrayList<E> buffer, E value) {
            buffer.append(value);
        }

        public MutableArrayList<E> mergeBuilder(@NotNull MutableArrayList<E> builder1, @NotNull MutableArrayList<E> builder2) {
            builder1.appendAll((Iterable<E>)((Object)builder2));
            return builder1;
        }

        public void sizeHint(@NotNull MutableArrayList<E> buffer, int size) {
            buffer.sizeHint(size);
        }

        public ArraySeq<E> build(@NotNull MutableArrayList<E> buffer) {
            return new ArraySeq(buffer.toArray());
        }
    }
}

