/*
 * Decompiled with CFR 0.152.
 */
package kala.collection;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.StringConcatFactory;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import kala.Conditions;
import kala.collection.Map;
import kala.collection.SeqLike;
import kala.collection.base.Growable;
import kala.collection.base.Iterators;
import kala.collection.factory.MapFactory;
import kala.collection.immutable.ImmutableLinkedSeq;
import kala.collection.immutable.ImmutableMap;
import kala.control.Option;
import kala.function.IndexedBiFunction;
import kala.function.IndexedConsumer;
import kala.function.IndexedFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IndexedSeqLike<E>
extends SeqLike<E> {
    @NotNull
    default public Iterator<E> iterator() {
        final int size = this.size();
        if (size == 0) {
            return Iterators.empty();
        }
        return new Iterator<E>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < size;
            }

            @Override
            public E next() {
                if (this.idx >= size) {
                    throw new NoSuchElementException();
                }
                return IndexedSeqLike.this.get(this.idx++);
            }
        };
    }

    @Override
    @NotNull
    default public Iterator<E> iterator(final int beginIndex) {
        final int size = this.size();
        Conditions.checkPositionIndex((int)beginIndex, (int)size);
        if (beginIndex == size) {
            return Iterators.empty();
        }
        return new Iterator<E>(){
            private int idx;
            {
                this.idx = beginIndex;
            }

            @Override
            public boolean hasNext() {
                return this.idx < size;
            }

            @Override
            public E next() {
                if (this.idx >= size) {
                    throw new NoSuchElementException();
                }
                return IndexedSeqLike.this.get(this.idx++);
            }
        };
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public int knownSize() {
        return this.size();
    }

    @Override
    default public boolean supportsFastRandomAccess() {
        return true;
    }

    @Override
    default public boolean isDefinedAt(int index) {
        return index >= 0 && index < this.size();
    }

    @Override
    public E get(int var1);

    @Override
    @Nullable
    default public E getOrNull(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return this.get(index);
    }

    @Override
    @NotNull
    default public Option<E> getOption(int index) {
        if (index < 0 || index >= this.size()) {
            return Option.none();
        }
        return Option.some(this.get(index));
    }

    @Override
    @NotNull
    default public Iterator<E> reverseIterator() {
        return new Iterator<E>(){
            private int idx;
            {
                this.idx = IndexedSeqLike.this.size() - 1;
            }

            @Override
            public boolean hasNext() {
                return this.idx >= 0;
            }

            @Override
            public E next() {
                if (this.idx < 0) {
                    throw new NoSuchElementException();
                }
                return IndexedSeqLike.this.get(this.idx--);
            }
        };
    }

    @Override
    default public E first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(0);
    }

    @Override
    default public E first(@NotNull Predicate<? super E> predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            E e = this.get(i);
            if (!predicate.test(e)) continue;
            return e;
        }
        throw new NoSuchElementException();
    }

    @Override
    @Nullable
    default public E firstOrNull() {
        return this.isEmpty() ? null : (E)this.first();
    }

    @Override
    @Nullable
    default public E firstOrNull(@NotNull Predicate<? super E> predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            E e = this.get(i);
            if (!predicate.test(e)) continue;
            return e;
        }
        return null;
    }

    @Override
    @NotNull
    default public Option<E> firstOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.first());
    }

    @Override
    @NotNull
    default public Option<E> firstOption(@NotNull Predicate<? super E> predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            E e = this.get(i);
            if (!predicate.test(e)) continue;
            return Option.some(e);
        }
        return Option.none();
    }

    @Override
    default public E last() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.get(size - 1);
    }

    @Override
    default public E last(@NotNull Predicate<? super E> predicate) {
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            E e = this.get(i);
            if (!predicate.test(e)) continue;
            return e;
        }
        throw new NoSuchElementException();
    }

    @Override
    @Nullable
    default public E lastOrNull() {
        return this.isEmpty() ? null : (E)this.last();
    }

    @Override
    @Nullable
    default public E lastOrNull(@NotNull Predicate<? super E> predicate) {
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            E e = this.get(i);
            if (!predicate.test(e)) continue;
            return e;
        }
        return null;
    }

    @Override
    @NotNull
    default public Option<E> lastOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.last());
    }

    @Override
    @NotNull
    default public Option<E> lastOption(@NotNull Predicate<? super E> predicate) {
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            E e = this.get(i);
            if (!predicate.test(e)) continue;
            return Option.some(e);
        }
        return Option.none();
    }

    default public boolean contains(Object value) {
        int size = this.size();
        if (size == 0) {
            return false;
        }
        if (value == null) {
            for (int i = 0; i < size; ++i) {
                if (null != this.get(i)) continue;
                return true;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (!value.equals(this.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean anyMatch(@NotNull Predicate<? super E> predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!predicate.test(this.get(i))) continue;
            return true;
        }
        return false;
    }

    default public boolean allMatch(@NotNull Predicate<? super E> predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (predicate.test(this.get(i))) continue;
            return false;
        }
        return true;
    }

    default public boolean noneMatch(@NotNull Predicate<? super E> predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!predicate.test(this.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    default public int indexOf(Object value) {
        int size = this.size();
        if (value == null) {
            for (int i = 0; i < size; ++i) {
                if (null != this.get(i)) continue;
                return i;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (!value.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    default public int indexOf(Object value, int from) {
        int size = this.size();
        if (from >= size) {
            return -1;
        }
        if (value == null) {
            for (int i = Math.max(from, 0); i < size; ++i) {
                if (null != this.get(i)) continue;
                return i;
            }
        } else {
            for (int i = Math.max(from, 0); i < size; ++i) {
                if (!value.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    default public int indexWhere(@NotNull Predicate<? super E> predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!predicate.test(this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    default public int indexWhere(@NotNull Predicate<? super E> predicate, int from) {
        int size = this.size();
        if (from >= size) {
            return -1;
        }
        for (int i = Math.max(from, 0); i < size; ++i) {
            if (!predicate.test(this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    default public int lastIndexOf(Object value) {
        if (value == null) {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (null != this.get(i)) continue;
                return i;
            }
        } else {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (!value.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    default public int lastIndexOf(Object value, int end) {
        if (end < 0) {
            return -1;
        }
        if (value == null) {
            for (int i = Integer.min(end, this.size() - 1); i >= 0; --i) {
                if (null != this.get(i)) continue;
                return i;
            }
        } else {
            for (int i = Integer.min(end, this.size() - 1); i >= 0; --i) {
                if (!value.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    default public int lastIndexWhere(@NotNull Predicate<? super E> predicate) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!predicate.test(this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    default public int lastIndexWhere(@NotNull Predicate<? super E> predicate, int end) {
        if (end < 0) {
            return -1;
        }
        for (int i = end; i >= 0; --i) {
            if (!predicate.test(this.get(i))) continue;
            return i;
        }
        return -1;
    }

    default public int binarySearch(E value) {
        return this.binarySearch(value, 0, this.size());
    }

    default public int binarySearch(E value, Comparator<? super E> comparator) {
        return this.binarySearch(value, comparator, 0, this.size());
    }

    default public int binarySearch(E value, int beginIndex, int endIndex) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size());
        int low = beginIndex;
        int high = endIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            E midVal = this.get(mid);
            int cmp = ((Comparable)midVal).compareTo(value);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    default public int binarySearch(E value, Comparator<? super E> comparator, int beginIndex, int endIndex) {
        if (comparator == null) {
            return this.binarySearch(value, beginIndex, endIndex);
        }
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size());
        int low = beginIndex;
        int high = endIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            E midVal = this.get(mid);
            int cmp = comparator.compare(midVal, value);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @NotNull
    default public <G extends Growable<? super E>> G filterTo(@NotNull G destination, @NotNull Predicate<? super E> predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            E e = this.get(i);
            if (!predicate.test(e)) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @NotNull
    default public <G extends Growable<? super E>> G filterNotTo(@NotNull G destination, @NotNull Predicate<? super E> predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            E e = this.get(i);
            if (predicate.test(e)) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @NotNull
    default public <G extends Growable<? super E>> G filterNotNullTo(@NotNull G destination) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            E e = this.get(i);
            if (e == null) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @NotNull
    default public <U, G extends Growable<? super U>> G mapTo(@NotNull G destination, @NotNull Function<? super E, ? extends U> mapper) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            destination.plusAssign(mapper.apply(this.get(i)));
        }
        return destination;
    }

    @NotNull
    default public <U, G extends Growable<? super U>> G mapNotNullTo(@NotNull G destination, @NotNull Function<? super E, ? extends U> mapper) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            U u = mapper.apply(this.get(i));
            if (u == null) continue;
            destination.plusAssign(u);
        }
        return destination;
    }

    @Override
    @NotNull
    default public <U, G extends Growable<? super U>> G mapIndexedTo(@NotNull G destination, @NotNull IndexedFunction<? super E, ? extends U> mapper) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            destination.plusAssign(mapper.apply(i, this.get(i)));
        }
        return destination;
    }

    default public int count(@NotNull Predicate<? super E> predicate) {
        int size = this.size();
        int c = 0;
        for (int i = 0; i < size; ++i) {
            if (!predicate.test(this.get(i))) continue;
            ++c;
        }
        return c;
    }

    default public E max(Comparator<? super E> comparator) {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        E res = this.get(0);
        if (comparator == null) {
            for (int i = 1; i < size; ++i) {
                E e = this.get(i);
                if (((Comparable)res).compareTo(e) >= 0) continue;
                res = e;
            }
        } else {
            for (int i = 1; i < size; ++i) {
                E e = this.get(i);
                if (comparator.compare(res, e) >= 0) continue;
                res = e;
            }
        }
        return res;
    }

    @NotNull
    default public Option<E> maxOption(Comparator<? super E> comparator) {
        if (this.isEmpty()) {
            return Option.none();
        }
        return Option.some(this.max(comparator));
    }

    default public E min(Comparator<? super E> comparator) {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        E res = this.get(0);
        if (comparator == null) {
            for (int i = 1; i < size; ++i) {
                E e = this.get(i);
                if (((Comparable)res).compareTo(e) <= 0) continue;
                res = e;
            }
        } else {
            for (int i = 1; i < size; ++i) {
                E e = this.get(i);
                if (comparator.compare(res, e) <= 0) continue;
                res = e;
            }
        }
        return res;
    }

    @NotNull
    default public Option<E> minOption(Comparator<? super E> comparator) {
        if (this.isEmpty()) {
            return Option.none();
        }
        return Option.some(this.min(comparator));
    }

    default public <U> U foldLeft(U zero, @NotNull BiFunction<? super U, ? super E, ? extends U> op) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            zero = op.apply(zero, this.get(i));
        }
        return zero;
    }

    default public <U> U foldRight(U zero, @NotNull BiFunction<? super E, ? super U, ? extends U> op) {
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            zero = op.apply(this.get(i), zero);
        }
        return zero;
    }

    @Override
    default public <U> U foldLeftIndexed(U zero, @NotNull IndexedBiFunction<? super U, ? super E, ? extends U> op) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            zero = op.apply(i, zero, this.get(i));
        }
        return zero;
    }

    @Override
    default public <U> U foldRightIndexed(U zero, @NotNull IndexedBiFunction<? super E, ? super U, ? extends U> op) {
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            zero = op.apply(i, this.get(i), zero);
        }
        return zero;
    }

    default public E reduceLeft(@NotNull BiFunction<? super E, ? super E, ? extends E> op) throws NoSuchElementException {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        E e = this.get(0);
        for (int i = 1; i < size; ++i) {
            e = op.apply(e, this.get(i));
        }
        return e;
    }

    default public E reduceRight(@NotNull BiFunction<? super E, ? super E, ? extends E> op) throws NoSuchElementException {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        E e = this.get(size - 1);
        for (int i = size - 2; i >= 0; --i) {
            e = op.apply(this.get(i), e);
        }
        return e;
    }

    @Nullable
    default public E reduceLeftOrNull(@NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        E e = this.get(0);
        for (int i = 1; i < size; ++i) {
            e = op.apply(e, this.get(i));
        }
        return e;
    }

    @Nullable
    default public E reduceRightOrNull(@NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        E e = this.get(size - 1);
        for (int i = size - 2; i >= 0; --i) {
            e = op.apply(this.get(i), e);
        }
        return e;
    }

    @NotNull
    default public Option<E> reduceLeftOption(@NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        int size = this.size();
        if (size == 0) {
            return Option.none();
        }
        E e = this.get(0);
        for (int i = 1; i < size; ++i) {
            e = op.apply(e, this.get(i));
        }
        return Option.some(e);
    }

    @Override
    @NotNull
    default public Option<E> reduceRightOption(@NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        int size = this.size();
        if (size == 0) {
            return Option.none();
        }
        E e = this.get(size - 1);
        for (int i = size - 2; i >= 0; --i) {
            e = op.apply(this.get(i), e);
        }
        return Option.some(e);
    }

    default public int copyToArray(int srcPos, Object @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"srcPos(\u0001) < 0"}, (int)destPos)));
        }
        if (destPos < 0) {
            throw new IllegalArgumentException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"destPos(\u0001) < 0"}, (int)destPos)));
        }
        int dl = dest.length;
        int size = this.size();
        if (destPos >= dl || srcPos >= size) {
            return 0;
        }
        int n = Math.min(Math.min(size - srcPos, dl - destPos), limit);
        for (int i = 0; i < n; ++i) {
            dest[i + destPos] = this.get(i + srcPos);
        }
        return n;
    }

    default public Object @NotNull [] toArray() {
        int size = this.size();
        Object[] arr = new Object[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = this.get(i);
        }
        return arr;
    }

    default public <U> U @NotNull [] toArray(@NotNull Class<U> type) {
        int size = this.size();
        Object[] arr = (Object[])Array.newInstance(type, size);
        for (int i = 0; i < size; ++i) {
            arr[i] = this.get(i);
        }
        return arr;
    }

    default public <U> U @NotNull [] toArray(@NotNull IntFunction<U[]> generator) {
        int size = this.size();
        U[] arr = generator.apply(size);
        for (int i = 0; i < size; ++i) {
            arr[i] = this.get(i);
        }
        return arr;
    }

    @Override
    @NotNull
    default public ImmutableLinkedSeq<E> toImmutableLinkedSeq() {
        int size = this.size();
        ImmutableLinkedSeq.Node<E> node = ImmutableLinkedSeq.nilNode();
        for (int i = size - 1; i >= 0; --i) {
            node = node.cons(this.get(i));
        }
        return ImmutableLinkedSeq.Unsafe.build(node, size);
    }

    @Override
    @NotNull
    default public <K, V> ImmutableMap<K, V> toImmutableMap() {
        int size = this.size();
        if (size == 0) {
            return ImmutableMap.empty();
        }
        MapFactory factory = Map.factory();
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, size);
        for (int i = 0; i < size; ++i) {
            Map.Entry v = (Map.Entry)this.get(i);
            factory.addToBuilder(builder, v.getKey(), v.getValue());
        }
        return (ImmutableMap)factory.build(builder);
    }

    @Override
    default public <K, V> @NotNull Map<K, V> associate(@NotNull Function<? super E, ? extends Map.Entry<? extends K, ? extends V>> transform) {
        int size = this.size();
        if (size == 0) {
            return Map.empty();
        }
        MapFactory factory = Map.factory();
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, size);
        for (int i = 0; i < size; ++i) {
            Map.Entry<K, V> v = transform.apply(this.get(i));
            factory.addToBuilder(builder, v.getKey(), v.getValue());
        }
        return (Map)factory.build(builder);
    }

    @Override
    default public <K> @NotNull Map<K, E> associateBy(@NotNull Function<? super E, ? extends K> keySelector) {
        int size = this.size();
        if (size == 0) {
            return Map.empty();
        }
        MapFactory factory = Map.factory();
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, size);
        for (int i = 0; i < size; ++i) {
            E e = this.get(i);
            factory.addToBuilder(builder, keySelector.apply(e), e);
        }
        return (Map)factory.build(builder);
    }

    @Override
    default public <K, V> @NotNull Map<K, V> associateBy(@NotNull Function<? super E, ? extends K> keySelector, @NotNull Function<? super E, ? extends V> valueTransform) {
        int size = this.size();
        if (size == 0) {
            return Map.empty();
        }
        MapFactory factory = Map.factory();
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, size);
        for (int i = 0; i < size; ++i) {
            E e = this.get(i);
            factory.addToBuilder(builder, keySelector.apply(e), valueTransform.apply(e));
        }
        return (Map)factory.build(builder);
    }

    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        int size = this.size();
        try {
            buffer.append(prefix);
            if (size > 0) {
                buffer.append(Objects.toString(this.get(0)));
                for (int i = 1; i < size; ++i) {
                    buffer.append(separator).append(Objects.toString(this.get(i)));
                }
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull Function<? super E, ? extends CharSequence> transform) {
        int size = this.size();
        try {
            buffer.append(prefix);
            if (size > 0) {
                buffer.append(transform.apply(this.get(0)));
                for (int i = 1; i < size; ++i) {
                    buffer.append(separator).append(transform.apply(this.get(i)));
                }
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    default public void forEach(@NotNull Consumer<? super E> action) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            action.accept(this.get(i));
        }
    }

    @Override
    default public void forEachIndexed(@NotNull IndexedConsumer<? super E> action) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            action.accept(i, this.get(i));
        }
    }
}

