/*
 * Decompiled with CFR 0.152.
 */
package kala.collection;

import java.util.Objects;
import java.util.function.Function;
import kala.Conditions;
import kala.collection.IndexedSeqLike;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.internal.view.IndexedSeqViews;
import kala.collection.internal.view.SeqViews;
import kala.tuple.primitive.IntObjTuple2;
import org.jetbrains.annotations.NotNull;

public interface IndexedSeqView<E>
extends IndexedSeqLike<E>,
SeqView<E> {
    @Override
    @NotNull
    default public String className() {
        return "IndexedSeqView";
    }

    @Override
    @NotNull
    default public SeqView<E> view() {
        return this;
    }

    @Override
    @NotNull
    default public SeqView<E> concat(@NotNull SeqLike<? extends E> other) {
        return other.supportsFastRandomAccess() ? new IndexedSeqViews.Concat<E>(this, other) : new SeqViews.Concat<E>(this, other);
    }

    @Override
    @NotNull
    default public SeqView<E> prepended(E value) {
        return new IndexedSeqViews.Prepended<E>(this, value);
    }

    @Override
    @NotNull
    default public SeqView<E> appended(E value) {
        return new IndexedSeqViews.Appended<E>(this, value);
    }

    @Override
    @NotNull
    default public SeqView<E> slice(int beginIndex, int endIndex) {
        int size = this.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        switch (endIndex - beginIndex) {
            case 0: {
                return SeqView.empty();
            }
            case 1: {
                return SeqView.of(this.get(beginIndex));
            }
        }
        if (beginIndex == 0) {
            return new IndexedSeqViews.Take(this, endIndex);
        }
        if (endIndex == size) {
            return new IndexedSeqViews.Drop(this, beginIndex);
        }
        return new IndexedSeqViews.Slice(this, beginIndex, endIndex);
    }

    @Override
    @NotNull
    default public SeqView<E> sliceView(int beginIndex, int endIndex) {
        return this.slice(beginIndex, endIndex);
    }

    @Override
    @NotNull
    default public SeqView<E> drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int size = this.size();
        if (size == 0 || n >= size) {
            return SeqView.empty();
        }
        return new IndexedSeqViews.Drop(this, n);
    }

    @Override
    @NotNull
    default public SeqView<E> dropLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int size = this.size();
        if (size == 0 || n >= size) {
            return SeqView.empty();
        }
        return new IndexedSeqViews.Take(this, size - n);
    }

    @Override
    @NotNull
    default public SeqView<E> take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return SeqView.empty();
        }
        int size = this.size();
        if (size == 0) {
            return SeqView.empty();
        }
        if (n >= size) {
            return this;
        }
        return new IndexedSeqViews.Take(this, n);
    }

    @Override
    @NotNull
    default public SeqView<E> takeLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return SeqView.empty();
        }
        int size = this.size();
        if (size == 0) {
            return SeqView.empty();
        }
        if (n >= size) {
            return this;
        }
        return new IndexedSeqViews.Drop(this, size - n);
    }

    @Override
    @NotNull
    default public SeqView<E> updated(int index, E newValue) {
        Conditions.checkElementIndex((int)index, (int)this.size());
        return new IndexedSeqViews.Updated<E>(this, index, newValue);
    }

    @Override
    @NotNull
    default public <U> SeqView<U> map(@NotNull Function<? super E, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return new IndexedSeqViews.Mapped<U, E>(this, mapper);
    }

    @Override
    @NotNull
    default public SeqView<IntObjTuple2<E>> withIndex() {
        return new IndexedSeqViews.WithIndex(this);
    }
}

