/*
 * Decompiled with CFR 0.152.
 */
package kala.collection;

import java.util.Objects;
import java.util.function.Function;
import kala.collection.MapView;
import kala.collection.SetView;
import kala.collection.View;
import kala.collection.base.MapBase;
import kala.collection.immutable.ImmutableArray;
import kala.collection.immutable.ImmutableLinkedSeq;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.immutable.ImmutableVector;
import kala.collection.internal.view.MapViews;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.NotNull;

public interface MapLike<K, V>
extends MapBase<K, V> {
    @NotNull
    default public String className() {
        return "MapLike";
    }

    @NotNull
    default public MapView<K, V> view() {
        return new MapViews.Of(this);
    }

    @NotNull
    default public SetView<K> keysView() {
        return new MapViews.Keys(this);
    }

    @NotNull
    default public View<V> valuesView() {
        return new MapViews.Values(this);
    }

    @NotNull
    default public MapView.WithDefault<K, V> withDefault(@NotNull Function<? super K, ? extends V> defaultFunction) {
        Objects.requireNonNull(defaultFunction);
        return new MapViews.WithDefaultImpl<K, V, MapLike>(this, defaultFunction);
    }

    @NotNull
    default public ImmutableMap<K, V> toImmutableMap() {
        return ImmutableMap.from(this);
    }

    @NotNull
    default public ImmutableSeq<Tuple2<K, V>> toImmutableSeq() {
        return ImmutableSeq.from(this.iterator());
    }

    @NotNull
    default public ImmutableArray<Tuple2<K, V>> toImmutableArray() {
        return ImmutableArray.from(this.toArray());
    }

    @NotNull
    default public ImmutableLinkedSeq<Tuple2<K, V>> toImmutableLinkedSeq() {
        return ImmutableLinkedSeq.from(this.iterator());
    }

    @NotNull
    default public ImmutableVector<Tuple2<K, V>> toImmutableVector() {
        return ImmutableVector.from(this.iterator());
    }
}

