/*
 * Decompiled with CFR 0.152.
 */
package kala.collection;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import kala.collection.MapLike;
import kala.collection.View;
import kala.collection.internal.view.MapViews;
import org.jetbrains.annotations.NotNull;

public interface MapView<K, V>
extends MapLike<K, V> {
    @NotNull
    public static <K, V> MapView<K, V> empty() {
        return MapViews.Empty.INSTANCE;
    }

    @Override
    @NotNull
    default public String className() {
        return "MapView";
    }

    @Override
    @NotNull
    default public MapView<K, V> view() {
        return this;
    }

    @NotNull
    default public <U> View<U> map(@NotNull BiFunction<? super K, ? super V, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return new MapViews.Mapped<U, K, V>(this, mapper);
    }

    @NotNull
    default public <NV> MapView<K, NV> mapValues(@NotNull BiFunction<? super K, ? super V, ? extends NV> mapper) {
        Objects.requireNonNull(mapper);
        return new MapViews.MapValues<K, NV, V>(this, mapper);
    }

    public static interface WithDefault<K, V>
    extends MapView<K, V> {
        @NotNull
        public Function<? super K, ? extends V> getDefaultFunction();
    }
}

