/*
 * Decompiled with CFR 0.152.
 */
package kala.collection;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import kala.collection.Collection;
import kala.collection.SetLike;
import kala.collection.SetView;
import kala.collection.base.Iterators;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.ImmutableSet;
import kala.collection.internal.convert.AsJavaConvert;
import kala.collection.internal.convert.FromJavaConvert;
import kala.collection.internal.view.SetViews;
import org.jetbrains.annotations.NotNull;

public interface Set<E>
extends Collection<E>,
SetLike<E> {
    public static <E> CollectionFactory<E, ?, Set<E>> factory() {
        return CollectionFactory.narrow(ImmutableSet.factory());
    }

    @NotNull
    public static <E> Set<E> wrapJava(@NotNull java.util.Set<E> source) {
        return new FromJavaConvert.SetFromJava<E>(source);
    }

    public static int hashCode(@NotNull Set<?> set) {
        int h = 1045751549;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null) continue;
            h += e.hashCode();
        }
        return h;
    }

    public static boolean equals(@NotNull Set<?> set1, @NotNull Set<?> set2) {
        if (!set1.canEqual(set2) || !set2.canEqual(set1)) {
            return false;
        }
        return set1.size() == set2.size() && set1.containsAll((Iterable)((Object)set2));
    }

    default public boolean contains(Object value) {
        return Iterators.contains((Iterator)this.iterator(), (Object)value);
    }

    default public Predicate<E> asPredicate() {
        return this::contains;
    }

    @Override
    @NotNull
    default public String className() {
        return "Set";
    }

    @Override
    @NotNull
    default public <U> CollectionFactory<U, ?, ? extends Set<U>> iterableFactory() {
        return Set.factory();
    }

    @NotNull
    default public Spliterator<E> spliterator() {
        int knownSize = this.knownSize();
        return knownSize >= 0 ? Spliterators.spliterator(this.iterator(), (long)knownSize, 1) : Spliterators.spliteratorUnknownSize(this.iterator(), 1);
    }

    @Override
    @NotNull
    default public SetView<E> view() {
        return new SetViews.Of(this);
    }

    @Override
    default public @NotNull java.util.Set<E> asJava() {
        return new AsJavaConvert.SetAsJava(this);
    }

    @Override
    default public boolean canEqual(Object other) {
        return other instanceof Set;
    }
}

