/*
 * Decompiled with CFR 0.152.
 */
package kala.collection;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import kala.collection.CollectionLike;
import kala.collection.internal.view.Views;
import kala.function.Predicates;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.NotNull;

public interface View<E>
extends CollectionLike<E> {
    @NotNull
    public static <E> View<E> empty() {
        return Views.Empty.INSTANCE;
    }

    @Override
    @NotNull
    default public String className() {
        return "View";
    }

    @Override
    @NotNull
    default public View<E> view() {
        return this;
    }

    @Override
    @NotNull
    default public View<E> filter(@NotNull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        return new Views.Filter<E>(this, predicate);
    }

    @Override
    @NotNull
    default public View<E> filterNot(@NotNull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        return new Views.FilterNot<E>(this, predicate);
    }

    @Override
    @NotNull
    default public @NotNull View<@NotNull E> filterNotNull() {
        return new Views.FilterNotNull(this);
    }

    @Override
    @NotNull
    default public <U> @NotNull View<@NotNull U> filterIsInstance(@NotNull Class<? extends U> clazz) {
        return this.filter(Predicates.instanceOf(clazz));
    }

    @Override
    @NotNull
    default public <U> View<U> map(@NotNull Function<? super E, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return new Views.Mapped<U, E>(this, mapper);
    }

    @Override
    @NotNull
    default public <U> View<U> mapNotNull(@NotNull Function<? super E, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return new Views.MapNotNull<U, E>(this, mapper);
    }

    @Override
    @NotNull
    default public <U> View<U> mapMulti(@NotNull BiConsumer<? super E, ? super Consumer<? super U>> mapper) {
        Objects.requireNonNull(mapper);
        return new Views.MapMulti(this, mapper);
    }

    @Override
    @NotNull
    default public <U> View<U> flatMap(@NotNull Function<? super E, ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        return new Views.FlatMapped(this, mapper);
    }

    @Override
    @NotNull
    default public <U> @NotNull View<@NotNull Tuple2<E, U>> zip(@NotNull Iterable<? extends U> other) {
        Objects.requireNonNull(other);
        return new Views.Zip(this, other);
    }
}

