/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kala.Conditions;
import kala.collection.ArraySeq;
import kala.collection.SeqLike;
import kala.collection.base.GenericArrays;
import kala.collection.base.Traversable;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.internal.CollectionHelper;
import kala.collection.mutable.MutableArrayList;
import kala.function.CheckedPredicate;
import kala.function.IndexedBiConsumer;
import kala.function.IndexedFunction;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImmutableArray<E>
extends ArraySeq<E>
implements ImmutableSeq<E>,
Serializable {
    private static final long serialVersionUID = 1845940935381169058L;
    public static final ImmutableArray<?> EMPTY = new ImmutableArray();
    private static final Factory<?> FACTORY = new Factory();

    private ImmutableArray() {
        this(GenericArrays.EMPTY_OBJECT_ARRAY);
    }

    private ImmutableArray(Object[] array) {
        super(array);
    }

    @Contract(value="_ -> param1", pure=true)
    public static <E> ImmutableArray<E> narrow(ImmutableArray<? extends E> array) {
        return array;
    }

    @NotNull
    public static <E> CollectionFactory<E, ?, ImmutableArray<E>> factory() {
        return FACTORY;
    }

    @NotNull
    public static <E> ImmutableArray<E> empty() {
        return EMPTY;
    }

    @NotNull
    public static <E> ImmutableArray<E> of() {
        return EMPTY;
    }

    @NotNull
    public static <E> ImmutableArray<E> of(E value1) {
        return new ImmutableArray<E>(new Object[]{value1});
    }

    @NotNull
    public static <E> ImmutableArray<E> of(E value1, E value2) {
        return new ImmutableArray<E>(new Object[]{value1, value2});
    }

    @NotNull
    public static <E> ImmutableArray<E> of(E value1, E value2, E value3) {
        return new ImmutableArray<E>(new Object[]{value1, value2, value3});
    }

    @NotNull
    public static <E> ImmutableArray<E> of(E value1, E value2, E value3, E value4) {
        return new ImmutableArray<E>(new Object[]{value1, value2, value3, value4});
    }

    @NotNull
    public static <E> ImmutableArray<E> of(E value1, E value2, E value3, E value4, E value5) {
        return new ImmutableArray<E>(new Object[]{value1, value2, value3, value4, value5});
    }

    @SafeVarargs
    @Contract(value="_ -> new")
    @NotNull
    public static <E> ImmutableArray<E> of(E ... values) {
        return ImmutableArray.from(values);
    }

    @NotNull
    public static <E> ImmutableArray<E> from(E @NotNull [] values) {
        if (values.length == 0) {
            return ImmutableArray.empty();
        }
        return new ImmutableArray<E>((Object[])values.clone());
    }

    @NotNull
    public static <E> ImmutableArray<E> from(@NotNull Traversable<? extends E> values) {
        if (values instanceof ImmutableArray) {
            return (ImmutableArray)values;
        }
        if (values.knownSize() == 0) {
            return ImmutableArray.empty();
        }
        Object[] arr = values.toArray();
        if (arr.length == 0) {
            return ImmutableArray.empty();
        }
        return new ImmutableArray<E>(arr);
    }

    @NotNull
    public static <E> ImmutableArray<E> from(@NotNull Collection<? extends E> values) {
        if (values.size() == 0) {
            return ImmutableArray.empty();
        }
        return new ImmutableArray<E>(values.toArray());
    }

    @NotNull
    public static <E> ImmutableArray<E> from(@NotNull Iterable<? extends E> values) {
        Objects.requireNonNull(values);
        if (values instanceof ImmutableArray) {
            return (ImmutableArray)((Object)values);
        }
        if (values instanceof Traversable) {
            return ImmutableArray.from((Traversable)values);
        }
        if (values instanceof Collection) {
            return ImmutableArray.from((Collection)values);
        }
        return MutableArrayList.from(values).toImmutableArray();
    }

    @NotNull
    public static <E> ImmutableArray<E> from(@NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            return ImmutableArray.empty();
        }
        MutableArrayList<E> buffer = new MutableArrayList<E>();
        while (it.hasNext()) {
            buffer.append(it.next());
        }
        return buffer.toImmutableArray();
    }

    @NotNull
    public static <E> ImmutableArray<E> from(@NotNull Stream<? extends E> stream) {
        Object[] arr = stream.toArray();
        return arr.length == 0 ? ImmutableArray.empty() : new ImmutableArray<E>(arr);
    }

    @NotNull
    public static <E> ImmutableArray<E> fill(int n, E value) {
        if (n <= 0) {
            return ImmutableArray.empty();
        }
        Object[] ans = new Object[n];
        if (value != null) {
            Arrays.fill(ans, value);
        }
        return new ImmutableArray<E>(ans);
    }

    @NotNull
    public static <E> ImmutableArray<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
        if (n <= 0) {
            return ImmutableArray.empty();
        }
        Object[] ans = new Object[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.get();
        }
        return new ImmutableArray<E>(ans);
    }

    @NotNull
    public static <E> ImmutableArray<E> fill(int n, @NotNull IntFunction<? extends E> init) {
        if (n <= 0) {
            return ImmutableArray.empty();
        }
        Object[] ans = new Object[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = init.apply(i);
        }
        return new ImmutableArray<E>(ans);
    }

    Object @NotNull [] getArray() {
        return this.elements;
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableArray";
    }

    @Override
    @NotNull
    public <U> CollectionFactory<U, ?, ImmutableArray<U>> iterableFactory() {
        return ImmutableArray.factory();
    }

    @Override
    @NotNull
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.elements, 1024);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> prepended(E value) {
        Object[] newValues = new Object[this.elements.length + 1];
        newValues[0] = value;
        System.arraycopy(this.elements, 0, newValues, 1, this.elements.length);
        return new ImmutableArray<E>(newValues);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> prependedAll(E @NotNull [] values) {
        if (values.length == 0) {
            return this;
        }
        Object[] newValues = Arrays.copyOf(values, values.length + this.elements.length, Object[].class);
        System.arraycopy(this.elements, 0, newValues, values.length, this.elements.length);
        return new ImmutableArray<E>(newValues);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> prependedAll(@NotNull Iterable<? extends E> values) {
        Objects.requireNonNull(values);
        Object[] data = values instanceof ImmutableArray ? ((ImmutableArray)((Object)values)).elements : CollectionHelper.asArray(values);
        Object[] newValues = new Object[data.length + this.elements.length];
        System.arraycopy(data, 0, newValues, 0, data.length);
        System.arraycopy(this.elements, 0, newValues, data.length, this.elements.length);
        return new ImmutableArray<E>(newValues);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> appended(E value) {
        Object[] elements = this.elements;
        int size = elements.length;
        Object[] newValues = Arrays.copyOf(elements, size + 1);
        newValues[size] = value;
        return new ImmutableArray<E>(newValues);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> appendedAll(E @NotNull [] values) {
        if (values.length == 0) {
            return this;
        }
        Object[] elements = this.elements;
        int size = elements.length;
        Object[] newValues = Arrays.copyOf(elements, values.length + size);
        System.arraycopy(values, 0, newValues, size, values.length);
        return new ImmutableArray<E>(newValues);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> appendedAll(@NotNull Iterable<? extends E> values) {
        Objects.requireNonNull(values);
        Object[] data = values instanceof ImmutableArray ? ((ImmutableArray)((Object)values)).elements : CollectionHelper.asArray(values);
        Object[] newValues = Arrays.copyOf(this.elements, this.elements.length + data.length);
        System.arraycopy(data, 0, newValues, this.elements.length, data.length);
        return new ImmutableArray<E>(newValues);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> slice(int beginIndex, int endIndex) {
        Object[] elements = this.elements;
        int size = elements.length;
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int ns = endIndex - beginIndex;
        if (ns == 0) {
            return ImmutableArray.empty();
        }
        if (ns == size) {
            return this;
        }
        return new ImmutableArray<E>(Arrays.copyOfRange(elements, beginIndex, endIndex));
    }

    @Override
    @NotNull
    public ImmutableSeq<E> drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        Object[] elements = this.elements;
        int size = elements.length;
        if (n >= size) {
            return ImmutableArray.empty();
        }
        return new ImmutableArray<E>(Arrays.copyOfRange(elements, n, size));
    }

    @Override
    @NotNull
    public ImmutableSeq<E> dropLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        return this.take(Integer.max(0, this.size() - n));
    }

    @Override
    @NotNull
    public ImmutableSeq<E> dropWhile(@NotNull Predicate<? super E> predicate) {
        int idx;
        Object[] elements = this.elements;
        int size = elements.length;
        for (idx = 0; idx < size && predicate.test(elements[idx]); ++idx) {
        }
        if (idx >= size) {
            return ImmutableArray.empty();
        }
        return new ImmutableArray<E>(Arrays.copyOfRange(elements, idx, size));
    }

    @Override
    @NotNull
    public ImmutableSeq<E> take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int size = this.elements.length;
        if (n == 0) {
            return ImmutableArray.empty();
        }
        if (n >= size) {
            return this;
        }
        return new ImmutableArray<E>(Arrays.copyOf(this.elements, n));
    }

    @Override
    @NotNull
    public ImmutableSeq<E> takeLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return ImmutableArray.empty();
        }
        return this.drop(Integer.max(0, this.size() - n));
    }

    @Override
    @NotNull
    public ImmutableSeq<E> takeWhile(@NotNull Predicate<? super E> predicate) {
        int count;
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return ImmutableArray.empty();
        }
        for (count = 0; count < size && predicate.test(elements[count]); ++count) {
        }
        if (count == 0) {
            return ImmutableArray.empty();
        }
        if (count == size) {
            return this;
        }
        return new ImmutableArray<E>(Arrays.copyOf(elements, count));
    }

    @Override
    @NotNull
    public ImmutableSeq<E> updated(int index, E newValue) {
        Object[] elements = this.elements;
        int size = elements.length;
        Conditions.checkElementIndex((int)index, (int)size);
        Object[] newValues = (Object[])elements.clone();
        newValues[index] = newValue;
        return new ImmutableArray<E>(newValues);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> concat(@NotNull SeqLike<? extends E> other) {
        return this.appendedAll((Iterable)((Object)other));
    }

    @Override
    @NotNull
    public ImmutableSeq<E> concat(@NotNull List<? extends E> other) {
        return this.appendedAll(other);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> filter(@NotNull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return this;
        }
        Object[] tmp = new Object[size];
        int c = 0;
        for (Object value : elements) {
            Object v = value;
            if (!predicate.test(v)) continue;
            tmp[c++] = v;
        }
        if (c == 0) {
            return ImmutableArray.empty();
        }
        if (c == size) {
            return this;
        }
        return new ImmutableArray<E>(Arrays.copyOf(tmp, c));
    }

    @Override
    @NotNull
    public <Ex extends Throwable> ImmutableSeq<E> filterChecked(@NotNull CheckedPredicate<? super E, ? extends Ex> predicate) {
        return this.filter((Predicate)predicate);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> filterUnchecked(@NotNull CheckedPredicate<? super E, ?> predicate) {
        return this.filter((Predicate)predicate);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> filterNot(@NotNull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return this;
        }
        Object[] tmp = new Object[size];
        int c = 0;
        for (Object value : elements) {
            Object v = value;
            if (predicate.test(v)) continue;
            tmp[c++] = v;
        }
        if (c == 0) {
            return ImmutableArray.empty();
        }
        if (c == size) {
            return this;
        }
        return new ImmutableArray<E>(Arrays.copyOf(tmp, c));
    }

    @Override
    @NotNull
    public @NotNull ImmutableSeq<@NotNull E> filterNotNull() {
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return this;
        }
        Object[] tmp = new Object[size];
        int c = 0;
        for (Object value : elements) {
            if (value == null) continue;
            tmp[c++] = value;
        }
        if (c == 0) {
            return ImmutableArray.empty();
        }
        if (c == size) {
            return this;
        }
        return new ImmutableArray<E>(Arrays.copyOf(tmp, c));
    }

    @Override
    @NotNull
    public <U> @NotNull ImmutableSeq<@NotNull U> filterIsInstance(@NotNull Class<? extends U> clazz) {
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return ImmutableArray.empty();
        }
        Object[] tmp = new Object[size];
        int c = 0;
        for (Object value : elements) {
            if (!clazz.isInstance(value)) continue;
            tmp[c++] = value;
        }
        if (c == 0) {
            return ImmutableArray.empty();
        }
        if (c == size) {
            return this;
        }
        return new ImmutableArray<E>(Arrays.copyOf(tmp, c));
    }

    @Override
    @NotNull
    public <U> ImmutableSeq<U> map(@NotNull Function<? super E, ? extends U> mapper) {
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return ImmutableArray.empty();
        }
        Object[] newValues = new Object[size];
        for (int i = 0; i < size; ++i) {
            newValues[i] = mapper.apply(elements[i]);
        }
        return new ImmutableArray<E>(newValues);
    }

    @Override
    @NotNull
    public <U> ImmutableSeq<U> mapIndexed(@NotNull IndexedFunction<? super E, ? extends U> mapper) {
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return ImmutableArray.empty();
        }
        Object[] newValues = new Object[size];
        for (int i = 0; i < size; ++i) {
            newValues[i] = mapper.apply(i, elements[i]);
        }
        return new ImmutableArray<E>(newValues);
    }

    @Override
    @NotNull
    public <U> @NotNull ImmutableSeq<@NotNull U> mapNotNull(@NotNull Function<? super E, ? extends @Nullable U> mapper) {
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return ImmutableArray.empty();
        }
        Object[] tmp = new Object[size];
        int c = 0;
        for (Object value : elements) {
            U u = mapper.apply(value);
            if (u == null) continue;
            tmp[c++] = u;
        }
        if (c == 0) {
            return ImmutableArray.empty();
        }
        if (c == size) {
            return new ImmutableArray<E>(tmp);
        }
        return new ImmutableArray<E>(Arrays.copyOf(tmp, c));
    }

    @Override
    @NotNull
    public <U> @NotNull ImmutableSeq<@NotNull U> mapIndexedNotNull(@NotNull IndexedFunction<? super E, ? extends @Nullable U> mapper) {
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return ImmutableArray.empty();
        }
        Object[] tmp = new Object[size];
        int c = 0;
        for (int i = 0; i < size; ++i) {
            Object u = mapper.apply(i, elements[i]);
            if (u == null) continue;
            tmp[c++] = u;
        }
        if (c == 0) {
            return ImmutableArray.empty();
        }
        if (c == size) {
            return new ImmutableArray<E>(tmp);
        }
        return new ImmutableArray<E>(Arrays.copyOf(tmp, c));
    }

    @Override
    @NotNull
    public <U> ImmutableSeq<U> mapMulti(@NotNull BiConsumer<? super E, ? super Consumer<? super U>> mapper) {
        MutableArrayList builder = new MutableArrayList();
        Consumer<Object> consumer = builder::append;
        for (Object element : this.elements) {
            mapper.accept(element, consumer);
        }
        return builder.toImmutableArray();
    }

    @Override
    @NotNull
    public <U> ImmutableSeq<U> mapIndexedMulti(@NotNull IndexedBiConsumer<? super E, ? super Consumer<? super U>> mapper) {
        MutableArrayList builder = new MutableArrayList();
        Consumer<Object> consumer = builder::append;
        for (int i = 0; i < this.elements.length; ++i) {
            mapper.accept(i, this.elements[i], consumer);
        }
        return builder.toImmutableArray();
    }

    @Override
    @NotNull
    public <U> ImmutableSeq<U> flatMap(@NotNull Function<? super E, ? extends Iterable<? extends U>> mapper) {
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return ImmutableArray.empty();
        }
        MutableArrayList<? extends U> builder = new MutableArrayList<U>();
        for (Object value : elements) {
            builder.appendAll(mapper.apply(value));
        }
        return builder.toImmutableArray();
    }

    @Override
    @NotNull
    public ImmutableSeq<E> sorted() {
        Object[] elements = this.elements;
        if (elements.length == 0 || elements.length == 1) {
            return this;
        }
        Object[] newValues = (Object[])elements.clone();
        Arrays.sort(newValues);
        return new ImmutableArray<E>(newValues);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> sorted(Comparator<? super E> comparator) {
        Object[] elements = this.elements;
        if (elements.length == 0 || elements.length == 1) {
            return this;
        }
        Object[] newValues = (Object[])elements.clone();
        Arrays.sort(newValues, comparator);
        return new ImmutableArray<E>(newValues);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> reversed() {
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return this;
        }
        Object[] res = new Object[size];
        for (int i = 0; i < size; ++i) {
            res[i] = elements[size - i - 1];
        }
        return new ImmutableArray<E>(res);
    }

    @Override
    @NotNull
    public <U> @NotNull ImmutableSeq<@NotNull Tuple2<E, U>> zip(@NotNull Iterable<? extends U> other) {
        int i;
        Iterator<U> it = other.iterator();
        if (!it.hasNext()) {
            return ImmutableArray.empty();
        }
        Object[] elements = this.elements;
        int size = elements.length;
        Object[] tmp = new Object[size];
        for (i = 0; it.hasNext() && i < size; ++i) {
            tmp[i] = new Tuple2(elements[i], it.next());
        }
        if (i < size) {
            tmp = Arrays.copyOf(tmp, i);
        }
        return new ImmutableArray<Tuple2<E, U>>(tmp);
    }

    @NotNull
    public @NotNull Tuple2<@NotNull ImmutableSeq<E>, @NotNull ImmutableSeq<E>> span(@NotNull Predicate<? super E> predicate) {
        int idx;
        Objects.requireNonNull(predicate);
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return new Tuple2(ImmutableArray.empty(), ImmutableArray.empty());
        }
        for (idx = 0; idx < size && predicate.test(elements[idx]); ++idx) {
        }
        if (idx == 0) {
            return new Tuple2(ImmutableArray.empty(), (Object)this);
        }
        if (idx == size) {
            return new Tuple2((Object)this, ImmutableArray.empty());
        }
        return new Tuple2(new ImmutableArray<E>(Arrays.copyOfRange(elements, 0, idx)), new ImmutableArray<E>(Arrays.copyOfRange(elements, idx, size)));
    }

    @Override
    @NotNull
    public ImmutableArray<E> toImmutableArray() {
        return this;
    }

    private static final class Factory<E>
    implements CollectionFactory<E, MutableArrayList<E>, ImmutableArray<E>> {
        Factory() {
        }

        public ImmutableArray<E> empty() {
            return ImmutableArray.empty();
        }

        public ImmutableArray<E> from(E @NotNull [] values) {
            return ImmutableArray.from(values);
        }

        public ImmutableArray<E> from(@NotNull Iterable<? extends E> values) {
            return ImmutableArray.from(values);
        }

        public ImmutableArray<E> from(@NotNull Iterator<? extends E> it) {
            return ImmutableArray.from(it);
        }

        public ImmutableArray<E> fill(int n, E value) {
            return ImmutableArray.fill(n, value);
        }

        public ImmutableArray<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
            return ImmutableArray.fill(n, supplier);
        }

        public ImmutableArray<E> fill(int n, @NotNull IntFunction<? extends E> init) {
            return ImmutableArray.fill(n, init);
        }

        public MutableArrayList<E> newBuilder() {
            return new MutableArrayList();
        }

        public void addToBuilder(@NotNull MutableArrayList<E> buffer, E value) {
            buffer.append(value);
        }

        public void sizeHint(@NotNull MutableArrayList<E> buffer, int size) {
            buffer.sizeHint(size);
        }

        public MutableArrayList<E> mergeBuilder(@NotNull MutableArrayList<E> buffer1, @NotNull MutableArrayList<E> buffer2) {
            buffer1.appendAll((Iterable<E>)((Object)buffer2));
            return buffer1;
        }

        public ImmutableArray<E> build(@NotNull MutableArrayList<E> buffer) {
            return buffer.toImmutableArray();
        }
    }

    public static final class Unsafe {
        private Unsafe() {
        }

        @Contract(value="_ -> new")
        @NotNull
        public static <E> ImmutableArray<E> wrap(Object @NotNull [] array) {
            Objects.requireNonNull(array);
            return new ImmutableArray(array);
        }
    }
}

