/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable;

import java.io.Serializable;
import java.lang.invoke.StringConcatFactory;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kala.Conditions;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.base.AbstractIterator;
import kala.collection.base.AnyTraversable;
import kala.collection.base.Iterators;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.AbstractImmutableSeq;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.internal.view.SeqViews;
import kala.collection.mutable.AbstractMutableList;
import kala.collection.mutable.MutableSinglyLinkedList;
import kala.control.Option;
import kala.function.IndexedBiConsumer;
import kala.function.IndexedConsumer;
import kala.function.IndexedFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImmutableLinkedSeq<E>
extends AbstractImmutableSeq<E>
implements Serializable {
    private static final long serialVersionUID = 4185879054671961536L;
    public static final NodeFactory<?> NODE_FACTORY = new NodeFactory();
    private static final Factory<?> FACTORY = new Factory();
    public static final Node<?> NIL_NODE = new Node();
    public static final ImmutableLinkedSeq<?> EMPTY = new ImmutableLinkedSeq(NIL_NODE, 0);
    private final Node<E> list;
    private final int size;

    ImmutableLinkedSeq(Node<E> list, int size) {
        this.list = list;
        this.size = size;
    }

    @Contract(value="_ -> param1", pure=true)
    public static <E> Node<E> narrow(Node<? extends E> node) {
        return node;
    }

    @NotNull
    public static <E> CollectionFactory<E, ?, ImmutableLinkedSeq<E>> factory() {
        return FACTORY;
    }

    public static <E> ImmutableLinkedSeq<E> empty() {
        return EMPTY;
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> of() {
        return ImmutableLinkedSeq.empty();
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> of(E value1) {
        return new ImmutableLinkedSeq<E>(ImmutableLinkedSeq.nodeOf(value1), 1);
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> of(E value1, E value2) {
        return new ImmutableLinkedSeq<E>(ImmutableLinkedSeq.nodeOf(value1, value2), 2);
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> of(E value1, E value2, E value3) {
        return new ImmutableLinkedSeq<E>(ImmutableLinkedSeq.nodeOf(value1, value2, value3), 3);
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> of(E value1, E value2, E value3, E value4) {
        return new ImmutableLinkedSeq<E>(ImmutableLinkedSeq.nodeOf(value1, value2, value3, value4), 4);
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> of(E value1, E value2, E value3, E value4, E value5) {
        return new ImmutableLinkedSeq<E>(ImmutableLinkedSeq.nodeOf(value1, value2, value3, value4, value5), 5);
    }

    @SafeVarargs
    @NotNull
    public static <E> ImmutableLinkedSeq<E> of(E ... values) {
        return ImmutableLinkedSeq.from(values);
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> from(E @NotNull [] values) {
        int size = values.length;
        if (size == 0) {
            return ImmutableLinkedSeq.empty();
        }
        return new ImmutableLinkedSeq<E>(ImmutableLinkedSeq.nodeFrom(values), size);
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> from(@NotNull List<? extends E> values) {
        int size = values.size();
        if (size == 0) {
            return ImmutableLinkedSeq.empty();
        }
        return new ImmutableLinkedSeq<E>(ImmutableLinkedSeq.nodeFrom(values), size);
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> from(@NotNull Iterable<? extends E> values) {
        if (values instanceof ImmutableLinkedSeq) {
            return (ImmutableLinkedSeq)((Object)values);
        }
        if (values instanceof Node) {
            return ImmutableLinkedSeq.from((Node)((Object)values));
        }
        return ImmutableLinkedSeq.from(values.iterator());
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> from(@NotNull Node<? extends E> values) {
        int size = values.size();
        return size == 0 ? ImmutableLinkedSeq.empty() : new ImmutableLinkedSeq<E>(values, size);
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> from(@NotNull Iterator<? extends E> it) {
        Node<E> res;
        if (!it.hasNext()) {
            return ImmutableLinkedSeq.empty();
        }
        Node<E> t = res = new Node<E>(it.next());
        int c = 1;
        while (it.hasNext()) {
            Node<E> nl = new Node<E>(it.next());
            t.tail = nl;
            t = nl;
            ++c;
        }
        t.tail = ImmutableLinkedSeq.nilNode();
        return new ImmutableLinkedSeq<E>(res, c);
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> from(@NotNull Stream<? extends E> stream) {
        return stream.collect(ImmutableLinkedSeq.factory());
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> fill(int n, E value) {
        if (n <= 0) {
            return ImmutableLinkedSeq.empty();
        }
        Node<E> res = ImmutableLinkedSeq.nilNode();
        for (int i = 0; i < n; ++i) {
            res = new Node<E>(value, res);
        }
        return new ImmutableLinkedSeq<E>(res, n);
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
        Node<E> res;
        if (n <= 0) {
            return ImmutableLinkedSeq.empty();
        }
        Node<E> t = res = new Node<E>(supplier.get());
        for (int i = 1; i < n; ++i) {
            Node<E> nl = new Node<E>(supplier.get());
            t.tail = nl;
            t = nl;
        }
        t.tail = ImmutableLinkedSeq.nilNode();
        return new ImmutableLinkedSeq<E>(res, n);
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> fill(int n, @NotNull IntFunction<? extends E> init) {
        Node<E> res;
        if (n <= 0) {
            return ImmutableLinkedSeq.empty();
        }
        Node<E> t = res = new Node<E>(init.apply(0));
        for (int i = 1; i < n; ++i) {
            Node<E> nl = new Node<E>(init.apply(i));
            t.tail = nl;
            t = nl;
        }
        t.tail = ImmutableLinkedSeq.nilNode();
        return new ImmutableLinkedSeq<E>(res, n);
    }

    public static <E> CollectionFactory<E, ?, Node<E>> nodeFactory() {
        return NODE_FACTORY;
    }

    @NotNull
    public static <E> Node<E> nilNode() {
        return NIL_NODE;
    }

    @NotNull
    public static <E> Node<E> emptyNode() {
        return ImmutableLinkedSeq.nilNode();
    }

    @NotNull
    public static <E> Node<E> nodeOf() {
        return ImmutableLinkedSeq.nilNode();
    }

    @NotNull
    public static <E> Node<E> nodeOf(E value1) {
        return new Node<E>(value1, ImmutableLinkedSeq.nilNode());
    }

    @NotNull
    public static <E> Node<E> nodeOf(E value1, E value2) {
        return new Node<E>(value1, new Node<E>(value2, ImmutableLinkedSeq.nilNode()));
    }

    @NotNull
    public static <E> Node<E> nodeOf(E value1, E value2, E value3) {
        return new Node<E>(value1, new Node<E>(value2, new Node<E>(value3, ImmutableLinkedSeq.nilNode())));
    }

    @NotNull
    public static <E> Node<E> nodeOf(E value1, E value2, E value3, E value4) {
        return new Node<E>(value1, new Node<E>(value2, new Node<E>(value3, new Node<E>(value4, ImmutableLinkedSeq.nilNode()))));
    }

    @NotNull
    public static <E> Node<E> nodeOf(E value1, E value2, E value3, E value4, E value5) {
        return new Node<E>(value1, new Node<E>(value2, new Node<E>(value3, new Node<E>(value4, new Node<E>(value5, ImmutableLinkedSeq.nilNode())))));
    }

    @SafeVarargs
    @NotNull
    public static <E> Node<E> nodeOf(E ... values) {
        return ImmutableLinkedSeq.nodeFrom(values);
    }

    @NotNull
    public static <E> Node<E> nodeFrom(E @NotNull [] values) {
        Node<E> res = ImmutableLinkedSeq.nilNode();
        for (int i = values.length - 1; i >= 0; --i) {
            res = new Node<E>(values[i], res);
        }
        return res;
    }

    @NotNull
    public static <E> Node<E> nodeFrom(@NotNull List<? extends E> values) {
        if (values.isEmpty()) {
            return ImmutableLinkedSeq.emptyNode();
        }
        return values instanceof RandomAccess ? ImmutableLinkedSeq.nodeFromRandomAccess(values) : ImmutableLinkedSeq.nodeFrom(values.iterator());
    }

    @NotNull
    private static <E> Node<E> nodeFromRandomAccess(@NotNull List<? extends E> values) {
        Node<E> res = ImmutableLinkedSeq.nilNode();
        for (int i = values.size() - 1; i >= 0; --i) {
            res = new Node<E>(values.get(i), res);
        }
        return res;
    }

    @NotNull
    public static <E> Node<E> nodeFrom(@NotNull Iterable<? extends E> values) {
        if (values instanceof Node) {
            return (Node)((Object)values);
        }
        return ImmutableLinkedSeq.nodeFrom(values.iterator());
    }

    @NotNull
    public static <E> Node<E> nodeFrom(@NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            return ImmutableLinkedSeq.nilNode();
        }
        Node<E> cons = new Node<E>(it.next());
        cons.appendIterator(it).tail = ImmutableLinkedSeq.nilNode();
        return cons;
    }

    @NotNull
    public static <E> Node<E> nodeFrom(@NotNull Stream<? extends E> stream) {
        return stream.collect(ImmutableLinkedSeq.nodeFactory());
    }

    @NotNull
    public static <E> Node<E> nodeFill(int n, E value) {
        Node<E> res = ImmutableLinkedSeq.nilNode();
        for (int i = 0; i < n; ++i) {
            res = new Node<E>(value, res);
        }
        return res;
    }

    @NotNull
    public static <E> Node<E> nodeFill(int n, @NotNull Supplier<? extends E> supplier) {
        Node<E> res;
        if (n <= 0) {
            return ImmutableLinkedSeq.nilNode();
        }
        Node<E> t = res = new Node<E>(supplier.get());
        for (int i = 1; i < n; ++i) {
            Node<E> nl = new Node<E>(supplier.get());
            t.tail = nl;
            t = nl;
        }
        t.tail = ImmutableLinkedSeq.nilNode();
        return res;
    }

    @NotNull
    public static <E> Node<E> nodeFill(int n, @NotNull IntFunction<? extends E> init) {
        Node<E> res;
        if (n <= 0) {
            return ImmutableLinkedSeq.nilNode();
        }
        Node<E> t = res = new Node<E>(init.apply(0));
        for (int i = 1; i < n; ++i) {
            Node<E> nl = new Node<E>(init.apply(i));
            t.tail = nl;
            t = nl;
        }
        t.tail = ImmutableLinkedSeq.nilNode();
        return res;
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableLinkedSeq";
    }

    @Override
    @NotNull
    public <U> CollectionFactory<U, ?, ImmutableLinkedSeq<U>> iterableFactory() {
        return ImmutableLinkedSeq.factory();
    }

    @NotNull
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public int knownSize() {
        return this.size;
    }

    @Override
    public E get(int index) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        Node<E> list = this.list;
        for (int i = 0; i < index; ++i) {
            list = list.tail;
        }
        return list.head;
    }

    @Override
    @Nullable
    public E getOrNull(int index) {
        if (index < 0 || index >= this.size) {
            return null;
        }
        Node<E> list = this.list;
        for (int i = 0; i < index; ++i) {
            list = list.tail;
        }
        return list.head;
    }

    @Override
    @NotNull
    public Option<E> getOption(int index) {
        if (index < 0 || index >= this.size) {
            return Option.none();
        }
        Node<E> list = this.list;
        for (int i = 0; i < index; ++i) {
            list = list.tail;
        }
        return Option.some(list.head);
    }

    @Override
    @NotNull
    public ImmutableLinkedSeq<E> reversed() {
        int size = this.size;
        if (size == 0 || size == 1) {
            return this;
        }
        return new ImmutableLinkedSeq<E>(this.list.reversed(), size);
    }

    @Override
    @NotNull
    public Iterator<E> reverseIterator() {
        return this.list.reverseIterator();
    }

    @NotNull
    public ImmutableSeq<E> cons(E value) {
        return new ImmutableLinkedSeq<E>(this.list.cons(value), this.size + 1);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> prepended(E value) {
        return new ImmutableLinkedSeq<E>(this.list.cons(value), this.size + 1);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> appended(E value) {
        return new ImmutableLinkedSeq<E>((Node)this.list.appended((Object)value), this.size + 1);
    }

    @Override
    public E first() {
        return this.list.first();
    }

    @Override
    public E first(@NotNull Predicate<? super E> predicate) {
        return (E)this.list.first(predicate);
    }

    @Override
    @Nullable
    public E firstOrNull() {
        return this.list.firstOrNull();
    }

    @Override
    @Nullable
    public E firstOrNull(@NotNull Predicate<? super E> predicate) {
        return (E)this.list.firstOrNull(predicate);
    }

    @Override
    @NotNull
    public Option<E> firstOption() {
        return this.list.firstOption();
    }

    @Override
    @NotNull
    public Option<E> firstOption(@NotNull Predicate<? super E> predicate) {
        return this.list.firstOption(predicate);
    }

    @Override
    public E last() {
        return this.list.last();
    }

    @Override
    public E last(@NotNull Predicate<? super E> predicate) {
        return (E)this.list.last(predicate);
    }

    @Override
    @Nullable
    public E lastOrNull() {
        return this.list.lastOrNull();
    }

    @Override
    @Nullable
    public E lastOrNull(@NotNull Predicate<? super E> predicate) {
        return (E)this.list.lastOrNull(predicate);
    }

    @Override
    @NotNull
    public Option<E> lastOption() {
        return this.list.lastOption();
    }

    @Override
    @NotNull
    public Option<E> lastOption(@NotNull Predicate<? super E> predicate) {
        return this.list.lastOption(predicate);
    }

    public boolean contains(Object value) {
        return this.list.contains(value);
    }

    public boolean containsAll(Object @NotNull [] values) {
        return this.list.containsAll(values);
    }

    public boolean containsAll(@NotNull Iterable<?> values) {
        return this.list.containsAll(values);
    }

    public boolean sameElements(@NotNull Iterable<?> other) {
        return this.list.sameElements(other);
    }

    public boolean sameElements(@NotNull Iterable<?> other, boolean identity) {
        return this.list.sameElements(other, identity);
    }

    public boolean anyMatch(@NotNull Predicate<? super E> predicate) {
        return this.list.anyMatch(predicate);
    }

    public boolean allMatch(@NotNull Predicate<? super E> predicate) {
        return this.list.allMatch(predicate);
    }

    public boolean noneMatch(@NotNull Predicate<? super E> predicate) {
        return this.list.noneMatch(predicate);
    }

    @Override
    @Contract(pure=true)
    public int indexOf(Object value) {
        return this.list.indexOf(value);
    }

    @Override
    @Contract(pure=true)
    public int indexWhere(@NotNull Predicate<? super E> predicate) {
        return this.list.indexWhere(predicate);
    }

    @Override
    @Contract(pure=true)
    public int lastIndexOf(Object value) {
        return this.list.lastIndexOf(value);
    }

    @Override
    @Contract(pure=true)
    public int lastIndexWhere(@NotNull Predicate<? super E> predicate) {
        return this.list.lastIndexWhere(predicate);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> slice(int beginIndex, int endIndex) {
        int size = this.size;
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        if (endIndex == size) {
            if (beginIndex == 0) {
                return this;
            }
            Node<E> list = this.list;
            int n = beginIndex;
            while (n-- > 0) {
                list = list.tail;
            }
            return new ImmutableLinkedSeq<E>(list, size - beginIndex);
        }
        int ns = endIndex - beginIndex;
        if (ns == 0) {
            return ImmutableLinkedSeq.empty();
        }
        return new ImmutableLinkedSeq<E>((Node)this.list.drop(beginIndex).take(ns), ns);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        if (n >= this.size) {
            return ImmutableLinkedSeq.empty();
        }
        Node<E> list = this.list;
        for (int i = 0; i < n; ++i) {
            list = list.tail;
        }
        return new ImmutableLinkedSeq<E>(list, this.size - n);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> dropLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        if (n >= this.size) {
            return ImmutableLinkedSeq.empty();
        }
        int ns = this.size - n;
        return new ImmutableLinkedSeq<E>((Node)this.list.take(ns), ns);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> dropWhile(@NotNull Predicate<? super E> predicate) {
        int c = 0;
        Node<E> list = this.list;
        while (list != NIL_NODE && predicate.test(list.head)) {
            list = list.tail();
            ++c;
        }
        if (list == NIL_NODE) {
            return ImmutableLinkedSeq.empty();
        }
        if (c == 0) {
            return this;
        }
        return new ImmutableLinkedSeq<E>(list, this.size - c);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return ImmutableLinkedSeq.empty();
        }
        if (n >= this.size) {
            return this;
        }
        return new ImmutableLinkedSeq<E>((Node)this.list.take(n), n);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> takeLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return ImmutableLinkedSeq.empty();
        }
        int size = this.size;
        if (n >= size) {
            return this;
        }
        return new ImmutableLinkedSeq<E>((Node)this.list.drop(size - n), n);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> takeWhile(@NotNull Predicate<? super E> predicate) {
        Node res;
        Node<E> list = this.list;
        if (list == NIL_NODE || !predicate.test(list.head)) {
            return ImmutableLinkedSeq.empty();
        }
        int c = 0;
        Node t = res = new Node(list.head);
        list = list.tail;
        while (true) {
            if (list == NIL_NODE) {
                return this;
            }
            if (!predicate.test(list.head)) break;
            Node nl = new Node(list.head);
            t.tail = nl;
            t = nl;
            ++c;
            list = list.tail;
        }
        t.tail = ImmutableLinkedSeq.nilNode();
        return new ImmutableLinkedSeq(res, c);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> updated(int index, E newValue) {
        int size = this.size;
        Conditions.checkElementIndex((int)index, (int)size);
        return new ImmutableLinkedSeq<E>((Node)this.list.updated(index, (Object)newValue), size);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> concat(@NotNull SeqLike<? extends E> other) {
        Node res;
        int size = this.size;
        int otherSize = other.size();
        if (otherSize == 0) {
            return this;
        }
        if (size == 0) {
            return new ImmutableLinkedSeq<E>(ImmutableLinkedSeq.nodeFrom(other), size);
        }
        Node<E> list = this.list;
        Node t = res = new Node(list.head);
        list = list.tail;
        while (list != NIL_NODE) {
            Node nl = new Node(list.head);
            t.tail = nl;
            t = nl;
            list = list.tail;
        }
        if (other.supportsFastRandomAccess()) {
            for (int i = 0; i < otherSize; ++i) {
                Node<E> nl = new Node<E>(other.get(i));
                t.tail = nl;
                t = nl;
            }
            t.tail = ImmutableLinkedSeq.nilNode();
            return new ImmutableLinkedSeq(res, size + otherSize);
        }
        int c = this.size;
        Iterator iterator = other.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Node nl = new Node(e);
            t.tail = nl;
            t = nl;
            ++c;
        }
        assert (c == size + otherSize);
        t.tail = ImmutableLinkedSeq.nilNode();
        return new ImmutableLinkedSeq(res, c);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> concat(@NotNull List<? extends E> other) {
        Node res;
        int size = this.size;
        int otherSize = other.size();
        if (otherSize == 0) {
            return this;
        }
        if (size == 0) {
            return new ImmutableLinkedSeq<E>(ImmutableLinkedSeq.nodeFrom(other), size);
        }
        Node<E> list = this.list;
        Node t = res = new Node(list.head);
        list = list.tail;
        while (list != NIL_NODE) {
            Node nl = new Node(list.head);
            t.tail = nl;
            t = nl;
            list = list.tail;
        }
        if (other instanceof RandomAccess) {
            for (int i = 0; i < otherSize; ++i) {
                Node<E> nl = new Node<E>(other.get(i));
                t.tail = nl;
                t = nl;
            }
            t.tail = ImmutableLinkedSeq.nilNode();
            return new ImmutableLinkedSeq(res, size + otherSize);
        }
        int c = this.size;
        for (E e : other) {
            Node<E> nl = new Node<E>(e);
            t.tail = nl;
            t = nl;
            ++c;
        }
        assert (c == size + otherSize);
        t.tail = ImmutableLinkedSeq.nilNode();
        return new ImmutableLinkedSeq(res, c);
    }

    @Override
    @NotNull
    public <U> ImmutableSeq<U> map(@NotNull Function<? super E, ? extends U> mapper) {
        int size = this.size;
        if (size == 0) {
            return ImmutableLinkedSeq.empty();
        }
        return new ImmutableLinkedSeq<E>((Node)this.list.map(mapper), size);
    }

    @Override
    @NotNull
    public <U> ImmutableSeq<U> mapIndexed(@NotNull IndexedFunction<? super E, ? extends U> mapper) {
        int size = this.size;
        if (size == 0) {
            return ImmutableLinkedSeq.empty();
        }
        return new ImmutableLinkedSeq<E>((Node)this.list.mapIndexed(mapper), size);
    }

    @Override
    @NotNull
    public <U> ImmutableSeq<U> mapMulti(@NotNull BiConsumer<? super E, ? super Consumer<? super U>> mapper) {
        MutableSinglyLinkedList builder = new MutableSinglyLinkedList();
        Consumer<Object> consumer = builder::append;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            E e = iterator.next();
            mapper.accept(e, consumer);
        }
        return builder.toImmutableLinkedSeq();
    }

    @Override
    @NotNull
    public <U> ImmutableSeq<U> mapIndexedMulti(@NotNull IndexedBiConsumer<? super E, ? super Consumer<? super U>> mapper) {
        MutableSinglyLinkedList builder = new MutableSinglyLinkedList();
        Consumer<Object> consumer = builder::append;
        int idx = 0;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            E e = iterator.next();
            mapper.accept(idx++, e, consumer);
        }
        return builder.toImmutableLinkedSeq();
    }

    @Override
    @NotNull
    public ImmutableSeq<E> sorted() {
        int size = this.size;
        if (size == 0 || size == 1) {
            return this;
        }
        return new ImmutableLinkedSeq<E>((Node)this.list.sorted(), size);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> sorted(@NotNull Comparator<? super E> comparator) {
        int size = this.size;
        if (size == 0 || size == 1) {
            return this;
        }
        return new ImmutableLinkedSeq<E>((Node)this.list.sorted(comparator), size);
    }

    private Object writeReplace() {
        return this == EMPTY ? EmptyReplaced.INSTANCE : this;
    }

    @Debug.Renderer(hasChildren="isNotEmpty()", childrenArray="toArray()")
    public static final class Node<E>
    extends AbstractImmutableSeq<E>
    implements Serializable {
        private static final long serialVersionUID = 944030391350569673L;
        E head;
        Node<E> tail;

        Node() {
        }

        Node(E head) {
            this.head = head;
        }

        Node(E head, @NotNull Node<E> tail) {
            this.head = head;
            this.tail = tail;
        }

        Node<E> appendIterator(@NotNull Iterator<? extends E> it) {
            Node<E> node = this;
            while (it.hasNext()) {
                Node<E> nn = new Node<E>(it.next());
                node.tail = nn;
                node = nn;
            }
            return node;
        }

        @Override
        @NotNull
        public String className() {
            return "ImmutableLinkedSeq.Node";
        }

        @Override
        @NotNull
        public <U> CollectionFactory<U, ?, Node<U>> iterableFactory() {
            return ImmutableLinkedSeq.nodeFactory();
        }

        @NotNull
        public Iterator<E> iterator() {
            if (this == NIL_NODE) {
                return Iterators.empty();
            }
            if (this.tail == NIL_NODE) {
                return Iterators.of(this.head);
            }
            return new NodeItr(this);
        }

        @Override
        @NotNull
        public Iterator<E> iterator(int beginIndex) {
            if (beginIndex < 0) {
                throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"beginIndex(\u0001) < 0"}, (int)beginIndex)));
            }
            if (beginIndex == 0) {
                return this.iterator();
            }
            Node<E> node = this;
            for (int i = 0; i < beginIndex; ++i) {
                if (node == NIL_NODE) {
                    throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"beginIndex: \u0001"}, (int)beginIndex)));
                }
                node = node.tail;
            }
            return node.iterator();
        }

        @Override
        @NotNull
        public SeqView<E> view() {
            if (this == NIL_NODE) {
                return SeqView.empty();
            }
            if (this.tail == NIL_NODE) {
                return new SeqViews.Single<E>(this.head);
            }
            return new SeqViews.WithCachedSize(this);
        }

        public boolean isEmpty() {
            return this == NIL_NODE;
        }

        public int size() {
            Node<E> node = this;
            int c = 0;
            while (node != NIL_NODE) {
                ++c;
                node = node.tail;
            }
            return c;
        }

        public int knownSize() {
            if (this == NIL_NODE) {
                return 0;
            }
            if (this.tail == NIL_NODE) {
                return 1;
            }
            return -1;
        }

        public int sizeCompare(int otherSize) {
            if (otherSize < 0) {
                return 1;
            }
            int i = 0;
            Node<E> node = this;
            while (node != NIL_NODE) {
                if (i == otherSize) {
                    return 1;
                }
                node = node.tail;
                ++i;
            }
            return i - otherSize;
        }

        @Override
        @NotNull
        public Node<E> reversed() {
            if (this == NIL_NODE || this.tail == NIL_NODE) {
                return this;
            }
            Node<E> node = this;
            Node res = ImmutableLinkedSeq.nilNode();
            while (node != NIL_NODE) {
                res = new Node<E>(node.head, res);
                node = node.tail;
            }
            return res;
        }

        @Override
        @NotNull
        public Iterator<E> reverseIterator() {
            return ((Node)this.reversed()).iterator();
        }

        public E head() {
            if (this == NIL_NODE) {
                throw new NoSuchElementException("ImmutableList.Nil.head()");
            }
            return this.head;
        }

        @Nullable
        public E headOrNull() {
            return this.head;
        }

        @NotNull
        public Option<E> headOption() {
            return this == NIL_NODE ? Option.none() : Option.some(this.head);
        }

        @NotNull
        public Node<E> tail() {
            if (this == NIL_NODE) {
                throw new NoSuchElementException("ImmutableList.Nil.tail()");
            }
            return this.tail;
        }

        @Nullable
        public Node<E> tailOrNull() {
            return this.tail;
        }

        @NotNull
        public @NotNull Option<@NotNull Node<E>> tailOption() {
            return Option.of(this.tail);
        }

        @Override
        public E first() {
            return this.head();
        }

        @Override
        public E last() {
            if (this == NIL_NODE) {
                throw new NoSuchElementException();
            }
            Node<E> node = this;
            while (node.tail != NIL_NODE) {
                node = node.tail;
            }
            return node.head;
        }

        @Contract(value="_ -> new")
        @NotNull
        public Node<E> cons(E element) {
            return new Node<E>(element, this);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> prepended(E value) {
            return this.cons(value);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> prependedAll(E @NotNull [] values) {
            int prefixLength = values.length;
            Node<E> result = this;
            for (int i = prefixLength - 1; i >= 0; --i) {
                result = result.cons(values[i]);
            }
            return result;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> prependedAll(@NotNull Iterable<? extends E> values) {
            if (values instanceof RandomAccess) {
                if (values instanceof Seq) {
                    Seq seq = (Seq)((Object)values);
                    Node<Object> res = this;
                    for (int i = seq.size() - 1; i >= 0; --i) {
                        res = res.cons(seq.get(i));
                    }
                    return res;
                }
                if (values instanceof List) {
                    List list = (List)values;
                    Node<Object> res = this;
                    for (int i = list.size() - 1; i >= 0; --i) {
                        res = res.cons(list.get(i));
                    }
                    return res;
                }
            }
            if (values instanceof List) {
                List list = (List)values;
                int listSize = list.size();
                if (listSize == 0) {
                    return this;
                }
                Node<Object> res = this;
                ListIterator it = list.listIterator(listSize);
                while (it.hasPrevious()) {
                    res = res.cons(it.previous());
                }
                return res;
            }
            Iterator<E> it = values.iterator();
            if (!it.hasNext()) {
                return this;
            }
            Node<E> res = new Node<E>(it.next());
            res.appendIterator(it).tail = this;
            return res;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> appended(E value) {
            if (this == NIL_NODE) {
                return ImmutableLinkedSeq.nodeOf(value);
            }
            if (this.tail == NIL_NODE) {
                return ImmutableLinkedSeq.nodeOf(this.head, value);
            }
            return super.appended(value);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> appendedAll(E @NotNull [] values) {
            if (values.length == 0) {
                return this;
            }
            if (this == NIL_NODE) {
                return ImmutableLinkedSeq.nodeFrom(values);
            }
            return super.appendedAll((Object[])values);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> appendedAll(@NotNull Iterable<? extends E> values) {
            if (AnyTraversable.knownSize(values) == 0) {
                return this;
            }
            if (this == NIL_NODE) {
                return ImmutableLinkedSeq.nodeFrom(values);
            }
            if (values instanceof Node) {
                return ((Node)((Object)values)).prependedAll((Iterable)((Object)this));
            }
            return super.appendedAll(values);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> slice(int beginIndex, int endIndex) {
            int i;
            if (beginIndex < 0) {
                throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"beginIndex(\u0001) < 0"}, (int)beginIndex)));
            }
            if (endIndex < 0) {
                throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"endIndex(\u0001) < 0"}, (int)endIndex)));
            }
            if (beginIndex > endIndex) {
                throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"beginIndex(\u0001) > endIndex(\u0001)"}, (int)beginIndex, (int)endIndex)));
            }
            if (beginIndex == endIndex) {
                if (this.sizeLessThan(beginIndex)) {
                    throw new IndexOutOfBoundsException();
                }
                return ImmutableLinkedSeq.nilNode();
            }
            if (beginIndex == 0) {
                if (this == NIL_NODE) {
                    throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"endIndex(\u0001) > size(0)"}, (int)endIndex)));
                }
                return this.take(endIndex);
            }
            int ns = endIndex - beginIndex;
            Node<E> list = this;
            for (i = 0; list != NIL_NODE && i < beginIndex; ++i) {
                list = list.tail;
            }
            if (i != beginIndex) {
                throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"beginIndex = \u0001"}, (int)beginIndex)));
            }
            if (ns == 1) {
                return ImmutableLinkedSeq.nodeOf(list.head());
            }
            MutableSinglyLinkedList<E> buffer = new MutableSinglyLinkedList<E>();
            for (i = 0; list != NIL_NODE && i < ns; ++i) {
                buffer.append(list.head);
                list = list.tail;
            }
            if (i != ns) {
                throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"endIndex = \u0001"}, (int)endIndex)));
            }
            return buffer.buildNode();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0 || this == NIL_NODE) {
                return this;
            }
            Node<E> list = this;
            while (list != NIL_NODE && n-- > 0) {
                list = list.tail;
            }
            return list;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> dropWhile(@NotNull Predicate<? super E> predicate) {
            Node<E> list;
            for (list = this; list != NIL_NODE && predicate.test(list.head); list = list.tail()) {
            }
            return list;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0 || this == NIL_NODE) {
                return ImmutableLinkedSeq.nilNode();
            }
            return super.take(n);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> takeLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return ImmutableLinkedSeq.nilNode();
            }
            int size = this.size();
            if (n >= size) {
                return this;
            }
            return this.drop(size - n);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> takeWhile(@NotNull Predicate<? super E> predicate) {
            Node<E> res;
            Node<E> list = this;
            if (list == NIL_NODE || !predicate.test(list.head)) {
                return ImmutableLinkedSeq.nilNode();
            }
            Node<E> t = res = new Node<E>(list.head);
            list = list.tail;
            while (true) {
                if (list == NIL_NODE) {
                    return this;
                }
                if (!predicate.test(list.head)) break;
                Node<E> nl = new Node<E>(list.head);
                t.tail = nl;
                t = nl;
                list = list.tail;
            }
            t.tail = ImmutableLinkedSeq.nilNode();
            return res;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> updated(int index, E newValue) {
            Node<E> res;
            if (index < 0) {
                throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"index(\u0001) < 0"}, (int)index)));
            }
            Node<E> list = this;
            if (this == NIL_NODE) {
                throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"index(\u0001) >= size(0)"}, (int)index)));
            }
            if (index == 0) {
                return new Node<E>(newValue, list.tail);
            }
            Node<E> t = res = new Node<E>(list.head);
            list = list.tail;
            for (int i = 1; i < index; ++i) {
                if (list == NIL_NODE) {
                    throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Index: \u0001"}, (int)index)));
                }
                Node<E> nl = new Node<E>(list.head);
                t.tail = nl;
                t = nl;
                list = list.tail;
            }
            if (list == NIL_NODE) {
                throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Index: \u0001"}, (int)index)));
            }
            t.tail = new Node<E>(newValue, list.tail);
            return res;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> concat(@NotNull SeqLike<? extends E> other) {
            Node<E> nl;
            Node<E> res;
            if (this == NIL_NODE) {
                return ImmutableLinkedSeq.nodeFrom(other);
            }
            int oks = other.knownSize();
            Iterator it = null;
            if (oks == 0) {
                return this;
            }
            if (oks < 0 && !(it = other.iterator()).hasNext()) {
                return this;
            }
            Node<E> t = res = new Node<E>(this.head);
            Node<E> list = this.tail;
            while (list != NIL_NODE) {
                nl = new Node<E>(list.head);
                t.tail = nl;
                t = nl;
                list = list.tail;
            }
            if (other.supportsFastRandomAccess()) {
                for (int i = 0; i < other.size(); ++i) {
                    Node<E> nl2 = new Node<E>(other.get(i));
                    t.tail = nl2;
                    t = nl2;
                }
            } else {
                if (it == null) {
                    it = other.iterator();
                }
                while (it.hasNext()) {
                    nl = new Node(it.next());
                    t.tail = nl;
                    t = nl;
                }
            }
            t.tail = ImmutableLinkedSeq.nilNode();
            return res;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> concat(@NotNull List<? extends E> other) {
            Node<E> res;
            if (this == NIL_NODE) {
                return ImmutableLinkedSeq.nodeFrom(other);
            }
            int os = other.size();
            if (os == 0) {
                return this;
            }
            Node<E> t = res = new Node<E>(this.head);
            Node<E> list = this.tail;
            while (list != NIL_NODE) {
                Node<E> nl = new Node<E>(list.head);
                t.tail = nl;
                t = nl;
                list = list.tail;
            }
            if (other instanceof RandomAccess) {
                for (int i = 0; i < os; ++i) {
                    Node<E> nl = new Node<E>(other.get(i));
                    t.tail = nl;
                    t = nl;
                }
            } else {
                for (E e : other) {
                    Node<E> nl = new Node<E>(e);
                    t.tail = nl;
                    t = nl;
                }
            }
            t.tail = ImmutableLinkedSeq.nilNode();
            return res;
        }

        @Override
        @NotNull
        public <U> ImmutableSeq<U> mapMulti(@NotNull BiConsumer<? super E, ? super Consumer<? super U>> mapper) {
            MutableSinglyLinkedList builder = new MutableSinglyLinkedList();
            Consumer<Object> consumer = builder::append;
            Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                E e = iterator.next();
                mapper.accept(e, consumer);
            }
            return builder.buildNode();
        }

        @Override
        @NotNull
        public <U> ImmutableSeq<U> mapIndexedMulti(@NotNull IndexedBiConsumer<? super E, ? super Consumer<? super U>> mapper) {
            MutableSinglyLinkedList builder = new MutableSinglyLinkedList();
            Consumer<Object> consumer = builder::append;
            int idx = 0;
            Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                E e = iterator.next();
                mapper.accept(idx++, e, consumer);
            }
            return builder.buildNode();
        }

        @Override
        @NotNull
        public <U> ImmutableSeq<U> flatMap(@NotNull Function<? super E, ? extends Iterable<? extends U>> mapper) {
            if (this == NIL_NODE) {
                return ImmutableLinkedSeq.nilNode();
            }
            MutableSinglyLinkedList buffer = new MutableSinglyLinkedList();
            Node<E> list = this;
            while (list != NIL_NODE) {
                buffer.appendAll(mapper.apply(list.head));
                list = list.tail;
            }
            return buffer.buildNode();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> sorted() {
            if (this == NIL_NODE || this.tail == NIL_NODE) {
                return this;
            }
            Object[] arr = this.toArray();
            Arrays.sort(arr);
            return ImmutableLinkedSeq.nodeFrom(arr);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> sorted(@NotNull Comparator<? super E> comparator) {
            if (this == NIL_NODE || this.tail == NIL_NODE) {
                return this;
            }
            Object[] arr = this.toArray();
            Arrays.sort(arr, comparator);
            return ImmutableLinkedSeq.nodeFrom(arr);
        }

        @Override
        @NotNull
        public ImmutableLinkedSeq<E> toImmutableLinkedSeq() {
            return ImmutableLinkedSeq.from(this);
        }

        public void forEach(@NotNull Consumer<? super E> action) {
            Node<E> list = this;
            while (list != NIL_NODE) {
                action.accept(list.head);
                list = list.tail;
            }
        }

        @Override
        public void forEachIndexed(@NotNull IndexedConsumer<? super E> action) {
            Node<E> list = this;
            int i = 0;
            while (list != NIL_NODE) {
                action.accept(i++, list.head);
                list = list.tail;
            }
        }

        private Object writeReplace() {
            return this == NIL_NODE ? NilNodeReplaced.INSTANCE : this;
        }
    }

    static final class Factory<E>
    implements CollectionFactory<E, MutableSinglyLinkedList<E>, ImmutableLinkedSeq<E>> {
        Factory() {
        }

        public MutableSinglyLinkedList<E> newBuilder() {
            return new MutableSinglyLinkedList();
        }

        public ImmutableLinkedSeq<E> build(MutableSinglyLinkedList<E> builder) {
            return builder.toImmutableLinkedSeq();
        }

        public void addToBuilder(@NotNull MutableSinglyLinkedList<E> builder, E value) {
            builder.append(value);
        }

        public MutableSinglyLinkedList<E> mergeBuilder(@NotNull MutableSinglyLinkedList<E> builder1, @NotNull MutableSinglyLinkedList<E> builder2) {
            return (MutableSinglyLinkedList)Builder.merge(builder1, builder2);
        }
    }

    public static final class NodeFactory<E>
    implements CollectionFactory<E, MutableSinglyLinkedList<E>, Node<E>> {
        NodeFactory() {
        }

        public Node<E> empty() {
            return ImmutableLinkedSeq.emptyNode();
        }

        public Node<E> from(E @NotNull [] values) {
            return ImmutableLinkedSeq.nodeFrom(values);
        }

        public Node<E> from(@NotNull Iterable<? extends E> values) {
            return ImmutableLinkedSeq.nodeFrom(values);
        }

        public Node<E> from(@NotNull Iterator<? extends E> it) {
            return ImmutableLinkedSeq.nodeFrom(it);
        }

        public Node<E> fill(int n, E value) {
            return ImmutableLinkedSeq.nodeFill(n, value);
        }

        public Node<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
            return ImmutableLinkedSeq.nodeFill(n, supplier);
        }

        public Node<E> fill(int n, @NotNull IntFunction<? extends E> init) {
            return ImmutableLinkedSeq.nodeFill(n, init);
        }

        public MutableSinglyLinkedList<E> newBuilder() {
            return new MutableSinglyLinkedList();
        }

        public void addToBuilder(@NotNull MutableSinglyLinkedList<E> builder, E value) {
            builder.append(value);
        }

        public MutableSinglyLinkedList<E> mergeBuilder(@NotNull MutableSinglyLinkedList<E> builder1, @NotNull MutableSinglyLinkedList<E> builder2) {
            return (MutableSinglyLinkedList)Builder.merge(builder1, builder2);
        }

        public Node<E> build(@NotNull MutableSinglyLinkedList<E> builder) {
            return builder.buildNode();
        }
    }

    @ApiStatus.Internal
    public static abstract class Builder<E>
    extends AbstractMutableList<E> {
        Node<E> first = null;
        Node<E> last = null;
        int len = 0;
        private boolean aliased = false;

        static <E> Builder<E> merge(@NotNull Builder<E> b1, @NotNull Builder<E> b2) {
            int b1s = b1.len;
            if (b1s == 0) {
                return b2;
            }
            if (b1s == 1) {
                b2.prepend(b1.first.head);
                return b2;
            }
            int b2s = b2.len;
            if (b2s == 0) {
                return b1;
            }
            if (b2s == 1) {
                b1.append(b2.first.head);
                return b1;
            }
            super.ensureUnaliased();
            super.ensureUnaliased();
            Node<E> b2f = b2.first;
            Node<E> b2l = b2.last;
            b2.clear();
            b1.last.tail = b2f;
            b1.last = b2l;
            b1.len = b1s + b2s;
            return b1;
        }

        private void ensureUnaliased() {
            if (this.aliased) {
                MutableSinglyLinkedList buffer = new MutableSinglyLinkedList();
                buffer.appendAll((Iterable)((Object)this));
                this.first = buffer.first;
                this.last = buffer.last;
                this.aliased = false;
            }
        }

        @NotNull
        public final Iterator<E> iterator() {
            Node<E> first = this.first;
            return first == null ? Iterators.empty() : first.iterator();
        }

        @Override
        @NotNull
        public Iterator<E> iterator(int beginIndex) {
            Conditions.checkPositionIndex((int)beginIndex, (int)this.len);
            if (beginIndex == this.len) {
                return Iterators.empty();
            }
            Node<E> node = this.first;
            for (int i = 0; i < beginIndex; ++i) {
                node = node.tail;
            }
            return node.iterator();
        }

        public final int size() {
            return this.len;
        }

        public final int knownSize() {
            return this.len;
        }

        @Override
        public final E get(int index) {
            if (index < 0 || index >= this.len) {
                throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Index out of range: \u0001"}, (int)index)));
            }
            if (index == this.len - 1) {
                return this.last.head;
            }
            return (E)this.first.get(index);
        }

        @Override
        public final void swap(int index1, int index2) {
            int i;
            Conditions.checkElementIndex((int)index1, (int)this.len);
            Conditions.checkElementIndex((int)index2, (int)this.len);
            if (index1 == index2) {
                return;
            }
            this.ensureUnaliased();
            int i1 = Integer.min(index1, index2);
            int i2 = Integer.max(index1, index2);
            Node<E> node = this.first;
            for (i = 0; i < i1; ++i) {
                node = node.tail;
            }
            Node<E> node1 = node;
            while (i < i2) {
                node = node.tail;
                ++i;
            }
            Node<E> node2 = node;
            Object tmp = node1.head;
            node1.head = node2.head;
            node2.head = tmp;
        }

        @Override
        @NotNull
        public final Option<E> getOption(int index) {
            if (index < 0 || index >= this.len) {
                return Option.none();
            }
            if (index == this.len - 1) {
                return Option.some(this.last.head);
            }
            return Option.some((Object)this.first.get(index));
        }

        @Override
        public final E first() {
            if (this.first == null) {
                throw new NoSuchElementException();
            }
            return this.first.head;
        }

        @Override
        public final E last() {
            if (this.last == null) {
                throw new NoSuchElementException();
            }
            return this.last.head;
        }

        public final boolean isEmpty() {
            return this.len == 0;
        }

        @Override
        public final void prepend(E value) {
            if (this.len == 0) {
                this.last = ImmutableLinkedSeq.nodeOf(value);
                this.first = this.last;
            } else {
                this.first = this.first.cons(value);
            }
            ++this.len;
        }

        @Override
        public final void append(E value) {
            Node<E> i = ImmutableLinkedSeq.nodeOf(value);
            if (this.len == 0) {
                this.first = i;
            } else {
                this.ensureUnaliased();
                this.last.tail = i;
            }
            this.last = i;
            ++this.len;
        }

        @Override
        public void insert(int index, E value) {
            if (index < 0 || index > this.len) {
                throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Index out of range: \u0001"}, (int)index)));
            }
            if (index == 0) {
                this.prepend(value);
                return;
            }
            if (index == this.len) {
                this.append(value);
                return;
            }
            this.ensureUnaliased();
            Node<E> i = this.first;
            int c = 1;
            while (c++ != index) {
                i = i.tail;
            }
            i.tail = i.tail.cons(value);
            ++this.len;
        }

        @Override
        public final E removeAt(int index) {
            if (index < 0 || index >= this.len) {
                throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Index out of range: \u0001"}, (int)index)));
            }
            if (index == 0) {
                Object v = this.first.head;
                if (this.len == 1) {
                    this.last = null;
                    this.first = null;
                    this.aliased = false;
                } else {
                    this.first = this.first.tail;
                }
                --this.len;
                return v;
            }
            this.ensureUnaliased();
            Node<E> i = this.first;
            int c = 1;
            while (c++ != index) {
                i = i.tail();
            }
            E v = i.tail().head();
            i.tail = i.tail().tail();
            --this.len;
            return v;
        }

        @Override
        public final E removeFirst() {
            if (this.isEmpty()) {
                throw new NoSuchElementException("Seq is empty");
            }
            Object v = this.first.head;
            if (this.len == 1) {
                this.last = null;
                this.first = null;
                this.aliased = false;
            } else {
                this.first = this.first.tail;
            }
            --this.len;
            return v;
        }

        @Override
        public final void clear() {
            this.last = null;
            this.first = null;
            this.len = 0;
            this.aliased = false;
        }

        @Override
        @NotNull
        public final ImmutableLinkedSeq<E> toImmutableLinkedSeq() {
            Node<E> first = this.first;
            if (first == null || first == NIL_NODE) {
                return ImmutableLinkedSeq.empty();
            }
            this.aliased = true;
            return new ImmutableLinkedSeq<E>(first, this.len);
        }

        @NotNull
        public final Node<E> buildNode() {
            Node<E> first = this.first;
            if (first == null || first == NIL_NODE) {
                return ImmutableLinkedSeq.nilNode();
            }
            this.aliased = true;
            return first;
        }

        @Override
        public final void set(int index, E newValue) {
            Conditions.checkElementIndex((int)index, (int)this.len);
            this.ensureUnaliased();
            if (index == this.len - 1) {
                this.last.head = newValue;
                return;
            }
            Node<E> l = this.first;
            while (--index >= 0) {
                l = l.tail;
            }
            l.head = newValue;
        }

        @Override
        public final void sort(Comparator<? super E> comparator) {
            if (this.len == 0) {
                return;
            }
            Object[] values = this.toArray();
            Arrays.sort(values, comparator);
            if (this.aliased) {
                Node<Object> newLast;
                Node<Object> newFirst = newLast = new Node<Object>(values[values.length - 1], ImmutableLinkedSeq.nilNode());
                for (int i = values.length - 2; i >= 0; --i) {
                    newFirst = new Node<Object>(values[i], newFirst);
                }
                this.first = newFirst;
                this.last = newLast;
                this.aliased = false;
            } else {
                Node<E> c = this.first;
                for (Object value : values) {
                    c.head = value;
                    c = c.tail;
                }
            }
        }

        @Override
        public final void replaceAll(@NotNull Function<? super E, ? extends E> operator) {
            Node<E> n = this.first;
            if (n == null || n == NIL_NODE) {
                return;
            }
            this.ensureUnaliased();
            while (n != NIL_NODE) {
                Node<E> c = n;
                c.head = operator.apply(c.head);
                n = c.tail;
            }
        }

        @Override
        public final void replaceAllIndexed(@NotNull IndexedFunction<? super E, ? extends E> operator) {
            Node<E> node = this.first;
            if (node == null || node == NIL_NODE) {
                return;
            }
            this.ensureUnaliased();
            int i = 0;
            while (node != NIL_NODE) {
                node.head = operator.apply(i++, node.head);
                node = node.tail;
            }
        }

        @Override
        public final boolean retainAll(@NotNull Predicate<? super E> predicate) {
            Node<E> prev = null;
            Node<E> cur = this.first;
            if (cur == null) {
                return false;
            }
            this.ensureUnaliased();
            int oldLen = this.len;
            while (cur != NIL_NODE) {
                Node follow = cur.tail;
                if (!predicate.test(cur.head)) {
                    if (prev == null) {
                        this.first = follow;
                    } else {
                        prev.tail = follow;
                    }
                    --this.len;
                } else {
                    prev = cur;
                }
                cur = follow;
            }
            this.last = prev;
            return this.len != oldLen;
        }

        @Override
        public final void reverse() {
            if (this.len <= 1) {
                return;
            }
            MutableSinglyLinkedList<E> newBuilder = new MutableSinglyLinkedList<E>();
            Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                E e = iterator.next();
                newBuilder.prepend(e);
            }
            this.first = newBuilder.first;
            this.last = newBuilder.last;
            this.aliased = false;
        }
    }

    static final class EmptyReplaced
    implements Serializable {
        private static final long serialVersionUID = 0L;
        static final EmptyReplaced INSTANCE = new EmptyReplaced();

        private EmptyReplaced() {
        }

        private Object readResolve() {
            return EMPTY;
        }
    }

    static final class NodeItr<E>
    extends AbstractIterator<E> {
        @NotNull
        private Node<? extends E> list;

        NodeItr(@NotNull Node<? extends E> list) {
            this.list = list;
        }

        public boolean hasNext() {
            return this.list != NIL_NODE;
        }

        public E next() {
            if (this.list == NIL_NODE) {
                throw new NoSuchElementException("ImmutableListIterator.next()");
            }
            E v = this.list.head();
            this.list = this.list.tail();
            return v;
        }
    }

    static final class NilNodeReplaced
    implements Serializable {
        private static final long serialVersionUID = 0L;
        static final NilNodeReplaced INSTANCE = new NilNodeReplaced();

        private NilNodeReplaced() {
        }

        private Object readResolve() {
            return NIL_NODE;
        }
    }

    public static final class Unsafe {
        private Unsafe() {
        }

        @NotNull
        public static <E> ImmutableLinkedSeq<E> build(@NotNull Node<? extends E> node, int size) {
            Objects.requireNonNull(node);
            assert (size >= 0);
            return size == 0 ? ImmutableLinkedSeq.empty() : new ImmutableLinkedSeq<E>(node, size);
        }
    }
}

