/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.base.Traversable;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.AbstractImmutableCollection;
import kala.collection.immutable.AbstractImmutableSeq;
import kala.collection.immutable.ImmutableCollection;
import kala.collection.immutable.ImmutableSeqs;
import kala.collection.immutable.ImmutableVector;
import kala.collection.immutable.ImmutableVectors;
import kala.comparator.Comparators;
import kala.function.IndexedBiConsumer;
import kala.function.IndexedFunction;
import kala.function.Predicates;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface ImmutableSeq<E>
extends ImmutableCollection<E>,
Seq<E> {
    @Contract(value="_ -> param1", pure=true)
    public static <E> ImmutableSeq<E> narrow(ImmutableSeq<? extends E> seq) {
        return seq;
    }

    @NotNull
    public static <E> CollectionFactory<E, ?, ImmutableSeq<E>> factory() {
        return ImmutableSeqs.FACTORY;
    }

    @NotNull
    public static <E> ImmutableSeq<E> empty() {
        return ImmutableSeqs.Seq0.INSTANCE;
    }

    @NotNull
    public static <E> ImmutableSeq<E> of() {
        return ImmutableSeq.empty();
    }

    @NotNull
    public static <E> ImmutableSeq<E> of(E value1) {
        return new ImmutableSeqs.Seq1<E>(value1);
    }

    @NotNull
    public static <E> ImmutableSeq<E> of(E value1, E value2) {
        return new ImmutableSeqs.Seq2<E>(value1, value2);
    }

    @NotNull
    public static <E> ImmutableSeq<E> of(E value1, E value2, E value3) {
        return new ImmutableSeqs.Seq3<E>(value1, value2, value3);
    }

    @NotNull
    public static <E> ImmutableSeq<E> of(E value1, E value2, E value3, E value4) {
        return new ImmutableSeqs.Seq4<E>(value1, value2, value3, value4);
    }

    @NotNull
    public static <E> ImmutableSeq<E> of(E value1, E value2, E value3, E value4, E value5) {
        return new ImmutableSeqs.Seq5<E>(value1, value2, value3, value4, value5);
    }

    @SafeVarargs
    @NotNull
    public static <E> ImmutableSeq<E> of(E ... values) {
        return ImmutableSeq.from(values);
    }

    @NotNull
    public static <E> ImmutableSeq<E> from(E @NotNull [] values) {
        switch (values.length) {
            case 0: {
                return ImmutableSeq.empty();
            }
            case 1: {
                return ImmutableSeq.of(values[0]);
            }
            case 2: {
                return ImmutableSeq.of(values[0], values[1]);
            }
            case 3: {
                return ImmutableSeq.of(values[0], values[1], values[2]);
            }
            case 4: {
                return ImmutableSeq.of(values[0], values[1], values[2], values[3]);
            }
            case 5: {
                return ImmutableSeq.of(values[0], values[1], values[2], values[3], values[4]);
            }
        }
        return ImmutableVector.from(values);
    }

    @NotNull
    public static <E> ImmutableSeq<E> from(@NotNull Collection<? extends E> values) {
        int size = values.size();
        if (size == 0) {
            return ImmutableSeq.empty();
        }
        if (size <= 32) {
            Object[] arr = values.toArray();
            int length = arr.length;
            if (!1.$assertionsDisabled && length != size) {
                throw new AssertionError();
            }
            switch (length) {
                case 1: {
                    return ImmutableSeq.of(arr[0]);
                }
                case 2: {
                    return ImmutableSeq.of(arr[0], arr[1]);
                }
                case 3: {
                    return ImmutableSeq.of(arr[0], arr[1], arr[2]);
                }
                case 4: {
                    return ImmutableSeq.of(arr[0], arr[1], arr[2], arr[3]);
                }
                case 5: {
                    return ImmutableSeq.of(arr[0], arr[1], arr[2], arr[3], arr[4]);
                }
            }
            return new ImmutableVectors.Vector1(arr);
        }
        return ImmutableVector.from(values.iterator());
    }

    @NotNull
    public static <E> ImmutableSeq<E> from(@NotNull Traversable<? extends E> values) {
        if (values instanceof ImmutableSeq) {
            return (ImmutableSeq)values;
        }
        int knownSize = values.knownSize();
        if (knownSize == 0) {
            return ImmutableSeq.empty();
        }
        if (knownSize > 0 && knownSize <= 32) {
            Object[] arr = new Object[knownSize];
            int cn = values.copyToArray(arr);
            if (!1.$assertionsDisabled && cn != knownSize) {
                throw new AssertionError();
            }
            switch (knownSize) {
                case 1: {
                    return ImmutableSeq.of(arr[0]);
                }
                case 2: {
                    return ImmutableSeq.of(arr[0], arr[1]);
                }
                case 3: {
                    return ImmutableSeq.of(arr[0], arr[1], arr[2]);
                }
                case 4: {
                    return ImmutableSeq.of(arr[0], arr[1], arr[2], arr[3]);
                }
                case 5: {
                    return ImmutableSeq.of(arr[0], arr[1], arr[2], arr[3], arr[4]);
                }
            }
            return new ImmutableVectors.Vector1(arr);
        }
        return ImmutableSeq.from(values.iterator());
    }

    @NotNull
    public static <E> ImmutableSeq<E> from(@NotNull Iterable<? extends E> values) {
        if (values instanceof Traversable) {
            return ImmutableSeq.from((Traversable)values);
        }
        if (values instanceof Collection) {
            return ImmutableSeq.from((Collection)values);
        }
        return ImmutableSeq.from(values.iterator());
    }

    @NotNull
    public static <E> ImmutableSeq<E> from(@NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            return ImmutableSeq.empty();
        }
        ImmutableVectors.VectorBuilder<E> builder = new ImmutableVectors.VectorBuilder<E>();
        while (it.hasNext()) {
            builder.add(it.next());
        }
        return builder.buildSeq();
    }

    @NotNull
    public static <E> ImmutableSeq<E> from(@NotNull Stream<? extends E> stream) {
        return stream.collect(ImmutableSeq.factory());
    }

    @NotNull
    public static <E> ImmutableSeq<E> fill(int n, E value) {
        if (n <= 0) {
            return ImmutableSeq.empty();
        }
        if (n == 1) {
            return new ImmutableSeqs.Seq1<E>(value);
        }
        return new ImmutableSeqs.CopiesSeq<E>(n, value);
    }

    @NotNull
    public static <E> ImmutableSeq<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
        if (n <= 0) {
            return ImmutableSeq.empty();
        }
        switch (n) {
            case 1: {
                return ImmutableSeq.of(supplier.get());
            }
            case 2: {
                return ImmutableSeq.of(supplier.get(), supplier.get());
            }
            case 3: {
                return ImmutableSeq.of(supplier.get(), supplier.get(), supplier.get());
            }
            case 4: {
                return ImmutableSeq.of(supplier.get(), supplier.get(), supplier.get(), supplier.get());
            }
            case 5: {
                return ImmutableSeq.of(supplier.get(), supplier.get(), supplier.get(), supplier.get(), supplier.get());
            }
        }
        return ImmutableVector.fill(n, supplier);
    }

    @NotNull
    public static <E> ImmutableSeq<E> fill(int n, @NotNull IntFunction<? extends E> init) {
        if (n <= 0) {
            return ImmutableSeq.empty();
        }
        switch (n) {
            case 1: {
                return ImmutableSeq.of(init.apply(0));
            }
            case 2: {
                return ImmutableSeq.of(init.apply(0), init.apply(1));
            }
            case 3: {
                return ImmutableSeq.of(init.apply(0), init.apply(1), init.apply(2));
            }
            case 4: {
                return ImmutableSeq.of(init.apply(0), init.apply(1), init.apply(2), init.apply(3));
            }
            case 5: {
                return ImmutableSeq.of(init.apply(0), init.apply(1), init.apply(2), init.apply(3), init.apply(4));
            }
        }
        return ImmutableVector.fill(n, init);
    }

    @Override
    @NotNull
    default public String className() {
        return "ImmutableSeq";
    }

    @Override
    @NotNull
    default public <U> CollectionFactory<U, ?, ? extends ImmutableSeq<U>> iterableFactory() {
        return ImmutableSeq.factory();
    }

    @Override
    @NotNull
    default public @Unmodifiable List<E> asJava() {
        return Seq.super.asJava();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> slice(int beginIndex, int endIndex) {
        return AbstractImmutableSeq.slice(this, beginIndex, endIndex, this.iterableFactory());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> drop(int n) {
        return AbstractImmutableSeq.drop(this, n, this.iterableFactory());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> dropLast(int n) {
        return AbstractImmutableSeq.dropLast(this, n, this.iterableFactory());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> dropWhile(@NotNull Predicate<? super E> predicate) {
        return AbstractImmutableSeq.dropWhile(this, predicate, this.iterableFactory());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> take(int n) {
        return AbstractImmutableSeq.take(this, n, this.iterableFactory());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> takeLast(int n) {
        return AbstractImmutableSeq.takeLast(this, n, this.iterableFactory());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> takeWhile(@NotNull Predicate<? super E> predicate) {
        return AbstractImmutableSeq.takeWhile(this, predicate, this.iterableFactory());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> updated(int index, E newValue) {
        return AbstractImmutableSeq.updated(this, index, newValue, this.iterableFactory());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> concat(@NotNull SeqLike<? extends E> other) {
        return AbstractImmutableSeq.concat(this, other, this.iterableFactory());
    }

    @Override
    @NotNull
    default public ImmutableSeq<E> concat(@NotNull List<? extends E> other) {
        return AbstractImmutableSeq.concat(this, other, this.iterableFactory());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> prepended(E value) {
        return AbstractImmutableSeq.prepended(this, value, this.iterableFactory());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> prependedAll(E @NotNull [] values) {
        return AbstractImmutableSeq.prependedAll(this, values, this.iterableFactory());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> prependedAll(@NotNull Iterable<? extends E> values) {
        return AbstractImmutableSeq.prependedAll(this, values, this.iterableFactory());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> appended(E value) {
        return AbstractImmutableSeq.appended(this, value, this.iterableFactory());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> appendedAll(@NotNull Iterable<? extends E> values) {
        return AbstractImmutableSeq.appendedAll(this, values, this.iterableFactory());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> appendedAll(E @NotNull [] values) {
        return AbstractImmutableSeq.appendedAll(this, values, this.iterableFactory());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> sorted() {
        return this.sorted(Comparators.naturalOrder());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> sorted(Comparator<? super E> comparator) {
        return AbstractImmutableSeq.sorted(this, comparator, this.iterableFactory());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> reversed() {
        return AbstractImmutableSeq.reversed(this, this.iterableFactory());
    }

    @Override
    @NotNull
    default public ImmutableSeq<E> filter(@NotNull Predicate<? super E> predicate) {
        return AbstractImmutableCollection.filter(this, predicate, this.iterableFactory());
    }

    @Override
    @NotNull
    default public ImmutableSeq<E> filterNot(@NotNull Predicate<? super E> predicate) {
        return AbstractImmutableCollection.filterNot(this, predicate, this.iterableFactory());
    }

    @Override
    @NotNull
    default public @NotNull ImmutableSeq<@NotNull E> filterNotNull() {
        return this.filter(Predicates.isNotNull());
    }

    @Override
    @NotNull
    default public <U> @NotNull ImmutableSeq<@NotNull U> filterIsInstance(@NotNull Class<? extends U> clazz) {
        return this.filter(Predicates.instanceOf(clazz));
    }

    @Override
    @NotNull
    default public <U> ImmutableSeq<U> map(@NotNull Function<? super E, ? extends U> mapper) {
        return AbstractImmutableCollection.map(this, mapper, this.iterableFactory());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U> ImmutableSeq<U> mapIndexed(@NotNull IndexedFunction<? super E, ? extends U> mapper) {
        return AbstractImmutableSeq.mapIndexed(this, mapper, this.iterableFactory());
    }

    @Override
    @NotNull
    default public <U> @NotNull ImmutableSeq<@NotNull U> mapNotNull(@NotNull Function<? super E, ? extends @Nullable U> mapper) {
        return AbstractImmutableCollection.mapNotNull(this, mapper, this.iterableFactory());
    }

    @Override
    @NotNull
    default public <U> @NotNull ImmutableSeq<@NotNull U> mapIndexedNotNull(@NotNull IndexedFunction<? super E, ? extends @Nullable U> mapper) {
        return AbstractImmutableSeq.mapIndexedNotNull(this, mapper, this.iterableFactory());
    }

    @Override
    @NotNull
    default public <U> ImmutableSeq<U> mapMulti(@NotNull BiConsumer<? super E, ? super Consumer<? super U>> mapper) {
        return AbstractImmutableCollection.mapMulti(this, mapper, this.iterableFactory());
    }

    @Override
    @NotNull
    default public <U> ImmutableSeq<U> mapIndexedMulti(@NotNull IndexedBiConsumer<? super E, ? super Consumer<? super U>> mapper) {
        return AbstractImmutableSeq.mapIndexedMulti(this, mapper, this.iterableFactory());
    }

    @Override
    @NotNull
    default public <U> ImmutableSeq<U> flatMap(@NotNull Function<? super E, ? extends Iterable<? extends U>> mapper) {
        return AbstractImmutableCollection.flatMap(this, mapper, this.iterableFactory());
    }

    @Override
    @NotNull
    default public <U> @NotNull ImmutableSeq<@NotNull Tuple2<E, U>> zip(@NotNull Iterable<? extends U> other) {
        return AbstractImmutableCollection.zip(this, other, this.iterableFactory());
    }

    @Override
    @NotNull
    default public ImmutableSeq<E> toImmutableSeq() {
        return this;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

