/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable;

import java.io.Serializable;
import java.lang.invoke.StringConcatFactory;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import kala.Conditions;
import kala.collection.IndexedSeqLike;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.base.Iterators;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.AbstractImmutableIndexedSeq;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.immutable.ImmutableVectors;
import kala.collection.internal.view.SeqViews;
import kala.control.Option;
import kala.function.IndexedConsumer;
import kala.function.IndexedFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

final class ImmutableSeqs {
    static final Factory<?> FACTORY = new Factory();

    private ImmutableSeqs() {
    }

    static final class Factory<E>
    implements CollectionFactory<E, ImmutableVectors.VectorBuilder<E>, ImmutableSeq<E>> {
        Factory() {
        }

        public ImmutableSeq<E> empty() {
            return ImmutableSeq.empty();
        }

        public ImmutableVectors.VectorBuilder<E> newBuilder() {
            return new ImmutableVectors.VectorBuilder();
        }

        public void addToBuilder( @NotNull ImmutableVectors.VectorBuilder<E> builder, E value) {
            builder.add(value);
        }

        public ImmutableVectors.VectorBuilder<E> mergeBuilder( @NotNull ImmutableVectors.VectorBuilder<E> builder1,  @NotNull ImmutableVectors.VectorBuilder<E> builder2) {
            builder1.addVector(builder2.build());
            return builder1;
        }

        public ImmutableSeq<E> build( @NotNull ImmutableVectors.VectorBuilder<E> builder) {
            return builder.buildSeq();
        }

        public ImmutableSeq<E> from(E @NotNull [] values) {
            return ImmutableSeq.from(values);
        }

        public ImmutableSeq<E> from(@NotNull Iterable<? extends E> values) {
            return ImmutableSeq.from(values);
        }

        public ImmutableSeq<E> from(@NotNull Iterator<? extends E> it) {
            return ImmutableSeq.from(it);
        }

        public ImmutableSeq<E> fill(int n, E value) {
            return ImmutableSeq.fill(n, value);
        }

        public ImmutableSeq<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
            return ImmutableSeq.fill(n, supplier);
        }

        public ImmutableSeq<E> fill(int n, @NotNull IntFunction<? extends E> init) {
            return ImmutableSeq.fill(n, init);
        }
    }

    static final class CopiesSeq<E>
    extends CopiesSeqBase<E>
    implements ImmutableSeq<E>,
    Serializable {
        private static final long serialVersionUID = 6615175156982747837L;

        CopiesSeq(@Range(from=1L, to=0x7FFFFFFFL) int size, E value) {
            super(size, value);
        }

        @NotNull
        public static <E> ImmutableSeq<E> fill(int n, E value) {
            if (n <= 0) {
                return ImmutableSeq.empty();
            }
            return new CopiesSeq<E>(n, value);
        }

        @Override
        @NotNull
        public SeqView<E> view() {
            return this.size == 1 ? new SeqViews.Single<Object>(this.value) : new CopiesSeqView<Object>(this.size, this.value);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> reversed() {
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> prepended(E value) {
            int size = this.size;
            if (value == this.value) {
                return new CopiesSeq<E>(size + 1, value);
            }
            Object oldValue = this.value;
            if (size < 32) {
                Object[] arr = new Object[size + 1];
                Arrays.fill(arr, oldValue);
                arr[0] = value;
                return new ImmutableVectors.Vector1(arr);
            }
            ImmutableVectors.VectorBuilder<Object> builder = new ImmutableVectors.VectorBuilder<Object>();
            builder.add(value);
            for (int i = 0; i < size; ++i) {
                builder.add(oldValue);
            }
            return builder.build();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> appended(E value) {
            int size = this.size;
            if (value == this.value) {
                assert (size != Integer.MAX_VALUE);
                return new CopiesSeq<E>(size + 1, value);
            }
            Object oldValue = this.value;
            if (size < 32) {
                Object[] arr = new Object[size + 1];
                Arrays.fill(arr, oldValue);
                arr[size] = value;
                return new ImmutableVectors.Vector1(arr);
            }
            ImmutableVectors.VectorBuilder<Object> builder = new ImmutableVectors.VectorBuilder<Object>();
            for (int i = 0; i < size; ++i) {
                builder.add(oldValue);
            }
            builder.add(value);
            return builder.build();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> slice(int beginIndex, int endIndex) {
            Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size);
            int ns = endIndex - beginIndex;
            return ns == 0 ? ImmutableSeq.empty() : new CopiesSeq<Object>(ns, this.value);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            if (n >= this.size) {
                return ImmutableSeq.empty();
            }
            return new CopiesSeq<Object>(this.size - n, this.value);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> dropLast(int n) {
            return this.drop(n);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> dropWhile(@NotNull Predicate<? super E> predicate) {
            int size = this.size;
            Object value = this.value;
            for (int i = 0; i < size; ++i) {
                if (predicate.test(value)) continue;
                return this.drop(i);
            }
            return ImmutableSeq.empty();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return ImmutableSeq.empty();
            }
            if (n >= this.size) {
                return this;
            }
            return new CopiesSeq<Object>(n, this.value);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> takeLast(int n) {
            return this.take(n);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> takeWhile(@NotNull Predicate<? super E> predicate) {
            int size = this.size;
            Object value = this.value;
            for (int i = 0; i < size; ++i) {
                if (predicate.test(value)) continue;
                return this.take(i);
            }
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> concat(@NotNull SeqLike<? extends E> other) {
            if (other instanceof CopiesSeq) {
                CopiesSeq ics = (CopiesSeq)other;
                if (ics.value == this.value) {
                    return new CopiesSeq<Object>(this.size + ics.size, this.value);
                }
            }
            Objects.requireNonNull(other);
            ImmutableVectors.VectorBuilder<Object> builder = new ImmutableVectors.VectorBuilder<Object>();
            for (int i = 0; i < this.size; ++i) {
                builder.add(this.value);
            }
            builder.addAll(other);
            return builder.build();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> filter(@NotNull Predicate<? super E> predicate) {
            int size = this.size;
            Object value = this.value;
            int c = 0;
            for (int i = 0; i < size; ++i) {
                if (!predicate.test(value)) continue;
                ++c;
            }
            if (c == 0) {
                return ImmutableSeq.empty();
            }
            if (c == 1) {
                return ImmutableSeq.of(value);
            }
            if (c == size) {
                return this;
            }
            return new CopiesSeq<Object>(c, value);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> filterNot(@NotNull Predicate<? super E> predicate) {
            int size = this.size;
            Object value = this.value;
            int c = 0;
            for (int i = 0; i < size; ++i) {
                if (predicate.test(value)) continue;
                ++c;
            }
            if (c == 0) {
                return ImmutableSeq.empty();
            }
            if (c == 1) {
                return ImmutableSeq.of(value);
            }
            if (c == size) {
                return this;
            }
            return new CopiesSeq<Object>(c, value);
        }

        @Override
        @NotNull
        public @NotNull ImmutableSeq<@NotNull E> filterNotNull() {
            return this.value == null ? ImmutableSeq.empty() : this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> sorted() {
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> sorted(Comparator<? super E> comparator) {
            return this;
        }

        public int hashCode() {
            if (this.value == null) {
                return -1140647423;
            }
            int vh = this.value.hashCode();
            if (vh == 0) {
                return -1140647423;
            }
            int h = 0;
            for (int i = 0; i < this.size; ++i) {
                h = h * 31 + vh;
            }
            return h + -1140647423;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Seq)) {
                return false;
            }
            return Seq.equals(this, (Seq)obj);
        }
    }

    static final class CopiesSeqView<E>
    extends CopiesSeqBase<E>
    implements SeqView<E> {
        public CopiesSeqView(@Range(from=1L, to=0x7FFFFFFFL) int size, E value) {
            super(size, value);
        }

        @Override
        @NotNull
        public String className() {
            return "CopiesSeqView";
        }

        @Override
        @NotNull
        public SeqView<E> prepended(E value) {
            if (value == this.value) {
                return new CopiesSeqView<E>(this.size + 1, value);
            }
            return SeqView.super.prepended((Object)value);
        }

        @Override
        @NotNull
        public SeqView<E> appended(E value) {
            if (value == this.value) {
                return new CopiesSeqView<E>(this.size + 1, value);
            }
            return SeqView.super.appended((Object)value);
        }

        @Override
        @NotNull
        public SeqView<E> reversed() {
            return this;
        }

        @Override
        @NotNull
        public SeqView<E> slice(int beginIndex, int endIndex) {
            Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size);
            int ns = endIndex - beginIndex;
            if (ns == 0) {
                return SeqView.empty();
            }
            if (ns == 1) {
                return new SeqViews.Single<Object>(this.value);
            }
            return new CopiesSeqView<Object>(ns, this.value);
        }

        @Override
        @NotNull
        public SeqView<E> drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            if (n >= this.size) {
                return SeqView.empty();
            }
            int ns = this.size - n;
            if (ns == 1) {
                return new SeqViews.Single<Object>(this.value);
            }
            return new CopiesSeqView<Object>(ns, this.value);
        }

        @Override
        @NotNull
        public SeqView<E> dropLast(int n) {
            return this.drop(n);
        }

        @Override
        @NotNull
        public SeqView<E> take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return SeqView.empty();
            }
            if (n >= this.size) {
                return this;
            }
            if (n == 1) {
                return new SeqViews.Single<Object>(this.value);
            }
            return new CopiesSeqView<Object>(n, this.value);
        }

        @Override
        @NotNull
        public SeqView<E> takeLast(int n) {
            return this.take(n);
        }

        @Override
        @NotNull
        public @NotNull SeqView<@NotNull E> filterNotNull() {
            return this.value == null ? SeqView.empty() : this;
        }

        @Override
        @NotNull
        public SeqView<E> sorted() {
            return this;
        }

        @Override
        @NotNull
        public SeqView<E> sorted(Comparator<? super E> comparator) {
            return this;
        }
    }

    static abstract class CopiesSeqBase<E>
    implements IndexedSeqLike<E>,
    Serializable {
        protected final @Range(from=1L, to=0x7FFFFFFFL) int size;
        protected final E value;

        protected CopiesSeqBase(@Range(from=1L, to=0x7FFFFFFFL) int size, E value) {
            this.size = size;
            this.value = value;
        }

        @Override
        @NotNull
        public final Iterator<E> iterator() {
            return Iterators.fill((int)this.size, this.value);
        }

        @NotNull
        public final Spliterator<E> spliterator() {
            return this.stream().spliterator();
        }

        @NotNull
        public final Stream<E> stream() {
            return this.size == 1 ? Stream.of(this.value) : IntStream.range(0, this.size).mapToObj(i -> this.value);
        }

        @NotNull
        public final Stream<E> parallelStream() {
            return this.size == 1 ? (Stream<Object>)Stream.of(this.value).parallel() : IntStream.range(0, this.size).parallel().mapToObj(i -> this.value);
        }

        public final int size() {
            return this.size;
        }

        @Override
        public final E get(int index) {
            Conditions.checkElementIndex((int)index, (int)this.size);
            return this.value;
        }

        @Override
        @Nullable
        public final E getOrNull(int index) {
            return index >= 0 && index < this.size ? (E)this.value : null;
        }

        @Override
        @NotNull
        public final Option<E> getOption(int index) {
            return index >= 0 && index < this.size ? Option.some(this.value) : Option.none();
        }

        @Override
        @NotNull
        public final Iterator<E> reverseIterator() {
            return this.iterator();
        }

        @Override
        public final E first() {
            return this.value;
        }

        @Override
        @Nullable
        public final E firstOrNull() {
            return this.value;
        }

        @Override
        @NotNull
        public final Option<E> firstOption() {
            return Option.some(this.value);
        }

        @Override
        public final E last() {
            return this.value;
        }

        @Override
        @Nullable
        public final E lastOrNull() {
            return this.value;
        }

        @Override
        @NotNull
        public final Option<E> lastOption() {
            return Option.some(this.value);
        }

        @Override
        public final boolean contains(Object value) {
            return Objects.equals(value, this.size);
        }

        public final boolean containsAll(Object @NotNull [] values) {
            E value = this.value;
            if (value == null) {
                for (Object v : values) {
                    if (null == v) continue;
                    return false;
                }
            } else {
                for (Object v : values) {
                    if (value.equals(v)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public final int indexOf(Object value) {
            return Objects.equals(value, this.value) ? 0 : -1;
        }

        @Override
        public final int indexOf(Object value, int from) {
            if (from >= this.size) {
                return -1;
            }
            return Objects.equals(value, this.value) ? Integer.max(from, 0) : -1;
        }

        @Override
        public final int lastIndexOf(Object value) {
            return Objects.equals(value, this.value) ? this.size - 1 : -1;
        }

        @Override
        public final int lastIndexOf(Object value, int end) {
            if (end < 0) {
                return -1;
            }
            return Objects.equals(value, this.value) ? Integer.min(this.size - 1, end) : -1;
        }

        public final E max() {
            return this.value;
        }

        @Override
        public E max(Comparator<? super E> comparator) {
            return this.max();
        }

        @Nullable
        public final E maxOrNull() {
            return this.value;
        }

        @Nullable
        public final E maxOrNull(@NotNull Comparator<? super E> comparator) {
            return this.maxOrNull();
        }

        @NotNull
        public final Option<E> maxOption() {
            return Option.some(this.value);
        }

        @Override
        @NotNull
        public final Option<E> maxOption(Comparator<? super E> comparator) {
            return this.maxOption();
        }

        public final E min() {
            return this.value;
        }

        @Override
        public E min(Comparator<? super E> comparator) {
            return this.min();
        }

        @Nullable
        public final E minOrNull() {
            return this.value;
        }

        @Nullable
        public final E minOrNull(@NotNull Comparator<? super E> comparator) {
            return this.minOrNull();
        }

        @NotNull
        public final Option<E> minOption() {
            return Option.some(this.value);
        }

        @Override
        @NotNull
        public final Option<E> minOption(Comparator<? super E> comparator) {
            return this.minOption();
        }

        @Override
        public int copyToArray(int srcPos, Object @NotNull [] dest, int destPos, int limit) {
            if (srcPos < 0) {
                throw new IllegalArgumentException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"srcPos(\u0001) < 0"}, (int)destPos)));
            }
            if (destPos < 0) {
                throw new IllegalArgumentException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"destPos(\u0001) < 0"}, (int)destPos)));
            }
            int dl = dest.length;
            int size = this.size;
            if (destPos >= dl || srcPos >= size) {
                return 0;
            }
            int n = Math.min(Math.min(size - srcPos, dl - destPos), limit);
            E value = this.value;
            int end = n + destPos;
            for (int i = destPos; i < end; ++i) {
                dest[i] = value;
            }
            return n;
        }

        @Override
        public final Object @NotNull [] toArray() {
            Object[] res = new Object[this.size];
            E value = this.value;
            if (value != null) {
                Arrays.fill(res, value);
            }
            return res;
        }

        @Override
        public final <U> U @NotNull [] toArray(@NotNull Class<U> type) {
            Object[] res = (Object[])Array.newInstance(type, this.size);
            E value = this.value;
            if (value != null) {
                Arrays.fill(res, value);
            }
            return res;
        }

        @Override
        public final <U> U @NotNull [] toArray(@NotNull IntFunction<U[]> generator) {
            Object[] res = generator.apply(this.size);
            E value = this.value;
            if (value != null) {
                Arrays.fill(res, value);
            }
            return res;
        }

        @Override
        @NotNull
        public final <K, V> ImmutableMap<K, V> toImmutableMap() {
            Map.Entry entry = (Map.Entry)this.value;
            return ImmutableMap.of(entry.getKey(), entry.getValue());
        }

        @Override
        public final void forEach(@NotNull Consumer<? super E> action) {
            for (int i = 0; i < this.size; ++i) {
                action.accept(this.value);
            }
        }

        @Override
        public final void forEachIndexed(@NotNull IndexedConsumer<? super E> action) {
            for (int i = 0; i < this.size; ++i) {
                action.accept(i, this.value);
            }
        }

        public final String toString() {
            String cn = this.className();
            int size = this.size;
            String vs = this.value.toString();
            StringBuilder builder = new StringBuilder(cn.length() + (vs.length() + 2) * size);
            builder.append(cn).append('[').append(vs);
            for (int i = 1; i < size; ++i) {
                builder.append(", ").append(vs);
            }
            builder.append(']');
            return builder.toString();
        }
    }

    static final class Seq5<E>
    extends SeqN<E>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final E value1;
        private final E value2;
        private final E value3;
        private final E value4;
        private final E value5;

        Seq5(E value1, E value2, E value3, E value4, E value5) {
            this.value1 = value1;
            this.value2 = value2;
            this.value3 = value3;
            this.value4 = value4;
            this.value5 = value5;
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return Iterators.of(this.value1, this.value2, this.value3, this.value4, this.value5);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> reversed() {
            return new Seq5<E>(this.value5, this.value4, this.value3, this.value2, this.value1);
        }

        @Override
        @NotNull
        public Iterator<E> reverseIterator() {
            return Iterators.of(this.value5, this.value4, this.value3, this.value2, this.value1);
        }

        public int size() {
            return 5;
        }

        @Override
        public E get(int index) {
            switch (index) {
                case 0: {
                    return this.value1;
                }
                case 1: {
                    return this.value2;
                }
                case 2: {
                    return this.value3;
                }
                case 3: {
                    return this.value4;
                }
                case 4: {
                    return this.value5;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> prepended(E value) {
            return new ImmutableVectors.Vector1(new Object[]{value, this.value1, this.value2, this.value3, this.value4, this.value5});
        }

        @Override
        @NotNull
        public ImmutableSeq<E> appended(E value) {
            return new ImmutableVectors.Vector1(new Object[]{this.value1, this.value2, this.value3, this.value4, this.value5, value});
        }

        @Override
        @NotNull
        public ImmutableSeq<E> take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return ImmutableSeq.empty();
            }
            switch (n) {
                case 1: {
                    return ImmutableSeq.of(this.value1);
                }
                case 2: {
                    return ImmutableSeq.of(this.value1, this.value2);
                }
                case 3: {
                    return ImmutableSeq.of(this.value1, this.value2, this.value3);
                }
                case 4: {
                    return ImmutableSeq.of(this.value1, this.value2, this.value3, this.value4);
                }
            }
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> takeLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            switch (n) {
                case 0: {
                    return ImmutableSeq.empty();
                }
                case 1: {
                    return ImmutableSeq.of(this.value5);
                }
                case 2: {
                    return ImmutableSeq.of(this.value4, this.value5);
                }
                case 3: {
                    return ImmutableSeq.of(this.value3, this.value4, this.value5);
                }
                case 4: {
                    return ImmutableSeq.of(this.value2, this.value3, this.value4, this.value5);
                }
            }
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> takeWhile(@NotNull Predicate<? super E> predicate) {
            if (!predicate.test(this.value1)) {
                return ImmutableSeq.empty();
            }
            if (!predicate.test(this.value2)) {
                return ImmutableSeq.of(this.value1);
            }
            if (!predicate.test(this.value3)) {
                return ImmutableSeq.of(this.value1, this.value2);
            }
            if (!predicate.test(this.value4)) {
                return ImmutableSeq.of(this.value1, this.value2, this.value3);
            }
            if (!predicate.test(this.value5)) {
                return ImmutableSeq.of(this.value1, this.value2, this.value3, this.value4);
            }
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            switch (n) {
                case 0: {
                    return this;
                }
                case 1: {
                    return ImmutableSeq.of(this.value2, this.value3, this.value4, this.value5);
                }
                case 2: {
                    return ImmutableSeq.of(this.value3, this.value4, this.value5);
                }
                case 3: {
                    return ImmutableSeq.of(this.value4, this.value5);
                }
                case 4: {
                    return ImmutableSeq.of(this.value5);
                }
            }
            return ImmutableSeq.empty();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> dropLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            switch (n) {
                case 0: {
                    return this;
                }
                case 1: {
                    return ImmutableSeq.of(this.value1, this.value2, this.value3, this.value4);
                }
                case 2: {
                    return ImmutableSeq.of(this.value1, this.value2, this.value3);
                }
                case 3: {
                    return ImmutableSeq.of(this.value1, this.value2);
                }
                case 4: {
                    return ImmutableSeq.of(this.value1);
                }
            }
            return ImmutableSeq.empty();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> dropWhile(@NotNull Predicate<? super E> predicate) {
            if (!predicate.test(this.value1)) {
                return this;
            }
            if (!predicate.test(this.value2)) {
                return ImmutableSeq.of(this.value2, this.value3, this.value4, this.value5);
            }
            if (!predicate.test(this.value3)) {
                return ImmutableSeq.of(this.value3, this.value4, this.value5);
            }
            if (!predicate.test(this.value4)) {
                return ImmutableSeq.of(this.value4, this.value5);
            }
            if (!predicate.test(this.value5)) {
                return ImmutableSeq.of(this.value5);
            }
            return ImmutableSeq.empty();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> updated(int index, E newValue) {
            switch (index) {
                case 0: {
                    return ImmutableSeq.of(newValue, this.value2, this.value3, this.value4, this.value5);
                }
                case 1: {
                    return ImmutableSeq.of(this.value1, newValue, this.value3, this.value4, this.value5);
                }
                case 2: {
                    return ImmutableSeq.of(this.value1, this.value2, newValue, this.value4, this.value5);
                }
                case 3: {
                    return ImmutableSeq.of(this.value1, this.value2, this.value3, newValue, this.value5);
                }
                case 4: {
                    return ImmutableSeq.of(this.value1, this.value2, this.value3, this.value4, newValue);
                }
            }
            throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"index: \u0001"}, (int)index)));
        }

        @Override
        @NotNull
        public <U> ImmutableSeq<U> map(@NotNull Function<? super E, ? extends U> mapper) {
            return ImmutableSeq.of(mapper.apply(this.value1), mapper.apply(this.value2), mapper.apply(this.value3), mapper.apply(this.value4), mapper.apply(this.value5));
        }

        @Override
        @NotNull
        public <U> ImmutableSeq<U> mapIndexed(@NotNull IndexedFunction<? super E, ? extends U> mapper) {
            return ImmutableSeq.of(mapper.apply(0, this.value1), mapper.apply(1, this.value2), mapper.apply(2, this.value3), mapper.apply(3, this.value4), mapper.apply(4, this.value5));
        }
    }

    static final class Seq4<E>
    extends SeqN<E>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final E value1;
        private final E value2;
        private final E value3;
        private final E value4;

        Seq4(E value1, E value2, E value3, E value4) {
            this.value1 = value1;
            this.value2 = value2;
            this.value3 = value3;
            this.value4 = value4;
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return Iterators.of(this.value1, this.value2, this.value3, this.value4);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> reversed() {
            return new Seq4<E>(this.value4, this.value3, this.value2, this.value1);
        }

        @Override
        @NotNull
        public Iterator<E> reverseIterator() {
            return Iterators.of(this.value4, this.value3, this.value2, this.value1);
        }

        public int size() {
            return 4;
        }

        @Override
        public E get(int index) {
            switch (index) {
                case 0: {
                    return this.value1;
                }
                case 1: {
                    return this.value2;
                }
                case 2: {
                    return this.value3;
                }
                case 3: {
                    return this.value4;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> prepended(E value) {
            return ImmutableSeq.of(value, this.value1, this.value2, this.value3, this.value4);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> appended(E value) {
            return ImmutableSeq.of(this.value1, this.value2, this.value3, this.value4, value);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return ImmutableSeq.empty();
            }
            switch (n) {
                case 1: {
                    return ImmutableSeq.of(this.value1);
                }
                case 2: {
                    return ImmutableSeq.of(this.value1, this.value2);
                }
                case 3: {
                    return ImmutableSeq.of(this.value1, this.value2, this.value3);
                }
            }
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> takeLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            switch (n) {
                case 0: {
                    return ImmutableSeq.empty();
                }
                case 1: {
                    return ImmutableSeq.of(this.value4);
                }
                case 2: {
                    return ImmutableSeq.of(this.value3, this.value4);
                }
                case 3: {
                    return ImmutableSeq.of(this.value2, this.value3, this.value4);
                }
            }
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> takeWhile(@NotNull Predicate<? super E> predicate) {
            if (!predicate.test(this.value1)) {
                return ImmutableSeq.empty();
            }
            if (!predicate.test(this.value2)) {
                return ImmutableSeq.of(this.value1);
            }
            if (!predicate.test(this.value3)) {
                return ImmutableSeq.of(this.value1, this.value2);
            }
            if (!predicate.test(this.value4)) {
                return ImmutableSeq.of(this.value1, this.value2, this.value3);
            }
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            switch (n) {
                case 0: {
                    return this;
                }
                case 1: {
                    return ImmutableSeq.of(this.value2, this.value3, this.value4);
                }
                case 2: {
                    return ImmutableSeq.of(this.value3, this.value4);
                }
                case 3: {
                    return ImmutableSeq.of(this.value4);
                }
            }
            return ImmutableSeq.empty();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> dropLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            switch (n) {
                case 0: {
                    return this;
                }
                case 1: {
                    return ImmutableSeq.of(this.value1, this.value2, this.value3);
                }
                case 2: {
                    return ImmutableSeq.of(this.value1, this.value2);
                }
                case 3: {
                    return ImmutableSeq.of(this.value1);
                }
            }
            return ImmutableSeq.empty();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> dropWhile(@NotNull Predicate<? super E> predicate) {
            if (!predicate.test(this.value1)) {
                return this;
            }
            if (!predicate.test(this.value2)) {
                return ImmutableSeq.of(this.value2, this.value3, this.value4);
            }
            if (!predicate.test(this.value3)) {
                return ImmutableSeq.of(this.value3, this.value4);
            }
            if (!predicate.test(this.value4)) {
                return ImmutableSeq.of(this.value4);
            }
            return ImmutableSeq.empty();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> updated(int index, E newValue) {
            switch (index) {
                case 0: {
                    return ImmutableSeq.of(newValue, this.value2, this.value3, this.value4);
                }
                case 1: {
                    return ImmutableSeq.of(this.value1, newValue, this.value3, this.value4);
                }
                case 2: {
                    return ImmutableSeq.of(this.value1, this.value2, newValue, this.value4);
                }
                case 3: {
                    return ImmutableSeq.of(this.value1, this.value2, this.value3, newValue);
                }
            }
            throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"index: \u0001"}, (int)index)));
        }

        @Override
        @NotNull
        public <U> ImmutableSeq<U> map(@NotNull Function<? super E, ? extends U> mapper) {
            return ImmutableSeq.of(mapper.apply(this.value1), mapper.apply(this.value2), mapper.apply(this.value3), mapper.apply(this.value4));
        }

        @Override
        @NotNull
        public <U> ImmutableSeq<U> mapIndexed(@NotNull IndexedFunction<? super E, ? extends U> mapper) {
            return ImmutableSeq.of(mapper.apply(0, this.value1), mapper.apply(1, this.value2), mapper.apply(2, this.value3), mapper.apply(3, this.value4));
        }
    }

    static final class Seq3<E>
    extends SeqN<E>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final E value1;
        private final E value2;
        private final E value3;

        Seq3(E value1, E value2, E value3) {
            this.value1 = value1;
            this.value2 = value2;
            this.value3 = value3;
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return Iterators.of(this.value1, this.value2, this.value3);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> reversed() {
            return new Seq3<E>(this.value3, this.value2, this.value1);
        }

        @Override
        @NotNull
        public Iterator<E> reverseIterator() {
            return Iterators.of(this.value3, this.value2, this.value1);
        }

        public int size() {
            return 3;
        }

        @Override
        public E get(int index) {
            switch (index) {
                case 0: {
                    return this.value1;
                }
                case 1: {
                    return this.value2;
                }
                case 2: {
                    return this.value3;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> prepended(E value) {
            return ImmutableSeq.of(value, this.value1, this.value2, this.value3);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> appended(E value) {
            return ImmutableSeq.of(this.value1, this.value2, this.value3, value);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return ImmutableSeq.empty();
            }
            switch (n) {
                case 1: {
                    return ImmutableSeq.of(this.value1);
                }
                case 2: {
                    return ImmutableSeq.of(this.value1, this.value2);
                }
            }
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> takeLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            switch (n) {
                case 0: {
                    return ImmutableSeq.empty();
                }
                case 1: {
                    return ImmutableSeq.of(this.value3);
                }
                case 2: {
                    return ImmutableSeq.of(this.value2, this.value3);
                }
            }
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> takeWhile(@NotNull Predicate<? super E> predicate) {
            if (!predicate.test(this.value1)) {
                return ImmutableSeq.empty();
            }
            if (!predicate.test(this.value2)) {
                return ImmutableSeq.of(this.value1);
            }
            if (!predicate.test(this.value3)) {
                return ImmutableSeq.of(this.value1, this.value2);
            }
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            switch (n) {
                case 0: {
                    return this;
                }
                case 1: {
                    return ImmutableSeq.of(this.value2, this.value3);
                }
                case 2: {
                    return ImmutableSeq.of(this.value3);
                }
            }
            return ImmutableSeq.empty();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> dropLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            switch (n) {
                case 0: {
                    return this;
                }
                case 1: {
                    return ImmutableSeq.of(this.value1, this.value2);
                }
                case 2: {
                    return ImmutableSeq.of(this.value2);
                }
            }
            return ImmutableSeq.empty();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> dropWhile(@NotNull Predicate<? super E> predicate) {
            if (!predicate.test(this.value1)) {
                return this;
            }
            if (!predicate.test(this.value2)) {
                return ImmutableSeq.of(this.value2, this.value3);
            }
            if (!predicate.test(this.value3)) {
                return ImmutableSeq.of(this.value3);
            }
            return ImmutableSeq.empty();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> updated(int index, E newValue) {
            switch (index) {
                case 0: {
                    return ImmutableSeq.of(newValue, this.value2, this.value3);
                }
                case 1: {
                    return ImmutableSeq.of(this.value1, newValue, this.value3);
                }
                case 2: {
                    return ImmutableSeq.of(this.value1, this.value2, newValue);
                }
            }
            throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"index: \u0001"}, (int)index)));
        }

        @Override
        @NotNull
        public <U> ImmutableSeq<U> map(@NotNull Function<? super E, ? extends U> mapper) {
            return ImmutableSeq.of(mapper.apply(this.value1), mapper.apply(this.value2), mapper.apply(this.value3));
        }

        @Override
        @NotNull
        public <U> ImmutableSeq<U> mapIndexed(@NotNull IndexedFunction<? super E, ? extends U> mapper) {
            return ImmutableSeq.of(mapper.apply(0, this.value1), mapper.apply(1, this.value2), mapper.apply(2, this.value3));
        }
    }

    static final class Seq2<E>
    extends SeqN<E>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final E value1;
        private final E value2;

        Seq2(E value1, E value2) {
            this.value1 = value1;
            this.value2 = value2;
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return Iterators.of(this.value1, this.value2);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> reversed() {
            return new Seq2<E>(this.value2, this.value1);
        }

        @Override
        @NotNull
        public Iterator<E> reverseIterator() {
            return Iterators.of(this.value2, this.value1);
        }

        public int size() {
            return 2;
        }

        @Override
        public E get(int index) {
            switch (index) {
                case 0: {
                    return this.value1;
                }
                case 1: {
                    return this.value2;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> prepended(E value) {
            return ImmutableSeq.of(value, this.value1, this.value2);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> appended(E value) {
            return ImmutableSeq.of(this.value1, this.value2, value);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return ImmutableSeq.empty();
            }
            if (n == 1) {
                return ImmutableSeq.of(this.value1);
            }
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> takeLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return ImmutableSeq.empty();
            }
            if (n == 1) {
                return ImmutableSeq.of(this.value2);
            }
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> takeWhile(@NotNull Predicate<? super E> predicate) {
            if (!predicate.test(this.value1)) {
                return ImmutableSeq.empty();
            }
            if (!predicate.test(this.value2)) {
                return ImmutableSeq.of(this.value1);
            }
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            switch (n) {
                case 0: {
                    return this;
                }
                case 1: {
                    return ImmutableSeq.of(this.value2);
                }
            }
            return ImmutableSeq.empty();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> dropLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            if (n == 1) {
                return ImmutableSeq.of(this.value1);
            }
            return ImmutableSeq.empty();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> dropWhile(@NotNull Predicate<? super E> predicate) {
            if (!predicate.test(this.value1)) {
                return this;
            }
            if (!predicate.test(this.value2)) {
                return ImmutableSeq.of(this.value2);
            }
            return ImmutableSeq.empty();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> updated(int index, E newValue) {
            switch (index) {
                case 0: {
                    return ImmutableSeq.of(newValue, this.value2);
                }
                case 1: {
                    return ImmutableSeq.of(this.value1, newValue);
                }
            }
            throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"index: \u0001"}, (int)index)));
        }

        @Override
        @NotNull
        public <U> ImmutableSeq<U> map(@NotNull Function<? super E, ? extends U> mapper) {
            return ImmutableSeq.of(mapper.apply(this.value1), mapper.apply(this.value2));
        }

        @Override
        @NotNull
        public <U> ImmutableSeq<U> mapIndexed(@NotNull IndexedFunction<? super E, ? extends U> mapper) {
            return ImmutableSeq.of(mapper.apply(0, this.value1), mapper.apply(1, this.value2));
        }
    }

    static final class Seq1<E>
    extends SeqN<E>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final E value1;

        Seq1(E value1) {
            this.value1 = value1;
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return Iterators.of(this.value1);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> reversed() {
            return this;
        }

        @Override
        @NotNull
        public Iterator<E> reverseIterator() {
            return Iterators.of(this.value1);
        }

        public int size() {
            return 1;
        }

        @Override
        public E get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.value1;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> prepended(E value) {
            return ImmutableSeq.of(value, this.value1);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> appended(E value) {
            return ImmutableSeq.of(this.value1, value);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return ImmutableSeq.empty();
            }
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> takeLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return ImmutableSeq.empty();
            }
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> takeWhile(@NotNull Predicate<? super E> predicate) {
            if (!predicate.test(this.value1)) {
                return ImmutableSeq.empty();
            }
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            return ImmutableSeq.empty();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> dropLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            return ImmutableSeq.empty();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> dropWhile(@NotNull Predicate<? super E> predicate) {
            return predicate.test(this.value1) ? ImmutableSeq.empty() : this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> updated(int index, E newValue) {
            if (index != 0) {
                throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"index: \u0001"}, (int)index)));
            }
            return ImmutableSeq.of(newValue);
        }

        @Override
        @NotNull
        public <U> ImmutableSeq<U> map(@NotNull Function<? super E, ? extends U> mapper) {
            return ImmutableSeq.of(mapper.apply(this.value1));
        }

        @Override
        @NotNull
        public <U> ImmutableSeq<U> mapIndexed(@NotNull IndexedFunction<? super E, ? extends U> mapper) {
            return ImmutableSeq.of(mapper.apply(0, this.value1));
        }

        @Override
        @NotNull
        public <U> @NotNull ImmutableSeq<@NotNull U> mapNotNull(@NotNull Function<? super E, ? extends @Nullable U> mapper) {
            U u = mapper.apply(this.value1);
            return u == null ? ImmutableSeq.empty() : ImmutableSeq.of(u);
        }

        @Override
        @NotNull
        public <U> @NotNull ImmutableSeq<@NotNull U> mapIndexedNotNull(@NotNull IndexedFunction<? super E, ? extends @Nullable U> mapper) {
            Object u = mapper.apply(0, this.value1);
            return u == null ? ImmutableSeq.empty() : ImmutableSeq.of(u);
        }
    }

    static final class Seq0<E>
    extends SeqN<E>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        static final Seq0<?> INSTANCE = new Seq0();

        Seq0() {
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return Iterators.empty();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> reversed() {
            return this;
        }

        @Override
        @NotNull
        public Iterator<E> reverseIterator() {
            return Iterators.empty();
        }

        @Override
        @NotNull
        public Spliterator<E> spliterator() {
            return Spliterators.emptySpliterator();
        }

        @Override
        @NotNull
        public SeqView<E> view() {
            return SeqView.empty();
        }

        public int size() {
            return 0;
        }

        @Override
        public E get(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        @NotNull
        public ImmutableSeq<E> prepended(E value) {
            return ImmutableSeq.of(value);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> appended(E value) {
            return ImmutableSeq.of(value);
        }

        @Override
        @NotNull
        public ImmutableSeq<E> take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> takeLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> takeWhile(@NotNull Predicate<? super E> predicate) {
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> dropLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> dropWhile(@NotNull Predicate<? super E> predicate) {
            return this;
        }

        @Override
        @NotNull
        public ImmutableSeq<E> updated(int index, E newValue) {
            throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"index: \u0001"}, (int)index)));
        }

        @Override
        @NotNull
        public <U> ImmutableSeq<U> map(@NotNull Function<? super E, ? extends U> mapper) {
            return ImmutableSeq.empty();
        }

        @Override
        @NotNull
        public <U> ImmutableSeq<U> mapIndexed(@NotNull IndexedFunction<? super E, ? extends U> mapper) {
            return ImmutableSeq.empty();
        }

        @Override
        @NotNull
        public <U> @NotNull ImmutableSeq<@NotNull U> mapNotNull(@NotNull Function<? super E, ? extends @Nullable U> mapper) {
            return ImmutableSeq.empty();
        }

        @Override
        @NotNull
        public <U> @NotNull ImmutableSeq<@NotNull U> mapIndexedNotNull(@NotNull IndexedFunction<? super E, ? extends @Nullable U> mapper) {
            return ImmutableSeq.empty();
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    static abstract class SeqN<E>
    extends AbstractImmutableIndexedSeq<E> {
        SeqN() {
        }
    }
}

