/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable;

import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import kala.collection.ArraySeq;
import kala.collection.Set;
import kala.collection.SortedSet;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.AbstractImmutableCollection;
import kala.collection.immutable.AbstractImmutableSet;
import kala.collection.immutable.ImmutableCollection;
import kala.function.Predicates;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface ImmutableSet<E>
extends ImmutableCollection<E>,
Set<E> {
    @Contract(value="_ -> param1", pure=true)
    public static <E> ImmutableSet<E> narrow(ImmutableSet<? extends E> set) {
        return set;
    }

    public static <E> CollectionFactory<E, ?, ? extends ImmutableSet<E>> factory() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    default public String className() {
        return "ImmutableSet";
    }

    @Override
    @NotNull
    default public <U> CollectionFactory<U, ?, ? extends ImmutableSet<U>> iterableFactory() {
        return ImmutableSet.factory();
    }

    @Override
    @NotNull
    default public Spliterator<E> spliterator() {
        int knownSize = this.knownSize();
        if (knownSize == 0) {
            return Spliterators.emptySpliterator();
        }
        if (knownSize > 0) {
            return Spliterators.spliterator(this.iterator(), (long)knownSize, 1025);
        }
        return Spliterators.spliteratorUnknownSize(this.iterator(), 1025);
    }

    @NotNull
    default public ImmutableSet<E> added(E value) {
        if (this.contains(value)) {
            return this;
        }
        if (this instanceof SortedSet) {
            CollectionFactory factory = ((SortedSet)((Object)this)).iterableFactory(((SortedSet)((Object)this)).comparator());
            return (ImmutableSet)((Object)AbstractImmutableSet.added(this, value, factory));
        }
        return AbstractImmutableSet.added(this, value, this.iterableFactory());
    }

    @NotNull
    default public ImmutableSet<E> addedAll(@NotNull Iterable<? extends E> values) {
        if (this instanceof SortedSet) {
            CollectionFactory factory = ((SortedSet)((Object)this)).iterableFactory(((SortedSet)((Object)this)).comparator());
            return (ImmutableSet)((Object)AbstractImmutableSet.addedAll(this, values, factory));
        }
        return AbstractImmutableSet.addedAll(this, values, this.iterableFactory());
    }

    @NotNull
    default public ImmutableSet<E> addedAll(E @NotNull [] values) {
        return this.addedAll((Iterable<? extends E>)((Object)ArraySeq.wrap(values)));
    }

    @Override
    @NotNull
    default public ImmutableSet<E> filter(@NotNull Predicate<? super E> predicate) {
        return AbstractImmutableCollection.filter(this, predicate, ImmutableSet.factory());
    }

    @Override
    @NotNull
    default public ImmutableSet<E> filterNot(@NotNull Predicate<? super E> predicate) {
        return AbstractImmutableCollection.filterNot(this, predicate, ImmutableSet.factory());
    }

    @Override
    @NotNull
    default public @NotNull ImmutableSet<@NotNull E> filterNotNull() {
        return this.filter(Predicates.isNotNull());
    }

    @Override
    @NotNull
    default public <U> @NotNull ImmutableSet<@NotNull U> filterIsInstance(@NotNull Class<? extends U> clazz) {
        return this.filter(clazz::isInstance);
    }
}

