/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kala.Conditions;
import kala.collection.SeqLike;
import kala.collection.base.AnyTraversable;
import kala.collection.base.Traversable;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.AbstractImmutableIndexedSeq;
import kala.collection.immutable.AbstractImmutableSeq;
import kala.collection.immutable.ImmutableArray;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.immutable.ImmutableVectors;
import kala.comparator.Comparators;
import kala.function.IndexedFunction;
import kala.function.Predicates;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImmutableVector<E>
extends AbstractImmutableIndexedSeq<E>
implements Serializable {
    final Object[] prefix1;
    private static final Factory<?> FACTORY = new Factory();

    ImmutableVector(Object[] prefix1) {
        this.prefix1 = prefix1;
    }

    @Contract(value="_ -> param1", pure=true)
    static <E> ImmutableVector<E> narrow(ImmutableVector<? extends E> vector) {
        return vector;
    }

    @NotNull
    public static <E> CollectionFactory<E, ?, ImmutableVector<E>> factory() {
        return FACTORY;
    }

    @NotNull
    public static <E> ImmutableVector<E> empty() {
        return ImmutableVectors.Vector0.INSTANCE;
    }

    @NotNull
    public static <E> ImmutableVector<E> of() {
        return ImmutableVector.empty();
    }

    @NotNull
    public static <E> ImmutableVector<E> of(E value1) {
        return new ImmutableVectors.Vector1(new Object[]{value1});
    }

    @NotNull
    public static <E> ImmutableVector<E> of(E value1, E value2) {
        return new ImmutableVectors.Vector1(new Object[]{value1, value2});
    }

    @NotNull
    public static <E> ImmutableVector<E> of(E value1, E value2, E value3) {
        return new ImmutableVectors.Vector1(new Object[]{value1, value2, value3});
    }

    @NotNull
    public static <E> ImmutableVector<E> of(E value1, E value2, E value3, E value4) {
        return new ImmutableVectors.Vector1(new Object[]{value1, value2, value3, value4});
    }

    @NotNull
    public static <E> ImmutableVector<E> of(E value1, E value2, E value3, E value4, E value5) {
        return new ImmutableVectors.Vector1(new Object[]{value1, value2, value3, value4, value5});
    }

    @SafeVarargs
    @NotNull
    public static <E> ImmutableVector<E> of(E ... values) {
        return ImmutableVector.from(values);
    }

    @NotNull
    public static <E> ImmutableVector<E> from(E @NotNull [] values) {
        int size = values.length;
        if (size == 0) {
            return ImmutableVector.empty();
        }
        if (size <= 32) {
            Object[] res = new Object[size];
            System.arraycopy(values, 0, res, 0, size);
            return new ImmutableVectors.Vector1(res);
        }
        ImmutableVectors.VectorBuilder builder = new ImmutableVectors.VectorBuilder();
        builder.addAll(values);
        return builder.build();
    }

    @NotNull
    public static <E> ImmutableVector<E> from(@NotNull Collection<? extends E> values) {
        int size = values.size();
        if (size == 0) {
            return ImmutableVector.empty();
        }
        if (size <= 32) {
            Object[] res = new Object[size];
            res = values.toArray(res);
            return new ImmutableVectors.Vector1(res);
        }
        return ImmutableVector.from(values.iterator());
    }

    @NotNull
    public static <E> ImmutableVector<E> from(@NotNull Traversable<? extends E> values) {
        if (values instanceof ImmutableVector) {
            return (ImmutableVector)values;
        }
        int knownSize = values.knownSize();
        if (knownSize == 0) {
            return ImmutableVector.empty();
        }
        if (knownSize > 0 && knownSize <= 32) {
            Object[] arr;
            if (values instanceof ImmutableArray && (arr = ((ImmutableArray)values).getArray()).getClass() == Object[].class) {
                return new ImmutableVectors.Vector1(arr);
            }
            arr = new Object[knownSize];
            int cn = values.copyToArray(arr);
            assert (cn == knownSize);
            return new ImmutableVectors.Vector1(arr);
        }
        return ImmutableVector.from(values.iterator());
    }

    @NotNull
    public static <E> ImmutableVector<E> from(@NotNull Iterable<? extends E> values) {
        if (values instanceof Traversable) {
            return ImmutableVector.from((Traversable)values);
        }
        if (values instanceof Collection) {
            return ImmutableVector.from((Collection)values);
        }
        return ImmutableVector.from(values.iterator());
    }

    @NotNull
    public static <E> ImmutableVector<E> from(@NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            return ImmutableVector.empty();
        }
        ImmutableVectors.VectorBuilder<E> builder = new ImmutableVectors.VectorBuilder<E>();
        while (it.hasNext()) {
            builder.add(it.next());
        }
        return builder.build();
    }

    @NotNull
    public static <E> ImmutableVector<E> from(@NotNull Stream<? extends E> stream) {
        return stream.collect(ImmutableVector.factory());
    }

    @NotNull
    public static <E> ImmutableVector<E> fill(int n, E value) {
        if (n <= 0) {
            return ImmutableVector.empty();
        }
        if (n <= 32) {
            Object[] arr = new Object[n];
            if (value != null) {
                Arrays.fill(arr, value);
            }
            return new ImmutableVectors.Vector1(arr);
        }
        ImmutableVectors.VectorBuilder<E> builder = new ImmutableVectors.VectorBuilder<E>();
        while (n-- > 0) {
            builder.add(value);
        }
        return builder.build();
    }

    @NotNull
    public static <E> ImmutableVector<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
        if (n <= 0) {
            return ImmutableVector.empty();
        }
        if (n <= 32) {
            Object[] arr = new Object[n];
            for (int i = 0; i < n; ++i) {
                arr[i] = supplier.get();
            }
            return new ImmutableVectors.Vector1(arr);
        }
        ImmutableVectors.VectorBuilder<E> builder = new ImmutableVectors.VectorBuilder<E>();
        while (n-- > 0) {
            builder.add(supplier.get());
        }
        return builder.build();
    }

    @NotNull
    public static <E> ImmutableVector<E> fill(int n, @NotNull IntFunction<? extends E> init) {
        if (n <= 0) {
            return ImmutableVector.empty();
        }
        if (n <= 32) {
            Object[] arr = new Object[n];
            for (int i = 0; i < n; ++i) {
                arr[i] = init.apply(i);
            }
            return new ImmutableVectors.Vector1(arr);
        }
        ImmutableVectors.VectorBuilder<E> builder = new ImmutableVectors.VectorBuilder<E>();
        for (int i = 0; i < n; ++i) {
            builder.add(init.apply(i));
        }
        return builder.build();
    }

    abstract int vectorSliceCount();

    abstract Object[] vectorSlice(int var1);

    abstract int vectorSlicePrefixLength(int var1);

    @Override
    @NotNull
    public final String className() {
        return "ImmutableVector";
    }

    @Override
    @NotNull
    public final <U> CollectionFactory<U, ?, ImmutableVector<U>> iterableFactory() {
        return ImmutableVector.factory();
    }

    @Override
    public final boolean isEmpty() {
        return this == ImmutableVectors.Vector0.INSTANCE;
    }

    @Override
    @NotNull
    public ImmutableSeq<E> reversed() {
        ImmutableVectors.VectorBuilder builder = new ImmutableVectors.VectorBuilder();
        Iterator it = this.reverseIterator();
        while (it.hasNext()) {
            builder.add(it.next());
        }
        return builder.build();
    }

    @Override
    @NotNull
    public ImmutableVector<E> appended(E value) {
        ImmutableVectors.VectorBuilder<E> builder = new ImmutableVectors.VectorBuilder<E>();
        builder.initFrom(this);
        builder.add(value);
        return builder.build();
    }

    @Override
    @NotNull
    public ImmutableVector<E> appendedAll(E @NotNull [] values) {
        ImmutableVectors.VectorBuilder builder = new ImmutableVectors.VectorBuilder();
        builder.initFrom(this);
        builder.addAll(values);
        return builder.build();
    }

    @Override
    @NotNull
    public ImmutableVector<E> appendedAll(@NotNull ImmutableVector<? extends E> values) {
        if (values == ImmutableVectors.Vector0.INSTANCE) {
            return this;
        }
        ImmutableVectors.VectorBuilder<? extends E> builder = new ImmutableVectors.VectorBuilder<E>();
        builder.initFrom(this);
        builder.addVector(values);
        return builder.build();
    }

    @Override
    @NotNull
    public ImmutableVector<E> appendedAll(@NotNull Iterable<? extends E> values) {
        if (values instanceof ImmutableVector) {
            return this.appendedAll((ImmutableVector)((Object)values));
        }
        if (AnyTraversable.knownSize(values) == 0) {
            return this;
        }
        ImmutableVectors.VectorBuilder<? extends E> builder = new ImmutableVectors.VectorBuilder<E>();
        builder.initFrom(this);
        builder.addAll(values);
        return builder.build();
    }

    @Override
    @NotNull
    public ImmutableVector<E> prepended(E value) {
        ImmutableVectors.VectorBuilder<E> builder = new ImmutableVectors.VectorBuilder<E>();
        builder.add(value);
        builder.addVector(this);
        return builder.build();
    }

    @Override
    @NotNull
    public ImmutableVector<E> prependedAll(E @NotNull [] values) {
        ImmutableVectors.VectorBuilder builder = new ImmutableVectors.VectorBuilder();
        builder.addAll(values);
        builder.addVector(this);
        return builder.build();
    }

    @Override
    @NotNull
    public ImmutableVector<E> prependedAll(@NotNull ImmutableVector<? extends E> values) {
        if (values == ImmutableVectors.Vector0.INSTANCE) {
            return this;
        }
        ImmutableVectors.VectorBuilder builder = new ImmutableVectors.VectorBuilder();
        builder.initFrom(values);
        builder.addVector(this);
        return builder.build();
    }

    @Override
    @NotNull
    public ImmutableVector<E> prependedAll(@NotNull Iterable<? extends E> values) {
        if (values instanceof ImmutableVector) {
            return this.prependedAll((ImmutableVector)((Object)values));
        }
        if (AnyTraversable.knownSize(values) == 0) {
            return this;
        }
        ImmutableVectors.VectorBuilder<? extends E> builder = new ImmutableVectors.VectorBuilder<E>();
        builder.addAll(values);
        builder.addVector(this);
        return builder.build();
    }

    @NotNull
    abstract ImmutableVector<E> slice0(int var1, int var2);

    @Override
    @NotNull
    public final ImmutableSeq<E> slice(int beginIndex, int endIndex) {
        int size = this.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int newSize = endIndex - beginIndex;
        if (newSize == 0) {
            return ImmutableVector.empty();
        }
        if (newSize == size) {
            return this;
        }
        return this.slice0(beginIndex, endIndex);
    }

    @Override
    @NotNull
    public final ImmutableSeq<E> drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int size = this.size();
        if (n >= size) {
            return ImmutableVector.empty();
        }
        return this.slice0(n, size);
    }

    @Override
    @NotNull
    public final ImmutableSeq<E> dropLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int size = this.size();
        if (n >= size) {
            return ImmutableVector.empty();
        }
        return this.slice0(0, size - n);
    }

    @Override
    @NotNull
    public final ImmutableSeq<E> take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return ImmutableVector.empty();
        }
        int size = this.size();
        if (n >= size) {
            return this;
        }
        return this.slice0(0, n);
    }

    @Override
    @NotNull
    public final ImmutableSeq<E> takeLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return ImmutableVector.empty();
        }
        int size = this.size();
        if (n >= size) {
            return this;
        }
        return this.slice0(size - n, size);
    }

    @Override
    @NotNull
    public final ImmutableSeq<E> concat(@NotNull SeqLike<? extends E> other) {
        return this.appendedAll((Iterable)((Object)other));
    }

    @Override
    @NotNull
    public final ImmutableSeq<E> concat(@NotNull List<? extends E> other) {
        return this.appendedAll(other);
    }

    abstract ImmutableSeq<E> filterImpl(Predicate<? super E> var1, boolean var2);

    @Override
    @NotNull
    public final ImmutableSeq<E> filter(@NotNull Predicate<? super E> predicate) {
        return this.filterImpl(predicate, false);
    }

    @Override
    @NotNull
    public final ImmutableSeq<E> filterNot(@NotNull Predicate<? super E> predicate) {
        return this.filterImpl(predicate, true);
    }

    @Override
    @NotNull
    public final ImmutableSeq<E> filterNotNull() {
        return this.filter(Predicates.isNotNull());
    }

    @Override
    @NotNull
    public <U> @NotNull ImmutableSeq<@NotNull U> filterIsInstance(@NotNull Class<? extends U> clazz) {
        return (ImmutableVector)this.filter(clazz::isInstance);
    }

    @Override
    @NotNull
    public <U> ImmutableSeq<U> map(@NotNull Function<? super E, ? extends U> mapper) {
        ImmutableVectors.VectorBuilder<U> builder = new ImmutableVectors.VectorBuilder<U>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            builder.add(mapper.apply(e));
        }
        return builder.build();
    }

    @Override
    @NotNull
    public <U> ImmutableSeq<U> mapIndexed(@NotNull IndexedFunction<? super E, ? extends U> mapper) {
        ImmutableVectors.VectorBuilder<Object> builder = new ImmutableVectors.VectorBuilder<Object>();
        int idx = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            builder.add(mapper.apply(idx++, e));
        }
        return builder.build();
    }

    @Override
    @NotNull
    public <U> @NotNull ImmutableSeq<@NotNull U> mapNotNull(@NotNull Function<? super E, ? extends @Nullable U> mapper) {
        ImmutableVectors.VectorBuilder<U> builder = new ImmutableVectors.VectorBuilder<U>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            U u = mapper.apply(e);
            if (u == null) continue;
            builder.add(u);
        }
        return builder.build();
    }

    @Override
    @NotNull
    public <U> @NotNull ImmutableSeq<@NotNull U> mapIndexedNotNull(@NotNull IndexedFunction<? super E, ? extends @Nullable U> mapper) {
        ImmutableVectors.VectorBuilder<Object> builder = new ImmutableVectors.VectorBuilder<Object>();
        int idx = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object u;
            Object e = iterator.next();
            if ((u = mapper.apply(idx++, e)) == null) continue;
            builder.add(u);
        }
        return builder.build();
    }

    @Override
    @NotNull
    public <U> ImmutableSeq<U> flatMap(@NotNull Function<? super E, ? extends Iterable<? extends U>> mapper) {
        if (this == ImmutableVectors.Vector0.INSTANCE) {
            return ImmutableVector.empty();
        }
        ImmutableVectors.VectorBuilder<? extends U> builder = new ImmutableVectors.VectorBuilder<U>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            builder.addAll(mapper.apply(e));
        }
        return builder.build();
    }

    @Override
    @NotNull
    public final ImmutableSeq<E> sorted() {
        return this.sorted(Comparators.naturalOrder());
    }

    @Override
    @NotNull
    public final ImmutableSeq<E> sorted(Comparator<? super E> comparator) {
        return AbstractImmutableSeq.sorted(this, comparator, this.iterableFactory());
    }

    @Override
    @NotNull
    public final ImmutableVector<E> toImmutableVector() {
        return this;
    }

    private static final class Factory<E>
    implements CollectionFactory<E, ImmutableVectors.VectorBuilder<E>, ImmutableVector<E>> {
        private Factory() {
        }

        public ImmutableVector<E> empty() {
            return ImmutableVector.empty();
        }

        public ImmutableVectors.VectorBuilder<E> newBuilder() {
            return new ImmutableVectors.VectorBuilder();
        }

        public void addToBuilder( @NotNull ImmutableVectors.VectorBuilder<E> builder, E value) {
            builder.add(value);
        }

        public ImmutableVectors.VectorBuilder<E> mergeBuilder( @NotNull ImmutableVectors.VectorBuilder<E> builder1,  @NotNull ImmutableVectors.VectorBuilder<E> builder2) {
            builder1.addVector(builder2.build());
            return builder1;
        }

        public ImmutableVector<E> build( @NotNull ImmutableVectors.VectorBuilder<E> builder) {
            return builder.build();
        }

        public ImmutableVector<E> from(E @NotNull [] values) {
            return ImmutableVector.from(values);
        }

        public ImmutableVector<E> from(@NotNull Iterable<? extends E> values) {
            return ImmutableVector.from(values);
        }

        public ImmutableVector<E> from(@NotNull Iterator<? extends E> it) {
            return ImmutableVector.from(it);
        }

        public ImmutableVector<E> fill(int n, E value) {
            return ImmutableVector.fill(n, value);
        }

        public ImmutableVector<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
            return ImmutableVector.fill(n, supplier);
        }

        public ImmutableVector<E> fill(int n, @NotNull IntFunction<? extends E> init) {
            return ImmutableVector.fill(n, init);
        }
    }
}

