/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import kala.Conditions;
import kala.collection.base.AbstractIterator;
import kala.collection.base.GenericArrays;
import kala.collection.base.Iterators;
import kala.collection.base.ObjectArrays;
import kala.collection.base.Traversable;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.immutable.ImmutableVector;
import kala.control.Option;
import kala.function.IndexedConsumer;
import kala.function.IndexedFunction;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ImmutableVectors {
    public static final int BITS = 5;
    public static final int WIDTH = 32;
    public static final int MASK = 31;
    public static final int BITS2 = 10;
    public static final int WIDTH2 = 1024;
    public static final int BITS3 = 15;
    public static final int WIDTH3 = 32768;
    public static final int BITS4 = 20;
    public static final int WIDTH4 = 0x100000;
    public static final int BITS5 = 25;
    public static final int WIDTH5 = 0x2000000;
    public static final int BITS6 = 30;
    public static final int WIDTH6 = 0x40000000;
    public static final int LASTWIDTH = 64;
    public static final int Log2ConcatFaster = 5;
    static final Object[] empty1 = new Object[0];
    static final Object[][] empty2 = new Object[0][];
    static final Object[][][] empty3 = new Object[0][][];
    static final Object[][][][] empty4 = new Object[0][][][];
    static final Object[][][][][] empty5 = new Object[0][][][][];
    static final Object[][][][][][] empty6 = new Object[0][][][][][];

    ImmutableVectors() {
    }

    static int vectorSliceDim(int count, int idx) {
        int c = count / 2;
        return c + 1 - Math.abs(idx - c);
    }

    static <T> T[] copyOrUse(T[] a, int start, int end) {
        return start == 0 && end == a.length ? a : Arrays.copyOfRange(a, start, end);
    }

    static <T> T[] copyTail(T[] a) {
        return Arrays.copyOfRange(a, 1, a.length);
    }

    static <T> T[] copyInit(T[] a) {
        return Arrays.copyOfRange(a, 0, a.length - 1);
    }

    static <T> T[] copyIfDifferentSize(T[] a, int len) {
        return a.length == len ? a : Arrays.copyOf(a, len);
    }

    static Object[] wrap1(Object x) {
        Object[] a = new Object[]{x};
        return a;
    }

    static Object[][] wrap2(Object[] x) {
        Object[][] a = new Object[][]{x};
        return a;
    }

    static Object[][][] wrap3(Object[][] x) {
        Object[][][] a = new Object[][][]{x};
        return a;
    }

    static Object[][][][] wrap4(Object[][][] x) {
        Object[][][][] a = new Object[][][][]{x};
        return a;
    }

    static Object[][][][][] wrap5(Object[][][][] x) {
        Object[][][][][] a = new Object[][][][][]{x};
        return a;
    }

    static Object[] copyUpdate(Object[] a1, int idx1, Object elem) {
        Object[] a1c = (Object[])a1.clone();
        a1c[idx1] = elem;
        return a1c;
    }

    static Object[][] copyUpdate(Object[][] a2, int idx2, int idx1, Object elem) {
        Object[][] a2c = (Object[][])a2.clone();
        a2c[idx2] = ImmutableVectors.copyUpdate(a2c[idx2], idx1, elem);
        return a2c;
    }

    static Object[][][] copyUpdate(Object[][][] a3, int idx3, int idx2, int idx1, Object elem) {
        Object[][][] a3c = (Object[][][])a3.clone();
        a3c[idx3] = ImmutableVectors.copyUpdate(a3c[idx3], idx2, idx1, elem);
        return a3c;
    }

    static Object[][][][] copyUpdate(Object[][][][] a4, int idx4, int idx3, int idx2, int idx1, Object elem) {
        Object[][][][] a4c = (Object[][][][])a4.clone();
        a4c[idx4] = ImmutableVectors.copyUpdate(a4c[idx4], idx3, idx2, idx1, elem);
        return a4c;
    }

    static Object[][][][][] copyUpdate(Object[][][][][] a5, int idx5, int idx4, int idx3, int idx2, int idx1, Object elem) {
        Object[][][][][] a5c = (Object[][][][][])a5.clone();
        a5c[idx5] = ImmutableVectors.copyUpdate(a5c[idx5], idx4, idx3, idx2, idx1, elem);
        return a5c;
    }

    static Object[][][][][][] copyUpdate(Object[][][][][][] a6, int idx6, int idx5, int idx4, int idx3, int idx2, int idx1, Object elem) {
        Object[][][][][][] a6c = (Object[][][][][][])a6.clone();
        a6c[idx6] = ImmutableVectors.copyUpdate(a6c[idx6], idx5, idx4, idx3, idx2, idx1, elem);
        return a6c;
    }

    static <T> T[] concatArrays(T[] a, T[] b) {
        T[] dest = Arrays.copyOf(a, a.length + b.length);
        System.arraycopy(b, 0, dest, a.length, b.length);
        return dest;
    }

    static Object[] copyAppend1(Object[] a, Object elem) {
        int alen = a.length;
        Object[] ac = new Object[alen + 1];
        System.arraycopy(a, 0, ac, 0, alen);
        ac[alen] = elem;
        return ac;
    }

    static <T> T[] copyAppend(T[] a, T elem) {
        T[] ac = Arrays.copyOf(a, a.length + 1);
        ac[ac.length - 1] = elem;
        return ac;
    }

    static Object[] copyPrepend1(Object elem, Object[] a) {
        Object[] ac = new Object[a.length + 1];
        System.arraycopy(a, 0, ac, 1, a.length);
        ac[0] = elem;
        return ac;
    }

    static <T> T[] copyPrepend(T elem, T[] a) {
        Object[] ac = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length + 1);
        System.arraycopy(a, 0, ac, 1, a.length);
        ac[0] = elem;
        return ac;
    }

    static void forEachRec(int level, Object[] a, Consumer f) {
        int i = 0;
        int len = a.length;
        if (level == 0) {
            while (i < len) {
                f.accept(a[i++]);
            }
        } else {
            int l = level - 1;
            while (i < len) {
                ImmutableVectors.forEachRec(l, (Object[])a[i++], f);
            }
        }
    }

    static Object[] mapElems1(Object[] a, Function f) {
        for (int i = 0; i < a.length; ++i) {
            Object v1 = a[i];
            Object v2 = f.apply(v1);
            if (v1 == v2) continue;
            return ImmutableVectors.mapElems1Rest(a, f, i, v2);
        }
        return a;
    }

    static Object[] mapElems1Rest(Object[] a, Function f, int at, Object v2) {
        Object[] ac = new Object[a.length];
        if (at > 0) {
            System.arraycopy(a, 0, ac, 0, at);
        }
        ac[at] = v2;
        for (int i = at + 1; i < a.length; ++i) {
            ac[i] = f.apply(a[i]);
        }
        return ac;
    }

    static <T> T[] mapElems(int n, T[] a, Function f) {
        if (n == 1) {
            return ImmutableVectors.mapElems1(a, f);
        }
        for (int i = 0; i < a.length; ++i) {
            T v1 = a[i];
            Object[] v2 = ImmutableVectors.mapElems(n - 1, (Object[])v1, f);
            if (v1 == v2) continue;
            return ImmutableVectors.mapElemsRest(n, a, f, i, v2);
        }
        return a;
    }

    static <T> T[] mapElemsRest(int n, T[] a, Function f, int at, Object v2) {
        Object[] ac = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length);
        if (at > 0) {
            System.arraycopy(a, 0, ac, 0, at);
        }
        ac[at] = v2;
        for (int i = at + 1; i < a.length; ++i) {
            ac[i] = ImmutableVectors.mapElems(n - 1, (Object[])a[i], f);
        }
        return ac;
    }

    static Object[] prepend1IfSpace(Object[] prefix1, Iterable<?> xs) {
        return null;
    }

    static Object[] append1IfSpace(Object[] suffix1, Iterable<?> xs) {
        if (xs instanceof Traversable) {
            Traversable it = (Traversable)xs;
            if (it.sizeCompare(32 - suffix1.length) <= 0) {
                int s = it.size();
                if (s == 0) {
                    return null;
                }
                if (s == 1) {
                    return ImmutableVectors.copyAppend(suffix1, it.iterator().next());
                }
                Object[] suffix1b = Arrays.copyOf(suffix1, suffix1.length + s);
                it.copyToArray(suffix1.length, suffix1b);
                return suffix1b;
            }
            return null;
        }
        return null;
    }

    static final class Itr<E>
    extends AbstractIterator<E>
    implements Spliterator<E>,
    Cloneable {
        private final BigVector<? extends E> v;
        private int totalLength;
        private final int sliceCount;
        private Object[] a1;
        private Object[][] a2;
        private Object[][][] a3;
        private Object[][][][] a4;
        private Object[][][][][] a5;
        private Object[][][][][][] a6;
        private int a1len;
        private int i1 = 0;
        private int oldPos = 0;
        private int len1;
        private int sliceIdx = 0;
        private int sliceDim = 1;
        private int sliceStart = 0;
        private int sliceEnd;

        Itr(BigVector<? extends E> v, int totalLength, int sliceCount) {
            this.v = v;
            this.totalLength = totalLength;
            this.sliceCount = sliceCount;
            this.a1 = v.prefix1;
            this.a1len = this.a1.length;
            this.len1 = totalLength;
            this.sliceEnd = this.a1len;
        }

        private void advanceSlice() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.sliceIdx;
            Object[] slice = this.v.vectorSlice(this.sliceIdx);
            while (slice.length == 0) {
                ++this.sliceIdx;
                slice = this.v.vectorSlice(this.sliceIdx);
            }
            this.sliceStart = this.sliceEnd;
            this.sliceDim = ImmutableVectors.vectorSliceDim(this.sliceCount, this.sliceIdx);
            switch (this.sliceDim) {
                case 1: {
                    this.a1 = slice;
                    break;
                }
                case 2: {
                    this.a2 = (Object[][])slice;
                    break;
                }
                case 3: {
                    this.a3 = (Object[][][])slice;
                    break;
                }
                case 4: {
                    this.a4 = (Object[][][][])slice;
                    break;
                }
                case 5: {
                    this.a5 = (Object[][][][][])slice;
                    break;
                }
                case 6: {
                    this.a6 = (Object[][][][][][])slice;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.sliceEnd = this.sliceStart + slice.length * (1 << 5 * (this.sliceDim - 1));
            if (this.sliceEnd > this.totalLength) {
                this.sliceEnd = this.totalLength;
            }
            if (this.sliceDim > 1) {
                this.oldPos = (1 << 5 * this.sliceDim) - 1;
            }
        }

        private void advance() {
            int pos = this.i1 - this.len1 + this.totalLength;
            if (pos == this.sliceEnd) {
                this.advanceSlice();
            }
            if (this.sliceDim > 1) {
                int io = pos - this.sliceStart;
                int xor = this.oldPos ^ io;
                this.advanceA(io, xor);
                this.oldPos = io;
            }
            this.len1 -= this.i1;
            this.a1len = Math.min(this.a1.length, this.len1);
            this.i1 = 0;
        }

        private void advanceA(int io, int xor) {
            if (xor < 1024) {
                this.a1 = this.a2[io >>> 5 & 0x1F];
            } else if (xor < 32768) {
                this.a2 = this.a3[io >>> 10 & 0x1F];
                this.a1 = this.a2[0];
            } else if (xor < 0x100000) {
                this.a3 = this.a4[io >>> 15 & 0x1F];
                this.a2 = this.a3[0];
                this.a1 = this.a2[0];
            } else if (xor < 0x2000000) {
                this.a4 = this.a5[io >>> 20 & 0x1F];
                this.a3 = this.a4[0];
                this.a2 = this.a3[0];
                this.a1 = this.a2[0];
            } else {
                this.a5 = this.a6[io >>> 25];
                this.a4 = this.a5[0];
                this.a3 = this.a4[0];
                this.a2 = this.a3[0];
                this.a1 = this.a2[0];
            }
        }

        public boolean hasNext() {
            return this.len1 > this.i1;
        }

        public E next() {
            if (this.i1 == this.a1len) {
                this.advance();
            }
            return (E)this.a1[this.i1++];
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            while (this.hasNext()) {
                action.accept(this.next());
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            if (this.hasNext()) {
                action.accept(this.next());
                return true;
            }
            return false;
        }

        private Itr<E> split(int at) {
            Object it2 = this.clone();
            super.take(at);
            this.drop(at);
            return it2;
        }

        @Override
        public Spliterator<E> trySplit() {
            int len = this.knownSize();
            if (len > 1) {
                return this.split(len >>> 1);
            }
            return null;
        }

        int knownSize() {
            return this.len1 - this.i1;
        }

        @Override
        public long estimateSize() {
            return this.knownSize();
        }

        @Override
        public int characteristics() {
            return 16464;
        }

        private void setA(int io, int xor) {
            if (xor < 1024) {
                this.a1 = this.a2[io >>> 5 & 0x1F];
            } else if (xor < 32768) {
                this.a2 = this.a3[io >>> 10 & 0x1F];
                this.a1 = this.a2[io >>> 5 & 0x1F];
            } else if (xor < 0x100000) {
                this.a3 = this.a4[io >>> 15 & 0x1F];
                this.a2 = this.a3[io >>> 10 & 0x1F];
                this.a1 = this.a2[io >>> 5 & 0x1F];
            } else if (xor < 0x2000000) {
                this.a4 = this.a5[io >>> 20 & 0x1F];
                this.a3 = this.a4[io >>> 15 & 0x1F];
                this.a2 = this.a3[io >>> 10 & 0x1F];
                this.a1 = this.a2[io >>> 5 & 0x1F];
            } else {
                this.a5 = this.a6[io >>> 25];
                this.a4 = this.a5[io >>> 20 & 0x1F];
                this.a3 = this.a4[io >>> 15 & 0x1F];
                this.a2 = this.a3[io >>> 10 & 0x1F];
                this.a1 = this.a2[io >>> 5 & 0x1F];
            }
        }

        private void drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return;
            }
            int oldpos = this.i1 - this.len1 + this.totalLength;
            int newpos = Math.min(oldpos + n, this.totalLength);
            if (newpos == this.totalLength) {
                this.i1 = 0;
                this.len1 = 0;
                this.a1len = 0;
            } else {
                while (newpos >= this.sliceEnd) {
                    this.advanceSlice();
                }
                int io = newpos - this.sliceStart;
                if (this.sliceDim > 1) {
                    int xor = this.oldPos ^ io;
                    this.setA(io, xor);
                    this.oldPos = io;
                }
                this.a1len = this.a1.length;
                this.i1 = io & 0x1F;
                this.len1 = this.i1 + (this.totalLength - newpos);
                if (this.a1len > this.len1) {
                    this.a1len = this.len1;
                }
            }
        }

        private void take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            int knownSize = this.knownSize();
            if (n < knownSize) {
                int trunc = knownSize - n;
                this.totalLength -= trunc;
                this.len1 -= trunc;
                if (this.len1 < this.a1len) {
                    this.a1len = this.len1;
                }
                if (this.totalLength < this.sliceEnd) {
                    this.sliceEnd = this.totalLength;
                }
            }
        }

        protected Itr<E> clone() {
            try {
                return (Itr)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static final class VectorBuilder<E> {
        private Object[][][][][][] a6;
        private Object[][][][][] a5;
        private Object[][][][] a4;
        private Object[][][] a3;
        private Object[][] a2;
        private Object[] a1 = new Object[32];
        private int len1 = 0;
        private int lenRest = 0;
        private int offset = 0;
        private int depth = 1;

        VectorBuilder() {
        }

        static <E> VectorBuilder<E> merge(VectorBuilder<E> builder1, VectorBuilder<E> builder2) {
            builder1.addVector(builder2.build());
            return builder1;
        }

        int size() {
            return this.len1 + this.lenRest - this.offset;
        }

        private void setLen(int i) {
            this.len1 = i & 0x1F;
            this.lenRest = i - this.len1;
        }

        void initSparse(int size, E elem) {
            this.setLen(size);
            Arrays.fill(this.a1, elem);
            if (size > 32) {
                this.a2 = new Object[32][];
                Arrays.fill((Object[])this.a2, this.a1);
                if (size > 1024) {
                    this.a3 = new Object[32][][];
                    Arrays.fill((Object[])this.a3, this.a2);
                    if (size > 32768) {
                        this.a4 = new Object[32][][][];
                        Arrays.fill((Object[])this.a4, this.a3);
                        if (size > 0x100000) {
                            this.a5 = new Object[32][][][][];
                            Arrays.fill((Object[])this.a5, this.a4);
                            if (size > 0x2000000) {
                                this.a6 = new Object[64][][][][][];
                                Arrays.fill((Object[])this.a6, this.a5);
                                this.depth = 6;
                            } else {
                                this.depth = 5;
                            }
                        } else {
                            this.depth = 4;
                        }
                    } else {
                        this.depth = 3;
                    }
                } else {
                    this.depth = 2;
                }
            } else {
                this.depth = 1;
            }
        }

        void initFrom(Object[] prefix1) {
            this.depth = 1;
            this.setLen(prefix1.length);
            this.a1 = ImmutableVectors.copyOrUse(prefix1, 0, 32);
            if (this.len1 == 0 && this.lenRest > 0) {
                this.len1 = 32;
                this.lenRest -= 32;
            }
        }

        void initFrom(ImmutableVector<?> v) {
            switch (v.vectorSliceCount()) {
                case 0: {
                    break;
                }
                case 1: {
                    Vector1 v1 = (Vector1)v;
                    this.depth = 1;
                    this.setLen(v1.prefix1.length);
                    this.a1 = ImmutableVectors.copyOrUse(v1.prefix1, 0, 32);
                    break;
                }
                case 3: {
                    Vector2 v2 = (Vector2)v;
                    Object[][] d2 = v2.data2;
                    this.a1 = ImmutableVectors.copyOrUse(v2.suffix1, 0, 32);
                    this.depth = 2;
                    this.offset = 32 - v2.len1;
                    this.setLen(v2.length0 + this.offset);
                    this.a2 = new Object[32][];
                    this.a2[0] = v2.prefix1;
                    System.arraycopy(d2, 0, this.a2, 1, d2.length);
                    this.a2[d2.length + 1] = this.a1;
                    break;
                }
                case 5: {
                    Vector3 v3 = (Vector3)v;
                    Object[][][] d3 = v3.data3;
                    Object[][] s2 = v3.suffix2;
                    this.a1 = ImmutableVectors.copyOrUse(v3.suffix1, 0, 32);
                    this.depth = 3;
                    this.offset = 1024 - v3.len12;
                    this.setLen(v3.length0 + this.offset);
                    this.a3 = new Object[32][][];
                    this.a3[0] = ImmutableVectors.copyPrepend(v3.prefix1, v3.prefix2);
                    System.arraycopy(d3, 0, this.a3, 1, d3.length);
                    this.a2 = (Object[][])Arrays.copyOf(s2, 32);
                    this.a3[d3.length + 1] = this.a2;
                    this.a2[s2.length] = this.a1;
                    break;
                }
                case 7: {
                    Vector4 v4 = (Vector4)v;
                    Object[][][][] d4 = v4.data4;
                    Object[][][] s3 = v4.suffix3;
                    Object[][] s2 = v4.suffix2;
                    this.a1 = ImmutableVectors.copyOrUse(v4.suffix1, 0, 32);
                    this.depth = 4;
                    this.offset = 32768 - v4.len123;
                    this.setLen(v4.length0 + this.offset);
                    this.a4 = new Object[32][][][];
                    this.a4[0] = ImmutableVectors.copyPrepend((Object[][])ImmutableVectors.copyPrepend(v4.prefix1, v4.prefix2), v4.prefix3);
                    System.arraycopy(d4, 0, this.a4, 1, d4.length);
                    this.a3 = (Object[][][])Arrays.copyOf(s3, 32);
                    this.a2 = (Object[][])Arrays.copyOf(s2, 32);
                    this.a4[d4.length + 1] = this.a3;
                    this.a3[s3.length] = this.a2;
                    this.a2[s2.length] = this.a1;
                    break;
                }
                case 9: {
                    Vector5 v5 = (Vector5)v;
                    Object[][][][][] d5 = v5.data5;
                    Object[][][][] s4 = v5.suffix4;
                    Object[][][] s3 = v5.suffix3;
                    Object[][] s2 = v5.suffix2;
                    this.a1 = ImmutableVectors.copyOrUse(v5.suffix1, 0, 32);
                    this.depth = 5;
                    this.offset = 0x100000 - v5.len1234;
                    this.setLen(v5.length0 + this.offset);
                    this.a5 = new Object[32][][][][];
                    this.a5[0] = ImmutableVectors.copyPrepend((Object[][][])ImmutableVectors.copyPrepend((Object[][])ImmutableVectors.copyPrepend(v5.prefix1, v5.prefix2), v5.prefix3), v5.prefix4);
                    System.arraycopy(d5, 0, this.a5, 1, d5.length);
                    this.a4 = (Object[][][][])Arrays.copyOf(s4, 32);
                    this.a3 = (Object[][][])Arrays.copyOf(s3, 32);
                    this.a2 = (Object[][])Arrays.copyOf(s2, 32);
                    this.a5[d5.length + 1] = this.a4;
                    this.a4[s4.length] = this.a3;
                    this.a3[s3.length] = this.a2;
                    this.a2[s2.length] = this.a1;
                    break;
                }
                case 11: {
                    Vector6 v6 = (Vector6)v;
                    Object[][][][][][] d6 = v6.data6;
                    Object[][][][][] s5 = v6.suffix5;
                    Object[][][][] s4 = v6.suffix4;
                    Object[][][] s3 = v6.suffix3;
                    Object[][] s2 = v6.suffix2;
                    this.a1 = ImmutableVectors.copyOrUse(v6.suffix1, 0, 32);
                    this.depth = 6;
                    this.offset = 0x2000000 - v6.len12345;
                    this.setLen(v6.length0 + this.offset);
                    this.a6 = new Object[32][][][][][];
                    this.a6[0] = ImmutableVectors.copyPrepend((Object[][][][])ImmutableVectors.copyPrepend((Object[][][])ImmutableVectors.copyPrepend((Object[][])ImmutableVectors.copyPrepend(v6.prefix1, v6.prefix2), v6.prefix3), v6.prefix4), v6.prefix5);
                    System.arraycopy(d6, 0, this.a6, 1, d6.length);
                    this.a5 = (Object[][][][][])Arrays.copyOf(s5, 32);
                    this.a4 = (Object[][][][])Arrays.copyOf(s4, 32);
                    this.a3 = (Object[][][])Arrays.copyOf(s3, 32);
                    this.a2 = (Object[][])Arrays.copyOf(s2, 32);
                    this.a6[d6.length + 1] = this.a5;
                    this.a5[s5.length] = this.a4;
                    this.a4[s4.length] = this.a3;
                    this.a3[s3.length] = this.a2;
                    this.a2[s2.length] = this.a1;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (this.len1 == 0 && this.lenRest > 0) {
                this.len1 = 32;
                this.lenRest -= 32;
            }
        }

        void add(E elem) {
            if (this.len1 == 32) {
                this.advance();
            }
            this.a1[this.len1++] = elem;
        }

        private void addArr1(Object[] data) {
            int dl = data.length;
            if (dl > 0) {
                if (this.len1 == 32) {
                    this.advance();
                }
                int copy1 = Math.min(32 - this.len1, dl);
                int copy2 = dl - copy1;
                System.arraycopy(data, 0, this.a1, this.len1, copy1);
                this.len1 += copy1;
                if (copy2 > 0) {
                    this.advance();
                    System.arraycopy(data, copy1, this.a1, 0, copy2);
                    this.len1 += copy2;
                }
            }
        }

        void addVector(ImmutableVector<? extends E> xs) {
            int sliceCount = xs.vectorSliceCount();
            for (int sliceIdx = 0; sliceIdx < sliceCount; ++sliceIdx) {
                Object[] slice = xs.vectorSlice(sliceIdx);
                int dim = ImmutableVectors.vectorSliceDim(sliceCount, sliceIdx);
                if (dim == 1) {
                    this.addArr1(slice);
                    continue;
                }
                ImmutableVectors.forEachRec(dim - 2, slice, this::addArr1);
            }
        }

        void addAll(Object[] xs) {
            for (Object e : xs) {
                this.add(e);
            }
        }

        void addAll(Iterable<? extends E> xs) {
            for (E e : xs) {
                this.add(e);
            }
        }

        void addAll(Traversable<? extends E> xs) {
            if (xs instanceof ImmutableVector) {
                ImmutableVector v = (ImmutableVector)xs;
                if (this.len1 == 0 && this.lenRest == 0) {
                    this.initFrom(v);
                } else {
                    this.addVector(v);
                }
            }
            for (Object e : xs) {
                this.add(e);
            }
        }

        private void advance() {
            int idx = this.lenRest + 32;
            int xor = idx ^ this.lenRest;
            this.lenRest = idx;
            this.len1 = 0;
            this.advance1(idx, xor);
        }

        private void advance1(int idx, int xor) {
            if (xor < 1024) {
                if (this.depth == 1) {
                    this.a2 = new Object[32][];
                    this.a2[0] = this.a1;
                    ++this.depth;
                }
                this.a1 = new Object[32];
                this.a2[idx >>> 5 & 0x1F] = this.a1;
            } else if (xor < 32768) {
                if (this.depth == 2) {
                    this.a3 = new Object[32][][];
                    this.a3[0] = this.a2;
                    ++this.depth;
                }
                this.a1 = new Object[32];
                this.a2 = new Object[32][];
                this.a2[idx >>> 5 & 0x1F] = this.a1;
                this.a3[idx >>> 10 & 0x1F] = this.a2;
            } else if (xor < 0x100000) {
                if (this.depth == 3) {
                    this.a4 = new Object[32][][][];
                    this.a4[0] = this.a3;
                    ++this.depth;
                }
                this.a1 = new Object[32];
                this.a2 = new Object[32][];
                this.a3 = new Object[32][][];
                this.a2[idx >>> 5 & 0x1F] = this.a1;
                this.a3[idx >>> 10 & 0x1F] = this.a2;
                this.a4[idx >>> 15 & 0x1F] = this.a3;
            } else if (xor < 0x2000000) {
                if (this.depth == 4) {
                    this.a5 = new Object[32][][][][];
                    this.a5[0] = this.a4;
                    ++this.depth;
                }
                this.a1 = new Object[32];
                this.a2 = new Object[32][];
                this.a3 = new Object[32][][];
                this.a4 = new Object[32][][][];
                this.a2[idx >>> 5 & 0x1F] = this.a1;
                this.a3[idx >>> 10 & 0x1F] = this.a2;
                this.a4[idx >>> 15 & 0x1F] = this.a3;
                this.a5[idx >>> 20 & 0x1F] = this.a4;
            } else if (xor < 0x40000000) {
                if (this.depth == 5) {
                    this.a6 = new Object[64][][][][][];
                    this.a6[0] = this.a5;
                    ++this.depth;
                }
                this.a1 = new Object[32];
                this.a2 = new Object[32][];
                this.a3 = new Object[32][][];
                this.a4 = new Object[32][][][];
                this.a5 = new Object[32][][][][];
                this.a2[idx >>> 5 & 0x1F] = this.a1;
                this.a3[idx >>> 10 & 0x1F] = this.a2;
                this.a4[idx >>> 15 & 0x1F] = this.a3;
                this.a5[idx >>> 20 & 0x1F] = this.a4;
                this.a6[idx >>> 25 & 0x1F] = this.a5;
            } else {
                throw new IllegalArgumentException(String.format("advance1(%d, %d): a1=%s, a2=%s, a3=%s, a4=%s, a5=%s, a6=%s, depth=%d", idx, xor, Arrays.toString(this.a1), Arrays.deepToString((Object[])this.a2), Arrays.deepToString((Object[])this.a3), Arrays.deepToString((Object[])this.a4), Arrays.deepToString((Object[])this.a5), Arrays.deepToString((Object[])this.a6), this.depth));
            }
        }

        ImmutableVector<E> build() {
            int len = this.len1 + this.lenRest;
            int realLen = len - this.offset;
            if (realLen == 0) {
                return ImmutableVector.empty();
            }
            if (len <= 32) {
                if (realLen == 32) {
                    return new Vector1(this.a1);
                }
                return new Vector1(Arrays.copyOf(this.a1, realLen));
            }
            if (len <= 1024) {
                int i1 = len - 1 & 0x1F;
                int i2 = len - 1 >>> 5;
                Object[][] data = (Object[][])Arrays.copyOfRange(this.a2, 1, i2);
                Object[] prefix1 = this.a2[0];
                Object[] suffix1 = ImmutableVectors.copyIfDifferentSize(this.a2[i2], i1 + 1);
                return new Vector2(prefix1, 32 - this.offset, data, suffix1, realLen);
            }
            if (len <= 32768) {
                int i1 = len - 1 & 0x1F;
                int i2 = len - 1 >>> 5 & 0x1F;
                int i3 = len - 1 >>> 10;
                Object[][][] data = (Object[][][])Arrays.copyOfRange(this.a3, 1, i3);
                Object[][] prefix2 = (Object[][])ImmutableVectors.copyTail(this.a3[0]);
                Object[] prefix1 = this.a3[0][0];
                Object[][] suffix2 = (Object[][])Arrays.copyOf(this.a3[i3], i2);
                Object[] suffix1 = ImmutableVectors.copyIfDifferentSize(this.a3[i3][i2], i1 + 1);
                int len1 = prefix1.length;
                int len12 = len1 + prefix2.length * 32;
                return new Vector3(prefix1, len1, prefix2, len12, data, suffix2, suffix1, realLen);
            }
            if (len <= 0x100000) {
                int i1 = len - 1 & 0x1F;
                int i2 = len - 1 >>> 5 & 0x1F;
                int i3 = len - 1 >>> 10 & 0x1F;
                int i4 = len - 1 >>> 15;
                Object[][][][] data = (Object[][][][])Arrays.copyOfRange(this.a4, 1, i4);
                Object[][][] prefix3 = (Object[][][])ImmutableVectors.copyTail(this.a4[0]);
                Object[][] prefix2 = (Object[][])ImmutableVectors.copyTail(this.a4[0][0]);
                Object[] prefix1 = this.a4[0][0][0];
                Object[][][] suffix3 = (Object[][][])Arrays.copyOf(this.a4[i4], i3);
                Object[][] suffix2 = (Object[][])Arrays.copyOf(this.a4[i4][i3], i2);
                Object[] suffix1 = ImmutableVectors.copyIfDifferentSize(this.a4[i4][i3][i2], i1 + 1);
                int len1 = prefix1.length;
                int len12 = len1 + prefix2.length * 32;
                int len123 = len12 + prefix3.length * 1024;
                return new Vector4(prefix1, len1, prefix2, len12, prefix3, len123, data, suffix3, suffix2, suffix1, realLen);
            }
            if (len <= 0x2000000) {
                int i1 = len - 1 & 0x1F;
                int i2 = len - 1 >>> 5 & 0x1F;
                int i3 = len - 1 >>> 10 & 0x1F;
                int i4 = len - 1 >>> 15 & 0x1F;
                int i5 = len - 1 >>> 20;
                Object[][][][][] data = (Object[][][][][])Arrays.copyOfRange(this.a5, 1, i5);
                Object[][][][] prefix4 = (Object[][][][])ImmutableVectors.copyTail(this.a5[0]);
                Object[][][] prefix3 = (Object[][][])ImmutableVectors.copyTail(this.a5[0][0]);
                Object[][] prefix2 = (Object[][])ImmutableVectors.copyTail(this.a5[0][0][0]);
                Object[] prefix1 = this.a5[0][0][0][0];
                Object[][][][] suffix4 = (Object[][][][])Arrays.copyOf(this.a5[i5], i4);
                Object[][][] suffix3 = (Object[][][])Arrays.copyOf(this.a5[i5][i4], i3);
                Object[][] suffix2 = (Object[][])Arrays.copyOf(this.a5[i5][i4][i3], i2);
                Object[] suffix1 = ImmutableVectors.copyIfDifferentSize(this.a5[i5][i4][i3][i2], i1 + 1);
                int len1 = prefix1.length;
                int len12 = len1 + prefix2.length * 32;
                int len123 = len12 + prefix3.length * 1024;
                int len1234 = len123 + prefix4.length * 32768;
                return new Vector5(prefix1, len1, prefix2, len12, prefix3, len123, prefix4, len1234, data, suffix4, suffix3, suffix2, suffix1, realLen);
            }
            int i1 = len - 1 & 0x1F;
            int i2 = len - 1 >>> 5 & 0x1F;
            int i3 = len - 1 >>> 10 & 0x1F;
            int i4 = len - 1 >>> 15 & 0x1F;
            int i5 = len - 1 >>> 20 & 0x1F;
            int i6 = len - 1 >>> 25;
            Object[][][][][][] data = (Object[][][][][][])Arrays.copyOfRange(this.a6, 1, i6);
            Object[][][][][] prefix5 = (Object[][][][][])ImmutableVectors.copyTail(this.a6[0]);
            Object[][][][] prefix4 = (Object[][][][])ImmutableVectors.copyTail(this.a6[0][0]);
            Object[][][] prefix3 = (Object[][][])ImmutableVectors.copyTail(this.a6[0][0][0]);
            Object[][] prefix2 = (Object[][])ImmutableVectors.copyTail(this.a6[0][0][0][0]);
            Object[] prefix1 = this.a6[0][0][0][0][0];
            Object[][][][][] suffix5 = (Object[][][][][])Arrays.copyOf(this.a6[i6], i5);
            Object[][][][] suffix4 = (Object[][][][])Arrays.copyOf(this.a6[i6][i5], i4);
            Object[][][] suffix3 = (Object[][][])Arrays.copyOf(this.a6[i6][i5][i4], i3);
            Object[][] suffix2 = (Object[][])Arrays.copyOf(this.a6[i6][i5][i4][i3], i2);
            Object[] suffix1 = ImmutableVectors.copyIfDifferentSize(this.a6[i6][i5][i4][i3][i2], i1 + 1);
            int len1 = prefix1.length;
            int len12 = len1 + prefix2.length * 32;
            int len123 = len12 + prefix3.length * 1024;
            int len1234 = len123 + prefix4.length * 32768;
            int len12345 = len1234 + prefix5.length * 0x100000;
            return new Vector6(prefix1, len1, prefix2, len12, prefix3, len123, prefix4, len1234, prefix5, len12345, data, suffix5, suffix4, suffix3, suffix2, suffix1, realLen);
        }

        ImmutableSeq<E> buildSeq() {
            int len = this.len1 + this.lenRest;
            int realLen = len - this.offset;
            if (realLen == 0) {
                return ImmutableSeq.empty();
            }
            if (len <= 32) {
                Object[] a1 = this.a1;
                switch (realLen) {
                    case 1: {
                        return ImmutableSeq.of(a1[0]);
                    }
                    case 2: {
                        return ImmutableSeq.of(a1[0], a1[1]);
                    }
                    case 3: {
                        return ImmutableSeq.of(a1[0], a1[1], a1[2]);
                    }
                    case 4: {
                        return ImmutableSeq.of(a1[0], a1[1], a1[2], a1[3]);
                    }
                    case 5: {
                        return ImmutableSeq.of(a1[0], a1[1], a1[2], a1[3], a1[4]);
                    }
                }
                if (realLen == 32) {
                    return new Vector1(a1);
                }
                return new Vector1(Arrays.copyOf(a1, realLen));
            }
            if (len <= 1024) {
                int i1 = len - 1 & 0x1F;
                int i2 = len - 1 >>> 5;
                Object[][] data = (Object[][])Arrays.copyOfRange(this.a2, 1, i2);
                Object[] prefix1 = this.a2[0];
                Object[] suffix1 = ImmutableVectors.copyIfDifferentSize(this.a2[i2], i1 + 1);
                return new Vector2(prefix1, 32 - this.offset, data, suffix1, realLen);
            }
            if (len <= 32768) {
                int i1 = len - 1 & 0x1F;
                int i2 = len - 1 >>> 5 & 0x1F;
                int i3 = len - 1 >>> 10;
                Object[][][] data = (Object[][][])Arrays.copyOfRange(this.a3, 1, i3);
                Object[][] prefix2 = (Object[][])ImmutableVectors.copyTail(this.a3[0]);
                Object[] prefix1 = this.a3[0][0];
                Object[][] suffix2 = (Object[][])Arrays.copyOf(this.a3[i3], i2);
                Object[] suffix1 = ImmutableVectors.copyIfDifferentSize(this.a3[i3][i2], i1 + 1);
                int len1 = prefix1.length;
                int len12 = len1 + prefix2.length * 32;
                return new Vector3(prefix1, len1, prefix2, len12, data, suffix2, suffix1, realLen);
            }
            if (len <= 0x100000) {
                int i1 = len - 1 & 0x1F;
                int i2 = len - 1 >>> 5 & 0x1F;
                int i3 = len - 1 >>> 10 & 0x1F;
                int i4 = len - 1 >>> 15;
                Object[][][][] data = (Object[][][][])Arrays.copyOfRange(this.a4, 1, i4);
                Object[][][] prefix3 = (Object[][][])ImmutableVectors.copyTail(this.a4[0]);
                Object[][] prefix2 = (Object[][])ImmutableVectors.copyTail(this.a4[0][0]);
                Object[] prefix1 = this.a4[0][0][0];
                Object[][][] suffix3 = (Object[][][])Arrays.copyOf(this.a4[i4], i3);
                Object[][] suffix2 = (Object[][])Arrays.copyOf(this.a4[i4][i3], i2);
                Object[] suffix1 = ImmutableVectors.copyIfDifferentSize(this.a4[i4][i3][i2], i1 + 1);
                int len1 = prefix1.length;
                int len12 = len1 + prefix2.length * 32;
                int len123 = len12 + prefix3.length * 1024;
                return new Vector4(prefix1, len1, prefix2, len12, prefix3, len123, data, suffix3, suffix2, suffix1, realLen);
            }
            if (len <= 0x2000000) {
                int i1 = len - 1 & 0x1F;
                int i2 = len - 1 >>> 5 & 0x1F;
                int i3 = len - 1 >>> 10 & 0x1F;
                int i4 = len - 1 >>> 15 & 0x1F;
                int i5 = len - 1 >>> 20;
                Object[][][][][] data = (Object[][][][][])Arrays.copyOfRange(this.a5, 1, i5);
                Object[][][][] prefix4 = (Object[][][][])ImmutableVectors.copyTail(this.a5[0]);
                Object[][][] prefix3 = (Object[][][])ImmutableVectors.copyTail(this.a5[0][0]);
                Object[][] prefix2 = (Object[][])ImmutableVectors.copyTail(this.a5[0][0][0]);
                Object[] prefix1 = this.a5[0][0][0][0];
                Object[][][][] suffix4 = (Object[][][][])Arrays.copyOf(this.a5[i5], i4);
                Object[][][] suffix3 = (Object[][][])Arrays.copyOf(this.a5[i5][i4], i3);
                Object[][] suffix2 = (Object[][])Arrays.copyOf(this.a5[i5][i4][i3], i2);
                Object[] suffix1 = ImmutableVectors.copyIfDifferentSize(this.a5[i5][i4][i3][i2], i1 + 1);
                int len1 = prefix1.length;
                int len12 = len1 + prefix2.length * 32;
                int len123 = len12 + prefix3.length * 1024;
                int len1234 = len123 + prefix4.length * 32768;
                return new Vector5(prefix1, len1, prefix2, len12, prefix3, len123, prefix4, len1234, data, suffix4, suffix3, suffix2, suffix1, realLen);
            }
            int i1 = len - 1 & 0x1F;
            int i2 = len - 1 >>> 5 & 0x1F;
            int i3 = len - 1 >>> 10 & 0x1F;
            int i4 = len - 1 >>> 15 & 0x1F;
            int i5 = len - 1 >>> 20 & 0x1F;
            int i6 = len - 1 >>> 25;
            Object[][][][][][] data = (Object[][][][][][])Arrays.copyOfRange(this.a6, 1, i6);
            Object[][][][][] prefix5 = (Object[][][][][])ImmutableVectors.copyTail(this.a6[0]);
            Object[][][][] prefix4 = (Object[][][][])ImmutableVectors.copyTail(this.a6[0][0]);
            Object[][][] prefix3 = (Object[][][])ImmutableVectors.copyTail(this.a6[0][0][0]);
            Object[][] prefix2 = (Object[][])ImmutableVectors.copyTail(this.a6[0][0][0][0]);
            Object[] prefix1 = this.a6[0][0][0][0][0];
            Object[][][][][] suffix5 = (Object[][][][][])Arrays.copyOf(this.a6[i6], i5);
            Object[][][][] suffix4 = (Object[][][][])Arrays.copyOf(this.a6[i6][i5], i4);
            Object[][][] suffix3 = (Object[][][])Arrays.copyOf(this.a6[i6][i5][i4], i3);
            Object[][] suffix2 = (Object[][])Arrays.copyOf(this.a6[i6][i5][i4][i3], i2);
            Object[] suffix1 = ImmutableVectors.copyIfDifferentSize(this.a6[i6][i5][i4][i3][i2], i1 + 1);
            int len1 = prefix1.length;
            int len12 = len1 + prefix2.length * 32;
            int len123 = len12 + prefix3.length * 1024;
            int len1234 = len123 + prefix4.length * 32768;
            int len12345 = len1234 + prefix5.length * 0x100000;
            return new Vector6(prefix1, len1, prefix2, len12, prefix3, len123, prefix4, len1234, prefix5, len12345, data, suffix5, suffix4, suffix3, suffix2, suffix1, realLen);
        }

        public String toString() {
            return String.format("ImmutableVector.Builder[len1=%d, lenRest=%d, offset=%d, depth=%d]", this.len1, this.lenRest, this.offset, this.depth);
        }
    }

    static final class VectorSliceBuilder {
        private final int lo;
        private final int hi;
        private final Object[][] slices = new Object[11][];
        private int len = 0;
        private int pos = 0;
        private int maxDim = 0;

        VectorSliceBuilder(int lo, int hi) {
            this.lo = lo;
            this.hi = hi;
        }

        private int prefixIdx(int n) {
            return n - 1;
        }

        private int suffixIdx(int n) {
            return 11 - n;
        }

        public <T> void consider(int n, T[] a) {
            int count = a.length * (1 << 5 * (n - 1));
            int lo0 = Math.max(this.lo - this.pos, 0);
            int hi0 = Math.min(this.hi - this.pos, count);
            if (hi0 > lo0) {
                this.addSlice(n, a, lo0, hi0);
                this.len += hi0 - lo0;
            }
            this.pos += count;
        }

        private <T> void addSlice(int n, T[] a, int lo, int hi) {
            if (n == 1) {
                this.add(1, ImmutableVectors.copyOrUse(a, lo, hi));
            } else {
                int bitsN = 5 * (n - 1);
                int widthN = 1 << bitsN;
                int loN = lo >>> bitsN;
                int hiN = hi >>> bitsN;
                int loRest = lo & widthN - 1;
                int hiRest = hi & widthN - 1;
                if (loRest == 0) {
                    if (hiRest == 0) {
                        this.add(n, ImmutableVectors.copyOrUse(a, loN, hiN));
                    } else {
                        if (hiN > loN) {
                            this.add(n, ImmutableVectors.copyOrUse(a, loN, hiN));
                        }
                        this.addSlice(n - 1, (Object[])a[hiN], 0, hiRest);
                    }
                } else if (hiN == loN) {
                    this.addSlice(n - 1, (Object[])a[loN], loRest, hiRest);
                } else {
                    this.addSlice(n - 1, (Object[])a[loN], loRest, widthN);
                    if (hiRest == 0) {
                        if (hiN > loN + 1) {
                            this.add(n, ImmutableVectors.copyOrUse(a, loN + 1, hiN));
                        }
                    } else {
                        if (hiN > loN + 1) {
                            this.add(n, ImmutableVectors.copyOrUse(a, loN + 1, hiN));
                        }
                        this.addSlice(n - 1, (Object[])a[hiN], 0, hiRest);
                    }
                }
            }
        }

        private <T> void add(int n, T[] a) {
            int idx;
            if (n <= this.maxDim) {
                idx = this.suffixIdx(n);
            } else {
                this.maxDim = n;
                idx = this.prefixIdx(n);
            }
            this.slices[idx] = a;
        }

        public <T> ImmutableVector<T> build() {
            if (this.len <= 32) {
                Object[] a;
                if (this.len == 0) {
                    return ImmutableVector.empty();
                }
                Object[] prefix1 = this.slices[this.prefixIdx(1)];
                Object[] suffix1 = this.slices[this.suffixIdx(1)];
                if (prefix1 != null) {
                    a = suffix1 != null ? ImmutableVectors.concatArrays(prefix1, suffix1) : prefix1;
                } else if (suffix1 != null) {
                    a = suffix1;
                } else {
                    Object[][] prefix2 = (Object[][])this.slices[this.prefixIdx(2)];
                    if (prefix2 != null) {
                        a = prefix2[0];
                    } else {
                        Object[][] suffix2 = (Object[][])this.slices[this.suffixIdx(2)];
                        a = suffix2[0];
                    }
                }
                return new Vector1(a);
            }
            this.balancePrefix(1);
            this.balanceSuffix(1);
            int resultDim = this.maxDim;
            if (resultDim < 6) {
                Object[] pre = this.slices[this.prefixIdx(this.maxDim)];
                Object[] suf = this.slices[this.suffixIdx(this.maxDim)];
                if (pre != null && suf != null) {
                    if (pre.length + suf.length <= 30) {
                        this.slices[this.prefixIdx((int)this.maxDim)] = ImmutableVectors.concatArrays(pre, suf);
                        this.slices[this.suffixIdx((int)this.maxDim)] = null;
                    } else {
                        ++resultDim;
                    }
                } else {
                    Object[] one;
                    Object[] objectArray = one = pre != null ? pre : suf;
                    if (one.length > 30) {
                        ++resultDim;
                    }
                }
            }
            Object[] prefix1 = this.slices[this.prefixIdx(1)];
            Object[] suffix1 = this.slices[this.suffixIdx(1)];
            int len1 = prefix1.length;
            switch (resultDim) {
                case 2: {
                    Object[][] data2 = (Object[][])this.dataOr(2, (T[])empty2);
                    return new Vector2(prefix1, len1, data2, suffix1, this.len);
                }
                case 3: {
                    Object[][] prefix2 = (Object[][])this.prefixOr(2, (T[])empty2);
                    Object[][][] data3 = (Object[][][])this.dataOr(3, (T[])empty3);
                    Object[][] suffix2 = (Object[][])this.suffixOr(2, (T[])empty2);
                    int len12 = len1 + prefix2.length * 32;
                    return new Vector3(prefix1, len1, prefix2, len12, data3, suffix2, suffix1, this.len);
                }
                case 4: {
                    Object[][] prefix2 = (Object[][])this.prefixOr(2, (T[])empty2);
                    Object[][][] prefix3 = (Object[][][])this.prefixOr(3, (T[])empty3);
                    Object[][][][] data4 = (Object[][][][])this.dataOr(4, (T[])empty4);
                    Object[][][] suffix3 = (Object[][][])this.suffixOr(3, (T[])empty3);
                    Object[][] suffix2 = (Object[][])this.suffixOr(2, (T[])empty2);
                    int len12 = len1 + prefix2.length * 32;
                    int len123 = len12 + prefix3.length * 1024;
                    return new Vector4(prefix1, len1, prefix2, len12, prefix3, len123, data4, suffix3, suffix2, suffix1, this.len);
                }
                case 5: {
                    Object[][] prefix2 = (Object[][])this.prefixOr(2, (T[])empty2);
                    Object[][][] prefix3 = (Object[][][])this.prefixOr(3, (T[])empty3);
                    Object[][][][] prefix4 = (Object[][][][])this.prefixOr(4, (T[])empty4);
                    Object[][][][][] data5 = (Object[][][][][])this.dataOr(5, (T[])empty5);
                    Object[][][][] suffix4 = (Object[][][][])this.suffixOr(4, (T[])empty4);
                    Object[][][] suffix3 = (Object[][][])this.suffixOr(3, (T[])empty3);
                    Object[][] suffix2 = (Object[][])this.suffixOr(2, (T[])empty2);
                    int len12 = len1 + prefix2.length * 32;
                    int len123 = len12 + prefix3.length * 1024;
                    int len1234 = len123 + prefix4.length * 32768;
                    return new Vector5(prefix1, len1, prefix2, len12, prefix3, len123, prefix4, len1234, data5, suffix4, suffix3, suffix2, suffix1, this.len);
                }
                case 6: {
                    Object[][] prefix2 = (Object[][])this.prefixOr(2, (T[])empty2);
                    Object[][][] prefix3 = (Object[][][])this.prefixOr(3, (T[])empty3);
                    Object[][][][] prefix4 = (Object[][][][])this.prefixOr(4, (T[])empty4);
                    Object[][][][][] prefix5 = (Object[][][][][])this.prefixOr(5, (T[])empty5);
                    Object[][][][][][] data6 = (Object[][][][][][])this.dataOr(6, (T[])empty6);
                    Object[][][][][] suffix5 = (Object[][][][][])this.suffixOr(5, (T[])empty5);
                    Object[][][][] suffix4 = (Object[][][][])this.suffixOr(4, (T[])empty4);
                    Object[][][] suffix3 = (Object[][][])this.suffixOr(3, (T[])empty3);
                    Object[][] suffix2 = (Object[][])this.suffixOr(2, (T[])empty2);
                    int len12 = len1 + prefix2.length * 32;
                    int len123 = len12 + prefix3.length * 1024;
                    int len1234 = len123 + prefix4.length * 32768;
                    int len12345 = len1234 + prefix5.length * 0x100000;
                    return new Vector6(prefix1, len1, prefix2, len12, prefix3, len123, prefix4, len1234, prefix5, len12345, data6, suffix5, suffix4, suffix3, suffix2, suffix1, this.len);
                }
            }
            throw new AssertionError();
        }

        private <T> T[] prefixOr(int n, T[] a) {
            Object[] p = this.slices[this.prefixIdx(n)];
            if (p != null) {
                return p;
            }
            return a;
        }

        private <T> T[] suffixOr(int n, T[] a) {
            Object[] s = this.slices[this.suffixIdx(n)];
            if (s != null) {
                return s;
            }
            return a;
        }

        private <T> T[] dataOr(int n, T[] a) {
            Object[] p = this.slices[this.prefixIdx(n)];
            if (p != null) {
                return p;
            }
            Object[] s = this.slices[this.suffixIdx(n)];
            if (s != null) {
                return s;
            }
            return a;
        }

        private void balancePrefix(int n) {
            if (this.slices[this.prefixIdx(n)] == null) {
                if (n == this.maxDim) {
                    this.slices[this.prefixIdx((int)n)] = this.slices[this.suffixIdx(n)];
                    this.slices[this.suffixIdx((int)n)] = null;
                } else {
                    this.balancePrefix(n + 1);
                    Object[][] preN1 = (Object[][])this.slices[this.prefixIdx(n + 1)];
                    this.slices[this.prefixIdx((int)n)] = preN1[0];
                    if (preN1.length == 1) {
                        this.slices[this.prefixIdx((int)(n + 1))] = null;
                        if (this.maxDim == n + 1 && this.slices[this.suffixIdx(n + 1)] == null) {
                            this.maxDim = n;
                        }
                    } else {
                        this.slices[this.prefixIdx((int)(n + 1))] = Arrays.copyOfRange(preN1, 1, preN1.length);
                    }
                }
            }
        }

        private void balanceSuffix(int n) {
            if (this.slices[this.suffixIdx(n)] == null) {
                if (n == this.maxDim) {
                    this.slices[this.suffixIdx((int)n)] = this.slices[this.prefixIdx(n)];
                    this.slices[this.prefixIdx((int)n)] = null;
                } else {
                    this.balanceSuffix(n + 1);
                    Object[][] sufN1 = (Object[][])this.slices[this.suffixIdx(n + 1)];
                    this.slices[this.suffixIdx((int)n)] = sufN1[sufN1.length - 1];
                    if (sufN1.length == 1) {
                        this.slices[this.suffixIdx((int)(n + 1))] = null;
                        if (this.maxDim == n + 1 && this.slices[this.prefixIdx(n + 1)] == null) {
                            this.maxDim = n;
                        }
                    } else {
                        this.slices[this.suffixIdx((int)(n + 1))] = Arrays.copyOfRange(sufN1, 0, sufN1.length - 1);
                    }
                }
            }
        }
    }

    static final class Vector6<E>
    extends BigVector<E> {
        final int len1;
        final Object[][] prefix2;
        final int len12;
        final Object[][][] prefix3;
        final int len123;
        final Object[][][][] prefix4;
        final int len1234;
        final Object[][][][][] prefix5;
        final int len12345;
        final Object[][][][][][] data6;
        final Object[][][][][] suffix5;
        final Object[][][][] suffix4;
        final Object[][][] suffix3;
        final Object[][] suffix2;

        Vector6(Object[] prefix1, int len1, Object[][] prefix2, int len12, Object[][][] prefix3, int len123, Object[][][][] prefix4, int len1234, Object[][][][][] prefix5, int len12345, Object[][][][][][] data6, Object[][][][][] suffix5, Object[][][][] suffix4, Object[][][] suffix3, Object[][] suffix2, Object[] suffix1, int length0) {
            super(prefix1, suffix1, length0);
            this.len1 = len1;
            this.prefix2 = prefix2;
            this.len12 = len12;
            this.prefix3 = prefix3;
            this.len123 = len123;
            this.prefix4 = prefix4;
            this.len1234 = len1234;
            this.prefix5 = prefix5;
            this.len12345 = len12345;
            this.data6 = data6;
            this.suffix5 = suffix5;
            this.suffix4 = suffix4;
            this.suffix3 = suffix3;
            this.suffix2 = suffix2;
        }

        @Override
        int vectorSliceCount() {
            return 11;
        }

        @Override
        Object[] vectorSlice(int idx) {
            switch (idx) {
                case 0: {
                    return this.prefix1;
                }
                case 1: {
                    return this.prefix2;
                }
                case 2: {
                    return this.prefix3;
                }
                case 3: {
                    return this.prefix4;
                }
                case 4: {
                    return this.prefix5;
                }
                case 5: {
                    return this.data6;
                }
                case 6: {
                    return this.suffix5;
                }
                case 7: {
                    return this.suffix4;
                }
                case 8: {
                    return this.suffix3;
                }
                case 9: {
                    return this.suffix2;
                }
                case 10: {
                    return this.suffix1;
                }
            }
            throw new AssertionError();
        }

        @Override
        int vectorSlicePrefixLength(int idx) {
            switch (idx) {
                case 0: {
                    return this.len1;
                }
                case 1: {
                    return this.len12;
                }
                case 2: {
                    return this.len123;
                }
                case 3: {
                    return this.len1234;
                }
                case 4: {
                    return this.len12345;
                }
                case 5: {
                    return this.len12345 + this.data6.length * 0x2000000;
                }
                case 6: {
                    return this.len12345 + this.data6.length * 0x2000000 + this.suffix5.length * 0x100000;
                }
                case 7: {
                    return this.len12345 + this.data6.length * 0x2000000 + this.suffix5.length * 0x100000 + this.suffix4.length * 32768;
                }
                case 8: {
                    return this.len12345 + this.data6.length * 0x2000000 + this.suffix5.length * 0x100000 + this.suffix4.length * 32768 + this.suffix3.length * 1024;
                }
                case 9: {
                    return this.length0 - this.suffix1.length;
                }
                case 10: {
                    return this.length0;
                }
            }
            throw new AssertionError();
        }

        @Override
        public E get(int index) {
            Conditions.checkElementIndex((int)index, (int)this.length0);
            int io = index - this.len12345;
            if (io >= 0) {
                int i6 = io >>> 25;
                int i5 = io >>> 20 & 0x1F;
                int i4 = io >>> 15 & 0x1F;
                int i3 = io >>> 10 & 0x1F;
                int i2 = io >>> 5 & 0x1F;
                int i1 = io & 0x1F;
                if (i6 < this.data6.length) {
                    return (E)this.data6[i6][i5][i4][i3][i2][i1];
                }
                if (i5 < this.suffix5.length) {
                    return (E)this.suffix5[i5][i4][i3][i2][i1];
                }
                if (i4 < this.suffix4.length) {
                    return (E)this.suffix4[i4][i3][i2][i1];
                }
                if (i3 < this.suffix3.length) {
                    return (E)this.suffix3[i3][i2][i1];
                }
                if (i2 < this.suffix2.length) {
                    return (E)this.suffix2[i2][i1];
                }
                return (E)this.suffix1[i1];
            }
            if (index >= this.len1234) {
                io = index - this.len1234;
                return (E)this.prefix5[io >>> 20][io >>> 15 & 0x1F][io >>> 10 & 0x1F][io >>> 5 & 0x1F][io & 0x1F];
            }
            if (index >= this.len123) {
                io = index - this.len123;
                return (E)this.prefix4[io >>> 15][io >>> 10 & 0x1F][io >>> 5 & 0x1F][io & 0x1F];
            }
            if (index >= this.len12) {
                io = index - this.len12;
                return (E)this.prefix3[io >>> 10][io >>> 5 & 0x1F][io & 0x1F];
            }
            if (index >= this.len1) {
                io = index - this.len1;
                return (E)this.prefix2[io >>> 5][io & 0x1F];
            }
            return (E)this.prefix1[index];
        }

        @Override
        @NotNull
        ImmutableVector<E> slice0(int lo, int hi) {
            VectorSliceBuilder b = new VectorSliceBuilder(lo, hi);
            b.consider(1, this.prefix1);
            b.consider(2, (T[])this.prefix2);
            b.consider(3, (T[])this.prefix3);
            b.consider(4, (T[])this.prefix4);
            b.consider(5, (T[])this.prefix5);
            b.consider(6, (T[])this.data6);
            b.consider(5, (T[])this.suffix5);
            b.consider(4, (T[])this.suffix4);
            b.consider(3, (T[])this.suffix3);
            b.consider(2, (T[])this.suffix2);
            b.consider(1, this.suffix1);
            return b.build();
        }
    }

    static final class Vector5<E>
    extends BigVector<E> {
        final int len1;
        final Object[][] prefix2;
        final int len12;
        final Object[][][] prefix3;
        final int len123;
        final Object[][][][] prefix4;
        final int len1234;
        final Object[][][][][] data5;
        final Object[][][][] suffix4;
        final Object[][][] suffix3;
        final Object[][] suffix2;

        Vector5(Object[] prefix1, int len1, Object[][] prefix2, int len12, Object[][][] prefix3, int len123, Object[][][][] prefix4, int len1234, Object[][][][][] data5, Object[][][][] suffix4, Object[][][] suffix3, Object[][] suffix2, Object[] suffix1, int length0) {
            super(prefix1, suffix1, length0);
            this.len1 = len1;
            this.prefix2 = prefix2;
            this.len12 = len12;
            this.prefix3 = prefix3;
            this.len123 = len123;
            this.prefix4 = prefix4;
            this.len1234 = len1234;
            this.data5 = data5;
            this.suffix4 = suffix4;
            this.suffix3 = suffix3;
            this.suffix2 = suffix2;
        }

        @Override
        int vectorSliceCount() {
            return 9;
        }

        @Override
        Object[] vectorSlice(int idx) {
            switch (idx) {
                case 0: {
                    return this.prefix1;
                }
                case 1: {
                    return this.prefix2;
                }
                case 2: {
                    return this.prefix3;
                }
                case 3: {
                    return this.prefix4;
                }
                case 4: {
                    return this.data5;
                }
                case 5: {
                    return this.suffix4;
                }
                case 6: {
                    return this.suffix3;
                }
                case 7: {
                    return this.suffix2;
                }
                case 8: {
                    return this.suffix1;
                }
            }
            throw new AssertionError();
        }

        @Override
        int vectorSlicePrefixLength(int idx) {
            switch (idx) {
                case 0: {
                    return this.len1;
                }
                case 1: {
                    return this.len12;
                }
                case 2: {
                    return this.len123;
                }
                case 3: {
                    return this.len1234;
                }
                case 4: {
                    return this.len1234 + this.data5.length * 0x100000;
                }
                case 5: {
                    return this.len1234 + this.data5.length * 0x100000 + this.suffix4.length * 32768;
                }
                case 6: {
                    return this.len1234 + this.data5.length * 0x100000 + this.suffix4.length * 32768 + this.suffix3.length * 1024;
                }
                case 7: {
                    return this.length0 - this.suffix1.length;
                }
                case 8: {
                    return this.length0;
                }
            }
            throw new AssertionError();
        }

        @Override
        public E get(int index) {
            Conditions.checkElementIndex((int)index, (int)this.length0);
            int io = index - this.len1234;
            if (io >= 0) {
                int i5 = io >>> 20;
                int i4 = io >>> 15 & 0x1F;
                int i3 = io >>> 10 & 0x1F;
                int i2 = io >>> 5 & 0x1F;
                int i1 = io & 0x1F;
                if (i5 < this.data5.length) {
                    return (E)this.data5[i5][i4][i3][i2][i1];
                }
                if (i4 < this.suffix4.length) {
                    return (E)this.suffix4[i4][i3][i2][i1];
                }
                if (i3 < this.suffix3.length) {
                    return (E)this.suffix3[i3][i2][i1];
                }
                if (i2 < this.suffix2.length) {
                    return (E)this.suffix2[i2][i1];
                }
                return (E)this.suffix1[i1];
            }
            if (index >= this.len123) {
                io = index - this.len123;
                return (E)this.prefix4[io >>> 15][io >>> 10 & 0x1F][io >>> 5 & 0x1F][io & 0x1F];
            }
            if (index >= this.len12) {
                io = index - this.len12;
                return (E)this.prefix3[io >>> 10][io >>> 5 & 0x1F][io & 0x1F];
            }
            if (index >= this.len1) {
                io = index - this.len1;
                return (E)this.prefix2[io >>> 5][io & 0x1F];
            }
            return (E)this.prefix1[index];
        }

        @Override
        @NotNull
        ImmutableVector<E> slice0(int lo, int hi) {
            VectorSliceBuilder b = new VectorSliceBuilder(lo, hi);
            b.consider(1, this.prefix1);
            b.consider(2, (T[])this.prefix2);
            b.consider(3, (T[])this.prefix3);
            b.consider(4, (T[])this.prefix4);
            b.consider(5, (T[])this.data5);
            b.consider(4, (T[])this.suffix4);
            b.consider(3, (T[])this.suffix3);
            b.consider(2, (T[])this.suffix2);
            b.consider(1, this.suffix1);
            return b.build();
        }
    }

    static final class Vector4<E>
    extends BigVector<E> {
        final int len1;
        final Object[][] prefix2;
        final int len12;
        final Object[][][] prefix3;
        final int len123;
        final Object[][][][] data4;
        final Object[][][] suffix3;
        final Object[][] suffix2;

        Vector4(Object[] prefix1, int len1, Object[][] prefix2, int len12, Object[][][] prefix3, int len123, Object[][][][] data4, Object[][][] suffix3, Object[][] suffix2, Object[] suffix1, int length0) {
            super(prefix1, suffix1, length0);
            this.len1 = len1;
            this.prefix2 = prefix2;
            this.len12 = len12;
            this.prefix3 = prefix3;
            this.len123 = len123;
            this.data4 = data4;
            this.suffix3 = suffix3;
            this.suffix2 = suffix2;
        }

        @Override
        int vectorSliceCount() {
            return 7;
        }

        @Override
        Object[] vectorSlice(int idx) {
            switch (idx) {
                case 0: {
                    return this.prefix1;
                }
                case 1: {
                    return this.prefix2;
                }
                case 2: {
                    return this.prefix3;
                }
                case 3: {
                    return this.data4;
                }
                case 4: {
                    return this.suffix3;
                }
                case 5: {
                    return this.suffix2;
                }
                case 6: {
                    return this.suffix1;
                }
            }
            throw new AssertionError();
        }

        @Override
        int vectorSlicePrefixLength(int idx) {
            switch (idx) {
                case 0: {
                    return this.len1;
                }
                case 1: {
                    return this.len12;
                }
                case 2: {
                    return this.len123;
                }
                case 3: {
                    return this.len123 + this.data4.length * 32768;
                }
                case 4: {
                    return this.len123 + this.data4.length * 32768 + this.suffix3.length * 1024;
                }
                case 5: {
                    return this.length0 - this.suffix1.length;
                }
                case 6: {
                    return this.length0;
                }
            }
            throw new AssertionError();
        }

        @Override
        public E get(int index) {
            Conditions.checkElementIndex((int)index, (int)this.length0);
            int io = index - this.len123;
            if (io >= 0) {
                int i4 = io >>> 15;
                int i3 = io >>> 10 & 0x1F;
                int i2 = io >>> 5 & 0x1F;
                int i1 = io & 0x1F;
                if (i4 < this.data4.length) {
                    return (E)this.data4[i4][i3][i2][i1];
                }
                if (i3 < this.suffix3.length) {
                    return (E)this.suffix3[i3][i2][i1];
                }
                if (i2 < this.suffix2.length) {
                    return (E)this.suffix2[i2][i1];
                }
                return (E)this.suffix1[i1];
            }
            if (index >= this.len12) {
                io = index - this.len12;
                return (E)this.prefix3[io >>> 10][io >>> 5 & 0x1F][io & 0x1F];
            }
            if (index >= this.len1) {
                io = index - this.len1;
                return (E)this.prefix2[io >>> 5][io & 0x1F];
            }
            return (E)this.prefix1[index];
        }

        @Override
        @NotNull
        ImmutableVector<E> slice0(int lo, int hi) {
            VectorSliceBuilder b = new VectorSliceBuilder(lo, hi);
            b.consider(1, this.prefix1);
            b.consider(2, (T[])this.prefix2);
            b.consider(3, (T[])this.prefix3);
            b.consider(4, (T[])this.data4);
            b.consider(3, (T[])this.suffix3);
            b.consider(2, (T[])this.suffix2);
            b.consider(1, this.suffix1);
            return b.build();
        }
    }

    static final class Vector3<E>
    extends BigVector<E> {
        final int len1;
        final Object[][] prefix2;
        final int len12;
        final Object[][][] data3;
        final Object[][] suffix2;

        Vector3(Object[] prefix1, int len1, Object[][] prefix2, int len12, Object[][][] data3, Object[][] suffix2, Object[] suffix1, int length0) {
            super(prefix1, suffix1, length0);
            this.len1 = len1;
            this.prefix2 = prefix2;
            this.len12 = len12;
            this.data3 = data3;
            this.suffix2 = suffix2;
        }

        @Override
        int vectorSliceCount() {
            return 5;
        }

        @Override
        Object[] vectorSlice(int idx) {
            switch (idx) {
                case 0: {
                    return this.prefix1;
                }
                case 1: {
                    return this.prefix2;
                }
                case 2: {
                    return this.data3;
                }
                case 3: {
                    return this.suffix2;
                }
                case 4: {
                    return this.suffix1;
                }
            }
            throw new AssertionError();
        }

        @Override
        int vectorSlicePrefixLength(int idx) {
            switch (idx) {
                case 0: {
                    return this.len1;
                }
                case 1: {
                    return this.len12;
                }
                case 2: {
                    return this.len12 + this.data3.length * 1024;
                }
                case 3: {
                    return this.length0 - this.suffix1.length;
                }
                case 4: {
                    return this.length0;
                }
            }
            throw new AssertionError();
        }

        @Override
        public E get(int index) {
            Conditions.checkElementIndex((int)index, (int)this.length0);
            int io = index - this.len12;
            if (io >= 0) {
                int i3 = io >>> 10;
                int i2 = io >>> 5 & 0x1F;
                int i1 = io & 0x1F;
                if (i3 < this.data3.length) {
                    return (E)this.data3[i3][i2][i1];
                }
                if (i2 < this.suffix2.length) {
                    return (E)this.suffix2[i2][i1];
                }
                return (E)this.suffix1[i1];
            }
            if (index >= this.len1) {
                io = index - this.len1;
                return (E)this.prefix2[io >>> 5][io & 0x1F];
            }
            return (E)this.prefix1[index];
        }

        @Override
        @NotNull
        ImmutableVector<E> slice0(int lo, int hi) {
            VectorSliceBuilder b = new VectorSliceBuilder(lo, hi);
            b.consider(1, this.prefix1);
            b.consider(2, (T[])this.prefix2);
            b.consider(3, (T[])this.data3);
            b.consider(2, (T[])this.suffix2);
            b.consider(1, this.suffix1);
            return b.build();
        }
    }

    static final class Vector2<E>
    extends BigVector<E> {
        private final int len1;
        private final Object[] @NotNull [] data2;

        Vector2(Object @NotNull [] prefix1, int len1, Object[] @NotNull [] data2, Object @NotNull [] suffix1, int length0) {
            super(prefix1, suffix1, length0);
            this.len1 = len1;
            this.data2 = data2;
        }

        @Override
        int vectorSliceCount() {
            return 3;
        }

        @Override
        Object[] vectorSlice(int idx) {
            switch (idx) {
                case 0: {
                    return this.prefix1;
                }
                case 1: {
                    return this.data2;
                }
                case 2: {
                    return this.suffix1;
                }
            }
            throw new AssertionError();
        }

        @Override
        int vectorSlicePrefixLength(int idx) {
            switch (idx) {
                case 0: {
                    return this.len1;
                }
                case 1: {
                    return this.length0 - this.suffix1.length;
                }
                case 2: {
                    return this.length0;
                }
            }
            throw new AssertionError();
        }

        @Override
        public E get(int index) {
            Conditions.checkElementIndex((int)index, (int)this.length0);
            int io = index - this.len1;
            if (io >= 0) {
                int i2 = io >>> 5;
                int i1 = io & 0x1F;
                if (i2 < this.data2.length) {
                    return (E)this.data2[i2][i1];
                }
                return (E)this.suffix1[io & 0x1F];
            }
            return (E)this.prefix1[index];
        }

        @Override
        @NotNull
        ImmutableVector<E> slice0(int lo, int hi) {
            VectorSliceBuilder b = new VectorSliceBuilder(lo, hi);
            b.consider(1, this.prefix1);
            b.consider(2, (T[])this.data2);
            b.consider(1, this.suffix1);
            return b.build();
        }
    }

    @Debug.Renderer(hasChildren="true", childrenArray="toArray()")
    static abstract class BigVector<E>
    extends ImmutableVector<E> {
        final Object[] suffix1;
        final int length0;

        BigVector(Object[] prefix1, Object[] suffix1, int length0) {
            super(prefix1);
            this.suffix1 = suffix1;
            this.length0 = length0;
        }

        @Override
        @NotNull
        public final Iterator<E> iterator() {
            return new Itr(this, this.length0, this.vectorSliceCount());
        }

        @Override
        @NotNull
        public final Spliterator<E> spliterator() {
            return new Itr(this, this.length0, this.vectorSliceCount());
        }

        public final int size() {
            return this.length0;
        }

        @Override
        public final E first() {
            return (E)this.prefix1[0];
        }

        @Override
        @Nullable
        public E firstOrNull() {
            return this.first();
        }

        @Override
        @NotNull
        public Option<E> firstOption() {
            return Option.some((Object)this.prefix1[0]);
        }

        @Override
        public final E last() {
            return (E)this.suffix1[this.suffix1.length - 1];
        }

        @Override
        @Nullable
        public E lastOrNull() {
            return this.last();
        }

        @Override
        @NotNull
        public Option<E> lastOption() {
            return Option.some((Object)this.suffix1[this.suffix1.length - 1]);
        }

        @Override
        final ImmutableVector<E> filterImpl(Predicate<? super E> predicate, boolean isFlipped) {
            Object[] prefix1 = this.prefix1;
            int len = prefix1.length;
            for (int i = 0; i != len; ++i) {
                int k;
                if (predicate.test(prefix1[i]) != isFlipped) continue;
                int bitmap = 0;
                for (int j = i + 1; j < len; ++j) {
                    if (predicate.test(prefix1[j]) == isFlipped) continue;
                    bitmap |= 1 << j;
                }
                int newLen = i + Integer.bitCount(bitmap);
                VectorBuilder<Object> b = new VectorBuilder<Object>();
                for (k = 0; k < i; ++k) {
                    b.add(prefix1[k]);
                }
                k = i + 1;
                while (i != newLen) {
                    if ((1 << k & bitmap) != 0) {
                        b.add(prefix1[k]);
                        ++i;
                    }
                    ++k;
                }
                this.forEachRest(v -> {
                    if (predicate.test(v) != isFlipped) {
                        b.add(v);
                    }
                });
                return b.build();
            }
            VectorBuilder b = new VectorBuilder();
            b.initFrom(prefix1);
            this.forEachRest(v -> {
                if (predicate.test(v) != isFlipped) {
                    b.add(v);
                }
            });
            return b.build();
        }

        @Override
        public final void forEach(@NotNull Consumer<? super E> action) {
            int c = this.vectorSliceCount();
            for (int i = 0; i < c; ++i) {
                ImmutableVectors.forEachRec(ImmutableVectors.vectorSliceDim(c, i) - 1, this.vectorSlice(i), action);
            }
        }

        private void forEachRest(@NotNull Consumer<? super E> action) {
            int c = this.vectorSliceCount();
            for (int i = 1; i < c; ++i) {
                ImmutableVectors.forEachRec(ImmutableVectors.vectorSliceDim(c, i) - 1, this.vectorSlice(i), action);
            }
        }
    }

    @Debug.Renderer(hasChildren="true", childrenArray="prefix1")
    static final class Vector1<E>
    extends ImmutableVector<E> {
        private static final long serialVersionUID = -2956354586637109936L;

        Vector1(Object[] prefix1) {
            super(prefix1);
        }

        @Override
        int vectorSliceCount() {
            return 1;
        }

        @Override
        Object[] vectorSlice(int idx) {
            return this.prefix1;
        }

        @Override
        int vectorSlicePrefixLength(int idx) {
            return this.prefix1.length;
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return GenericArrays.iterator((Object[])this.prefix1);
        }

        @Override
        @NotNull
        public Spliterator<E> spliterator() {
            return Arrays.spliterator(this.prefix1);
        }

        public int size() {
            return this.prefix1.length;
        }

        @Override
        public E get(int index) {
            try {
                return (E)this.prefix1[index];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException();
            }
        }

        @Override
        @NotNull
        public ImmutableVector<E> reversed() {
            return new Vector1<E>(ObjectArrays.reversed((Object[])this.prefix1));
        }

        @Override
        @NotNull
        public ImmutableVector<E> appended(E value) {
            Object[] prefix1 = this.prefix1;
            int len1 = prefix1.length;
            if (len1 < 32) {
                return new Vector1<E>(ImmutableVectors.copyAppend1(prefix1, value));
            }
            return new Vector2(prefix1, 32, empty2, ImmutableVectors.wrap1(value), 33);
        }

        @Override
        @NotNull
        public ImmutableVector<E> appendedAll(E @NotNull [] values) {
            int vl = values.length;
            if (vl == 0) {
                return this;
            }
            Object[] prefix1 = this.prefix1;
            int size = prefix1.length;
            if (size + vl <= 32) {
                Object[] res = new Object[size + vl];
                System.arraycopy(prefix1, 0, res, 0, size);
                System.arraycopy(values, 0, res, size, vl);
                return new Vector1<E>(res);
            }
            VectorBuilder builder = new VectorBuilder();
            builder.initFrom(this);
            builder.addAll(values);
            return builder.build();
        }

        @Override
        @NotNull
        public ImmutableVector<E> prepended(E value) {
            Object[] prefix1 = this.prefix1;
            int len1 = prefix1.length;
            if (len1 < 32) {
                return new Vector1<E>(ImmutableVectors.copyPrepend1(value, prefix1));
            }
            return new Vector2(ImmutableVectors.wrap1(value), 1, empty2, prefix1, len1 + 1);
        }

        @Override
        @NotNull
        public ImmutableVector<E> prependedAll(E @NotNull [] values) {
            int vl = values.length;
            if (vl == 0) {
                return this;
            }
            Object[] prefix1 = this.prefix1;
            int size = prefix1.length;
            if (size + vl <= 32) {
                Object[] res = new Object[vl + size];
                System.arraycopy(values, 0, res, 0, vl);
                System.arraycopy(prefix1, 0, res, vl, size);
                return new Vector1<E>(res);
            }
            VectorBuilder builder = new VectorBuilder();
            builder.addAll(values);
            builder.addVector(this);
            return builder.build();
        }

        @Override
        public E first() {
            return (E)this.prefix1[0];
        }

        @Override
        @Nullable
        public E firstOrNull() {
            return this.first();
        }

        @Override
        @NotNull
        public Option<E> firstOption() {
            return Option.some((Object)this.prefix1[0]);
        }

        @Override
        public E last() {
            return (E)this.prefix1[this.prefix1.length - 1];
        }

        @Override
        @Nullable
        public E lastOrNull() {
            return this.last();
        }

        @Override
        @NotNull
        public Option<E> lastOption() {
            return Option.some((Object)this.prefix1[this.prefix1.length - 1]);
        }

        @Override
        @NotNull
        ImmutableVector<E> slice0(int lo, int hi) {
            Object[] elements = this.prefix1;
            int size = elements.length;
            int newSize = hi - lo;
            Object[] res = new Object[newSize];
            System.arraycopy(elements, lo, res, 0, newSize);
            return new Vector1<E>(res);
        }

        @Override
        @NotNull
        public ImmutableVector<E> updated(int index, E newValue) {
            Object[] prefix1 = this.prefix1;
            int size = prefix1.length;
            Conditions.checkElementIndex((int)index, (int)size);
            Object[] res = (Object[])prefix1.clone();
            res[index] = newValue;
            return new Vector1<E>(res);
        }

        @Override
        ImmutableVector<E> filterImpl(Predicate<? super E> predicate, boolean isFlipped) {
            Object[] prefix1 = this.prefix1;
            int size = prefix1.length;
            Object[] temp = new Object[size];
            int c = 0;
            for (Object value : prefix1) {
                Object v = value;
                if (predicate.test(v) == isFlipped) continue;
                temp[c++] = v;
            }
            if (c == 0) {
                return Vector1.empty();
            }
            if (c == size) {
                return this;
            }
            return new Vector1<E>(Arrays.copyOf(temp, c));
        }

        @Override
        @NotNull
        public <U> ImmutableVector<U> map(@NotNull Function<? super E, ? extends U> mapper) {
            Object[] prefix1 = this.prefix1;
            int size = prefix1.length;
            Object[] res = new Object[size];
            for (int i = 0; i < size; ++i) {
                res[i] = mapper.apply(prefix1[i]);
            }
            return new Vector1<E>(res);
        }

        @Override
        @NotNull
        public <U> @NotNull ImmutableVector<@NotNull U> mapNotNull(@NotNull Function<? super E, ? extends @Nullable U> mapper) {
            Object[] prefix1 = this.prefix1;
            int size = prefix1.length;
            int n = 0;
            Object[] tmp = new Object[size];
            for (Object o : prefix1) {
                U u = mapper.apply(o);
                if (u == null) continue;
                tmp[n++] = u;
            }
            if (n == 0) {
                return ImmutableVector.empty();
            }
            if (n == size) {
                return new Vector1<E>(tmp);
            }
            return new Vector1<E>(Arrays.copyOf(tmp, n));
        }

        @Override
        @NotNull
        public <U> ImmutableVector<U> mapIndexed(@NotNull IndexedFunction<? super E, ? extends U> mapper) {
            Object[] prefix1 = this.prefix1;
            int size = prefix1.length;
            Object[] res = new Object[size];
            for (int i = 0; i < size; ++i) {
                res[i] = mapper.apply(i, prefix1[i]);
            }
            return new Vector1<E>(res);
        }

        @Override
        @NotNull
        public <U> @NotNull ImmutableVector<@NotNull U> mapIndexedNotNull(@NotNull IndexedFunction<? super E, ? extends @Nullable U> mapper) {
            Object[] prefix1 = this.prefix1;
            int size = prefix1.length;
            int n = 0;
            Object[] tmp = new Object[size];
            for (int i = 0; i < size; ++i) {
                Object u = mapper.apply(i, prefix1[i]);
                if (u == null) continue;
                tmp[n++] = u;
            }
            if (n == 0) {
                return ImmutableVector.empty();
            }
            if (n == size) {
                return new Vector1<E>(tmp);
            }
            return new Vector1<E>(Arrays.copyOf(tmp, n));
        }

        @Override
        public void forEach(@NotNull Consumer<? super E> action) {
            for (Object element : this.prefix1) {
                action.accept(element);
            }
        }

        @Override
        public void forEachIndexed(@NotNull IndexedConsumer<? super E> action) {
            Object[] prefix1 = this.prefix1;
            int size = prefix1.length;
            for (int i = 0; i < size; ++i) {
                action.accept(i, prefix1[i]);
            }
        }
    }

    @Debug.Renderer(hasChildren="false", childrenArray="new Object[0]")
    static final class Vector0
    extends ImmutableVector<Object> {
        private static final long serialVersionUID = 6286060267578716429L;
        static final Vector0 INSTANCE = new Vector0();

        private Vector0() {
            super(ObjectArrays.EMPTY);
        }

        @Override
        int vectorSliceCount() {
            return 0;
        }

        @Override
        Object[] vectorSlice(int idx) {
            return null;
        }

        @Override
        int vectorSlicePrefixLength(int idx) {
            return 0;
        }

        @Override
        @NotNull
        public Iterator<Object> iterator() {
            return Iterators.empty();
        }

        @Override
        @NotNull
        public Spliterator<Object> spliterator() {
            return Spliterators.emptySpliterator();
        }

        public int size() {
            return 0;
        }

        @Override
        public Object get(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        @NotNull
        public ImmutableVector<Object> reversed() {
            return this;
        }

        @Override
        @NotNull
        public ImmutableVector<Object> appended(Object value) {
            return new Vector1<Object>(new Object[]{value});
        }

        @Override
        @NotNull
        public ImmutableVector<Object> appendedAll(Object @NotNull [] values) {
            return Vector0.from(values);
        }

        @Override
        @NotNull
        public ImmutableVector<Object> appendedAll(@NotNull ImmutableVector<?> values) {
            return Objects.requireNonNull(values);
        }

        @Override
        @NotNull
        public ImmutableVector<Object> appendedAll(@NotNull Iterable<?> values) {
            return Vector0.from(values);
        }

        @Override
        @NotNull
        public ImmutableVector<Object> prepended(Object value) {
            return new Vector1<Object>(new Object[]{value});
        }

        @Override
        @NotNull
        public ImmutableVector<Object> prependedAll(@NotNull Iterable<?> values) {
            return Vector0.from(values);
        }

        @Override
        @NotNull
        public ImmutableVector<Object> prependedAll(@NotNull ImmutableVector<?> values) {
            return Objects.requireNonNull(values);
        }

        @Override
        @NotNull
        public ImmutableVector<Object> prependedAll(Object @NotNull [] values) {
            return Vector0.from(values);
        }

        @Override
        @NotNull
        ImmutableVector<Object> slice0(int lo, int hi) {
            throw new AssertionError();
        }

        @Override
        ImmutableVector<Object> filterImpl(Predicate<? super Object> predicate, boolean isFlipped) {
            return this;
        }

        @Override
        @NotNull
        public <U> ImmutableVector<U> map(@NotNull Function<? super Object, ? extends U> mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> @NotNull ImmutableVector<@NotNull U> mapNotNull(@NotNull Function<? super Object, ? extends @Nullable U> mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> ImmutableVector<U> mapIndexed(@NotNull IndexedFunction<? super Object, ? extends U> mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> @NotNull ImmutableVector<@NotNull U> mapIndexedNotNull(@NotNull IndexedFunction<? super Object, ? extends @Nullable U> mapper) {
            return this;
        }

        @Override
        public void forEach(@NotNull Consumer<? super Object> action) {
        }

        @Override
        public void forEachIndexed(@NotNull IndexedConsumer<? super Object> action) {
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

