/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.internal.convert;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import kala.collection.Collection;
import kala.collection.Map;
import kala.collection.Seq;
import kala.collection.Set;
import kala.collection.SortedSet;
import kala.collection.mutable.MutableCollection;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableSeq;
import kala.collection.mutable.MutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AsJavaConvert {

    public static class MutableMapAsJava<K, V, C extends MutableMap<K, V>>
    extends MapAsJava<K, V, C> {
        public MutableMapAsJava(@NotNull C source) {
            super(source);
        }

        @Override
        @Nullable
        public V put(K key, V value) {
            return (V)((MutableMap)this.source).put(key, value).getOrNull();
        }

        @Override
        public void putAll(@NotNull java.util.Map<? extends K, ? extends V> m) {
            ((MutableMap)this.source).putAll(m);
        }

        @Override
        public V remove(Object key) {
            return (V)((MutableMap)this.source).remove(key).getOrNull();
        }

        @Override
        public void clear() {
            ((MutableMap)this.source).clear();
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            return ((MutableMap)this.source).replace(key, oldValue, newValue);
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            ((MutableMap)this.source).replaceAll(function);
        }
    }

    public static class MapAsJava<K, V, C extends Map<K, V>>
    extends AbstractMap<K, V> {
        public final C source;

        public MapAsJava(@NotNull C source) {
            this.source = source;
        }

        @Override
        public final boolean isEmpty() {
            return this.source.isEmpty();
        }

        @Override
        public final int size() {
            return this.source.size();
        }

        @Override
        public final boolean containsKey(Object key) {
            try {
                return this.source.containsKey(key);
            }
            catch (ClassCastException ignored) {
                return false;
            }
        }

        @Override
        public boolean containsValue(Object value) {
            try {
                return this.source.containsValue(value);
            }
            catch (ClassCastException ignored) {
                return false;
            }
        }

        @Override
        public final V get(Object key) {
            try {
                return (V)this.source.getOrNull(key);
            }
            catch (ClassCastException ignored) {
                return null;
            }
        }

        @Override
        @NotNull
        public java.util.Set<Map.Entry<K, V>> entrySet() {
            return new EntrySet(this.source);
        }

        public static class EntrySet<K, V, M extends Map<K, V>>
        extends AbstractSet<Map.Entry<K, V>> {
            protected final M source;

            public EntrySet(M source) {
                this.source = source;
            }

            @Override
            @NotNull
            public Iterator<Map.Entry<K, V>> iterator() {
                return this.source.iterator();
            }

            @Override
            public final boolean isEmpty() {
                return this.source.isEmpty();
            }

            @Override
            public final int size() {
                return this.source.size();
            }

            @Override
            public final boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                try {
                    return this.source.contains(entry.getKey(), entry.getValue());
                }
                catch (Throwable e) {
                    return false;
                }
            }
        }
    }

    public static class MutableSetAsJava<E, C extends MutableSet<E>>
    extends SetAsJava<E, C>
    implements java.util.Set<E> {
        public MutableSetAsJava(C source) {
            super(source);
        }

        @Override
        public boolean add(E e) {
            return ((MutableSet)this.source).add(e);
        }

        @Override
        public boolean remove(Object o) {
            return ((MutableSet)this.source).remove(o);
        }

        @Override
        public boolean addAll(@NotNull java.util.Collection<? extends E> c) {
            return ((MutableSet)this.source).addAll(c);
        }

        @Override
        public boolean removeAll(@NotNull java.util.Collection<?> c) {
            return ((MutableSet)this.source).removeAll(c);
        }

        @Override
        public boolean retainAll(@NotNull java.util.Collection<?> c) {
            return super.retainAll(c);
        }

        @Override
        public final void clear() {
            ((MutableSet)this.source).clear();
        }
    }

    public static class MutableSortedSetAsJava<E, C extends MutableSet<E> & SortedSet<E>>
    extends SortedSetAsJava<E, C>
    implements java.util.SortedSet<E> {
        public MutableSortedSetAsJava(@NotNull C collection) {
            super(collection);
        }
    }

    public static class SortedSetAsJava<E, C extends SortedSet<E>>
    extends CollectionAsJava<E, C>
    implements java.util.SortedSet<E> {
        public SortedSetAsJava(@NotNull C collection) {
            super(collection);
        }

        @Override
        @Nullable
        public Comparator<? super E> comparator() {
            return ((SortedSet)this.source).comparator();
        }

        @Override
        @NotNull
        public java.util.SortedSet<E> subSet(E fromElement, E toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public java.util.SortedSet<E> headSet(E toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public java.util.SortedSet<E> tailSet(E fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E first() {
            return ((SortedSet)this.source).first();
        }

        @Override
        public E last() {
            return ((SortedSet)this.source).last();
        }
    }

    public static class SetAsJava<E, C extends Set<E>>
    extends CollectionAsJava<E, C>
    implements java.util.Set<E> {
        public SetAsJava(@NotNull C collection) {
            super(collection);
        }
    }

    public static class MutableIndexedListAsJava<E, C extends MutableList<E>>
    extends MutableListAsJava<E, C>
    implements RandomAccess {
        public MutableIndexedListAsJava(@NotNull C source) {
            super(source);
        }
    }

    public static class MutableListAsJava<E, C extends MutableList<E>>
    extends MutableSeqAsJava<E, C> {
        public MutableListAsJava(@NotNull C source) {
            super(source);
        }

        @Override
        public boolean add(E e) {
            ((MutableList)this.source).append(e);
            return true;
        }

        @Override
        public void add(int index, E element) {
            ((MutableList)this.source).insert(index, element);
        }

        @Override
        public boolean addAll(int index, @NotNull java.util.Collection<? extends E> c) {
            ((MutableList)this.source).insertAll(index, c);
            return !c.isEmpty();
        }

        @Override
        public E remove(int index) {
            return ((MutableList)this.source).removeAt(index);
        }

        @Override
        public void clear() {
            ((MutableList)this.source).clear();
        }
    }

    public static class MutableIndexedSeqAsJava<E, C extends MutableSeq<E>>
    extends MutableSeqAsJava<E, C>
    implements RandomAccess {
        public MutableIndexedSeqAsJava(@NotNull C source) {
            super(source);
        }
    }

    public static class MutableSeqAsJava<E, C extends MutableSeq<E>>
    extends SeqAsJava<E, C> {
        public MutableSeqAsJava(@NotNull C source) {
            super(source);
        }

        @Override
        public E set(int index, E element) {
            Object ans = ((MutableSeq)this.source).get(index);
            ((MutableSeq)this.source).set(index, element);
            return (E)ans;
        }

        @Override
        public void sort(Comparator<? super E> c) {
            ((MutableSeq)this.source).sort(c);
        }
    }

    public static class MutableCollectionAsJava<E, C extends MutableCollection<E>>
    extends AbstractCollection<E> {
        protected final C source;

        public MutableCollectionAsJava(C source) {
            this.source = source;
        }

        @Override
        public int size() {
            return this.source.size();
        }

        @Override
        public <T> T[] toArray(IntFunction<T[]> generator) {
            return this.source.toArray(generator);
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return this.source.iterator();
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.source.spliterator();
        }

        @Override
        public Stream<E> stream() {
            return this.source.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.source.parallelStream();
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            this.source.forEach(action);
        }
    }

    public static class IndexedSeqAsJava<E, C extends Seq<E>>
    extends SeqAsJava<E, C>
    implements RandomAccess {
        public IndexedSeqAsJava(@NotNull C collection) {
            super(collection);
        }
    }

    public static class SeqAsJava<E, C extends Seq<E>>
    extends AbstractList<E>
    implements List<E> {
        public final C source;

        public SeqAsJava(@NotNull C source) {
            this.source = source;
        }

        @Override
        public boolean addAll(int index, @NotNull java.util.Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E get(int index) {
            return (E)this.source.get(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.source.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.source.lastIndexOf(o);
        }

        @Override
        public int size() {
            return this.source.size();
        }

        @Override
        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.source.contains(o);
        }

        @Override
        public boolean containsAll(@NotNull java.util.Collection<?> c) {
            return this.source.containsAll(c);
        }

        @Override
        public <T> T[] toArray(IntFunction<T[]> generator) {
            return this.source.toArray(generator);
        }

        @Override
        public Object @NotNull [] toArray() {
            return this.source.toArray();
        }

        @Override
        public final <T> T @NotNull [] toArray(@NotNull T[] a) {
            Objects.requireNonNull(a);
            T[] arr = this.toArray(i -> (Object[])Array.newInstance(a.getClass().getComponentType(), i));
            if (a.length < arr.length) {
                return arr;
            }
            System.arraycopy(arr, 0, a, 0, arr.length);
            return a;
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return this.source.iterator();
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.source.spliterator();
        }

        @Override
        public Stream<E> stream() {
            return this.source.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.source.parallelStream();
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            this.source.forEach(action);
        }
    }

    public static class CollectionAsJava<E, C extends Collection<E>>
    extends AbstractCollection<E> {
        @NotNull
        protected final C source;

        public CollectionAsJava(@NotNull C source) {
            this.source = source;
        }

        @Override
        public final boolean isEmpty() {
            return this.source.isEmpty();
        }

        @Override
        public final int size() {
            return this.source.size();
        }

        @Override
        @NotNull
        public final Iterator<E> iterator() {
            return this.source.iterator();
        }

        @Override
        @NotNull
        public final Spliterator<E> spliterator() {
            return this.source.spliterator();
        }

        @Override
        @NotNull
        public final Stream<E> stream() {
            return this.source.stream();
        }

        @Override
        @NotNull
        public Stream<E> parallelStream() {
            return this.source.parallelStream();
        }

        @Override
        public final boolean contains(Object o) {
            return this.source.contains(o);
        }

        @Override
        public final boolean containsAll(@NotNull java.util.Collection<?> c) {
            return this.source.containsAll(c);
        }

        @Override
        public final Object @NotNull [] toArray() {
            return this.source.toArray();
        }

        @Override
        public final <T> T @NotNull [] toArray(@NotNull IntFunction<T[]> generator) {
            return this.source.toArray(generator);
        }

        @Override
        public final <T> T @NotNull [] toArray(T @NotNull [] a) {
            return this.source.toArray((Object[])a);
        }

        @Override
        public void forEach(@NotNull Consumer<? super E> action) {
            this.source.forEach(action);
        }
    }
}

