/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.internal.convert;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kala.collection.AbstractCollection;
import kala.collection.AbstractMap;
import kala.collection.AbstractSet;
import kala.collection.Collection;
import kala.collection.Seq;
import kala.collection.Set;
import kala.collection.base.MapIterator;
import kala.collection.mutable.AbstractMutableSet;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableSeq;
import kala.collection.mutable.MutableSet;
import kala.control.Option;
import kala.internal.InternalIdentifyObject;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FromJavaConvert {
    private static final Object NULL_HOLE = new InternalIdentifyObject();

    public static class MutableMapFromJava<K, V>
    extends MapFromJava<K, V>
    implements MutableMap<K, V> {
        public MutableMapFromJava(Map<K, V> source) {
            super(source);
        }

        @Override
        @NotNull
        public Map<K, V> asJava() {
            return this.source;
        }

        @Override
        @NotNull
        public Option<V> put(K key, V value) {
            if (this.source.containsKey(key)) {
                return Option.some(this.source.put(key, value));
            }
            this.source.put(key, value);
            return Option.none();
        }

        @Override
        public void set(K key, V value) {
            this.source.put(key, value);
        }

        @Override
        @NotNull
        public Option<V> putIfAbsent(K key, V value) {
            if (this.source.containsKey(key)) {
                return Option.some(this.source.put(key, value));
            }
            return Option.none();
        }

        @Override
        public void putAll(@NotNull Map<? extends K, ? extends V> m) {
            this.source.putAll(m);
        }

        @Override
        @NotNull
        public Option<V> remove(K key) {
            if (this.source.containsKey(key)) {
                return Option.some(this.source.remove(key));
            }
            return Option.none();
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            return this.source.replace(key, oldValue, newValue);
        }

        @Override
        public final void clear() {
            this.source.clear();
        }

        @Override
        @NotNull
        public final MutableSet<Tuple2<K, V>> asMutableSet() {
            return new AbstractMutableSet<Tuple2<K, V>>(){

                @Override
                public boolean add(@NotNull Tuple2<K, V> value) {
                    return this.put(value._1, value._2).isDefined();
                }

                @Override
                public boolean remove(Object value) {
                    if (!(value instanceof Tuple2)) {
                        return false;
                    }
                    Tuple2 tuple = (Tuple2)value;
                    if (this.contains(tuple)) {
                        source.remove(tuple._1);
                        return true;
                    }
                    return false;
                }

                @Override
                public void clear() {
                    source.clear();
                }

                @NotNull
                public Iterator<Tuple2<K, V>> iterator() {
                    return this.iterator();
                }
            };
        }

        @Override
        public final void replaceAll(@NotNull BiFunction<? super K, ? super V, ? extends V> function) {
            this.source.replaceAll(function);
        }
    }

    public static class MapFromJava<K, V>
    extends AbstractMap<K, V> {
        protected final Map<K, V> source;

        public MapFromJava(Map<K, V> source) {
            this.source = source;
        }

        @NotNull
        public MapIterator<K, V> iterator() {
            return MapIterator.ofIterator(this.source.entrySet().iterator());
        }

        public final boolean isEmpty() {
            return this.source.isEmpty();
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.size();
        }

        public V get(K key) {
            Object res = this.source.getOrDefault(key, NULL_HOLE);
            if (res == NULL_HOLE) {
                throw new NoSuchElementException();
            }
            return (V)res;
        }

        @Nullable
        public V getOrNull(K key) {
            return this.source.get(key);
        }

        @NotNull
        public Option<V> getOption(K key) {
            Object res = this.source.getOrDefault(key, NULL_HOLE);
            return res == NULL_HOLE ? Option.none() : Option.some((Object)res);
        }

        public V getOrDefault(K key, V defaultValue) {
            return this.source.getOrDefault(key, defaultValue);
        }

        public V getOrElse(K key, @NotNull Supplier<? extends V> supplier) {
            Object res = this.source.getOrDefault(key, NULL_HOLE);
            return (V)(res == NULL_HOLE ? supplier.get() : res);
        }

        public <Ex extends Throwable> V getOrThrow(K key, @NotNull Supplier<? extends Ex> supplier) throws Ex {
            Objects.requireNonNull(supplier);
            Object res = this.source.getOrDefault(key, NULL_HOLE);
            if (res == null) {
                throw (Throwable)supplier.get();
            }
            return (V)res;
        }

        public <Ex extends Throwable> V getOrThrowException(K key, @NotNull Ex exception) throws Ex {
            Objects.requireNonNull(exception);
            Object res = this.source.getOrDefault(key, NULL_HOLE);
            if (res == null) {
                throw exception;
            }
            return (V)res;
        }

        public boolean containsKey(K key) {
            return this.source.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.source.containsValue(value);
        }
    }

    public static class MutableSetFromJava<E>
    extends SetFromJava<E>
    implements MutableSet<E> {
        public MutableSetFromJava(@NotNull java.util.Set<E> source) {
            super(source);
        }

        @Override
        public final boolean add(E value) {
            return this.source.add(value);
        }

        @Override
        public final boolean remove(Object value) {
            return this.source.remove(value);
        }

        @Override
        public final void clear() {
            this.source.clear();
        }
    }

    public static class SetFromJava<E>
    extends AbstractSet<E>
    implements Set<E> {
        @NotNull
        protected final java.util.Set<E> source;

        public SetFromJava(@NotNull java.util.Set<E> source) {
            this.source = source;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return this.source.iterator();
        }

        @Override
        public final boolean contains(Object value) {
            return this.source.contains(value);
        }
    }

    public static class MutableIndexedListFromJava<E>
    extends MutableListFromJava<E>
    implements RandomAccess {
        public MutableIndexedListFromJava(@NotNull List<E> list) {
            super(list);
        }
    }

    public static class MutableListFromJava<E>
    extends MutableSeqFromJava<E>
    implements MutableList<E> {
        public MutableListFromJava(@NotNull List<E> list) {
            super(list);
        }

        @Override
        public void append(E value) {
            this.source.add(value);
        }

        @Override
        public void prepend(E value) {
            this.source.add(0, value);
        }

        @Override
        public void insert(int index, E value) {
            this.source.add(index, value);
        }

        @Override
        public E removeAt(int index) {
            return this.source.remove(index);
        }

        @Override
        public void clear() {
            this.source.clear();
        }
    }

    public static class MutableIndexedSeqFromJava<E>
    extends MutableSeqFromJava<E>
    implements RandomAccess {
        public MutableIndexedSeqFromJava(@NotNull List<E> list) {
            super(list);
        }
    }

    public static class MutableSeqFromJava<E>
    extends SeqFromJava<E>
    implements MutableSeq<E> {
        public MutableSeqFromJava(@NotNull List<E> list) {
            super(list);
        }

        @Override
        public void set(int index, E newValue) {
            this.source.set(index, newValue);
        }

        @Override
        public void sort(Comparator<? super E> comparator) {
            this.source.sort(comparator);
        }
    }

    public static class IndexedSeqFromJava<E>
    extends SeqFromJava<E>
    implements RandomAccess {
        public IndexedSeqFromJava(@NotNull List<E> list) {
            super(list);
        }
    }

    public static class SeqFromJava<E>
    implements Seq<E> {
        @NotNull
        protected final List<E> source;

        public SeqFromJava(@NotNull List<E> source) {
            this.source = source;
        }

        @Override
        public E get(int index) {
            return this.source.get(index);
        }

        public int size() {
            return this.source.size();
        }

        @Override
        public int indexOf(Object value) {
            return this.source.indexOf(value);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.source.lastIndexOf(value);
        }

        public boolean contains(Object value) {
            return this.source.contains(value);
        }

        @NotNull
        public final Iterator<E> iterator() {
            return this.source.iterator();
        }

        @Override
        @NotNull
        public Iterator<E> reverseIterator() {
            return new Iterator<E>(){
                private final ListIterator<E> it;
                {
                    this.it = source.listIterator(source.size());
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasPrevious();
                }

                @Override
                public E next() {
                    return this.it.previous();
                }
            };
        }

        @NotNull
        public final Spliterator<E> spliterator() {
            return this.source.spliterator();
        }

        @NotNull
        public final Stream<E> stream() {
            return this.source.stream();
        }

        @NotNull
        public final Stream<E> parallelStream() {
            return this.source.parallelStream();
        }

        @Override
        @NotNull
        public List<E> asJava() {
            return this.source;
        }
    }

    public static class CollectionFromJava<E>
    extends AbstractCollection<E>
    implements Collection<E> {
        @NotNull
        protected final java.util.Collection<E> source;

        public CollectionFromJava(@NotNull java.util.Collection<E> source) {
            this.source = source;
        }

        @NotNull
        public Iterator<E> iterator() {
            return this.source.iterator();
        }

        @NotNull
        public Spliterator<E> spliterator() {
            return this.source.spliterator();
        }

        @NotNull
        public Stream<E> stream() {
            return this.source.stream();
        }

        @NotNull
        public Stream<E> parallelStream() {
            return this.source.parallelStream();
        }

        @Override
        @NotNull
        public java.util.Collection<E> asJava() {
            return this.source;
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.size();
        }
    }
}

