/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.internal.hash;

import java.io.Serializable;
import java.lang.invoke.StringConcatFactory;
import java.util.Arrays;
import java.util.Objects;
import kala.collection.internal.hash.HashNode;
import kala.collection.internal.hash.HashUtils;
import kala.function.Balance;
import org.jetbrains.annotations.Nullable;

public abstract class HashBase<K, N extends HashNode<K, N>>
implements Serializable {
    private static final long serialVersionUID = 5938151855937027660L;
    protected static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected static final double DEFAULT_LOAD_FACTOR = 0.75;
    protected static final int MAXIMUM_CAPACITY = 0x40000000;
    protected Balance<? super K> balance;
    protected double loadFactor;
    protected transient N[] table;
    protected int threshold;
    protected transient int contentSize = 0;

    protected HashBase(Balance<? super K> balance, int initialCapacity, double loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Illegal initial capacity: \u0001"}, (int)initialCapacity)));
        }
        if (loadFactor <= 0.0 || Double.isNaN(loadFactor)) {
            throw new IllegalArgumentException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Illegal load factor: \u0001"}, (double)loadFactor)));
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        this.balance = Objects.requireNonNull(balance);
        this.loadFactor = loadFactor;
        int tableSize = HashUtils.tableSizeFor(initialCapacity);
        this.table = this.createNodeArray(tableSize);
        this.threshold = this.newThreshold(tableSize);
    }

    protected HashBase(HashBase<K, N> old) {
        this.balance = old.balance;
        this.loadFactor = old.loadFactor;
        this.threshold = old.threshold;
        this.contentSize = old.contentSize;
        N[] oldTable = old.table;
        HashNode[] newTable = this.createNodeArray(oldTable.length);
        this.table = newTable;
        for (int i = 0; i < oldTable.length; ++i) {
            N oldNode = oldTable[i];
            if (oldNode == null) continue;
            newTable[i] = ((HashNode)oldNode).deepClone();
        }
    }

    protected abstract N[] createNodeArray(int var1);

    protected abstract void growTable(int var1);

    protected final int index(int hash) {
        return hash & this.table.length - 1;
    }

    protected final int newThreshold(int size) {
        return (int)((double)size * this.loadFactor);
    }

    @Nullable
    protected final N findNode(K key) {
        int hash = this.balance.hash(key);
        N fn = this.table[this.index(hash)];
        if (fn == null) {
            return null;
        }
        return ((HashNode)fn).findNode(key, hash);
    }

    protected final N removeNode(K elem) {
        return this.removeNode(elem, this.balance.hash(elem));
    }

    protected final N removeNode(K elem, int hash) {
        N[] table = this.table;
        int idx = this.index(hash);
        N nd = this.table[idx];
        if (nd == null) {
            return null;
        }
        if (((HashNode)nd).hash == hash && this.balance.test(((HashNode)nd).key, elem)) {
            table[idx] = ((HashNode)nd).next;
            --this.contentSize;
            return nd;
        }
        N prev = nd;
        Object next = ((HashNode)nd).next;
        while (next != null && ((HashNode)next).hash <= hash) {
            if (((HashNode)next).hash == hash && this.balance.test(((HashNode)next).key, elem)) {
                ((HashNode)prev).next = ((HashNode)next).next;
                --this.contentSize;
                return next;
            }
            prev = next;
            next = ((HashNode)next).next;
        }
        return null;
    }

    public Balance<? super K> getBalance() {
        return this.balance;
    }

    public final int size() {
        return this.contentSize;
    }

    public final int knownSize() {
        return this.contentSize;
    }

    public final void sizeHint(int size) {
        int target = HashUtils.tableSizeFor((int)((double)(size + 1) / this.loadFactor));
        if (target > this.table.length) {
            this.growTable(target);
        }
    }

    public void clear() {
        this.contentSize = 0;
        Arrays.fill(this.table, null);
    }
}

