/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.internal.view;

import java.lang.invoke.StringConcatFactory;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import kala.Conditions;
import kala.collection.IndexedSeqView;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.base.AbstractIterator;
import kala.collection.base.GenericArrays;
import kala.collection.internal.view.SeqViews;
import kala.control.Option;
import kala.tuple.Tuple2;
import kala.tuple.primitive.IntObjTuple2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class IndexedSeqViews {

    public static class OfArraySlice<E>
    implements IndexedSeqView<E> {
        protected final Object[] array;
        protected final int beginIndex;
        protected final int endIndex;

        public OfArraySlice(Object[] array, int beginIndex, int endIndex) {
            this.array = array;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return GenericArrays.iterator((Object[])this.array, (int)this.beginIndex, (int)this.endIndex);
        }

        public final int size() {
            return this.endIndex - this.beginIndex;
        }

        public final int beginIndex() {
            return this.beginIndex;
        }

        public final int endIndex() {
            return this.endIndex;
        }

        @Override
        public final E get(int index) {
            Conditions.checkElementIndex((int)index, (int)this.size());
            return (E)this.array[index + this.beginIndex];
        }

        @Override
        @Nullable
        public final E getOrNull(int index) {
            return (E)(index < 0 || index >= this.size() ? null : this.array[index + this.beginIndex]);
        }

        @Override
        @NotNull
        public final Option<E> getOption(int index) {
            return index < 0 || index >= this.size() ? Option.none() : Option.some((Object)this.array[index + this.beginIndex]);
        }

        @Override
        @NotNull
        public SeqView<E> slice(int beginIndex, int endIndex) {
            Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size());
            int ns = endIndex - beginIndex;
            switch (ns) {
                case 0: {
                    return SeqView.empty();
                }
                case 1: {
                    return SeqView.of(this.array[this.beginIndex + beginIndex]);
                }
            }
            return new OfArraySlice<E>(this.array, this.beginIndex + beginIndex, this.beginIndex + endIndex);
        }

        @Override
        @NotNull
        public SeqView<E> sliceView(int beginIndex, int endIndex) {
            return this.slice(beginIndex, endIndex);
        }

        @Override
        @NotNull
        public SeqView<E> drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            int size = this.size();
            if (n >= size) {
                return SeqView.empty();
            }
            return new OfArraySlice<E>(this.array, this.beginIndex + n, this.endIndex);
        }

        @Override
        @NotNull
        public SeqView<E> dropLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            int size = this.size();
            if (n >= size) {
                return SeqView.empty();
            }
            return new OfArraySlice<E>(this.array, this.beginIndex, this.endIndex - n);
        }

        @Override
        @NotNull
        public SeqView<E> take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return SeqView.empty();
            }
            int size = this.size();
            if (n >= size) {
                return this;
            }
            if (n == 1) {
                return SeqView.of(this.array[this.beginIndex]);
            }
            return new OfArraySlice<E>(this.array, this.beginIndex, this.beginIndex + n);
        }

        @Override
        @NotNull
        public SeqView<E> takeLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return SeqView.empty();
            }
            int size = this.size();
            if (n >= size) {
                return this;
            }
            if (n == 1) {
                return SeqView.of(this.array[this.beginIndex]);
            }
            return new OfArraySlice<E>(this.array, this.endIndex - n, this.endIndex);
        }
    }

    public static class Zip<E, U>
    extends SeqViews.Zip<E, U>
    implements IndexedSeqView<Tuple2<E, U>> {
        public Zip(@NotNull SeqLike<? extends E> source, @NotNull SeqLike<? extends U> other) {
            super(source, other);
        }
    }

    public static class WithIndexReversed<E>
    extends SeqViews.WithIndexReversed<E>
    implements IndexedSeqView<IntObjTuple2<E>> {
        public WithIndexReversed(SeqLike<E> source) {
            super(source);
        }
    }

    public static class WithIndex<E>
    extends SeqViews.WithIndex<E>
    implements IndexedSeqView<IntObjTuple2<E>> {
        public WithIndex(SeqLike<E> source) {
            super(source);
        }
    }

    public static class Appended<E>
    extends SeqViews.Appended<E>
    implements IndexedSeqView<E> {
        public Appended(@NotNull SeqView<E> source, E value) {
            super(source, value);
        }

        @Override
        public final E get(int index) {
            if (index == this.source.size()) {
                return (E)this.value;
            }
            return (E)this.source.get(index);
        }

        @Override
        @NotNull
        public final Option<E> getOption(int index) {
            if (index == this.source.size()) {
                return Option.some((Object)this.value);
            }
            return this.source.getOption(index);
        }
    }

    public static class Prepended<E>
    extends SeqViews.Prepended<E>
    implements IndexedSeqView<E> {
        public Prepended(@NotNull SeqView<E> source, E value) {
            super(source, value);
        }
    }

    public static class Take<E>
    extends SeqViews.Take<E>
    implements IndexedSeqView<E> {
        public Take(@NotNull SeqView<E> source, int n) {
            super(source, n);
        }

        @Override
        public final int size() {
            return this.n;
        }

        @Override
        public final int knownSize() {
            return this.n;
        }

        @Override
        public final E get(int index) {
            if (index < 0 || index >= this.n) {
                throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Index out of range: \u0001"}, (int)index)));
            }
            return (E)this.source.get(index);
        }

        @Override
        @NotNull
        public final Option<E> getOption(int index) {
            return index >= 0 && index < this.size() ? this.source.getOption(index) : Option.none();
        }

        @Override
        @NotNull
        public SeqView<E> take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return SeqView.empty();
            }
            if (n >= this.n) {
                return this;
            }
            return new Take<E>(this.source, n);
        }
    }

    public static class Drop<E>
    extends SeqViews.Drop<E>
    implements IndexedSeqView<E> {
        public Drop(@NotNull SeqView<E> source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            super(source, n);
        }

        @Override
        public final E get(int index) {
            if (this.n <= 0) {
                return (E)this.source.get(index);
            }
            int s = this.source.size();
            if (this.n >= s) {
                throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Index out of range: \u0001"}, (int)index)));
            }
            return (E)this.source.get(index + this.n);
        }

        @Override
        @NotNull
        public final Option<E> getOption(int index) {
            if (this.n <= 0) {
                return this.source.getOption(index);
            }
            return this.source.getOption(index + this.n);
        }

        @Override
        @NotNull
        public SeqView<E> drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            int nn = this.n + n;
            int ss = this.source.size();
            if (nn >= ss) {
                return SeqView.empty();
            }
            return new Drop<E>(this.source, nn);
        }
    }

    public static class Slice<E>
    extends SeqViews.Slice<E>
    implements IndexedSeqView<E> {
        public Slice(@NotNull SeqView<E> source, int beginIndex, int endIndex) {
            super(source, beginIndex, endIndex);
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return new Itr();
        }

        @Override
        @NotNull
        public Iterator<E> reverseIterator() {
            return new ReverseItr();
        }

        @Override
        public final E get(int index) {
            Conditions.checkElementIndex((int)index, (int)this.size());
            return (E)this.source.get(index + this.beginIndex);
        }

        @Override
        @Nullable
        public final E getOrNull(int index) {
            return (E)(index < 0 || index >= this.size() ? null : this.source.get(index + this.beginIndex));
        }

        @Override
        @NotNull
        public Option<E> getOption(int index) {
            return index < 0 || index >= this.size() ? Option.none() : Option.some((Object)this.source.get(index + this.beginIndex));
        }

        private final class Itr
        extends AbstractIterator<E> {
            private int idx;

            private Itr() {
                this.idx = Slice.this.beginIndex;
            }

            public final boolean hasNext() {
                return this.idx < Slice.this.endIndex;
            }

            public final E next() {
                if (this.idx >= Slice.this.endIndex) {
                    throw new NoSuchElementException();
                }
                return Slice.this.get(this.idx++);
            }
        }

        private final class ReverseItr
        extends AbstractIterator<E> {
            private int idx;

            private ReverseItr() {
                this.idx = Slice.this.endIndex - 1;
            }

            public final boolean hasNext() {
                return this.idx >= Slice.this.beginIndex;
            }

            public E next() {
                return Slice.this.get(this.idx--);
            }
        }
    }

    public static class Mapped<E, T>
    extends SeqViews.Mapped<E, T>
    implements IndexedSeqView<E> {
        public Mapped(@NotNull SeqView<T> source, @NotNull Function<? super T, ? extends E> mapper) {
            super(source, mapper);
        }
    }

    public static class Updated<E>
    extends SeqViews.Updated<E>
    implements IndexedSeqView<E> {
        public Updated(@NotNull SeqView<E> source, int index, E newValue) {
            super(source, index, newValue);
        }
    }

    public static class Concat<E>
    extends SeqViews.Concat<E>
    implements IndexedSeqView<E> {
        public Concat(@NotNull SeqLike<? extends E> seq1, @NotNull SeqLike<? extends E> seq2) {
            super(seq1, seq2);
        }

        @Override
        public final int knownSize() {
            return this.size();
        }

        @Override
        public E get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"index(\u0001) < 0"}, (int)index)));
            }
            SeqLike seq1 = this.seq1;
            int ss1 = seq1.size();
            if (index < ss1) {
                return seq1.get(index);
            }
            SeqLike seq2 = this.seq2;
            int ss2 = seq2.size();
            if (index < ss1 + ss2) {
                return seq2.get(index - ss1);
            }
            throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"index(\u0001) > size(\u0001)"}, (int)index, (int)(ss1 + ss2))));
        }

        @Override
        @Nullable
        public E getOrNull(int index) {
            if (index < 0) {
                return null;
            }
            SeqLike seq1 = this.seq1;
            int ss1 = seq1.size();
            if (index < ss1) {
                return seq1.get(index);
            }
            SeqLike seq2 = this.seq2;
            int ss2 = seq2.size();
            if (index < ss1 + ss2) {
                return seq2.get(index + ss1);
            }
            return null;
        }

        @Override
        @NotNull
        public Option<E> getOption(int index) {
            if (index < 0) {
                return Option.none();
            }
            SeqLike seq1 = this.seq1;
            int ss1 = seq1.size();
            if (index < ss1) {
                return Option.some(seq1.get(index));
            }
            SeqLike seq2 = this.seq2;
            int ss2 = seq2.size();
            if (index < ss1 + ss2) {
                return Option.some(seq2.get(index + ss1));
            }
            return Option.none();
        }
    }
}

