/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.internal.view;

import java.io.Serializable;
import java.lang.invoke.StringConcatFactory;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Stream;
import kala.collection.AbstractView;
import kala.collection.CollectionLike;
import kala.collection.Map;
import kala.collection.Seq;
import kala.collection.View;
import kala.collection.base.Iterators;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.ImmutableArray;
import kala.collection.immutable.ImmutableLinkedSeq;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.immutable.ImmutableVector;
import kala.control.Option;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Views {
    private Views() {
    }

    static final class MappedSpliterator<E, T>
    implements Spliterator<E> {
        @NotNull
        private final Spliterator<? extends T> source;
        @NotNull
        private final Function<? super T, ? extends E> mapper;

        MappedSpliterator(@NotNull Spliterator<? extends T> source, @NotNull Function<? super T, ? extends E> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            return this.source.tryAdvance((Consumer<Object> & Serializable)t -> action.accept((E)this.mapper.apply(t)));
        }

        @Override
        public Spliterator<E> trySplit() {
            Spliterator<? extends T> ss = this.source.trySplit();
            return ss != null ? new MappedSpliterator<E, T>(ss, this.mapper) : null;
        }

        @Override
        public long estimateSize() {
            return this.source.estimateSize();
        }

        @Override
        public int characteristics() {
            return this.source.characteristics();
        }
    }

    public static final class Zip<E, U>
    extends AbstractView<Tuple2<E, U>> {
        @NotNull
        private final View<? extends E> source;
        @NotNull
        private final Iterable<? extends U> other;

        public Zip(@NotNull View<? extends E> source, @NotNull Iterable<? extends U> other) {
            this.source = source;
            this.other = other;
        }

        @NotNull
        public Iterator<Tuple2<E, U>> iterator() {
            return Iterators.zip((Iterator)this.source.iterator(), this.other.iterator());
        }
    }

    public static final class FlatMapped<E, T>
    extends AbstractView<E> {
        @NotNull
        private final View<? extends T> source;
        @NotNull
        private final Function<? super T, ? extends Iterable<? extends E>> mapper;

        public FlatMapped(@NotNull View<? extends T> source, @NotNull Function<? super T, ? extends Iterable<? extends E>> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public Iterator<E> iterator() {
            return Iterators.concat((Iterable)((Object)this.source.map((T it) -> this.mapper.apply(it).iterator())));
        }
    }

    public static final class FilterNotNull<E>
    extends AbstractView<E> {
        @NotNull
        private final View<E> source;

        public FilterNotNull(@NotNull View<E> source) {
            this.source = source;
        }

        @NotNull
        public Iterator<E> iterator() {
            return Iterators.filterNotNull((Iterator)this.source.iterator());
        }
    }

    public static final class FilterNot<E>
    extends AbstractView<E> {
        @NotNull
        private final View<E> source;
        @NotNull
        private final Predicate<? super E> predicate;

        public FilterNot(@NotNull View<E> source, @NotNull Predicate<? super E> predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public Iterator<E> iterator() {
            return Iterators.filterNot((Iterator)this.source.iterator(), this.predicate);
        }

        @NotNull
        public Stream<E> stream() {
            return this.source.stream().filter(this.predicate.negate());
        }

        @NotNull
        public Stream<E> parallelStream() {
            return (Stream)this.source.stream().filter(this.predicate.negate()).parallel();
        }
    }

    public static final class Filter<E>
    extends AbstractView<E> {
        @NotNull
        private final View<E> source;
        @NotNull
        private final Predicate<? super E> predicate;

        public Filter(@NotNull View<E> source, @NotNull Predicate<? super E> predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public Iterator<E> iterator() {
            return Iterators.filter((Iterator)this.source.iterator(), this.predicate);
        }

        @NotNull
        public Stream<E> stream() {
            return this.source.stream().filter(this.predicate);
        }

        @NotNull
        public Stream<E> parallelStream() {
            return (Stream)this.source.stream().filter(this.predicate).parallel();
        }
    }

    public static class MapMulti<E, T>
    extends AbstractView<E> {
        @NotNull
        private final View<T> source;
        @NotNull
        private final BiConsumer<? super T, ? super Consumer<? super E>> mapper;

        public MapMulti(@NotNull View<T> source, @NotNull BiConsumer<? super T, ? super Consumer<? super E>> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return Iterators.mapMulti((Iterator)this.source.iterator(), this.mapper);
        }
    }

    public static class MapNotNull<E, T>
    extends AbstractView<E> {
        @NotNull
        private final View<T> source;
        @NotNull
        private final Function<? super T, ? extends E> mapper;

        public MapNotNull(@NotNull View<T> source, @NotNull Function<? super T, ? extends E> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public Iterator<E> iterator() {
            return Iterators.mapNotNull((Iterator)this.source.iterator(), this.mapper);
        }
    }

    public static final class Mapped<E, T>
    extends AbstractView<E> {
        @NotNull
        private final View<T> source;
        @NotNull
        private final Function<? super T, ? extends E> mapper;

        public Mapped(@NotNull View<T> source, @NotNull Function<? super T, ? extends E> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public Iterator<E> iterator() {
            return Iterators.map((Iterator)this.source.iterator(), this.mapper);
        }

        @NotNull
        public Spliterator<E> spliterator() {
            return new MappedSpliterator<E, T>(this.source.spliterator(), this.mapper);
        }

        @NotNull
        public Stream<E> stream() {
            return this.source.stream().map(this.mapper);
        }

        @NotNull
        public Stream<E> parallelStream() {
            return this.source.parallelStream().map(this.mapper);
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }
    }

    public static class Of<E, C extends CollectionLike<E>>
    extends AbstractView<E> {
        @NotNull
        protected final C source;

        public Of(@NotNull C source) {
            this.source = source;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return this.source.iterator();
        }

        @NotNull
        public final Spliterator<E> spliterator() {
            return this.source.spliterator();
        }

        @NotNull
        public final Stream<E> stream() {
            return this.source.stream();
        }

        @NotNull
        public final Stream<E> parallelStream() {
            return this.source.parallelStream();
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }

        @NotNull
        public final Option<E> find(@NotNull Predicate<? super E> predicate) {
            return this.source.find(predicate);
        }

        public final boolean contains(Object value) {
            return this.source.contains(value);
        }

        public final boolean containsAll(Object @NotNull [] values) {
            return this.source.containsAll(values);
        }

        public final boolean containsAll(@NotNull Iterable<?> values) {
            return this.source.containsAll(values);
        }

        public final boolean sameElements(@NotNull Iterable<?> other) {
            return this.source.sameElements(other);
        }

        public final boolean sameElements(@NotNull Iterable<?> other, boolean identity) {
            return this.source.sameElements(other, identity);
        }

        public final boolean anyMatch(@NotNull Predicate<? super E> predicate) {
            return this.source.anyMatch(predicate);
        }

        public final boolean allMatch(@NotNull Predicate<? super E> predicate) {
            return this.source.allMatch(predicate);
        }

        public final boolean noneMatch(@NotNull Predicate<? super E> predicate) {
            return this.source.noneMatch(predicate);
        }

        public final int count(@NotNull Predicate<? super E> predicate) {
            return this.source.count(predicate);
        }

        public final E max() {
            return (E)this.source.max();
        }

        public final E max(@NotNull Comparator<? super E> comparator) {
            return (E)this.source.max(comparator);
        }

        @Nullable
        public E maxOrNull() {
            return (E)this.source.maxOrNull();
        }

        @Nullable
        public E maxOrNull(@NotNull Comparator<? super E> comparator) {
            return (E)this.source.maxOrNull(comparator);
        }

        @NotNull
        public final Option<E> maxOption() {
            return this.source.maxOption();
        }

        @NotNull
        public final Option<E> maxOption(@NotNull Comparator<? super E> comparator) {
            return this.source.maxOption(comparator);
        }

        public final E min() {
            return (E)this.source.min();
        }

        public final E min(@NotNull Comparator<? super E> comparator) {
            return (E)this.source.min(comparator);
        }

        @Nullable
        public E minOrNull() {
            return (E)this.source.minOrNull();
        }

        @Nullable
        public E minOrNull(@NotNull Comparator<? super E> comparator) {
            return (E)this.source.minOrNull(comparator);
        }

        @NotNull
        public final Option<E> minOption() {
            return this.source.minOption();
        }

        @NotNull
        public final Option<E> minOption(@NotNull Comparator<? super E> comparator) {
            return this.source.minOption(comparator);
        }

        public final E fold(E zero, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
            return (E)this.source.fold(zero, op);
        }

        public final <U> U foldLeft(U zero, @NotNull BiFunction<? super U, ? super E, ? extends U> op) {
            return (U)this.source.foldLeft(zero, op);
        }

        public final <U> U foldRight(U zero, @NotNull BiFunction<? super E, ? super U, ? extends U> op) {
            return (U)this.source.foldRight(zero, op);
        }

        public final E reduceLeft(@NotNull BiFunction<? super E, ? super E, ? extends E> op) throws NoSuchElementException {
            return (E)this.source.reduceLeft(op);
        }

        @NotNull
        public final Option<E> reduceLeftOption(@NotNull BiFunction<? super E, ? super E, ? extends E> op) {
            return this.source.reduceLeftOption(op);
        }

        public final E reduceRight(@NotNull BiFunction<? super E, ? super E, ? extends E> op) throws NoSuchElementException {
            return (E)this.source.reduceRight(op);
        }

        @NotNull
        public final Option<E> reduceRightOption(@NotNull BiFunction<? super E, ? super E, ? extends E> op) {
            return this.source.reduceRightOption(op);
        }

        public final <R, Builder> R collect(@NotNull Collector<? super E, Builder, ? extends R> collector) {
            return (R)this.source.collect(collector);
        }

        public final <R, Builder> R collect(@NotNull CollectionFactory<? super E, Builder, ? extends R> factory) {
            return (R)this.source.collect(factory);
        }

        public final Object @NotNull [] toArray() {
            return this.source.toArray();
        }

        public final <U> U @NotNull [] toArray(@NotNull Class<U> type) {
            return this.source.toArray(type);
        }

        public final <U> U @NotNull [] toArray(@NotNull IntFunction<U[]> generator) {
            return this.source.toArray(generator);
        }

        public <U> U @NotNull [] toArray(U @NotNull [] array) {
            return this.source.toArray((Object[])array);
        }

        @Override
        @NotNull
        public final Seq<E> toSeq() {
            return this.source.toSeq();
        }

        @Override
        @NotNull
        public final ImmutableSeq<E> toImmutableSeq() {
            return this.source.toImmutableSeq();
        }

        @Override
        @NotNull
        public final ImmutableArray<E> toImmutableArray() {
            return this.source.toImmutableArray();
        }

        @Override
        @NotNull
        public final ImmutableLinkedSeq<E> toImmutableLinkedSeq() {
            return this.source.toImmutableLinkedSeq();
        }

        @Override
        @NotNull
        public final ImmutableVector<E> toImmutableVector() {
            return this.source.toImmutableVector();
        }

        @Override
        @NotNull
        public final <K, V> ImmutableMap<K, V> toImmutableMap() {
            return this.source.toImmutableMap();
        }

        @Override
        @NotNull
        public final <K, V> Map<K, V> associate(@NotNull Function<? super E, ? extends Map.Entry<? extends K, ? extends V>> transform) {
            return this.source.associate(transform);
        }

        @Override
        @NotNull
        public final <K, V> Map<K, V> associateBy(@NotNull Function<? super E, ? extends K> keySelector, @NotNull Function<? super E, ? extends V> valueTransform) {
            return this.source.associateBy(keySelector, valueTransform);
        }

        @Override
        @NotNull
        public final <K> Map<K, E> associateBy(@NotNull Function<? super E, ? extends K> keySelector) {
            return this.source.associateBy(keySelector);
        }

        public final void forEach(@NotNull Consumer<? super E> action) {
            this.source.forEach(action);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer) {
            return (A)this.source.joinTo(buffer);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull CharSequence separator) {
            return (A)this.source.joinTo(buffer, separator);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix) {
            return (A)this.source.joinTo(buffer, separator, prefix, postfix);
        }

        @NotNull
        public <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull Function<? super E, ? extends CharSequence> transform) {
            return (A)this.source.joinTo(buffer, transform);
        }

        @NotNull
        public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, @NotNull Function<? super E, ? extends CharSequence> transform) {
            return (A)this.source.joinTo(buffer, separator, transform);
        }

        @Contract(value="_, _, _, _, _ -> param1", mutates="param1")
        @NotNull
        public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull Function<? super E, ? extends CharSequence> transform) {
            return (A)this.source.joinTo(buffer, separator, prefix, postfix, transform);
        }

        @NotNull
        public final String joinToString() {
            return this.source.joinToString();
        }

        @NotNull
        public final String joinToString(@NotNull CharSequence separator) {
            return this.source.joinToString(separator);
        }

        @NotNull
        public final String joinToString(@NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix) {
            return this.source.joinToString(separator, prefix, postfix);
        }

        @NotNull
        public String joinToString(@NotNull Function<? super E, ? extends CharSequence> transform) {
            return this.source.joinToString(transform);
        }

        @NotNull
        public String joinToString(CharSequence separator, @NotNull Function<? super E, ? extends CharSequence> transform) {
            return this.source.joinToString(separator, transform);
        }

        @NotNull
        public String joinToString(CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull Function<? super E, ? extends CharSequence> transform) {
            return this.source.joinToString(separator, prefix, postfix, transform);
        }

        @Override
        public final String toString() {
            return this.joinToString(", ", (CharSequence)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001["}, (String)this.className())), "]");
        }
    }

    public static class Single<E>
    extends AbstractView<E> {
        protected final E value;

        public Single(E value) {
            this.value = value;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return Iterators.of(this.value);
        }

        @NotNull
        public Spliterator<E> spliterator() {
            return Spliterators.spliterator(Iterators.of(this.value), 1L, 0);
        }

        @NotNull
        public Stream<E> stream() {
            return Stream.of(this.value);
        }

        @NotNull
        public Stream<E> parallelStream() {
            return (Stream)Stream.of(this.value).parallel();
        }

        public final boolean isEmpty() {
            return false;
        }

        public final int size() {
            return 1;
        }

        public final int knownSize() {
            return 1;
        }

        public void forEach(@NotNull Consumer<? super E> action) {
            action.accept(this.value);
        }
    }

    public static class Empty<E>
    extends AbstractView<E> {
        public static final Empty<?> INSTANCE = new Empty();

        @NotNull
        public final Iterator<E> iterator() {
            return Iterators.empty();
        }

        @NotNull
        public Spliterator<E> spliterator() {
            return Spliterators.emptySpliterator();
        }

        @NotNull
        public Stream<E> stream() {
            return Stream.empty();
        }

        @NotNull
        public Stream<E> parallelStream() {
            return (Stream)Stream.empty().parallel();
        }

        public final boolean isEmpty() {
            return true;
        }

        public final int size() {
            return 0;
        }

        public final int knownSize() {
            return 0;
        }

        @Override
        @NotNull
        public View<E> filter(@NotNull Predicate<? super E> predicate) {
            return this;
        }

        @Override
        @NotNull
        public View<E> filterNot(@NotNull Predicate<? super E> predicate) {
            return this;
        }

        @Override
        @NotNull
        public @NotNull View<@NotNull E> filterNotNull() {
            return this;
        }

        @Override
        @NotNull
        public <U> View<U> map(@NotNull Function<? super E, ? extends U> mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> View<U> flatMap(@NotNull Function<? super E, ? extends Iterable<? extends U>> mapper) {
            return this;
        }

        public final Object @NotNull [] toArray() {
            return new Object[0];
        }

        @Override
        @NotNull
        public final ImmutableVector<E> toImmutableVector() {
            return ImmutableVector.empty();
        }

        @Override
        public final String toString() {
            return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001[]"}, (String)this.className());
        }
    }
}

