/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import kala.collection.mutable.MutableArrayDeque;
import kala.collection.mutable.MutableQueue;
import kala.control.Option;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MutableDeque<E>
extends MutableQueue<E> {
    @NotNull
    public static <E> MutableDeque<E> create() {
        return new MutableArrayDeque();
    }

    @Override
    public boolean isEmpty();

    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public void prepend(E var1);

    public void append(E var1);

    default public E removeFirst() {
        return (E)this.removeFirstOption().get();
    }

    @Nullable
    default public E removeFirstOrNull() {
        return (E)this.removeFirstOption().getOrNull();
    }

    @NotNull
    public Option<E> removeFirstOption();

    default public E removeLast() {
        return (E)this.removeLastOption().get();
    }

    @Nullable
    default public E removeLastOrNull() {
        return (E)this.removeLastOption().getOrNull();
    }

    @NotNull
    public Option<E> removeLastOption();

    default public E first() {
        return (E)this.firstOption().get();
    }

    @Nullable
    default public E firstOrNull() {
        return (E)this.firstOption().getOrNull();
    }

    @NotNull
    public Option<E> firstOption();

    default public E last() {
        return (E)this.lastOption().get();
    }

    @Nullable
    default public E lastOrNull() {
        return (E)this.lastOption().getOrNull();
    }

    @NotNull
    public Option<E> lastOption();

    @Override
    default public void enqueue(E value) {
        this.prepend(value);
    }

    @Override
    default public E dequeue() {
        return (E)this.dequeueOption().get();
    }

    @Override
    @Nullable
    default public E dequeueOrNull() {
        return (E)this.dequeueOption().getOrNull();
    }

    @Override
    @NotNull
    default public Option<E> dequeueOption() {
        return this.removeLastOption();
    }
}

