/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.StringConcatFactory;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import kala.collection.Set;
import kala.collection.factory.CollectionFactory;
import kala.collection.internal.hash.HashBase;
import kala.collection.internal.hash.HashNode;
import kala.collection.internal.hash.HashUtils;
import kala.collection.mutable.AbstractMutableSetFactory;
import kala.collection.mutable.MutableSet;
import kala.function.Balance;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableHashSet<E>
extends HashBase<E, Node<E>>
implements MutableSet<E>,
Serializable {
    private static final long serialVersionUID = 2267952928135789371L;
    private static final Factory<?> FACTORY = new Factory();

    public MutableHashSet() {
        this(16, 0.75);
    }

    public MutableHashSet(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public MutableHashSet(int initialCapacity, double loadFactor) {
        super(Balance.optimizedBalance(), initialCapacity, loadFactor);
    }

    public MutableHashSet(Balance<? super E> balance) {
        this(balance, 16, 0.75);
    }

    public MutableHashSet(Balance<? super E> balance, int initialCapacity) {
        this(balance, initialCapacity, 0.75);
    }

    public MutableHashSet(Balance<? super E> balance, int initialCapacity, double loadFactor) {
        super(balance, initialCapacity, loadFactor);
    }

    @NotNull
    public static <E> CollectionFactory<E, ?, MutableHashSet<E>> factory() {
        return FACTORY;
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <E> MutableHashSet<E> create() {
        return new MutableHashSet<E>();
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <E> MutableHashSet<E> of() {
        return new MutableHashSet<E>();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <E> MutableHashSet<E> of(E value1) {
        MutableHashSet<E> s = new MutableHashSet<E>();
        s.add(value1);
        return s;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <E> MutableHashSet<E> of(E value1, E value2) {
        MutableHashSet<E> s = new MutableHashSet<E>();
        s.add(value1);
        s.add(value2);
        return s;
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <E> MutableHashSet<E> of(E value1, E value2, E value3) {
        MutableHashSet<E> s = new MutableHashSet<E>();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        return s;
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static <E> MutableHashSet<E> of(E value1, E value2, E value3, E value4) {
        MutableHashSet<E> s = new MutableHashSet<E>();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        return s;
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static <E> MutableHashSet<E> of(E value1, E value2, E value3, E value4, E value5) {
        MutableHashSet<E> s = new MutableHashSet<E>();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        s.add(value5);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <E> MutableHashSet<E> of(E ... values) {
        return MutableHashSet.from(values);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <E> MutableHashSet<E> from(E @NotNull [] values) {
        MutableHashSet<E> s = new MutableHashSet<E>(values.length);
        s.addAll(values);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <E> MutableHashSet<E> from(@NotNull Iterable<? extends E> values) {
        MutableHashSet<? extends E> s = new MutableHashSet<E>();
        s.addAll(values);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <E> MutableHashSet<E> from(@NotNull Iterator<? extends E> it) {
        MutableHashSet<E> s = new MutableHashSet<E>();
        while (it.hasNext()) {
            s.add(it.next());
        }
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <E> MutableHashSet<E> from(@NotNull Stream<? extends E> stream) {
        return stream.collect(MutableHashSet.factory());
    }

    private int indexOf(int hash) {
        return hash & ((Node[])this.table).length - 1;
    }

    protected Node<E>[] createNodeArray(int length) {
        return new Node[length];
    }

    @Override
    protected void growTable(int newLen) {
        this.threshold = this.newThreshold(newLen);
        if (this.isEmpty()) {
            this.table = this.createNodeArray(newLen);
        } else {
            this.table = Arrays.copyOf((Node[])this.table, newLen);
            Node preLow = new Node((Object)null, 0);
            Node preHigh = new Node((Object)null, 0);
            for (int oldLen = ((Node[])this.table).length; oldLen < newLen; oldLen *= 2) {
                for (int i = 0; i < oldLen; ++i) {
                    Node old = ((Node[])this.table)[i];
                    if (old == null) continue;
                    preLow.next = null;
                    preHigh.next = null;
                    Node lastLow = preLow;
                    Node lastHigh = preHigh;
                    Node n = old;
                    while (n != null) {
                        Node next = (Node)n.next;
                        if ((n.hash & oldLen) == 0) {
                            lastLow.next = n;
                            lastLow = n;
                        } else {
                            lastHigh.next = n;
                            lastHigh = n;
                        }
                        n = next;
                    }
                    lastLow.next = null;
                    if (old != preLow.next) {
                        ((Node[])this.table)[i] = (Node)preLow.next;
                    }
                    if (preHigh.next == null) continue;
                    ((Node[])this.table)[i + oldLen] = (Node)preHigh.next;
                    lastHigh.next = null;
                }
            }
        }
    }

    private boolean add(E value, int hash) {
        int idx = this.indexOf(hash);
        Node n = ((Node[])this.table)[idx];
        if (n == null) {
            ((Node[])this.table)[idx] = new Node((Object)value, hash);
        } else {
            Node old = n;
            Node prev = null;
            while (n != null && n.hash <= hash) {
                if (n.hash == hash && this.balance.test(value, n.key)) {
                    return false;
                }
                prev = n;
                n = (Node)n.next;
            }
            if (prev == null) {
                ((Node[])this.table)[idx] = new Node(value, hash, old);
            } else {
                prev.next = new Node(value, hash, (Node)prev.next);
            }
        }
        ++this.contentSize;
        return true;
    }

    @Override
    public boolean add(E value) {
        if (this.contentSize + 1 >= this.threshold) {
            this.growTable(((Node[])this.table).length * 2);
        }
        return this.add(value, HashUtils.computeHash(value));
    }

    @Override
    public boolean addAll(E @NotNull [] values) {
        int s = values.length;
        if (s == 0) {
            return false;
        }
        this.sizeHint(s);
        for (E value : values) {
            this.add(value);
        }
        return true;
    }

    @Override
    public boolean remove(Object value) {
        return this.removeNode(value, HashUtils.computeHash(value)) != null;
    }

    @Override
    @NotNull
    public String className() {
        return "MutableHashSet";
    }

    @Override
    @NotNull
    public <U> CollectionFactory<U, ?, MutableHashSet<U>> iterableFactory() {
        return MutableHashSet.factory();
    }

    @NotNull
    public Iterator<E> iterator() {
        return new Itr();
    }

    public int hashCode() {
        return Set.hashCode(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof Set && Set.equals(this, (Set)obj);
    }

    public String toString() {
        return this.joinToString(", ", (CharSequence)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001["}, (String)this.className())), "]");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        double loadFactor = in.readDouble();
        if (size < 0) {
            throw new InvalidObjectException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Illegal size: \u0001"}, (int)size)));
        }
        if (loadFactor <= 0.0 || Double.isNaN(loadFactor)) {
            throw new InvalidObjectException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Illegal load factor: \u0001"}, (double)loadFactor)));
        }
        this.contentSize = 0;
        this.loadFactor = loadFactor;
        this.table = this.createNodeArray(HashUtils.tableSizeFor(size));
        this.threshold = this.newThreshold(((Node[])this.table).length);
        for (int i = 0; i < size; ++i) {
            this.add(in.readObject());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.contentSize);
        out.writeDouble(this.loadFactor);
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            E e = iterator.next();
            out.writeObject(e);
        }
    }

    static /* synthetic */ HashNode[] access$400(MutableHashSet x0) {
        return x0.table;
    }

    private static final class Factory<E>
    extends AbstractMutableSetFactory<E, MutableHashSet<E>> {
        private Factory() {
        }

        public MutableHashSet<E> newBuilder() {
            return new MutableHashSet();
        }

        public void sizeHint(@NotNull MutableHashSet<E> es, int size) {
            es.sizeHint(size);
        }
    }

    protected static final class Node<E>
    extends HashNode<E, Node<E>> {
        private Node(E key, int hash) {
            super(key, hash);
        }

        private Node(E key, int hash, Node<E> next) {
            super(key, hash, next);
        }

        @Override
        public Node<E> deepClone() {
            Node<Object> nextNode;
            Node<Object> head;
            Node<Object> node = head = new Node<Object>(this.key, this.hash, (Node)this.next);
            while ((nextNode = (Node<Object>)node.next) != null) {
                node.next = nextNode = new Node<Object>(nextNode.key, nextNode.hash, (Node)nextNode.next);
                node = nextNode;
            }
            return head;
        }
    }

    private final class Itr
    implements Iterator<E> {
        private int i = 0;
        private Node<E> node = null;
        private final int len = ((Node[])MutableHashSet.access$400(MutableHashSet.this)).length;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            if (this.node != null) {
                return true;
            }
            while (this.i < this.len) {
                Node n = ((Node[])MutableHashSet.this.table)[this.i];
                ++this.i;
                if (n == null) continue;
                this.node = n;
                return true;
            }
            return false;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object res = this.node.key;
            this.node = (Node)this.node.next;
            return res;
        }
    }
}

