/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import kala.collection.base.MapBase;
import kala.collection.factory.MapFactory;
import kala.collection.internal.convert.FromJavaConvert;
import kala.collection.mutable.AbstractMutableMapFactory;
import kala.collection.mutable.MutableMapEditor;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.NotNull;

public final class MutableLinkedHashMap<K, V>
extends FromJavaConvert.MutableMapFromJava<K, V> {
    private static final Factory<?, ?> FACTORY = new Factory();

    public MutableLinkedHashMap() {
        this(new LinkedHashMap());
    }

    public MutableLinkedHashMap(int initialCapacity) {
        this(new LinkedHashMap(initialCapacity));
    }

    public MutableLinkedHashMap(int initialCapacity, double loadFactor) {
        this(new LinkedHashMap(initialCapacity, (float)loadFactor));
    }

    private MutableLinkedHashMap(@NotNull LinkedHashMap<K, V> source) {
        super(source);
    }

    @NotNull
    public static <K, V> MapFactory<K, V, ?, MutableLinkedHashMap<K, V>> factory() {
        return FACTORY;
    }

    @NotNull
    static <T, K, V> Collector<T, ?, MutableLinkedHashMap<K, V>> collector(@NotNull Function<? super T, ? extends K> keyMapper, @NotNull Function<? super T, ? extends V> valueMapper) {
        return MapFactory.collector(MutableLinkedHashMap.factory(), keyMapper, valueMapper);
    }

    @NotNull
    public static <K, V> MutableLinkedHashMap<K, V> of() {
        return new MutableLinkedHashMap<K, V>();
    }

    @NotNull
    public static <K, V> MutableLinkedHashMap<K, V> of(K k1, V v1) {
        MutableLinkedHashMap<K, V> m = new MutableLinkedHashMap<K, V>();
        m.set(k1, v1);
        return m;
    }

    @NotNull
    public static <K, V> MutableLinkedHashMap<K, V> of(K k1, V v1, K k2, V v2) {
        MutableLinkedHashMap<K, V> m = new MutableLinkedHashMap<K, V>();
        m.set(k1, v1);
        m.set(k2, v2);
        return m;
    }

    @NotNull
    public static <K, V> MutableLinkedHashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        MutableLinkedHashMap<K, V> m = new MutableLinkedHashMap<K, V>();
        m.set(k1, v1);
        m.set(k2, v2);
        m.set(k3, v3);
        return m;
    }

    @NotNull
    public static <K, V> MutableLinkedHashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        MutableLinkedHashMap<K, V> m = new MutableLinkedHashMap<K, V>();
        m.set(k1, v1);
        m.set(k2, v2);
        m.set(k3, v3);
        m.set(k4, v4);
        return m;
    }

    @NotNull
    public static <K, V> MutableLinkedHashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        MutableLinkedHashMap<K, V> m = new MutableLinkedHashMap<K, V>();
        m.set(k1, v1);
        m.set(k2, v2);
        m.set(k3, v3);
        m.set(k4, v4);
        m.set(k5, v5);
        return m;
    }

    @NotNull
    public static <K, V> MutableLinkedHashMap<K, V> ofEntries() {
        return new MutableLinkedHashMap<K, V>();
    }

    @NotNull
    public static <K, V> MutableLinkedHashMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1) {
        MutableLinkedHashMap<K, V> res = new MutableLinkedHashMap<K, V>();
        res.set(entry1);
        return res;
    }

    @NotNull
    public static <K, V> MutableLinkedHashMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2) {
        MutableLinkedHashMap<K, V> res = new MutableLinkedHashMap<K, V>();
        res.set(entry1);
        res.set(entry2);
        return res;
    }

    @NotNull
    public static <K, V> MutableLinkedHashMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3) {
        MutableLinkedHashMap<K, V> res = new MutableLinkedHashMap<K, V>();
        res.set(entry1);
        res.set(entry2);
        res.set(entry3);
        return res;
    }

    @NotNull
    public static <K, V> MutableLinkedHashMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3, @NotNull Tuple2<? extends K, ? extends V> entry4) {
        MutableLinkedHashMap<K, V> res = new MutableLinkedHashMap<K, V>();
        res.set(entry1);
        res.set(entry2);
        res.set(entry3);
        res.set(entry4);
        return res;
    }

    @NotNull
    public static <K, V> MutableLinkedHashMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3, @NotNull Tuple2<? extends K, ? extends V> entry4, @NotNull Tuple2<? extends K, ? extends V> entry5) {
        MutableLinkedHashMap<K, V> res = new MutableLinkedHashMap<K, V>();
        res.set(entry1);
        res.set(entry2);
        res.set(entry3);
        res.set(entry4);
        res.set(entry5);
        return res;
    }

    @SafeVarargs
    @NotNull
    public static <K, V> MutableLinkedHashMap<K, V> ofEntries(Tuple2<? extends K, ? extends V> ... entries) {
        MutableLinkedHashMap<K, V> res = new MutableLinkedHashMap<K, V>();
        for (Tuple2<? extends K, ? extends V> entry : entries) {
            res.set(entry);
        }
        return res;
    }

    @NotNull
    public static <K, V> MutableLinkedHashMap<K, V> from(@NotNull Map<? extends K, ? extends V> values) {
        MutableLinkedHashMap<? extends K, ? extends V> m = new MutableLinkedHashMap<K, V>();
        m.putAll(values);
        return m;
    }

    @NotNull
    public static <K, V> MutableLinkedHashMap<K, V> from(@NotNull MapBase<? extends K, ? extends V> values) {
        MutableLinkedHashMap<K, V> m = new MutableLinkedHashMap<K, V>();
        m.putAll(values);
        return m;
    }

    @NotNull
    public static <K, V> MutableLinkedHashMap<K, V> from(Map.Entry<? extends K, ? extends V> @NotNull [] values) {
        MutableLinkedHashMap<K, V> m = new MutableLinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry : values) {
            m.set(entry.getKey(), entry.getValue());
        }
        return m;
    }

    @NotNull
    public static <K, V> MutableLinkedHashMap<K, V> from(@NotNull Iterable<? extends Map.Entry<? extends K, ? extends V>> values) {
        MutableLinkedHashMap<K, V> m = new MutableLinkedHashMap<K, V>();
        for (Map.Entry<K, V> value : values) {
            m.set(value.getKey(), value.getValue());
        }
        return m;
    }

    @Override
    @NotNull
    public String className() {
        return "MutableLinkedHashMap";
    }

    @Override
    @NotNull
    public <NK, NV> MapFactory<NK, NV, ?, MutableLinkedHashMap<NK, NV>> mapFactory() {
        return MutableLinkedHashMap.factory();
    }

    @Override
    @NotNull
    public MutableMapEditor<K, V, MutableLinkedHashMap<K, V>> edit() {
        return new MutableMapEditor(this);
    }

    @NotNull
    public MutableLinkedHashMap<K, V> clone() {
        return new MutableLinkedHashMap(new LinkedHashMap(this.source));
    }

    private static final class Factory<K, V>
    extends AbstractMutableMapFactory<K, V, MutableLinkedHashMap<K, V>> {
        private Factory() {
        }

        public MutableLinkedHashMap<K, V> newBuilder() {
            return new MutableLinkedHashMap();
        }
    }
}

