/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.lang.invoke.StringConcatFactory;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kala.Conditions;
import kala.collection.ArraySeq;
import kala.collection.Seq;
import kala.collection.base.Growable;
import kala.collection.base.Traversable;
import kala.collection.factory.CollectionFactory;
import kala.collection.internal.CollectionHelper;
import kala.collection.internal.SeqIterators;
import kala.collection.internal.convert.AsJavaConvert;
import kala.collection.internal.convert.FromJavaConvert;
import kala.collection.mutable.MutableArrayList;
import kala.collection.mutable.MutableListEditor;
import kala.collection.mutable.MutableListIterator;
import kala.collection.mutable.MutableListStackAdapter;
import kala.collection.mutable.MutableSeq;
import kala.collection.mutable.MutableSeqIterator;
import kala.collection.mutable.MutableStack;
import kala.control.Option;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MutableList<E>
extends MutableSeq<E>,
Growable<E> {
    @NotNull
    public static <E> CollectionFactory<E, ?, MutableList<E>> factory() {
        return CollectionFactory.narrow(MutableArrayList.factory());
    }

    @Contract(value="-> new")
    @NotNull
    public static <E> MutableList<E> create() {
        return new MutableArrayList();
    }

    @Contract(value="-> new")
    @NotNull
    public static <E> MutableList<E> of() {
        return MutableArrayList.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableList<E> of(E value1) {
        return MutableArrayList.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static <E> MutableList<E> of(E value1, E value2) {
        return MutableArrayList.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static <E> MutableList<E> of(E value1, E value2, E value3) {
        return MutableArrayList.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static <E> MutableList<E> of(E value1, E value2, E value3, E value4) {
        return MutableArrayList.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static <E> MutableList<E> of(E value1, E value2, E value3, E value4, E value5) {
        return MutableArrayList.of(value1, value2, value3, value4, value5);
    }

    @SafeVarargs
    @NotNull
    public static <E> MutableList<E> of(E ... values) {
        return MutableList.from(values);
    }

    @NotNull
    public static <E> MutableList<E> from(E @NotNull [] values) {
        return MutableArrayList.from(values);
    }

    @NotNull
    public static <E> MutableList<E> from(@NotNull Iterable<? extends E> values) {
        return MutableArrayList.from(values);
    }

    @NotNull
    public static <E> MutableList<E> from(@NotNull Iterator<? extends E> it) {
        return MutableArrayList.from(it);
    }

    @NotNull
    public static <E> MutableList<E> from(@NotNull Stream<? extends E> stream) {
        return MutableArrayList.from(stream);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableList<E> wrapJava(@NotNull List<E> list) {
        Objects.requireNonNull(list);
        if (list instanceof AsJavaConvert.MutableListAsJava) {
            return (MutableList)((AsJavaConvert.MutableListAsJava)list).source;
        }
        return list instanceof RandomAccess ? new FromJavaConvert.MutableIndexedListFromJava<E>(list) : new FromJavaConvert.MutableListFromJava<E>(list);
    }

    @NotNull
    public static <E, C extends MutableList<E>> MutableListEditor<E, C> edit(@NotNull C seq) {
        return new MutableListEditor(seq);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableList";
    }

    @Override
    @NotNull
    default public <U> CollectionFactory<U, ?, ? extends MutableList<U>> iterableFactory() {
        return MutableList.factory();
    }

    @Override
    @NotNull
    default public MutableListIterator<E> seqIterator() {
        return this.seqIterator(0);
    }

    @Override
    @NotNull
    default public MutableListIterator<E> seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new SeqIterators.DefaultMutableListIterator(this, index);
    }

    @Override
    @NotNull
    default public List<E> asJava() {
        return this.supportsFastRandomAccess() ? new AsJavaConvert.MutableIndexedListAsJava(this) : new AsJavaConvert.MutableListAsJava(this);
    }

    @NotNull
    default public MutableStack<E> asMutableStack() {
        return this instanceof MutableStack ? (MutableStack)((Object)this) : new MutableListStackAdapter(this);
    }

    @Contract(mutates="this")
    public void append(@Flow(targetIsContainer=true) E var1);

    @Contract(mutates="this")
    default public void appendAll(@Flow(sourceIsContainer=true, targetIsContainer=true) E @NotNull [] values) {
        int length = values.length;
        if (length != 0) {
            if (length == 1) {
                this.append(values[0]);
            } else {
                this.appendAll((Iterable<? extends E>)((Object)ArraySeq.wrap(values)));
            }
        }
    }

    @Contract(mutates="this")
    default public void appendAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) Iterable<? extends E> values) {
        Objects.requireNonNull(values);
        if (values == this) {
            Iterator iterator = this.toImmutableSeq().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.append(e);
            }
        } else {
            for (E e : values) {
                this.append(e);
            }
        }
    }

    default public void plusAssign(E value) {
        this.append(value);
    }

    default public void plusAssign(E @NotNull [] values) {
        this.appendAll(values);
    }

    default public void plusAssign(@NotNull Iterable<? extends E> values) {
        this.appendAll(values);
    }

    @Contract(mutates="this")
    public void prepend(E var1);

    @Contract(mutates="this")
    default public void prependAll(@Flow(sourceIsContainer=true, targetIsContainer=true) E @NotNull [] values) {
        this.prependAll((Iterable<? extends E>)((Object)ArraySeq.wrap(values)));
    }

    @Contract(mutates="this")
    default public void prependAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) Iterable<? extends E> values) {
        Objects.requireNonNull(values);
        if (values == this) {
            Iterator iterator = ((Seq)((Object)values)).toImmutableArray().reverseIterator();
            while (iterator.hasNext()) {
                this.prepend(iterator.next());
            }
            return;
        }
        if (values instanceof Seq) {
            Iterator iterator = ((Seq)((Object)values)).reverseIterator();
            while (iterator.hasNext()) {
                this.prepend(iterator.next());
            }
            return;
        }
        if (values instanceof List && values instanceof RandomAccess) {
            List seq = (List)values;
            int s = seq.size();
            for (int i = s - 1; i >= 0; --i) {
                this.prepend(seq.get(i));
            }
            return;
        }
        Object[] cv = CollectionHelper.asArray(values);
        for (int i = cv.length - 1; i >= 0; --i) {
            this.prepend(cv[i]);
        }
    }

    @Contract(mutates="this")
    public void insert(int var1, @Flow(targetIsContainer=true) E var2);

    @Contract(mutates="this")
    default public void insertAll(int index, @Flow(sourceIsContainer=true, targetIsContainer=true) E @NotNull [] values) {
        this.insertAll(index, ArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public void insertAll(int index, @NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) Traversable<? extends E> values) {
        this.insertAll(index, (Iterable<? extends E>)values);
    }

    @Contract(mutates="this")
    default public void insertAll(int index, @NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) Iterable<? extends E> values) {
        Object[] valuesArray;
        Objects.requireNonNull(values);
        if (this.isEmpty() && index != 0) {
            throw new IndexOutOfBoundsException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Index out of range: \u0001"}, (int)index)));
        }
        for (Object e : valuesArray = CollectionHelper.asArray(values)) {
            this.insert(index++, e);
        }
    }

    @Contract(mutates="this")
    @Flow(sourceIsContainer=true)
    public E removeAt(int var1);

    default public void removeInRange(int beginIndex, int endIndex) {
        int size = this.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int rangeLength = endIndex - beginIndex;
        if (rangeLength == 0) {
            return;
        }
        if (rangeLength == size) {
            this.clear();
            return;
        }
        for (int i = 0; i < rangeLength; ++i) {
            this.removeAt(beginIndex);
        }
    }

    @Contract(mutates="this")
    default public E removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Seq is empty");
        }
        return this.removeAt(0);
    }

    @Contract(mutates="this")
    @Nullable
    default public E removeFirstOrNull() {
        return this.isEmpty() ? null : (E)this.removeAt(0);
    }

    @Contract(mutates="this")
    @NotNull
    default public Option<E> removeFirstOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.removeAt(0));
    }

    @Contract(mutates="this")
    default public E removeLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException("Seq is empty");
        }
        return this.removeAt(size - 1);
    }

    @Contract(mutates="this")
    @Nullable
    default public E removeLastOrNull() {
        int size = this.size();
        return size == 0 ? null : (E)this.removeAt(size - 1);
    }

    @Contract(mutates="this")
    @NotNull
    default public Option<E> removeLastOption() {
        int size = this.size();
        return size == 0 ? Option.none() : Option.some(this.removeAt(size - 1));
    }

    @Contract(mutates="this")
    default public boolean removeAll(@NotNull Predicate<? super E> predicate) {
        MutableSeqIterator it = this.seqIterator();
        boolean changed = false;
        while (it.hasNext()) {
            Object value = it.next();
            if (!predicate.test(value)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Contract(mutates="this")
    default public boolean retainAll(@NotNull Predicate<? super E> predicate) {
        MutableSeqIterator it = this.seqIterator();
        boolean changed = false;
        while (it.hasNext()) {
            Object value = it.next();
            if (predicate.test(value)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Contract(mutates="this")
    public void clear();

    @Contract(mutates="this")
    default public void dropInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return;
        }
        MutableSeqIterator it = this.seqIterator();
        for (int i = 0; i < n && it.hasNext(); ++i) {
            it.next();
            it.remove();
        }
    }

    @Contract(mutates="this")
    default public void takeInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            this.clear();
            return;
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0 && n >= knownSize) {
            return;
        }
        MutableSeqIterator it = this.seqIterator(n);
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    @Contract(mutates="this")
    default public void filterInPlace(@NotNull Predicate<? super E> predicate) {
        this.retainAll(predicate);
    }

    @Contract(mutates="this")
    default public void filterNotInPlace(@NotNull Predicate<? super E> predicate) {
        this.removeAll(predicate);
    }
}

